"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const common_flags_1 = require("../../common-flags");
class List extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(List);
            const Listr = require('listr');
            const notifier = require('node-notifier');
            const tasks = new Listr([
                { title: 'Verify if we can access Kubernetes API', skip: this.warn('Not implemented yet') },
                { title: 'Verify if CodeReady Workspaces is running', skip: this.warn('Not implemented yet') },
                { title: 'Get Workspaces', skip: this.warn('Not implemented yet') },
            ], { renderer: flags['listr-renderer'] });
            // Use https://github.com/oclif/cli-ux/tree/supertable#clitable to dispalay:
            //  - workspace id
            //  - workspace state
            //  - workspace creation date ?
            //  - workspace stack ?
            yield tasks.run();
            notifier.notify({
                title: 'crwctl',
                message: 'Command workspace:list has completed.'
            });
        });
    }
}
exports.default = List;
List.description = 'list workspaces';
List.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
    'access-token': common_flags_1.accessToken,
    'listr-renderer': common_flags_1.listrRenderer
};
//# sourceMappingURL=list.js.map