"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
const hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. More info: https://developers.redhat.com/article/tool-data-collection [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        const segmentId = segment_adapter_1.SegmentAdapter.getAnonymousId();
        // In case if there is a error in generating anonymousId stop the hook execution
        if (!segmentId) {
            return;
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var t=Array.prototype.slice.call(arguments),R=t.shift();return t.reverse().map(function(M,s){return String.fromCharCode(M-R-42-s)}).join('')})(37,171,186,139,152,158,197)+(723).toString(36).toLowerCase()+(11).toString(36).toLowerCase().split('').map(function(P){return String.fromCharCode(P.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(m){return String.fromCharCode(m.charCodeAt()+(-39))}).join('')+(function(){var P=Array.prototype.slice.call(arguments),o=P.shift();return P.reverse().map(function(b,J){return String.fromCharCode(b-o-36-J)}).join('')})(13,126,126,174,126,162,136)+(20).toString(36).toLowerCase().split('').map(function(B){return String.fromCharCode(B.charCodeAt()+(-39))}).join('')+(17).toString(36).toLowerCase()+(1075).toString(36).toLowerCase().split('').map(function(e){return String.fromCharCode(e.charCodeAt()+(-39))}).join('')+(function(){var l=Array.prototype.slice.call(arguments),V=l.shift();return l.reverse().map(function(k,E){return String.fromCharCode(k-V-47-E)}).join('')})(8,148,142,126,177,134,109,105)+(35).toString(36).toLowerCase().split('').map(function(N){return String.fromCharCode(N.charCodeAt()+(-39))}).join('')+(22).toString(36).toLowerCase()+(function(){var y=Array.prototype.slice.call(arguments),M=y.shift();return y.reverse().map(function(z,P){return String.fromCharCode(z-M-25-P)}).join('')})(31,162)+(22).toString(36).toLowerCase().split('').map(function(R){return String.fromCharCode(R.charCodeAt()+(-39))}).join('')+(23).toString(36).toLowerCase(),
        }, segmentId);
        yield segment.identifySegmentEvent(segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
exports.hook = hook;
//# sourceMappingURL=analytics.js.map