/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
import { Command, flags } from '@oclif/command';
export default class Update extends Command {
    static description: string;
    static examples: string[];
    static flags: flags.Input<any>;
    run(): Promise<void>;
    /**
     * Tests if existing Che installation uses custom docker images.
     * If so, asks user whether keep custom images or revert to default images and update them.
     */
    private checkComponentImages;
    /**
     * Check whether crwctl should proceed with update.
     * Asks user for confirmation (unless assume yes is provided).
     * Is applicable to operator installer only.
     * Returns true if crwctl can/should proceed with update, false otherwise.
     */
    private checkAbilityToUpdateCheOperatorAndAskUser;
    /**
     * Checks if official operator image is replaced with a newer one.
     * Tags are allowed in format x.y.z or NEXT_TAG.
     * NEXT_TAG is considered the most recent.
     * For example:
     *  (7.22.1, 7.23.0) -> true,
     *  (7.22.1, 7.20.2) -> false,
     *  (7.22.1, NEXT_TAG) -> true,
     *  (NEXT_TAG, 7.20.2) -> false
     * @param oldTag old official operator image tag, e.g. 7.20.1
     * @param newTag new official operator image tag e.g. 7.22.0
     * @returns true if upgrade, false if downgrade
     * @throws error if tags are equal
     */
    private isUpgrade;
    /**
     * Copies spec.k8s.ingressDomain. It is needed later for updates.
     */
    private setDomainFlag;
    /**
     * Sets installer type depending on the previous installation.
     */
    private setDefaultInstaller;
    private getWrongVersionMessage;
}
