"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlatformTasks = void 0;
const crc_1 = require("./crc");
const openshift_1 = require("./openshift");
/**
 * Platform specific tasks.
 *  - preflightCheck
 */
class PlatformTasks {
    preflightCheckTasks(flags, command) {
        const openshiftTasks = new openshift_1.OpenshiftTasks();
        const crc = new crc_1.CRCHelper();
        let task;
        if (!flags.platform) {
            task = {
                title: '✈️  Platform preflight checklist',
                task: () => { command.error('Platform is required ¯\\_(ツ)_/¯'); }
            };
        }
        else if (flags.platform === 'openshift') {
            task = {
                title: '✈️  Openshift preflight checklist',
                task: () => openshiftTasks.preflightCheckTasks(flags, command)
            };
        }
        else if (flags.platform === 'crc') {
            task = {
                title: '✈️  CodeReady Containers preflight checklist',
                task: () => crc.preflightCheckTasks(flags, command)
            };
        }
        else {
            task = {
                title: '✈️  Platform preflight checklist',
                task: () => { command.error(`Platform ${flags.platform} is not supported yet ¯\\_(ツ)_/¯`); }
            };
        }
        return [task];
    }
}
exports.PlatformTasks = PlatformTasks;
//# sourceMappingURL=platform.js.map