<?xml version='1.0' encoding='UTF-8' ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1562488:1750571 (outdated) -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="configure.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

  <title>configure - Configure l'arborescence des sources</title>

<summary>
    <p>Le script <code>configure</code> permet de configurer
    l'arborescence des sources afin de compiler et installer le serveur
    HTTP Apache sur votre plate-forme spécifique. De nombreuses options
    vous permettent de compiler un serveur correspondant à vos propres
    besoins.</p>

    <p>Ce script, situé dans le répertoire racine de la distribution des
    sources, ne concerne que la compilation sur les systèmes Unix et
    apparentés. Pour les autres plates-formes, voir la <a
    href="../platform/">documentation spécifique</a> de ces
    dernières.</p>
</summary>

<seealso><a href="../install.html">Compilation et installation</a></seealso>

<section id="synopsis"><title>Résumé</title>
    <p>Vous devez appeler le script <code>configure</code> depuis le
    répertoire racine de la distribution.</p>

    <p><code><strong>./configure</strong> [<var>OPTION</var>]...
    [<var>VARIABLE</var>=<var>VALEUR</var>]...</code></p>

    <p>Pour définir des variables d'environnement (par exemple
    <code>CC</code>,<code>CFLAGS</code>, etc...), utilisez la clause
    <code><var>VARIABLE</var>=<var>VALEUR</var></code>. Voir <a
    href="#env">ci-dessous</a> pour la description de quelques variables
    usuelles.</p>
</section>

<section id="options"><title>Options</title>
  <ul>
    <li><a href="#configurationoptions">Options de Configuration</a></li>
    <li><a href="#installationdirectories">Répertoires d'installation</a></li>
    <li><a href="#systemtypes">Types de Systèmes</a></li>
    <li><a href="#optionalfeatures">Fonctionnalités optionnelles</a></li>
    <li><a href="#supportopt">Options pour les programmes support</a></li>
  </ul>

  <section id="configurationoptions"><title>Options de Configuration</title>

    <p>Les options suivantes affectent le comportement du script
    <code>configure</code>.</p>

    <dl>
      <dt><code>-C</code></dt>
      <dt><code>--config-cache</code></dt>
      <dd>C'est un alias pour <code>--cache-file=config.cache</code></dd>

      <dt><code>--cache-file=<var>FICHIER</var></code></dt>
      <dd>Les résultats des tests seront mis en cache dans le fichier
      <var>FICHIER</var>. Cette option est désactivée par défaut.</dd>

      <dt><code>-h</code></dt>
      <dt><code>--help [short|recursive]</code></dt>
      <dd>Affichage de l'aide et sortie du script. Avec l'argument
      <code>short</code>, seules les options spécifiques à ce paquet
      seront affichées. L'argument <code>recursive</code> permet
      d'afficher l'aide de tous les paquets inclus.</dd>

      <dt><code>-n</code></dt>
      <dt><code>--no-create</code></dt>
      <dd>Le script <code>configure</code> s'exécute normalement, mais
      ne crée pas les fichiers résultants. Ceci permet de vérifier les
      résultats des tests avant de générer les fichiers makefile pour la
      compilation.</dd>

      <dt><code>-q</code></dt>
      <dt><code>--quiet</code></dt>
      <dd>Les messages <code>checking ...</code> ne sont pas affichés au
      cours du processus de configuration.</dd>

      <dt><code>--srcdir=<var>DIR</var></code></dt>
      <dd>Définit le répertoire <var>DIR</var> comme répertoire des
      fichiers sources. Par défaut, c'est le répertoire où se situe le
      script <code>configure</code>, ou le répertoire parent.</dd>

      <dt><code>--silent</code></dt>
      <dd>Identique à <code>--quiet</code></dd>

      <dt>-V</dt>
      <dt>--version</dt>
      <dd>Affichage des informations de copyright et sortie du
      script.</dd>
    </dl>
  </section>

  <section id="installationdirectories"><title>Répertoires
  d'installation</title>

    <p>Ces options permettent de spécifier le répertoire d'installation.
    L'arborescence de l'installation dépend de l'organisation (layout)
    sélectionnée.</p>

    <dl>
      <dt><code>--prefix=<var>PREFIX</var></code></dt>
      <dd>Installe les fichiers indépendants de l'architecture dans
      <var>PREFIX</var>. Par défaut, le répertoire d'installation est
      <code>/usr/local/apache2</code>.</dd>

      <dt><code>--exec-prefix=<var>EPREFIX</var></code></dt>
      <dd>Installe les fichiers dépendants de l'architecture dans
      <var>EPREFIX</var>. La valeur par défaut de cette option
      correspond à la valeur de la variable
      <var>PREFIX</var>.</dd>
    </dl>

    <p>Par défaut, <code>make install</code> va installer tous les
    fichiers dans <code>/usr/local/apache2/bin</code>,
    <code>/usr/local/apache2/lib</code>, etc... Vous pouvez cependant
    spécifier un préfixe d'installation autre que
    <code>/usr/local/apache2</code> en utilisant l'option
    <code>--prefix</code> (par exemple <code>--prefix=$HOME</code>).</p>

    <section id="layout"><title>Spécifier une organisation (layout) des
    répertoires</title>
      <dl>
        <dt><code>--enable-layout=<var>LAYOUT</var></code></dt>
        <dd>Configure le code source et les scripts de compilation de
	façon à ce que l'arborescence d'installation adopte
	l'organisation <var>LAYOUT</var>. Ceci vous permet de spécifier
	des chemins séparés pour chaque type de fichier de
	l'installation du serveur HTTP Apache. Le fichier
	<code>config.layout</code> contient de nombreux exemples de
	configurations, et vous pouvez créer vos propres configurations
	personnalisées en vous basant sur ces exemples. Les différentes
	organisations contenues dans ce fichier sont enregistrées sous
	forme de sections <code>&lt;Layout
	FOO&gt;...&lt;/Layout&gt;</code> et référencées dans ce cas par
	le nom <code>FOO</code>. L'organisation par défaut
	est <code>Apache</code>.</dd>
      </dl>
    </section>

    <section id="directoryfinetuning"><title>Configuration avancée des
    répertoires d'installation</title>

      <p>Pour une définition plus précise des répertoires
      d'installation, utilisez les options ci-dessous. Notez que les
      répertoires par défaut sont définis par <code>autoconf</code>, et
      que leurs valeurs sont écrasées par les valeurs correspondantes
      définies lors du choix de l'organisation des répertoires
      (layout).</p>

      <dl>
        <dt><code>--bindir=<var>DIR</var></code></dt>
        <dd>Installe les exécutables utilisateur dans <var>DIR</var>.
	Les exécutables utilisateur sont des programmes support comme
	<program>htpasswd</program>, <program>dbmmanage</program>,
	etc..., et destinés aux administrateurs du site. Par défaut,
	<var>DIR</var> est défini à
	<code><var>EPREFIX</var>/bin</code>.</dd>

        <dt><code>--datadir=<var>DIR</var></code></dt>
        <dd>Installe les données non modifiables indépendantes de
	l'architecture dans <var>DIR</var>. Par défaut,
	<code>datadir</code> est défini à
	<code><var>PREFIX</var>/share</code>. Cette option est fournie
	par autoconf et actuellement inutilisée.</dd>

        <dt><code>--includedir=<var>DIR</var></code></dt>
        <dd>Installe les fichiers d'en-têtes C dans <var>DIR</var>. Par
	défaut, <code>includedir</code> est défini à
	<code><var>EPREFIX</var>/include</code>.</dd>

        <dt><code>--infodir=<var>DIR</var></code></dt>
        <dd>Installe la documentation info dans <var>DIR</var>. Par
	défaut, <code>infodir</code> est défini à
	<code><var>PREFIX</var>/info</code>. Cette option est
	actuellement inutilisée.</dd>

        <dt><code>--libdir=<var>DIR</var></code></dt>
        <dd>Installe les fichiers objet des bibliothèques dans
	<var>DIR</var>. Par défaut, <code>libdir</code> est défini à
	<code><var>EPREFIX</var>/lib</code>.</dd>

        <dt><code>--libexecdir=<var>DIR</var></code></dt>
        <dd>Installe les exécutables du programme (autrement dit les
	modules partagés) dans <var>DIR</var>. Par défaut,
	<code>libexecdir</code> est défini à
	<code><var>EPREFIX</var>/modules</code>.</dd>

        <dt><code>--localstatedir=<var>DIR</var></code></dt>
        <dd>Installe les données temporaires modifiables spécifiques à
	la machine dans
	<var>DIR</var>. Par défaut, <code>localstatedir</code> est
	défini à <code><var>PREFIX</var>/var</code>. Cette option est
	fournie par <code>autoconf</code> et est actuellement
	inutilisée.</dd>

        <dt><code>--mandir=<var>DIR</var></code></dt>
        <dd>Installe les pages de manuel dans  <var>DIR</var>. Par
	défaut, <code>mandir</code> est défini à
	<code><var>EPREFIX</var>/man</code>.</dd>

        <dt><code>--oldincludedir=<var>DIR</var></code></dt>
        <dd>Installe les fichiers d'en-têtes C pour les programmes
	autres que gcc dans <var>DIR</var>. Par défaut,
	<code>oldincludedir</code> est défini à
	<code>/usr/include</code>. Cette option est fournie par
	<code>autoconf</code> et est actuellement inutilisée.</dd>

        <dt><code>--sbindir=<var>DIR</var></code></dt>
        <dd>Installe les exécutables de l'administrateur système dans
	<var>DIR</var>. Ce sont les programmes du serveur comme
	<program>httpd</program>, <program>apachectl</program>,
	<program>suexec</program>, etc..., qui sont nécessaires à
	l'exécution du serveur HTTP Apache. Par défaut,
	<code>sbindir</code> est défini à
	<code><var>EPREFIX</var>/sbin</code>.</dd>

        <dt><code>--sharedstatedir=<var>DIR</var></code></dt>
        <dd>Installe les données modifiables indépendantes de
	l'architecture dans <var>DIR</var>. Par défaut,
	<code>sharedstatedir</code> est défini à
	<code><var>PREFIX</var>/com</code>. Cette option est fournie par
	<code>autoconf</code> et est actuellement inutilisée.</dd>

        <dt><code>--sysconfdir=<var>DIR</var></code></dt>
        <dd>Installe les données non modifiables spécifiques à la
	machine comme les fichiers de configuration du serveur
	<code>httpd.conf</code>, <code>mime.types</code>, etc... dans
	<var>DIR</var>. Par défaut, <code>sysconfdir</code> est défini à
	<code><var>PREFIX</var>/conf</code>.</dd>
      </dl>
    </section>
  </section>

  <section id="systemtypes"><title>Types de systèmes</title>

    <p>Ces options sont utilisées pour la cross-compilation du serveur
    HTTP Apache afin de pouvoir l'utiliser sur un autre système. Dans le
    cas général où la compilation et l'exécution du serveur ont lieu sur
    le même système, ces options ne sont pas utilisées.</p>

    <dl>
      <dt><code>--build=<var>BUILD</var></code></dt>
      <dd>Définit le type du système sur lequel les outils sont
      compilés. Par défaut, il s'agit de la chaîne renvoyée par le
      script <code>config.guess</code>.</dd>

      <dt><code>--host=<var>HOST</var></code></dt>
      <dd>Définit le type du système sur lequel le serveur s'exécutera.
      Par défaut, <var>HOST</var> est identique à <var>BUILD</var>.</dd>

      <dt><code>--target=<var>TARGET</var></code></dt>
      <dd>Configure pour construire des compilateurs pour le type de
      système <var>TARGET</var>. Par défaut, <var>TARGET</var> est
      identique à <var>HOST</var>. Cette option est fournie par
	<code>autoconf</code> et n'est pas requise par le serveur HTTP
	Apache.</dd>
    </dl>
  </section>

  <section id="optionalfeatures"><title>Fonctionnalités
  optionnelles</title>

    <p>Ces options vous permettent de configurer avec précision les
    fonctionnalités de votre futur serveur HTTP.</p>

    <section id="generaloptfeat"><title>Syntaxe générale</title>
      <p>D'une manière générale, vous pouvez utiliser la syntaxe
      suivante pour activer ou désactiver une fonctionnalité :</p>

      <dl>
        <dt><code>--disable-<var>FONCTIONNALITE</var></code></dt>
        <dd>Désactive la fonctionnalité <var>FONCTIONNALITE</var>.
	Identique à
	<code>--enable-<var>FONCTIONNALITE</var>=no</code>.</dd>

        <dt><code>--enable-<var>FONCTIONNALITE</var>[=<var>ARG</var>]</code></dt>
        <dd>Active la fonctionnalité <var>FONCTIONNALITE</var>. La
	valeur par défaut de <var>ARG</var> est <code>yes</code>.</dd>

        <dt><code>--enable-<var>MODULE</var>=shared</code></dt>
        <dd>Le module spécifié sera compilé en tant que module DSO. Par
	défaut, les modules activés sont liés dynamiquement.</dd>

        <dt><code>--enable-<var>MODULE</var>=static</code></dt>
        <dd>Le module correspondant sera lié statiquement.</dd>
      </dl>

      <note><title>Note</title>
        Si vous spécifiez <code>--enable-<var>foo</var></code>, et si
	<var>foo</var> n'existe pas, <code>configure</code> ne le
	signalera pas ; vous devez donc prendre soin de taper les
	options correctement.
      </note>
    </section>

    <section id="choosemodules"><title>Choix des modules à compiler</title>
      <p>La plupart des modules sont compilés par défaut et ils doivent être
      désactivés de manière explicite ou via les mots-clés
      <code>few</code> ou <code>none</code> (voir ci-dessous
      <code>--enable-modules</code>, <code>--enable-mods-shared</code>
      et <code>--enable-mods-static</code> pour une explication plus
      détaillée).</p>

      <p>Par défaut, les autres modules ne sont pas compilés et doivent
      être activés explicitement, ou en utilisant les mots-clés
      <code>all</code> ou <code>reallyall</code> pour être disponibles.</p>

      <p>Pour déterminer quels modules sont compilés par défaut,
      exécutez la commande <code>./configure -h</code> ou
      <code>./configure --help</code>, et consultez les <code>Optional
      Features</code>. Par exemple, supposons que vous soyez intéressé
      par les modules <code>mod_example1</code> et
      <code>mod_example2</code>, et que vous voyiez ceci :</p>

        <example><pre>Optional Features:
  ...
  --disable-example1     example module 1
  --enable-example2      example module 2
  ...</pre></example>

        <p>Le module <code>mod_example1</code> est ici activé par
	défaut, et vous devez spécifier <code>--disable-example1</code>
	si vous ne voulez pas le compiler. Par contre, le module
	<code>mod_example2</code> est désactivé par défaut, et vous
	devez spécifier <code>--enable-example2</code> si vous voulez le
	compiler.</p>

    </section>

    <section id="mpms"><title>Modules Multi-Processus</title>
      <p>Les <a href="../mpm.html">Modules Multi-Processus</a>, ou MPMs,
      constituent le coeur du serveur. Un seul MPM doit être actif pour
      que le serveur puisse fonctionner. Vous trouverez la liste des
      MPMs disponibles à <a href="../mod/">module index page</a>.</p>

      <p>Les MPMs peuvent être compilés en tant que modules DSO pour un
      chargement dynamique, ou liés statiquement avec le serveur, et
      sont activés via les options suivantes :</p>

      <dl>
        <dt><code>--with-mpm=MPM</code></dt>
        <dd>
          <p>Sélectionne le MPM par défaut pour votre serveur. Si les
	  MPMs sont compilés en tant que modules DSO (voir
	  <code>--enable-mpms-shared</code>), cette option spécifie le
	  MPM qui sera chargé par défaut selon le fichier de
	  configuration. Dans le cas contraire, cette option spécifie le
	  seul MPM disponible qui sera lié statiquement avec le
	  serveur.</p>
          <p>Si cette option est omise, c'est le <a
	  href="../mpm.html#defaults">MPM par défaut</a> pour votre
	  système d'exploitation qui sera utilisé.</p>
        </dd>

        <dt><code>--enable-mpms-shared=<var>Liste de MPM</var></code></dt>
        <dd>
          <p>Définit une liste de MPMs à compiler en tant que modules
	  dynamiquement partagés (DSO). Un de ces modules doit être
	  chargé dynamiquement via la directive <directive
	  module="mod_so">LoadModule</directive>.</p>
          <p><var>Liste de MPM</var> est une liste, entourée
	  d'apostrophes,  de noms de MPM séparés par des espaces. Par
	  exemple :</p>
          <example>
            --enable-mpms-shared='prefork worker'
          </example>
          <p>Vous pouvez aussi utiliser le mot-clé <code>all</code>, ce
	  qui aura pour effet de spécifier tous les MPMs qui supportent
	  le chargement dynamique sur la plate-forme considérée, et de
	  les compiler en tant que modules DSO. Par exemple :</p>
          <example>
            --enable-mpms-shared=all
          </example>
	</dd>
      </dl>
    </section>

    <section id="modules"><title>Modules tiers</title>
      <p>Pour ajouter des modules tiers, utilisez les options suivantes
      :</p>

      <dl>
        <dt><code>--with-module=<var>type-module</var>:<var>fichier-module</var>[,
          <var>type-module</var>:<var>fichier-module</var>]</code></dt>
        <dd><p>Ajoute un ou plusieurs modules tiers à la liste des
	modules liés statiquement. Le fichier source du module
	<var>fichier-module</var> sera recherché dans le sous-répertoire
	<var>type-module</var> de l'arborescence des sources de votre
	serveur HTTP Apache. S'il ne l'y trouve pas,
	<code>configure</code> considèrera <var>fichier-module</var>
	comme un chemin de fichier absolu et essaiera de copier le
	fichier source dans le sous-répertoire <var>type-module</var>.
	Si ce sous-répertoire n'existe pas, il sera créé et un fichier
	<code>Makefile.in</code> standard y sera enregistré.</p>
          <p>Cette option est conçue pour ajouter de petits modules
	  externes ne comportant qu'un seul fichier source. Pour des
	  modules plus complexes, vous devrez lire la documentation du
	  fournisseur du module.</p>
          <note><title>Note</title>
            Si vous voulez compiler un module DSO (lié de manière
	    dynamique au lieu de statique), utilisez le programme
	    <program>apxs</program>.</note>
        </dd>

      </dl>
    </section>

    <section id="otheroptfeat"><title>Options cumulatives et autres
    options</title>
      <dl>
        <dt><code>--enable-maintainer-mode</code></dt>
        <dd>Active les avertissements de débogage et de compilation et
	charge tous les modules compilés.</dd>

        <dt><code>--enable-mods-shared=<var>LISTE-MODULES</var></code></dt>
        <dd>
          <p>Définit une liste de modules à activer et à compiler en
	  tant que modules dynamiques partagés. Cela signifie que ces
	  modules doivent être chargés dynamiquement en utilisant la
	  directive <directive
	  module="mod_so">LoadModule</directive>.</p>
          <p><var>LISTE-MODULES</var> est une liste, entourée
	  d'apostrophes, de noms de modules
	  séparés par des espaces. Les noms
	  des modules sont spécifiés sans le préfixe <code>mod_</code>.
	  Par exemple :</p>
          <example>
            --enable-mods-shared='headers rewrite dav'
          </example>
          <p>Vous pouvez aussi utiliser les mots-clés <code>reallyall</code>,
	  <code>all</code>, <code>most</code>, <code>few</code> et
	  <code>none</code>. Par exemple,</p>
          <example>
            --enable-mods-shared=most
          </example>
          <p>va compiler la plupart des modules en tant que modules DSO,</p>
	  <example>
            --enable-mods-shared=few
          </example>
          <p>ne compilera qu'un jeu de modules de base.</p>
          <p>Le jeu par défaut correspond au mot-clé <code>most</code>.</p>
            <!-- See <a href="../install/enabledmodules.html">Overview of
              enabled modules</a> for further information. -->
	  <p>Les directives <directive
	  module="mod_so">LoadModule</directive> correspondant aux
	  différents modules choisis sont automatiquement générées dans
	  le fichier de configuration principal. Par défaut, toutes ces
	  directives sont mises en commentaire, sauf pour les modules
	  requis ou ceux explicitement sélectionnés par un argument
	  <code>--enable-nom-module</code> du script configure. Vous
	  pouvez modifier le jeu de modules chargé en activant ou
	  désactivant les directives <directive
	  module="mod_so">LoadModule</directive> dans le fichier
	  <code>httpd.conf</code>. En outre, les directives <directive
	  module="mod_so">LoadModule</directive> peuvent être activées
	  pour tous les modules compilés via l'option
	  <code>--enable-load-all-modules</code> du script configure.</p>
          
        </dd>

        <dt><code>--enable-mods-static=<var>MODULE-LIST</var></code></dt>
        <dd>Cette option produit le même effet que l'option
	<code>--enable-mods-shared</code>, à l'exception que les modules
	seront liés statiquement. Cela signifie que les modules
	spécifiés seront toujours disponibles au cours du fonctionnement
	de <program>httpd</program>. Ils n'ont pas besoin d'être chargés
	via la directive <directive
	module="mod_so">LoadModule</directive>.</dd>

	<dt><code>--enable-modules=<var>MODULE-LIST</var></code></dt>
        <dd>Cette option se comporte comme
	<code>--enable-mods-shared</code>, et va aussi lier les modules
	concernés dynamiquement. Le mot-clé spécial <code>none</code>
	désactive la compilation de tous les modules.</dd>

        <dt><code>--enable-v4-mapped</code></dt>
        <dd>Permet aux sockets IPv6 de traiter les connexions IPv4.</dd>

        <dt><code>--with-port=<var>PORT</var></code></dt>
        <dd>Permet de définir le port que le programme
	<program>httpd</program> va écouter. Ce numéro de port est
	utilisé lors de la génération du fichier de configuration
	<code>httpd.conf</code>. Sa valeur par défaut est 80.</dd>

        <dt><code>--with-program-name</code></dt>
        <dd>Permet de définir un nom d'exécutable alternatif. Le nom par
	défaut est <code>httpd</code>.</dd>
      </dl>
    </section>
  </section>

  <section id="packages"><title>Paquets optionnels</title>
    <p>Ces options permettent de définir des paquets optionnels.</p>

    <section id="generalpackages"><title>Syntaxe générale</title>
      <p>D'une manière générale, vous pouvez utiliser la syntaxe
      suivante pour définir un paquet optionnel :</p>

      <dl>
        <dt><code>--with-<var>PAQUET</var>[=<var>ARG</var>]</code></dt>
        <dd>Utilise le paquet <var>PAQUET</var>. La valeur par défaut de
	<var>ARG</var> est <code>yes</code>.</dd>

        <dt><code>--without-<var>PAQUET</var></code></dt>
        <dd>N'utilise pas le paquet <var>PAQUET</var>. Cette option est
	identique à <code>--with-<var>PAQUET</var>=no</code>. Elle est
	fournie par <code>autoconf</code> mais n'est pas très utile pour
	le serveur HTTP Apache.</dd>
      </dl>
    </section>

    <!-- options not known are passed to packages?
    are there other important options for packages? -->

    <section id="packageopt"><title>Paquets spécifiques</title>
      <dl>
        <dt><code>--with-apr=<var>REP</var>|<var>FICHIER</var></code></dt>
        <dd>La <glossary ref="apr">Bibliothèque pour la portabilité
	d'Apache ou
	Apache Portable Runtime</glossary> (APR) fait partie de la
	distribution des sources de httpd et est compilée
	automatiquement avec le serveur HTTP. Si vous voulez utiliser
	une APR déjà installée à la place, vous devez indiquer à
	<code>configure</code> le chemin du script
	<code>apr-config</code>. Vous pouvez spécifier le chemin absolu
	et le nom ou le répertoire d'installation de l'APR.
	<code>apr-config</code> doit se trouver dans ce répertoire ou
	dans le sous-repertoire <code>bin</code>.</dd>

        <dt><code>--with-apr-util=<var>REP</var>|<var>FICHIER</var></code></dt>
        <dd>Les utilitaires pour la Bibliothèque pour la portabilité
	d'Apache ou Apache Portable Runtime Utilities (APU) font partie de la
	distribution des sources de httpd et sont compilés
	automatiquement avec le serveur HTTP. Si vous voulez utiliser
	des APU déjà installés à la place, vous devez indiquer à
	<code>configure</code> le chemin du script
	<code>apu-config</code>. Vous pouvez spécifier le chemin absolu
	et le nom ou le répertoire d'installation des APU.
	<code>apu-config</code> doit se trouver dans ce répertoire ou
	dans le sous-repertoire <code>bin</code>.</dd>

        <dt><code>--with-ssl=<var>REP</var></code></dt>
        <dd>Si <module>mod_ssl</module> a été activé,
	<code>configure</code> recherche une installation d'OpenSSL.
	Vous pouvez définir le répertoire de la boîte à outils SSL/TLS à
	la place.</dd>

        <dt><code>--with-z=<var>REP</var></code></dt>
        <dd><code>configure</code> recherche automatiquement une
	bibliothèque <code>zlib</code> installée si la configuration de
	vos sources en nécessite une (par exemple lorsque
	<module>mod_deflate</module> est activé). Vous pouvez définir le
	répertoire de la bibliothèque de compression à la place.</dd>
      </dl>

      <p>De nombreuses fonctionnalités du serveur HTTP Apache, y compris
      les directives <directive
      module="mod_rewrite">RewriteMap</directive> DBM de
      <module>mod_rewrite</module> et <module>mod_authn_dbm</module>
      utilisent une base de données simple
      de la forme clé/valeur pour une recherche rapide d'informations.
      SDBM, inclus dans les APU, est donc toujours disponible. Si vous
      souhaitez utiliser d'autres types de bases de données, utilisez
      les options suivantes afin de les activer :</p>

      <dl>
        <dt><code>--with-gdbm[=<var>chemin</var>]</code></dt>
        <dd>Si aucun <var>chemin</var> n'est spécifié,
	<code>configure</code> va rechercher les fichiers d'en-têtes et
	les bibliothèques d'une installation DBM GNU dans les chemins
	standards. Avec un <var>chemin</var> explicite,
	<code>configure</code> recherchera les fichiers concernés dans
	<code><var>chemin</var>/lib</code> et
	<code><var>chemin</var>/include</code>. En fait,
	<var>chemin</var> permet de spécifier plusieurs chemins
	d'en-têtes et bibliothèques spécifiques en les séparant par des
	caractères ':'.</dd>

        <dt><code>--with-ndbm[=<var>chemin</var>]</code></dt>
        <dd>Identique à <code>--with-gdbm</code>, mais recherche une
	installation de New DBM.</dd>

        <dt><code>--with-berkeley-db[=<var>chemin</var>]</code></dt>
        <dd>Identique à <code>--with-gdbm</code>, mais recherche une
	installation de Berkeley DB.</dd>
      </dl>

      <note><title>Note</title>
        <p>Les options DBM sont fournies par les APU et passées en
	paramètres à son script de configuration. Elles sont inutiles
	lorsqu'on utilise des APU déjà installés définis par
	<code>--with-apr-util</code>.</p>
        <p>Vous pouvez utiliser plusieurs implémentations DBM avec votre
	serveur HTTP. Le type DBM approprié sera choisi au cours de la
	configuration de l'exécution à chaque démarrage.</p>
      </note>
    </section>
  </section>

  <section id="supportopt"><title>Options pour les programmes de
  support</title>
    <dl>
      <dt><code>--enable-static-support</code></dt>
      <dd>Permet de compiler une version des binaires de support liés
      statiquement. En d'autres termes, la compilation produira un
      exécutable indépendant comportant toutes les bibliothèques
      nécessaires. Sans cette option, les binaires de supports sont liés
      dynamiquement.</dd>

      <dt><code>--enable-suexec</code></dt>
      <dd>Utilisez cette option pour activer la programme
      <program>suexec</program>, qui vous permet de définir un uid et un
      gid pour les processus lancés. <strong>N'utilisez cette option que
      si vous maîtrisez toutes les implications en matière de sécurité
      de l'exécution d'un binaire suid sur votre serveur.</strong>
      D'autres options permettent de configurer
      <program>suexec</program> comme décrit <a
      href="#suexec">ci-dessous</a>.</dd>
    </dl>

    <p>Il est possible de lier statiquement le binaire d'un programme
    support particulier en utilisant les options suivantes :</p>

    <dl>
      <dt><code>--enable-static-ab</code></dt>
      <dd>Compile une version liée statiquement du programme
      <program>ab</program>.</dd>

      <!-- missing documentation for chechgid -->
      <dt><code>--enable-static-checkgid</code></dt>
      <dd>>Compile une version liée statiquement du programme
      <code>checkgid</code>.</dd>

      <dt><code>--enable-static-htdbm</code></dt>
      <dd>Compile une version liée statiquement du programme <program>
        htdbm</program>.</dd>

      <dt><code>--enable-static-htdigest</code></dt>
      <dd>Compile une version liée statiquement du programme <program>
        htdigest</program>.</dd>

      <dt><code>--enable-static-htpasswd</code></dt>
      <dd>Compile une version liée statiquement du programme <program>
        htpasswd</program>.</dd>

      <dt><code>--enable-static-logresolve</code></dt>
      <dd>Compile une version liée statiquement du programme <program>
        logresolve</program>.</dd>

      <dt><code>--enable-static-rotatelogs</code></dt>
      <dd>Compile une version liée statiquement du programme <program>
        rotatelogs</program>.</dd>
    </dl>

    <section id="suexec">
      <title>Options de configuration de <code>suexec</code></title>
      <p>Les options suivantes permettent de définir avec précision le
      comportement du programme <program>suexec</program>. Voir <a
        href="suexec.html#install">Configurer et installer suEXEC</a>
	pour plus de détails.</p>

      <dl>
        <dt><code>--with-suexec-bin</code></dt>
        <dd>Définit le chemin du binaire <program>suexec</program>. La
	valeur par défaut est <code>--sbindir</code> (voir <a
	href="#directoryfinetuning">Définition précise des répertoires
	d'installation</a>).</dd>

        <dt><code>--with-suexec-caller</code></dt>
        <dd>Définit l'utilisateur qui a l'autorisation d'appeler
	<program>suexec</program>. Il est en général souhaitable que ce
	soit le même que celui sous lequel <program>httpd</program>
	s'exécute.</dd>

        <dt><code>--with-suexec-docroot</code></dt>
        <dd>Définit l'arborescence des répertoires dans laquelle le
	lancement des exécutables via <program>suexec</program> est
	autorisé. La valeur par défaut est
	<code>--datadir/htdocs</code>.</dd>

        <dt><code>--with-suexec-gidmin</code></dt>
        <dd>Définit la valeur de GID la plus basse autorisée comme
	valeur cible pour <program>suexec</program>. La valeur par
	défaut est 100.</dd>

        <dt><code>--with-suexec-logfile</code></dt>
        <dd>Définit le nom du fichier journal de
	<program>suexec</program>. La valeur par défaut est
	<code>--logfiledir/suexec_log</code>.</dd>

        <dt><code>--with-suexec-safepath</code></dt>
        <dd>Définit la valeur de la variable d'environnement
	<code>PATH</code> pour les processus lancés par
	<program>suexec</program>. La valeur par défaut est
	<code>/usr/local/bin:/usr/bin:/bin</code>.</dd>

        <dt><code>--with-suexec-userdir</code></dt>
        <dd>Définit le sous-répertoire du répertoire utilisateur qui
	contient tous les exécutables pouvant être lancés par
	<program>suexec</program>. Cette option est nécessaire si vous
	souhaitez utiliser <program>suexec</program> avec des
	répertoires utilisateurs (définis via
	<module>mod_userdir</module>). La valeur par défaut est
	<code>public_html</code>.</dd>

        <dt><code>--with-suexec-uidmin</code></dt>
        <dd>Définit la valeur d'UID la plus basse autorisée comme
	valeur cible pour <program>suexec</program>. La valeur par
	défaut est 100.</dd>

        <dt><code>--with-suexec-umask</code></dt>
        <dd>Définit le masque de permissions <code>umask</code> pour les
	processus lancés par <program>suexec</program>. Il correspond
	par défaut au masque défini par la configuration de votre
	système.</dd>
      </dl>
    </section>
  </section>
</section>

<section id="env"><title>Variables d'environnement</title>
  <p>Certaines variables d'environnement permettent de modifier les
  choix effectués par <code>configure</code>, ou d'aider ce dernier à
  trouver les bibliothèques et programmes possédant des noms et chemins
  non standards.</p>

  <!-- are these all useful variables? -->
  <dl>
    <dt><code>CC</code></dt>
    <dd>Définit la commande du compilateur C à utiliser pour la
    compilation.</dd>

    <dt><code>CFLAGS</code></dt>
    <dd>Définit les paramètres du compilateur C que vous voulez utiliser
    pour la compilation.</dd>

    <dt><code>CPP</code></dt>
    <dd>Définit la commande du préprocesseur C à utiliser.</dd>

    <dt><code>CPPFLAGS</code></dt>
    <dd>Définit les paramètres du préprocesseur C/C++, par exemple
    <code>-I<var>répertoire-include</var></code>, si certains de vos
    fichiers d'en-têtes se trouvent dans le répertoire non standard
    <var>répertoire-include</var>.</dd>

    <dt><code>LDFLAGS</code></dt>
    <dd>Définit les paramètres de l'éditeur de liens, par exemple
    <code>-L<var>répertoire-lib</var></code>, si certaines de vos
    bibliothèques se trouvent dans le répertoire non standard
    <var>répertoire-lib</var>.</dd>
  </dl>
</section>
</manualpage>
