<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision: 1731194 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="sections.xml.meta">

<title>Sections de configuration</title>

<summary> <p>Les directives des <a
href="configuring.html">fichiers de configuration</a> peuvent s'appliquer
au serveur dans son ensemble, ou seulement à des répertoires, fichiers, hôtes,
ou URLs particuliers.  Ce document décrit comment utiliser les conteneurs de
sections de configuration ou les fichiers <code>.htaccess</code> pour
modifier la portée des directives de configuration.</p>
</summary>

<section id="types"><title>Types de conteneurs de sections de
configuration</title>

<related>
<modulelist>
<module>core</module>
<module>mod_version</module>
<module>mod_proxy</module>
</modulelist>
<directivelist>
<directive type="section" module="core">Directory</directive>
<directive type="section" module="core">DirectoryMatch</directive>
<directive type="section" module="core">Files</directive>
<directive type="section" module="core">FilesMatch</directive>
<directive type="section" module="core">If</directive>
<directive type="section" module="core">IfDefine</directive>
<directive type="section" module="core">IfModule</directive>
<directive type="section" module="mod_version">IfVersion</directive>
<directive type="section" module="core">Location</directive>
<directive type="section" module="core">LocationMatch</directive>
<directive type="section" module="mod_proxy">Proxy</directive>
<directive type="section" module="mod_proxy">ProxyMatch</directive>
<directive type="section" module="core">VirtualHost</directive>
</directivelist>
</related>

<p>Il existe deux grands types de conteneurs.  La plupart des conteneurs sont
évalués pour chaque requête.  Les directives qu'ils contiennent s'appliquent
seulement aux requêtes qui sont concernées par le conteneur.  En revanche,
les conteneurs
<directive type="section" module="core">IfDefine</directive>, <directive
type="section" module="core">IfModule</directive>, et
<directive type="section" module="mod_version">IfVersion</directive> sont
évalués seulement au démarrage et au redémarrage du serveur.
Si leurs conditions sont vérifiées au démarrage, les directives qu'ils contiennent
s'appliqueront à toutes les requêtes.  Si leurs conditions ne sont pas vérifiées, les
directives qu'ils contiennent seront ignorées.</p>

<p>Le conteneur <directive type="section" module="core">IfDefine</directive>
contient des directives qui ne seront appliquées que si un paramètre
approprié a été défini dans la ligne de commande de <program>httpd</program>.
Par exemple,
avec la configuration suivante, toutes les requêtes seront redirigées vers
un autre site si le serveur est démarré en utilisant la ligne de commande :
<code>httpd -DClosedForNow</code>:</p>

<highlight language="config">
&lt;IfDefine ClosedForNow&gt;
    Redirect "/" "http://otherserver.example.com/"
&lt;/IfDefine&gt;
</highlight>

<p>Le conteneur <directive type="section" module="core">IfModule</directive>
est similaire; les directives qu'il contient ne s'appliqueront que si
un module particulier est disponible au niveau du serveur.
Le module doit être soit compilé statiquement dans le serveur, soit
dynamiquement et dans ce cas, la ligne <directive
module="mod_so">LoadModule</directive> correspondante doit apparaître
plus haut dans le fichier de configuration.  Ce conteneur ne doit être
utilisé que dans le cas où votre fichier de configuration doit fonctionner
indépendamment de la présence ou de l'absence de certains modules.
Il ne doit pas contenir de directives que vous souhaitez voir s'appliquer
systématiquement, car vous pouvez perdre ainsi de précieux messages d'erreur
à propos de modules manquants.</p>

<p>Dans l'exemple suivant, la directive <directive
module="mod_mime_magic">MimeMagicFile</directive> ne s'appliquera que si le
module <module>mod_mime_magic</module> est disponible.</p>

<highlight language="config">
&lt;IfModule mod_mime_magic.c&gt;
    MimeMagicFile "conf/magic"
&lt;/IfModule&gt;
</highlight>

<p>Le conteneur
<directive type="section" module="mod_version">IfVersion</directive>
est similaire aux conteneurs <directive type="section"
module="core">IfDefine</directive> et <directive type="section"
module="core">IfModule</directive>; les directives qu'il contient ne
s'appliqueront que si une version particulière du serveur s'exécute.  Ce
conteneur a été conçu pour une utilisation dans les suites de tests
et les grands réseaux qui doivent prendre en compte différentes versions
et configurations de httpd.</p>

<highlight language="config">
&lt;IfVersion >= 2.4&gt;
    # les directives situées ici ne s'appliquent que si la version <br />
    # est supérieure ou égale à 2.4.0.
&lt;/IfVersion&gt;
</highlight>

<p><directive type="section" module="core">IfDefine</directive>,
<directive type="section" module="core">IfModule</directive>, et
<directive type="section" module="mod_version">IfVersion</directive>
peuvent inverser leur test conditionnel en le faisant précéder d'un "!".
De plus, ces sections peuvent être imbriquées afin de définir des restrictions
plus complexes.</p>
</section>

<section id="file-and-web"><title>Système de fichiers,
arborescence du site web et expressions booléennes</title>

<p>Les conteneurs de sections de configuration les plus couramment utilisés
sont ceux qui modifient la configuration de points particuliers du système de
fichiers ou de l'arborescence du site web.  Tout d'abord, il est important de
comprendre la différence entre les deux.  Le système de fichiers est une vue
de vos disques tels qu'ils sont perçus par votre système d'exploitation.
Par exemple, avec une installation par défaut,
Apache httpd est situé dans <code>/usr/local/apache2</code> pour le système de
fichiers UNIX, ou <code>"c:/Program Files/Apache Group/Apache2"</code> pour
le système de fichiers Windows.  (Notez que des slashes directs doivent
toujours être utilisés comme séparateur de chemin
dans les fichiers de configuration d'Apache httpd, même sous
Windows.)  Quant à
l'arborescence du site web, il s'agit d'une vue de votre site
tel que présenté par le
serveur web et perçue par le client.  Ainsi le chemin <code>/dir/</code> dans
l'arborescence du site web correspond au chemin
<code>/usr/local/apache2/htdocs/dir/</code> dans le système de fichiers pour
une installation d'Apache httpd par défaut sous UNIX.
En outre, l'arborescence du site web n'a pas besoin de correspondre en permanence au
système de fichiers, car les pages web peuvent être générées dynamiquement
à partir de bases de données ou d'autres emplacements.</p>

<section id="filesystem"><title>Conteneurs de système de fichiers</title>

<p>Les conteneurs <directive type="section" module="core">Directory</directive>
et <directive type="section" module="core">Files</directive>,
ainsi que leurs équivalents acceptant les
<glossary ref="regex">expressions rationnelles</glossary>,
appliquent des directives à certaines parties du système de fichiers.
Les directives contenues dans une section <directive
type="section" module="core">Directory</directive> s'appliquent au répertoire
précisé, ainsi qu'à tous ses sous-répertoires et aux fichiers que ces
derniers contiennent.
Le même effet peut être obtenu en utilisant les <a
href="howto/htaccess.html">fichiers .htaccess</a>.  Par exemple, avec la
configuration suivante, l'indexation sera activée pour le répertoire
<code>/var/web/dir1</code> et tous ses sous-répertoires.</p>

<highlight language="config">
&lt;Directory "/var/web/dir1"&gt;
    Options +Indexes
&lt;/Directory&gt;
</highlight>

<p>Les directives contenues dans une section <directive type="section"
module="core">Files</directive> s'appliquent à tout fichier
avec le nom spécifié, quel que soit le répertoire dans lequel il se trouve.
Ainsi par exemple, les directives de configuration suivantes, si elles sont
placées dans la section principale du fichier de configuration, vont interdire
l'accès à tout fichier nommé <code>private.html</code> quel que soit
l'endroit où il se trouve.</p>

<highlight language="config">
&lt;Files "private.html"&gt;
    Require all denied
&lt;/Files&gt;
</highlight>

<p>Pour faire référence à des fichiers qui se trouvent en des points
particuliers du système de fichiers, les sections
<directive type="section" module="core">Files</directive> et
<directive type="section" module="core">Directory</directive>
peuvent être combinées.  Par exemple, la configuration suivante va interdire
l'accès à <code>/var/web/dir1/private.html</code>,
<code>/var/web/dir1/subdir2/private.html</code>,
<code>/var/web/dir1/subdir3/private.html</code>, ainsi que toute instance de
<code>private.html</code> qui se trouve dans l'arborescence
<code>/var/web/dir1/</code>.</p>

<highlight language="config">
&lt;Directory "/var/web/dir1"&gt;
    &lt;Files "private.html"&gt;
        Require all denied
    &lt;/Files&gt;
&lt;/Directory&gt;
</highlight>
</section>

<section id="webspace"><title>Conteneurs de l'arborescence du site web</title>

<p>le conteneur <directive type="section" module="core">Location</directive>
et son équivalent acceptant les
<glossary ref="regex">expressions rationnelles</glossary>, modifient quant à eux la
configuration de parties de l'arborescence du site web.  Par exemple, la
configuration suivante interdit l'accès à toute URL dont la partie chemin
commence par /private.
En particulier, l'interdiction s'appliquera aux requêtes pour :
<code>http://yoursite.example.com/private</code>,
<code>http://yoursite.example.com/private123</code>, et
<code>http://yoursite.example.com/private/dir/file.html</code> ainsi qu'à
toute requête commençant par la chaîne de caractères <code>/private</code>.</p>

<highlight language="config">
&lt;LocationMatch "^/private"&gt;
    Require all denied
&lt;/LocationMatch&gt;
</highlight>

<p>Le conteneur <directive type="section" module="core">Location</directive>
n'a pas besoin de faire référence à un élément du système de fichiers.
Par exemple, l'exemple suivant montre comment faire référence à une URL
particulière vers un gestionnaire interne du serveur HTTP Apache fourni par le module
<module>mod_status</module>.
Il n'est pas nécessaire de trouver un fichier nommé <code>server-status</code>
dans le système de fichiers.</p>

<highlight language="config">
&lt;Location "/server-status"&gt;
    SetHandler server-status
&lt;/Location&gt;
</highlight>
</section>

<section id="overlapping-webspace"><title>Espace web imbriqué</title>
<p>Pour contrôler deux URLs imbriquées, on doit tenir compte de l'ordre
dans lequel certaines sections ou directives sont évaluées. Pour
<directive type="section" module="core">Location</directive>, on doit
avoir :</p>
<highlight language="config">
&lt;Location "/foo"&gt;
&lt;/Location&gt;
&lt;Location "/foo/bar"&gt;
&lt;/Location>
</highlight>
<p>Les directives <directive type="section"
module="mod_alias">Alias</directive>, quant à elles, sont évaluées vice-versa :</p>
<highlight language="config">
Alias "/foo/bar" "/srv/www/uncommon/bar"
Alias "/foo" "/srv/www/common/foo"
</highlight>
<p>Ceci est aussi vrai pour les directives <directive
module="mod_proxy">ProxyPass</directive> :</p>
<highlight language="config">
ProxyPass "/special-area" "http://special.example.com" smax=5 max=10
ProxyPass "/" "balancer://mycluster/" stickysession=JSESSIONID|jsessionid nofailover=On
</highlight>
</section>


<section id="wildcards"><title>Caractères de remplacement
et expressions rationnelles</title>

<p>Les conteneurs
<directive type="section" module="core">Directory</directive>,
<directive type="section" module="core">Files</directive>, et
<directive type="section" module="core">Location</directive>
peuvent utiliser des caractères de remplacement de style shell comme dans
la fonction <code>fnmatch</code> de la bibliothèque C standard.
Le caractère "*"
correspond à toute séquence de caractères, "?" à un caractère seul,
et "[<em>seq</em>]" à tout caractère contenu dans <em>seq</em>.
Le caractère "/"
ne peut pas faire l'objet d'un remplacement;
il doit être spécifié explicitement.</p>

<p>Si une définition des critères de correspondance
encore plus souple est nécessaire, chaque conteneur
possède son équivalent acceptant les expressions rationnelles : <directive
type="section" module="core">DirectoryMatch</directive>, <directive
type="section" module="core">FilesMatch</directive>, et <directive
type="section" module="core">LocationMatch</directive> acceptent les
<glossary ref="regex">expressions rationnelles</glossary> compatibles Perl
pour définir les critères de correspondance.  Mais voyez plus loin la section
à propos de la combinaison des sections de configuration
pour comprendre comment l'utilisation de
conteneurs avec des expressions rationnelles va modifier la manière
dont les directives sont appliquées.</p>

<p>Un conteneur qui modifie la configuration de tous les
répertoires utilisateurs à l'aide de caractères de remplacement
mais sans utiliser
les expressions rationnelles pourrait ressembler à ceci :</p>

<highlight language="config">
&lt;Directory "/home/*/public_html"&gt;
    Options Indexes
&lt;/Directory&gt;
</highlight>

<p>Avec les conteneurs utilisant les expressions rationnelles,
on peut interdire l'accès à de nombreux types de fichiers d'images
simultanément :</p>
<highlight language="config">
+&lt;FilesMatch "\.(?i:gif|jpe?g|png)$"&gt;
    Require all denied
&lt;/FilesMatch&gt;
</highlight>

<p>Les expressions rationnelles contenant des <strong>groupes nommés et
des références arrières</strong> sont ajoutées à l'environnement avec
leur nom en majuscules. Ceci permet de référencer des éléments de
chemins de fichiers et d'URLs depuis une <a
href="expr.html">expression</a> et au sein de modules comme
<module>mod_rewrite</module>.</p>

<highlight language="config">
&lt;DirectoryMatch "^/var/www/combined/(?&lt;SITENAME&gt;[^/]+)"&gt;
    require ldap-group "cn=%{env:MATCH_SITENAME},ou=combined,o=Example"
&lt;/DirectoryMatch&gt;
</highlight>

</section>

<section id="expressions"><title>Expressions booléennes</title>
<p>La directive <directive type="section" module="core">If</directive>
permet de modifier la configuration en fonction d'une condition qui peut
être définie sous la forme d'une expression booléenne. Dans l'exemple
suivant, l'accès est interdit si l'en-tête HTTP Referer ne commence pas
par "http://www.example.com/".</p>
<highlight language="config">
&lt;If "!(%{HTTP_REFERER} -strmatch 'http://www.example.com/*')"&gt;
    Require all denied
&lt;/If&gt;
</highlight>

</section>

<section id="whichwhen"><title>Que faut-il utiliser et quand ?</title>

<p>Choisir entre des conteneurs de système de fichiers et des conteneurs
d'arborescence du site web est vraiment très simple.
Pour appliquer des directives à des objets qui résident dans le système de
fichiers, utilisez toujours un conteneur <directive type="section"
module="core">Directory</directive> ou <directive type="section"
module="core">Files</directive>.  Pour appliquer des directives à des objets
qui ne résident pas dans le système de fichiers (comme une page web générée
par une base de données), utilisez un conteneur <directive type="section"
module="core">Location</directive>.</p>

<p>Il ne faut jamais utiliser un conteneur <directive type="section"
module="core">Location</directive> pour restreindre l'accès à des
objets du système de fichiers, car plusieurs localisations de
l'arborescence du site web (URLs) peuvent correspondre à la même localisation
du système de fichier, ce qui peut permettre de contourner vos restrictions.
Par exemple, imaginez la configuration suivante :</p>

<highlight language="config">
&lt;Location "/dir/"&gt;
    Require all denied
&lt;/Location&gt;
</highlight>

<p>Elle fonctionne correctement si la requête appelle
<code>http://yoursite.example.com/dir/</code>.  Mais que va-t-il se passer si
votre système de fichiers est insensible à la casse ?
Votre restriction va pouvoir être tout simplement contournée en envoyant une
requête sur
<code>http://yoursite.example.com/DIR/</code>.  Le conteneur <directive
type="section" module="core">Directory</directive>, quant à lui, s'appliquera
à tout contenu servi à partir de cette localisation,
sans tenir compte de la manière dont il est appelé.
(Les liens du système de fichiers constituent une exception.
Le même répertoire peut être placé dans plusieurs parties du système de
fichiers en utilisant des liens symboliques.  Le conteneur
<directive type="section" module="core">Directory</directive> va suivre le
lien symbolique sans modifier le nom du chemin.  Par conséquent, pour plus de
sécurité, les liens symboliques doivent être désactivés à l'aide de la
directive
<directive module="core">Options</directive> appropriée.)</p>

<p>Si vous pensez que vous n'êtes pas concerné par ce problème
parceque vous utilisez un système de fichiers sensible à la casse,
gardez à l'esprit qu'il y a de nombreuses autres manières pour faire
correspondre plusieurs localisations de l'arborescence du site web à la même
localisation du système de fichiers.  C'est pourquoi vous devez autant que
possible toujours utiliser les conteneurs de système de fichiers.
Il y a cependant une exception à cette règle.  Placer des restrictions de
configuration dans un conteneur <code>&lt;Location
"/"&gt;</code> est tout à fait sans rique car ce conteneur va s'appliquer à
toutes les requêtes sans tenir compte de l'URL spécifique.</p>
</section>

<section id="nesting"><title>Imbrication des sections</title>

<p>Certains types de sections peuvent être imbriqués : d'une part, on
peut utiliser les sections <directive type="section"
module="core">Files</directive> à l'intérieur des sections <directive
type="section" module="core">Directory</directive>, d'autre part, on
peut utiliser les
directives <directive type="section" module="core">If</directive> à
l'intérieur des sections <directive type="section"
module="core">Directory</directive>, <directive type="section"
module="core">Location</directive> et <directive type="section"
module="core">Files</directive>. Les valeurs des expressions
rationnelles correspondant aux sections nommées se comportent de manière
identique.</p>

<p>Les sections imbriquées sont fusionnées après les sections
non-imbriquées de même type.</p>

</section>

</section>

<section id="virtualhost"><title>Hôtes virtuels</title>

<p>Le conteneur <directive type="section" module="core">VirtualHost</directive>
contient des directives qui s'appliquent à des hôtes spécifiques.
Ceci s'avère utile pour servir des hôtes multiples à partir de la même machine,
chacun d'entre eux possédant une configuration différente.  Pour de plus amples
informations,
voir la <a href="vhosts/">Documentation sur les hôtes virtuels</a>.</p>
</section>

<section id="proxy"><title>Mandataire</title>

<p>Les conteneurs
<directive type="section" module="mod_proxy">Proxy</directive>
et <directive type="section" module="mod_proxy">ProxyMatch</directive>
appliquent les directives de configuration qu'ils contiennent uniquement aux
sites qui correspondent à l'URL spécifiée et auxquels on a
accédé via le serveur mandataire du module <module>mod_proxy</module>.
Par exemple, la configuration suivante n'autorisera qu'un sous-ensemble de
clients à accéder au site <code>www.example.com</code> en passant par le serveur
mandataire :.</p>

<highlight language="config">
&lt;Proxy "http://www.example.com/*"&gt;
    Require host yournetwork.example.com
&lt;/Proxy&gt;
</highlight>
</section>

<section id="whatwhere"><title>Quelles sont les directives autorisées ?</title>

<p>Pour déterminer quelles sont les directives autorisées pour tel type de
section de configuration, vérifiez le <a
href="mod/directive-dict.html#Context">Contexte</a> de la directive.
Tout ce qui est autorisé dans les sections
<directive type="section" module="core">Directory</directive>
l'est aussi d'un point de vue syntaxique dans les sections
<directive type="section" module="core">DirectoryMatch</directive>,
<directive type="section" module="core">Files</directive>,
<directive type="section" module="core">FilesMatch</directive>,
<directive type="section" module="core">Location</directive>,
<directive type="section" module="core">LocationMatch</directive>,
<directive type="section" module="mod_proxy">Proxy</directive>,
et <directive type="section" module="mod_proxy">ProxyMatch</directive>.
Il y a cependant quelques exceptions :</p>

<ul>
<li>La directive <directive module="core">AllowOverride</directive>
ne fonctionne que dans les sections
<directive type="section" module="core">Directory</directive>.</li>

<li>Les <directive
module="core">Options</directive> <code>FollowSymLinks</code> et
<code>SymLinksIfOwnerMatch</code>  ne fonctionnent que dans les sections
<directive type="section" module="core">Directory</directive> ou les fichiers
<code>.htaccess</code>.</li>

<li>La directive <directive module="core">Options</directive> ne peut pas être
utilisée dans les sections
<directive type="section" module="core">Files</directive>
et <directive type="section" module="core">FilesMatch</directive>.</li>
</ul>
</section>

<section id="merging"><title>Comment les sections sont combinées entre elles</title>

<p>Les sections de configuration sont appliquées dans un ordre très particulier.
Il est important de savoir comment cet ordre est défini car il peut avoir
des effets importants sur la manière dont les directives de configuration
sont interprétées.</p>

    <p>L'ordre dans lequel les sections sont combinées est :</p>

    <ol>
      <li> Les sections <directive type="section"
      module="core">Directory</directive> (à l'exception des
      expressions rationnelles)
      et les fichiers <code>.htaccess</code> sont appliqués simultanément (avec
      la possibilité pour <code>.htaccess</code>, s'il y est autorisé, de
      prévaloir sur
      <directive type="section" module="core">Directory</directive>)</li>

      <li>Les sections
      <directive type="section" module="core">DirectoryMatch</directive>
      (et <code>&lt;Directory "~"&gt;</code>)</li>

      <li>Les sections <directive type="section"
      module="core">Files</directive> et <directive
      type="section" module="core">FilesMatch</directive> sont appliquées
      simultanément</li>

      <li>Les sections
      <directive type="section" module="core">Location</directive>
      et <directive type="section"
      module="core">LocationMatch</directive> sont appliquées
      simultanément</li>

      <li>Les directives <directive type="section" module="core">If</directive>
      </li>
    </ol>

    <p>Mises à part les sections <directive type="section"
    module="core">Directory</directive>, chaque groupe est traité selon
    l'ordre dans lequel il apparaît dans les fichiers de configuration.
    Les sections <directive
    type="section" module="core">Directory</directive> (groupe 1 ci-dessus)
    sont traitées dans l'ordre du répertoire le plus court vers le plus long.
    Par exemple, <code>&lt;Directory "/var/web/dir"&gt;</code> sera
    traité avant <code>&lt;Directory
    "/var/web/dir/subdir"&gt;</code>.  Si plusieurs sections <directive
    type="section" module="core">Directory</directive> s'appliquent au même
    répertoire, elles sont traitées selon l'ordre dans lequel elles
    apparaissent dans le fichier de configuration.
    Les sections de configuration incluses via la directive <directive
    module="core">Include</directive> sont traitées comme si elles se
    trouvaient réellement dans le fichier qui les inclut à la position de la
    directive
    <directive module="core">Include</directive>.</p>

    <p>Les sections situées à l'intérieur de sections <directive type="section"
    module="core">VirtualHost</directive>
    sont appliquées <em>après</em> les sections correspondantes situées en
    dehors de la définition de l'hôte virtuel, ce qui permet à l'hôte virtuel
    de prévaloir sur la configuration du serveur principal.</p>

    <p>Quand la requête est servie par le module <module>mod_proxy</module>,
    le conteneur <directive module="mod_proxy" type="section">Proxy</directive>
    prend la place du conteneur <directive module="core"
    type="section">Directory</directive> dans l'ordre de traitement.</p>
    
	<note><title>Note technique</title>
	Une séquence <code>&lt;Location&gt;</code>/<code>&lt;LocationMatch&gt;</code>
	est réellement traitée juste avant la phase de traduction du nom
	(où <code>Aliases</code> et <code>DocumentRoots</code>
      sont utilisés pour faire correspondre les URLs aux noms de fichiers).
      Les effets de cette séquence disparaissent totalement lorsque
      la traduction est terminée.
	</note>

<section id="relationship-module-configuration"><title>Interactions entre
modules et sections de configuration</title>
    <p>Une question se pose souvent après avoir lu comment les sections de
    configuration sont fusionnées : comment et quand les directives de modules
    particuliers comme <module>mod_rewrite</module> sont-elles interprétées ? La
    réponse n'est pas triviale et nécessite un approfondissement. Chaque module
    httpd gère sa propre configuration, et chacune de ses directives dans
    httpd.conf définit un élément de configuration dans un contexte particulier.
    httpd n'exécute pas un commande au moment où elle est lue.</p>
    <p>A l'exécution, le noyau de httpd parcours les sections de configuration
    dans l'ordre décrit ci-dessus afin de déterminer lesquelles s'appliquent à
    la requête courante. Lorsqu'une première section s'applique, elle est
    considérée comme la configuration courante pour cette requête. Si une
    section suivante s'applique aussi, chaque module qui possède des directives
    dans chacune de ces sections a la possibilité de fusionner sa configuration
    entre ces deux sections. Il en résulte une troisième configuration et le
    processus de fusion se poursuit jusqu'à ce que toutes les sections de
    configuration aient été évaluées.</p>
    <p>Après l'étape précédente, le traitement proprement dit de la requête HTTP
    peut commencer : chaque module peut effectuer toute tâche qui lui incombe,
    et pour déterminer de quelle manière dont il doit agir, il peut s'appuyer
    sur le noyau de httpd pour retrouver sa configuration globale issue de la
    fusion précédente.</p>
    <p>Un exemple permet de mieux visualiser l'ensemble du processus. la
    configuration suivante utilise la directive <directive
    module="mod_headers">Header</directive> du module
    <module>mod_headers</module> pour définir un en-tête HTTP spécifique. Quelle
    valeur httpd va-t-il affecter à l'en-tête <code>CustomHeaderName</code> pour
    une requête vers <code>/example/index.html</code> ?
    </p>
    <highlight language="config">

&lt;Directory "/"&gt;
    Header set CustomHeaderName one
    &lt;FilesMatch ".*"&gt;
        Header set CustomHeaderName three
    &lt;/FilesMatch&gt;
&lt;/Directory&gt;

&lt;Directory "/example"&gt;
    Header set CustomHeaderName two
&lt;/Directory&gt;
     
    </highlight>    
    <ul>
        <li><directive>Directory</directive> "/" s'applique, et une configuration
	initiale est créée qui définit l'en-tête <code>CustomHeaderName</code>
	avec la valeur <code>one</code>.</li>
        <li><directive>Directory</directive> "/example" s'applique, et comme
	<module>mod_headers</module> spécifie dans son code que
	la valeur d'un en-tête doit être écrasée si ce dernier est défini à
	nouveau, une nouvelle configuration est créée qui définit l'en-tête
	<code>CustomHeaderName</code> avec la valeur <code>two</code>.</li>
        <li><directive>FilesMatch</directive> ".*" s'applique, une nouvelle
	opportunité de fusion surgit, et l'en-tête <code>CustomHeaderName</code>
	est défini à la valeur <code>three</code>.</li>
        <li>Finalement, au cours des étapes suivantes du traitement de la
	requête HTTP, <module>mod_headers</module> sera sollicité, et il se
	basera sur la configuration qui a défini l'en-tête
	<code>CustomHeaderName</code> à la valeur <code>three</code>.
	<module>mod_headers</module> utilise normalement cette configuration pour
	accomplir sa tâche, à savoir définir des en-têtes HTTP. Cela ne veut
	cependant pas dire qu'un module ne peut pas effectuer des actions plus
	complexes comme désactiver des directives car elle ne sont pas
	nécessaires ou obsolètes, etc...</li>
    </ul>

    <p>Ceci est aussi vrai pour les fichiers .htaccess car ils possèdent la même
    priorité que les sections <directive>Directory</directive> dans l'ordre de
    fusion. Il faut bien comprendre que les sections de configuration comme
    <directive>Directory</directive> et <directive>FilesMatch</directive> ne
    sont pas comparables avec les directives spécifiques de modules comme
    <directive module="mod_headers">Header</directive> ou <directive
    module="mod_rewrite">RewriteRule</directive> car elles agissent à des
    niveaux différents.
    </p>
</section>	

<section id="merge-examples"><title>Quelques exemples utiles</title>

<p>Voici un exemple imaginaire qui montre l'ordre de combinaison des sections.
En supposant qu'elles s'appliquent toutes à la requête, les directives de
cet exemple seront appliquées dans l'ordre suivant : A &gt; B &gt; C &gt; D &gt;
E.</p>

<highlight language="config">
&lt;Location "/"&gt;
    E
&lt;/Location&gt;

&lt;Files "f.html"&gt;
    D
&lt;/Files&gt;

&lt;VirtualHost *&gt;
&lt;Directory "/a/b"&gt;
    B
&lt;/Directory&gt;
&lt;/VirtualHost&gt;

&lt;DirectoryMatch "^.*b$"&gt;
    C
&lt;/DirectoryMatch&gt;

&lt;Directory "/a/b"&gt;
    A
&lt;/Directory&gt;

</highlight>

<p>Pour un exemple plus concret, considérez ce qui suit.  Sans tenir compte
de toute restriction d'accès placée dans les sections <directive module="core"
type="section">Directory</directive>, la section <directive
module="core" type="section">Location</directive> sera
évaluée en dernier et permettra un accès au serveur sans aucune restriction.
En d'autres termes, l'ordre de la combinaison des sections est important,
soyez donc prudent !</p>

<highlight language="config">
&lt;Location "/"&gt;
    Require all granted
&lt;/Location&gt;

# Arrghs!  Cette section &lt;Directory&gt; n'aura aucun effet
&lt;Directory "/"&gt;
    &lt;RequireAll&gt;
        Require all granted
        Require not host badguy.example.com
    &lt;/RequireAll&gt;
&lt;/Directory&gt;
</highlight>

</section>

</section>
</manualpage>
