<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1808855 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_proxy.xml.meta">

<name>mod_proxy</name>
<description>Serveur mandataire/passerelle multi-protocole</description>
<status>Extension</status>
<sourcefile>mod_proxy.c</sourcefile>
<identifier>proxy_module</identifier>

<summary>
    <note type="warning"><title>Avertissement</title>
      <p>N'activez pas la fonctionnalité de mandataire avec la directive
      <directive module="mod_proxy">ProxyRequests</directive> avant
      d'avoir <a href="#access">sécurisé votre serveur</a>. Les serveurs
      mandataires ouverts sont dangereux pour votre réseau,
      mais aussi pour l'Internet au sens large.</p>
    </note>

    <p><module>mod_proxy</module> et ses modules associés implémentent
    un mandataire/passerelle pour le serveur HTTP Apache, et supportent
    de nombreux protocoles courants, ainsi que plusieurs algorithmes de
    répartition de charge. Le support de protocoles et d'algorithmes de
    répartition de charge supplémentaires peut être assuré par des
    modules tiers.</p>

    <p>Un jeu de modules chargés dans le serveur permet de fournir les
    fonctionnalités souhaitées. Ces modules peuvent être inclus
    statiquement à la compilation, ou dynamiquement via la directive
    <directive module="mod_so">LoadModule</directive>. Ce jeu de module
    doit comporter :</p>

    <ul>
      <li><module>mod_proxy</module>, qui fournit les fonctionnalités de
      base d'un mandataire</li>

      <li><module>mod_proxy_balancer</module> et un ou plusieurs modules
      de répartition, si la répartition de charge doit être mise en
      oeuvre (Voir la documentation de
      <module>mod_proxy_balancer</module> pour plus de détails).</li>

      <li>un ou plusieurs modules de types de mandataire, ou protocoles
      :

        <table border="1">
        <tr><th>Protocole</th><th>Module</th></tr>
        <tr><td>AJP13 (Protocole Apache JServe version
          1.3)</td><td><module>mod_proxy_ajp</module></td></tr>
        <tr><td>CONNECT (pour
          SSL)</td><td><module>mod_proxy_connect</module></td></tr>
        <tr><td>FastCGI</td><td><module>mod_proxy_fcgi</module></td></tr>
        <tr><td>ftp</td><td><module>mod_proxy_ftp</module></td></tr>
        <tr><td>HTTP/0.9, HTTP/1.0, et
          HTTP/1.1</td><td><module>mod_proxy_http</module></td></tr>
        <tr><td>SCGI</td><td><module>mod_proxy_scgi</module></td></tr>
	<tr><td>WS and WSS (Web-sockets)</td><td><module>mod_proxy_wstunnel</module></td></tr>
        </table>
      </li>
    </ul>

    <p>En outre, d'autres modules fournissent des fonctionnalités
    étendues. <module>mod_cache</module> et ses modules associés
    fournissent la mise en cache. Les directives <code>SSLProxy*</code>
    du module <module>mod_ssl</module> permettent de contacter des
    serveurs distants en utilisant le protocole SSL/TLS. Ces modules
    additionnels devront être chargés et configurés pour pouvoir
    disposer de ces fonctionnalités.</p>
</summary>
<seealso><module>mod_cache</module></seealso>
<seealso><module>mod_proxy_ajp</module></seealso>
<seealso><module>mod_proxy_connect</module></seealso>
<seealso><module>mod_proxy_fcgi</module></seealso>
<seealso><module>mod_proxy_ftp</module></seealso>
<seealso><module>mod_proxy_http</module></seealso>
<seealso><module>mod_proxy_scgi</module></seealso>
<seealso><module>mod_proxy_wstunnel</module></seealso>
<seealso><module>mod_proxy_balancer</module></seealso>
<seealso><module>mod_ssl</module></seealso>

    <section id="forwardreverse"><title>Mandataires directs et
    mandataires/passerelles inverses</title>
      <p>Le serveur HTTP Apache peut être configuré dans les deux modes mandataire
      <dfn>direct</dfn> et mandataire <dfn>inverse</dfn> (aussi nommé
      mode <dfn>passerelle</dfn>).</p>

      <p>Un <dfn>mandataire direct</dfn> standard est un serveur
      intermédiaire qui s'intercale entre le client et le <em>serveur
      demandé</em>. Pour obtenir un contenu hébergé par
      le serveur demandé, le client envoie une requête au
      mandataire en nommant le serveur demandé comme
      cible. Le mandataire extrait alors le contenu depuis le
      serveur demandé et le renvoie enfin au client. Le client doit être
      configuré de manière appropriée pour pouvoir utiliser le mandataire
      direct afin d'accéder à d'autres sites.</p>

      <p>L'accès à Internet depuis des clients situés derrière un
      pare-feu est une utilisation typique du mandataire direct. Le
      mandataire direct peut aussi utiliser la mise en cache (fournie
      par <module>mod_cache</module>) pour réduire la charge du
      réseau.</p>

      <p>La fonctionnalité de mandataire direct est activée via la
      directive <directive module="mod_proxy">ProxyRequests</directive>.
      Comme les mandataires directs permettent aux clients d'accéder à
      des sites quelconques via votre serveur et de dissimuler leur
      véritable origine, il est indispensable de <a
      href="#access">sécuriser votre serveur</a> de façon à ce que seuls
      les clients autorisés puissent accéder à votre serveur avant
      d'activer la fonctionnalité de mandataire direct.</p>

      <p>Un <dfn>mandataire inverse</dfn> (ou <dfn>passerelle</dfn>),
      quant à lui, apparaît au client comme un serveur web standard.
      Aucune configuration particulière du client n'est nécessaire. Le
      client adresse ses demandes de contenus ordinaires dans l'espace
      de nommage du mandataire inverse. Ce dernier décide alors où
      envoyer ces requêtes, et renvoie le contenu au client comme s'il
      l'hébergeait lui-même.</p>

      <p>L'accès d'utilisateurs depuis Internet vers un serveur situé
      derrière un pare-feu est une utilisation typique du mandataire
      inverse. On peut aussi utiliser les mandataires inverses pour
      mettre en oeuvre une répartition de charge entre plusieurs
      serveurs en arrière-plan, ou fournir un cache pour un serveur
      d'arrière-plan plus lent. Les mandataires inverses peuvent aussi
      tout simplement servir à rassembler plusieurs serveurs dans le
      même espace de nommage d'URLs.</p>

      <p>La fonctionnalité de mandataire inverse est activée via la
      directive <directive module="mod_proxy">ProxyPass</directive> ou
      le drapeau <code>[P]</code> de la directive <directive
      module="mod_rewrite">RewriteRule</directive>. Il n'est
      <strong>pas</strong> nécessaire de définir <directive
      module="mod_proxy">ProxyRequests</directive> pour configurer
      un mandataire inverse.</p>
    </section> <!-- /forwardreverse -->

    <section id="examples"><title>Exemples simples</title>

    <p>Les exemples ci-dessous illustrent de manière très basique la
    mise en oeuvre de la fonctionnalité de mandataire et ne sont là que
    pour vous aider à démarrer. Reportez-vous à la documentation de
    chaque directive.</p>

    <p>Si en outre, vous désirez activer la mise en cache, consultez la
    documentation de <module>mod_cache</module>.</p>

    <example><title>Mandataire inverse</title>
    <highlight language="config">
ProxyPass "/foo" "http://foo.example.com/bar"
ProxyPassReverse "/foo" "http://foo.example.com/bar"
    </highlight>
    </example>

    <example><title>Mandataire direct</title>
    <highlight language="config">
ProxyRequests On
ProxyVia On

&lt;Proxy "*"&gt;
  Require host internal.example.com
&lt;/Proxy&gt;
    </highlight>
    </example>
    </section> <!-- /examples -->

    <section id="handler"><title>Accès via un gestionnaire</title>

    <p>Vous pouvez aussi forcer le traitement d'une requête en tant que
    requête de mandataire inverse en créant un gestionnaire de transfert
    approprié. Dans l'exemple suivant, toutes les requêtes pour
    des scripts PHP seront transmises au serveur FastCGI
    spécifié via un mandat inverse :
    </p>

    <example><title>Scripts PHP et mandataire inverse</title>
    <highlight language="config">
&lt;FilesMatch "\.php$"&gt;
    # Les sockets Unix nécessitent une version 2.4.7 ou supérieure du
    # serveur HTTP Apache
    SetHandler  "proxy:unix:/path/to/app.sock|fcgi://localhost/"
&lt;/FilesMatch&gt;
    </highlight>
      </example>

      <p>Cette fonctionnalité est disponible à partir de la version
      2.4.10 du serveur HTTP Apache.</p>

    </section> <!-- /handler -->

    <section id="workers"><title>Workers</title>
      <p>Le mandataire gère la configuration et les paramètres de
      communication des serveurs originaux au sein d'objets nommés
      <dfn>workers</dfn>. Deux types de worker sont fournis : le worker
      par défaut du mandataire direct et le worker par défaut du
      mandataire inverse. Il est aussi possible de définir explicitement
      des workers supplémentaires.</p>

      <p>Les deux workers par défaut possèdent une configuration figée
      et seront utilisés si aucun autre worker ne correspond à la
      requête. Ils ne réutilisent pas les connexions et n'utilisent pas les
      connexions HTTP persistantes (Keep-Alive). En effet, les
      connexions TCP vers le serveur original sont fermées et ouvertes
      pour chaque requête.</p>

      <p>Les workers définis explicitement sont identifiés par leur URL.
      Ils sont en général définis via les directives <directive
      module="mod_proxy">ProxyPass</directive> ou <directive
      module="mod_proxy">ProxyPassMatch</directive> lorsqu'on les
      utilise dans le cadre d'un mandataire inverse :</p>

      <example>
      <highlight language="config">
          ProxyPass "/example" "http://backend.example.com" connectiontimeout=5 timeout=30
	  </highlight>
      </example>
      

      <p>Cette directive va créer un worker associé à l'URL du serveur
      original <code>http://backend.example.com</code> qui utilisera les
      valeurs de timeout données. Lorsqu'ils sont utilisés dans le cadre
      d'un mandataire direct, les workers sont en général définis via la
      directive <directive module="mod_proxy">ProxySet</directive>,</p>

      <example>
      <highlight language="config">
          ProxySet "http://backend.example.com" connectiontimeout=5 timeout=30
	  </highlight>
      </example>
      

      <p>ou encore via les directives <directive
      module="mod_proxy">Proxy</directive> et <directive
      module="mod_proxy">ProxySet</directive> :</p>

      <highlight language="config">
&lt;Proxy "http://backend.example.com"&gt;
  ProxySet connectiontimeout=5 timeout=30
&lt;/Proxy&gt;
      </highlight>

      <p>L'utilisation de workers définis explicitement dans le mode
      mandataire direct n'est pas très courante, car les mandataires
      directs communiquent en général avec de nombreux serveurs
      originaux. La création explicite de workers pour certains serveurs
      originaux peut cependant s'avérer utile si ces serveurs sont
      très souvent sollicités. A leur niveau, les workers explicitement
      définis ne possèdent aucune notion de mandataire direct ou
      inverse. Ils encapsulent un concept de communication commun avec
      les serveurs originaux. Un worker créé via la directive <directive
      module="mod_proxy">ProxyPass</directive> pour être utilisé dans le
      cadre d'un mandataire inverse sera aussi utilisé dans le cadre
      d'un mandataire directe chaque fois que l'URL vers le serveur
      original correspondra à l'URL du worker, et vice versa.</p>

      <p>L'URL qui identifie un worker correspond à l'URL de son serveur
      original, y compris un éventuel chemin donné :</p>

      <highlight language="config">
ProxyPass "/examples" "http://backend.example.com/examples"
ProxyPass "/docs" "http://backend.example.com/docs"
      </highlight>

      <p>Dans cet exemple, deux workers différents sont définis, chacun
      d'eux utilisant des configurations et jeux de connexions
      séparés.</p>

      <note type="warning"><title>Partage de workers</title>
        <p>Le partage de workers intervient lorsque les URLs des workers
	s'entrecoupent, ce qui arrive lorsque l'URL d'un worker
	correspond au début de l'URL d'un autre worker défini plus loin
	dans le fichier de configuration. Dans l'exemple suivant,</p>

        <highlight language="config">
ProxyPass "/apps" "http://backend.example.com/" timeout=60
ProxyPass "/examples" "http://backend.example.com/examples" timeout=10
        </highlight>

        <p>le second worker n'est pas vraiment créé. C'est le premier
	worker qui est en fait utilisé. L'avantage de ceci réside dans
	le fait qu'il n'existe qu'un seul jeu de connexions, ces
	dernières étant donc réutilisées plus souvent. Notez que tous
	les attributs de configuration définis explicitement pour le
	deuxième worker seront ignorés, ce qui sera journalisé en tant
	qu'avertissement. Ainsi, dans l'exemple ci-dessus, la valeur de
	timeout retenue pour l'URL <code>/exemples</code> sera
	<code>60</code>, et non <code>10</code> !</p>

        <p>Si vous voulez empêcher le partage de workers, classez vos
	définitions de workers selon la longueur des URLs, de la plus
	longue à la plus courte. Si au contraire vous voulez favoriser
	ce partage, utilisez l'ordre de classement inverse. Voir aussi
	l'avertissement à propos de l'ordre de classement des directives
	<directive module="mod_proxy">ProxyPass</directive>.</p>

      </note> <!-- /worker_sharing -->

      <p>Les workers définis explicitement sont de deux sortes :
      <dfn>workers directs</dfn> et <dfn>workers de répartition (de
      charge)</dfn>. Ils supportent de nombreux attributs de
      configuration importants décrits dans la directive <directive
      module="mod_proxy">ProxyPass</directive>. Ces mêmes attributs
      peuvent aussi être définis via la directive <directive
      module="mod_proxy">ProxySet</directive>.</p>

      <p>Le jeu d'options disponibles pour un worker direct dépend du
      protocole spécifié dans l'URL du serveur original. Les protocoles
      disponibles comprennent <code>ajp</code>, <code>fcgi</code>,
      <code>ftp</code>, <code>http</code> et <code>scgi</code>.</p>

      <p>Les workers de répartition sont des workers virtuels qui
      utilisent les workers directs, connus comme faisant partie de leurs
      membres, pour le traitement effectif des requêtes. Chaque
      répartiteur peut comporter plusieurs membres. Lorsqu'il traite une
      requête, il choisit un de ses membres en fonction de l'algorithme
      de répartition de charge défini.</p>

      <p>Un worker de répartition est créé si son URL de worker comporte
      <code>balancer</code> comme indicateur de protocole. L'URL du
      répartiteur permet d'identifier de manière unique le worker de
      répartition. La directive <directive
      module="mod_proxy">BalancerMember</directive> permet d'ajouter des
      membres au répartiteur.</p>

      <note><title>Résolution DNS pour les domaines originaux</title>
      <p>La résolution DNS s'effectue lorsque le socket vers le
      domaine original est créé pour la première fois. Lorsque la réutilisation
      des connexions est activée, chaque domaine d'arrière-plan n'est résolu qu'une
      seule fois pour chaque processus enfant, et cette résolution est mise en
      cache pour toutes les connexions ultérieures jusqu'à ce que le processus enfant
      soit recyclé. Ce comportement doit être pris en considération lorsqu'on
      planifie des tâches de maintenance du DNS impactant les domaines
      d'arrière-plan. Veuillez aussi vous reporter aux paramètres de la
      directive <directive module="mod_proxy">ProxyPass</directive> pour plus de
      détails à propos de la réutilisation des connexions.</p>
      </note>

    </section> <!-- /workers -->

    <section id="access"><title>Contrôler l'accès à votre
    mandataire</title>
      <p>Vous pouvez restreindre l'accès à votre mandataire via le bloc
      de contrôle <directive
      module="mod_proxy" type="section">Proxy</directive> comme dans
      l'exemple suivant :</p>

      <highlight language="config">
&lt;Proxy "*"&gt;
  Require ip 192.168.0
&lt;/Proxy&gt;
      </highlight>

      <p>Pour plus de détails sur les directives de contrôle d'accès,
      voir la documentation du module
      <module>mod_authz_host</module>.</p>

      <p>Restreindre l'accès de manière stricte est essentiel si vous
      mettez en oeuvre un mandataire direct (en définissant la directive
      <directive module="mod_proxy">ProxyRequests</directive> à "on").
      Dans le cas contraire, votre serveur pourrait être utilisé par
      n'importe quel client pour accéder à des serveurs quelconques,
      tout en masquant sa véritable identité. Ceci représente un danger
      non seulement pour votre réseau, mais aussi pour l'Internet au
      sens large. Dans le cas de la mise en oeuvre d'un mandataire
      inverse (en utilisant la directive <directive
      module="mod_proxy">ProxyPass</directive> avec <code>ProxyRequests Off</code>), le contrôle
      d'accès est moins critique car les clients ne peuvent contacter
      que les serveurs que vous avez spécifiés.</p>

      <p><strong>Voir aussi</strong> la variable d'environnement <a
      href="mod_proxy_http.html#env">Proxy-Chain-Auth</a>.</p>

    </section> <!-- /access -->

    <section id="startup"><title>Ralentissement au démarrage</title>
      <p>Si vous utilisez la directive <directive module="mod_proxy"
      >ProxyBlock</directive>, les noms d'hôtes sont résolus en adresses
      IP puis ces dernières mises en cache au cours du démarrage
      à des fins de tests de comparaisons ultérieurs. Ce processus peut
      durer plusieurs secondes (ou d'avantage) en fonction de la vitesse
      à laquelle s'effectue la résolution des noms d'hôtes.</p>
    </section> <!-- /startup -->

    <section id="intranet"><title>Mandataire en Intranet</title>
      <p>Un serveur mandataire Apache httpd situé à l'intérieur d'un Intranet
      doit faire suivre les requêtes destinées à un serveur externe à
      travers le pare-feu de l'entreprise (pour ce faire, définissez la
      directive <directive module="mod_proxy">ProxyRemote</directive> de
      façon à ce qu'elle fasse suivre le <var>protocole</var> concerné
      vers le mandataire du pare-feu). Cependant, lorsqu'il doit accéder
      à des ressources situées dans l'Intranet, il peut se passer du
      pare-feu pour accéder aux serveurs. A cet effet, la directive
      <directive module="mod_proxy">NoProxy</directive> permet de
      spécifier quels hôtes appartiennent à l'Intranet et peuvent donc
      être accédés directement.</p>

      <p>Les utilisateurs d'un Intranet ont tendance à oublier le nom du
      domaine local dans leurs requêtes WWW, et demandent par exemple
      "http://un-serveur/" au lieu de
      <code>http://un-serveur.example.com/</code>. Certains serveurs
      mandataires commerciaux acceptent ce genre de requête et les
      traitent simplement en utilisant un nom de domaine local
      implicite. Lorsque la directive <directive
      module="mod_proxy">ProxyDomain</directive> est utilisée et si le
      serveur est <a href="#proxyrequests">configuré comme
      mandataire</a>, Apache httpd peut renvoyer une réponse de redirection et
      ainsi fournir au client l'adresse de serveur correcte,
      entièrement qualifiée. C'est la méthode à privilégier car le
      fichier des marque-pages de l'utilisateur contiendra alors des
      noms de serveurs entièrement qualifiés.</p>
    </section> <!-- /intranet -->

    <section id="envsettings"><title>Ajustements relatifs au
    protocole</title>
      <p>Pour les cas où <module>mod_proxy</module> envoie des requêtes
      vers un serveur qui n'implémente pas correctement les connexions
      persistantes ou le protocole HTTP/1.1, il existe deux variables
      d'environnement qui permettent de forcer les requêtes à utiliser
      le protocole HTTP/1.0 avec connexions non persistantes. Elles
      peuvent être définies via la directive <directive
      module="mod_env">SetEnv</directive>.</p>

      <p>Il s'agit des variables <code>force-proxy-request-1.0</code> et
      <code>proxy-nokeepalive</code>.</p>

      <highlight language="config">
&lt;Location "/buggyappserver/"&gt;
  ProxyPass "http://buggyappserver:7001/foo/"
  SetEnv force-proxy-request-1.0 1
  SetEnv proxy-nokeepalive 1
&lt;/Location&gt;
        </highlight>

      <p>A partir de la version 2.4.26 du serveur HTTP Apache, la définition de
      la variable d'environnement "no-proxy" permet de désactiver
      <module>mod_proxy</module> dans le traitement de la requête courante.
      Cette variable doit être définie via la directive <directive
      module="mod_setenvif">SetEnvIf</directive> car la directive <directive
      module="mod_env">SetEnv</directive> n'est pas évaluée assez tôt.</p>	

    </section> <!-- /envsettings -->

    <section id="request-bodies"><title>Corps de requêtes</title>

    <p>Certaines méthodes de requêtes comme POST comportent un corps de
    requête. Le protocole HTTP stipule que les requêtes qui comportent
    un corps doivent soit utiliser un codage de transmission
    fractionnée (chunked transfer encoding), soit envoyer un en-tête de requête
    <code>Content-Length</code>. Lorsqu'il fait suivre ce genre de
    requête vers le serveur demandé, <module>mod_proxy_http</module>
    s'efforce toujours d'envoyer l'en-tête <code>Content-Length</code>.
    Par contre, si la taille du corps est importante, et si la requête
    originale utilise un codage à fractionnement, ce dernier peut aussi
    être utilisé dans la requête montante. Ce comportement peut être
    contrôlé à l'aide de <a href="../env.html">variables
    d'environnement</a>. Ainsi, si elle est définie, la variable
    <code>proxy-sendcl</code> assure une compatibilité maximale avec les
    serveurs demandés en imposant l'envoi de l'en-tête
    <code>Content-Length</code>, alors que
    <code>proxy-sendchunked</code> diminue la consommation de ressources
    en imposant l'utilisation d'un codage à fractionnement.</p>

    <p>Dans certaines circonstances, le serveur doit mettre en file
    d'attente sur disque les corps de requêtes afin de satisfaire le
    traitement demandé des corps de requêtes. Par exemple, cette mise en
    file d'attente se produira si le corps original a été envoyé selon un
    codage morcelé (et possède une taille importante), alors que
    l'administrateur a demandé que les requêtes du serveur
    d'arrière-plan soient envoyées avec l'en-tête Content-Length ou en
    HTTP/1.0. Cette mise en file d'attente se produira aussi si le corps
    de la requête contient déjà un en-tête Content-Length, alors que le
    serveur est configuré pour filtrer les corps des requêtes entrantes.</p>

    <p>La directive <directive
    module="core">LimitRequestBody</directive> ne s'applique qu'aux
    corps de requêtes que le serveur met en file d'attente sur disque.</p>

    </section> <!-- /request-bodies -->

    <section id="x-headers"><title>En-têtes de requête du mandataire
    inverse</title>

    <p>Lorsqu'il est configuré en mode mandataire inverse (en utilisant
    par exemple la directive <directive
    module="mod_proxy">ProxyPass</directive>),
    <module>mod_proxy_http</module> ajoute plusieurs en-têtes de requête
    afin de transmettre des informations au serveur demandé. Ces
    en-têtes sont les suivants :</p>

    <dl>
      <dt><code>X-Forwarded-For</code></dt>
      <dd>L'adresse IP du client.</dd>
      <dt><code>X-Forwarded-Host</code></dt>
      <dd>L'hôte d'origine demandé par le client dans l'en-tête de
      requête HTTP <code>Host</code>.</dd>
      <dt><code>X-Forwarded-Server</code></dt>
      <dd>Le nom d'hôte du serveur mandataire.</dd>
    </dl>

    <p>Ces en-têtes doivent être utilisés avec précautions sur le
    serveur demandé, car ils contiendront plus d'une valeur (séparées
    par des virgules) si la requête originale contenait déjà un de ces
    en-têtes. Par exemple, vous pouvez utiliser
    <code>%{X-Forwarded-For}i</code> dans la chaîne de format du journal
    du serveur demandé pour enregistrer les adresses IP des clients
    originaux, mais il est possible que vous obteniez plusieurs adresses
    si la requête passe à travers plusieurs mandataires.</p>

    <p>Voir aussi les directives <directive
    module="mod_proxy">ProxyPreserveHost</directive> et <directive
    module="mod_proxy">ProxyVia</directive> directives, qui permettent
    de contrôler d'autres en-têtes de requête.</p>

    <p>Note : Si vous devez ajouter des en-têtes particuliers à la
    requête mandatée, utilisez la directive  <directive
    module="mod_headers">RequestHeader</directive>.</p>

   </section> <!--/x-headers -->


<directivesynopsis type="section">
<name>Proxy</name>
<description>Conteneur de directives s'appliquant à des ressources
mandatées</description>
<syntax>&lt;Proxy <var>url-avec-jokers</var>&gt; ...&lt;/Proxy&gt;</syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Les directives situées dans une section <directive
    type="section">Proxy</directive> ne s'appliquent qu'au contenu
    mandaté concerné. Les jokers de style shell sont autorisés.</p>

    <p>Par exemple, les lignes suivantes n'autoriseront à accéder à un
    contenu via votre serveur mandataire que les hôtes appartenant à
    <code>votre-reseau.example.com</code> :</p>

    <highlight language="config">
&lt;Proxy "*"&gt;
  Require host votre-reseau.example.com
&lt;/Proxy&gt;
    </highlight>

    <p>Dans l'exemple suivant, tous les fichiers du répertoire
    <code>foo</code> de <code>example.com</code> seront traités par le
    filtre <code>INCLUDES</code> lorsqu'ils seront envoyés par
    l'intermédiaire du serveur mandataire :</p>

    <highlight language="config">    
&lt;Proxy "http://example.com/foo/*"&gt;
  SetOutputFilter INCLUDES
&lt;/Proxy&gt;
    </highlight>

    <note><title>Différences avec la section de configuration Location</title>
      <p>Une URL d'arrière-plan sera concernée par le conteneur Proxy si
      elle commence par la <var>url-avec-jokers</var>, même si le
      dernier segment de chemin de la directive ne correspond qu'à un
      préfixe de segment dee chemin de l'URL d'arrière-plan. Par exemple, &lt;Proxy
      "http://example.com/foo"&gt; correspondra entre autres aux URLs
      http://example.com/foo, http://example.com/foo/bar, et
      http://example.com/foobar. La correspondance de l'URL finale
      diffère du comportement de la section <directive type="section"
      module="core">Location</directive> qui, pour le cas de cette note,
      traitera le segment de chemin final comme s'il se terminait par un
      slash.</p>
      <p>Pour un contrôle plus fin de la correspondance des URL, voir la
      directive <directive type="section">ProxyMatch</directive>.</p>
    </note>

</usage>
<seealso><directive type="section" module="mod_proxy">ProxyMatch</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ProxyBadHeader</name>
<description>Détermine la manière de traiter les lignes d'en-tête
incorrectes d'une réponse</description>
<syntax>ProxyBadHeader IsError|Ignore|StartBody</syntax>
<default>ProxyBadHeader IsError</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>ProxyBadHeader</directive> permet de
    déterminer le comportement de <module>mod_proxy</module> lorsqu'il
    reçoit des lignes d'en-tête de réponse dont la syntaxe n'est pas valide (c'est
    à dire ne contenant pas de caractère ':') en provenance du serveur
    original. Les arguments disponibles sont :</p>

    <dl>
    <dt><code>IsError</code></dt>
    <dd>Annule la requête et renvoie une réponse de code 502 (mauvaise
    passerelle). C'est le comportement par défaut.</dd>

    <dt><code>Ignore</code></dt>
    <dd>Traite les lignes d'en-tête incorrectes comme si elles n'avaient
    pas été envoyées.</dd>

    <dt><code>StartBody</code></dt>
    <dd>A la réception de la première ligne d'en-tête incorrecte, les
    autres en-têtes sont lus et ce qui reste est traité en tant que
    corps. Ceci facilite la prise en compte des serveurs d'arrière-plan
    bogués qui oublient d'insérer une ligne vide entre les
    en-têtes et le corps.</dd>
    </dl>
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>ProxyMatch</name>
<description>Conteneur de directives s'appliquant à des ressources
mandatées correspondant à une expression rationnelle</description>
<syntax>&lt;ProxyMatch <var>regex</var>&gt; ...&lt;/ProxyMatch&gt;</syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive type="section">ProxyMatch</directive> est
    identique à la directive <directive module="mod_proxy"
    type="section">Proxy</directive>, à l'exception qu'elle définit
    les URLs auxquelles elle s'applique en utilisant une <glossary
    ref="regex">expression rationnelle</glossary>.</p>

    <p>A partir de la version 2.4.8, les groupes nommés et les
    références arrières sont extraits et enregistrés dans
    l'environnement avec leur nom en majuscules et préfixé par "MATCH_". Ceci permet
    de référencer des URLs dans des <a href="../expr.html">expressions</a>
    ou au sein de modules comme <module>mod_rewrite</module>. Pour
    éviter toute confusion, les références arrières numérotées (non
    nommées) sont ignorées. Vous devez utiliser à la place des groupes
    nommés.</p>

<highlight language="config">
&lt;ProxyMatch "^http://(?&lt;sitename&gt;[^/]+)"&gt;
    Require ldap-group cn=%{env:MATCH_SITENAME},ou=combined,o=Example
&lt;/ProxyMatch&gt;
</highlight>
</usage>
<seealso><directive type="section" module="mod_proxy">Proxy</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ProxyPreserveHost</name>
<description>Utilise l'en-tête de requête entrante Host pour la requête
du mandataire</description>
<syntax>ProxyPreserveHost On|Off</syntax>
<default>ProxyPreserveHost Off</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>
<compatibility>Utilisable
dans un contexte de répertoire depuis la version 2.3.3.</compatibility>

<usage>
    <p>Lorsqu'elle est activée, cette directive va transmettre l'en-tête
    Host: de la requête entrante vers le serveur mandaté, au lieu du nom
    d'hôte spécifié par la directive <directive
    module="mod_proxy">ProxyPass</directive>.</p>

    <p>Cette directive est habituellement définie à <code>Off</code>.
    Elle est principalement utile dans les configurations particulières
    comme l'hébergement virtuel mandaté en masse à base de nom, où
    l'en-tête Host d'origine doit être évalué par le serveur
    d'arrière-plan.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyRequests</name>
<description>Active la fonctionnalité (standard) de mandataire
direct</description>
<syntax>ProxyRequests On|Off</syntax>
<default>ProxyRequests Off</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive permet d'activer/désactiver la fonctionnalité de
    serveur mandataire direct d'Apache httpd. Définir ProxyRequests à
    <code>Off</code> n'interdit pas l'utilisation de la directive
    <directive module="mod_proxy">ProxyPass</directive>.</p>

    <p>Pour une configuration typique de mandataire inverse ou
    passerelle, cette directive doit être définie à
    <code>Off</code>.</p>

    <p>Afin d'activer la fonctionnalité de mandataire pour des sites
    HTTP et/ou FTP, les modules <module>mod_proxy_http</module> et/ou
    <module>mod_proxy_ftp</module> doivent également être chargés dans le
    serveur.</p>

    <p>Pour activer la fonctionnalité de mandataire sur les sites chiffrés en HTTPS, le module
    <module>mod_proxy_connect</module> doit également être chargé dans le serveur.</p>

    <note type="warning"><title>Avertissement</title>
      <p>N'activez pas la fonctionnalité de mandataire avec la directive
      <directive module="mod_proxy">ProxyRequests</directive> avant
      d'avoir <a href="#access">sécurisé votre serveur</a>. Les serveurs
      mandataires ouverts sont dangereux non seulement pour votre
      réseau, mais aussi pour l'Internet au sens large.</p>
    </note>
</usage>
<seealso><a href="#forwardreverse">Mandataires/Passerelles directs et
inverses</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ProxyRemote</name>
<description>Mandataire distant à utiliser pour traiter certaines
requêtes</description>
<syntax>ProxyRemote <var>comparaison</var> <var>serveur-distant</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive permet de définir des mandataires distants pour
    ce mandataire. <var>comparaison</var> est soit le nom d'un protocole
    que supporte le serveur distant, soit une URL partielle pour
    laquelle le serveur distant devra être utilisé, soit <code>*</code>
    pour indiquer que le serveur distant doit être utilisé pour toutes
    les requêtes. <var>serveur-distant</var> est une URL partielle
    correspondant au serveur distant. Syntaxe : </p>

    <example>
      <dfn>serveur-distant</dfn> =
          <var>protocole</var>://<var>nom-serveur</var>[:<var>port</var>]
    </example>

    <p><var>protocole</var> est effectivement le protocole à utiliser
    pour communiquer avec le serveur distant ; ce module ne supporte que
    <code>http</code> et <code>https</code>. Lorsqu'on utilise
    <code>https</code>, les requêtes sont redirigées par le mandataire
    distant en utilisant la méthode HTTP CONNECT.</p>

    <example><title>Exemple</title>
      <highlight language="config">
ProxyRemote "http://goodguys.example.com/"
"http://mirrorguys.example.com:8000"
ProxyRemote "*" "http://cleverproxy.localdomain"
ProxyRemote "ftp" "http://ftpproxy.mydomain:8080"
    </highlight>
    </example>

    <p>Dans la dernière ligne de l'exemple, le mandataire va faire
    suivre les requêtes FTP, encapsulées dans une autre requête mandatée
    HTTP, vers un autre mandataire capable de les traiter.</p>

    <p>Cette directive supporte aussi les configurations de mandataire
    inverse ; un serveur web d'arrière-plan peut être intégré dans
    l'espace d'URL d'un serveur virtuel, même si ce serveur est caché
    par un autre mandataire direct.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyRemoteMatch</name>
<description>Le mandataire distant à utiliser pour traiter les requêtes
correspondant à une expression rationnelle</description>
<syntax>ProxyRemoteMatch <var>regex</var> <var>serveur-distant</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>ProxyRemoteMatch</directive> est
    identique à la directive <directive
    module="mod_proxy">ProxyRemote</directive>, à l'exception du
    premier argument qui est une <glossary ref="regex">expression
    rationnelle</glossary> à mettre en correspondance avec l'URL de la
    requête.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>BalancerGrowth</name>
<description>Nombre de membres supplémentaires pouvant être ajoutés
après la configuration initiale</description>
    <syntax>BalancerGrowth <var>#</var></syntax>
    <default>BalancerGrowth 5</default>
    <contextlist><context>server config</context><context>virtual host</context></contextlist>
<compatibility>BalancerGrowth est disponible depuis la version 2.3.13 du
serveur HTTP Apache</compatibility>
<usage>
    <p>Cette directive permet de définir le nombre de membres pouvant
    être ajoutés au groupe de répartition de charge préconfiguré d'un
    serveur virtuel. Elle n'est active que si le groupe a été
    préconfiguré avec un membre au minimum.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>BalancerPersist</name>
    <description>Tente de conserver les changements effectués par le
    gestionnaire de répartition de charge après un redémarrage du
    serveur.</description>
    <syntax>BalancerPersist On|Off</syntax>
    <default>BalancerPersist Off</default>
    <contextlist><context>server config</context><context>virtual host</context></contextlist>
    <compatibility>BalancerPersist n'est disponible qu'à partir de la
    version 2.4.4 du serveur HTTP Apache.</compatibility>
    <usage>
        <p>Cette directive permet de conserver le contenu de l'espace
	mémoire partagé associé aux répartiteurs de charge et à leurs
	membres après un redémarrage du serveur. Ces modifications
	locales ne sont ainsi pas perdues lors des transitions d'état
	dues à un redémarrage.</p>
    </usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyPassInherit</name>
    <description>Héritage des directives ProxyPass définies au niveau du
serveur principal</description>
    <syntax>ProxyPassInherit On|Off</syntax>
    <default>ProxyPassInherit On</default>
    <contextlist><context>server config</context><context>virtual host</context></contextlist>
    <compatibility>Disponible à partir de la version 2.4.5 du serveur
HTTP Apache.</compatibility>
    <usage>
        <p>Cette directive permet à un serveur virtuel d'hériter des
	directives <directive module="mod_proxy">ProxyPass</directive> définies
	au niveau du serveur principal. Si vous utilisez la fonctionnalité de
	modifications dynamiques du Balancer Manager, cette directive peut
	causer des problèmes et des comportements inattendus et doit donc
	être désactivée.</p>
        <p>Les valeurs définies au niveau du serveur principal
	constituent les valeurs par défaut pour tous les serveurs virtuels.</p>
        <p>La désactivation de ProxyPassInherit désactive aussi la
	directive <directive module="mod_proxy">BalancerInherit</directive>.</p>
    </usage>
</directivesynopsis>

<directivesynopsis>
    <name>BalancerInherit</name>
    <description>Héritage des membres du groupes de répartition de
    charge du mandataire définis au niveau du serveur principal</description>
    <syntax>BalancerInherit On|Off</syntax>
    <default>BalancerInherit On</default>
    <contextlist><context>server config</context><context>virtual host</context></contextlist>
    <compatibility>Disponible à partir de la version 2.4.5 du serveur
    HTTP Apache.</compatibility>
    <usage>
        <p>Cette directive permet d'attribuer au serveur virtuel courant
	l'héritage des membres de groupes de répartition de charge
	définis au niveau du serveur
	principal. Elle ne doit pas être activée si vous
	utilisez la fonctionnalité de modifications dynamiques du
	gestionnaire de répartition de charge (Balancer Manager) pour
	éviter des problèmes et des comportements inattendus.</p>
        <p>Les définitions au niveau du serveur principal constituent
	les définitions par défaut au niveau des serveurs virtuels.</p>
	
    </usage>
</directivesynopsis>

<directivesynopsis>
<name>BalancerMember</name>
<description>Ajoute un membre à un groupe de répartition de
charge</description>
<syntax>BalancerMember [<var>balancerurl</var>] <var>url</var> [<var
  >clé=valeur [clé=valeur ...]]</var></syntax>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.2 du serveur HTTP Apache.</compatibility>
<usage>
    <p>Cette directive permet d'ajouter un membre à un groupe de
    répartition de charge. Elle peut se trouver dans un conteneur
    <code>&lt;Proxy <var>balancer://</var>...&gt;</code>, et accepte
    tous les paramètres de paires clé/valeur que supporte la directive
    <directive module="mod_proxy">ProxyPass</directive>.</p>
    <p>La directive <directive>BalancerMember</directive> accepte un paramètre
    supplémentaire : <var>loadfactor</var>. Il s'agit du facteur de
    charge du membre - un nombre décimal entre 1.0 (valeur par défaut) et 100.0, qui
    définit la charge à appliquer au membre en question.</p>
    <p>L'argument <var>balancerurl</var> n'est requis que s'il ne se trouve pas
    dèjà dans la directive de conteneur <code>&lt;Proxy
    <var>balancer://</var>...&gt;</code>. Il correspond à l'URL d'un
    répartiteur de charge défini par une directive <directive
    module="mod_proxy">ProxyPass</directive>.</p>
    <p>La partie chemin de l'URL du répartiteur dans toute directive de
    conteneur <code>&lt;Proxy <var>balancer://</var>...&gt;</code> est
    ignorée.</p>
    <p>En particulier, le slash de fin de l'URL d'un
    <directive>BalancerMember</directive> doit être supprimé.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxySet</name>
<description>Définit différents paramètres relatifs à la répartition de
charge des mandataires et aux membres des groupes de répartition de
charge</description>
<syntax>ProxySet <var>url</var> <var>clé=valeur [clé=valeur ...]</var></syntax>
<contextlist><context>directory</context>
</contextlist>
<compatibility>ProxySet n'est disponible que depuis la version 2.2
du serveur HTTP Apache.</compatibility>
<usage>
    <p>Cette directive propose une méthode alternative pour définir tout
    paramètre relatif aux répartiteurs de charge et serveurs cibles de
    mandataires normalement définis via la directive <directive
    module="mod_proxy">ProxyPass</directive>. Si elle se trouve dans un
    conteneur <code>&lt;Proxy <var>url de répartiteur|url de
    serveur cible</var>&gt;</code>, l'argument <var>url</var> n'est pas
    nécessaire. Comme effet de bord, le répartiteur ou serveur cible respectif
    est créé. Ceci peut s'avérer utile pour la mise en oeuvre d'un
    mandataire inverse via une directive <directive
    module="mod_rewrite">RewriteRule</directive> au lieu de <directive
    module="mod_proxy">ProxyPass</directive>.</p>

    <example>
      <highlight language="config">
&lt;Proxy "balancer://hotcluster"&gt;
    BalancerMember "http://www2.example.com:8080" loadfactor=1
    BalancerMember "http://www3.example.com:8080" loadfactor=2
    ProxySet lbmethod=bytraffic
&lt;/Proxy&gt;
      </highlight>
    </example>

    <highlight language="config">
&lt;Proxy "http://backend"&gt;
    ProxySet keepalive=On
&lt;/Proxy&gt;
    </highlight>

    <highlight language="config">
        ProxySet "balancer://foo" lbmethod=bytraffic timeout=15
    </highlight>

    <highlight language="config">
        ProxySet "ajp://backend:7001" timeout=15
    </highlight>

   <note type="warning"><title>Avertissement</title>
      <p>Gardez à l'esprit qu'une même clé de paramètre peut avoir
      différentes significations selon qu'elle s'applique à un
      répartiteur ou à un serveur cible, et ceci est illustré par les deux
      exemples précédents où il est question d'un timeout.</p>
   </note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyPass</name>
<description>Référencer des serveurs distants depuis
l'espace d'URLs du serveur local</description>
<syntax>ProxyPass [<var>chemin</var>] !|<var>url</var> [<var>clé=valeur</var>
  <var>[clé=valeur</var> ...]] [nocanon] [interpolate] [noquery]</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>
<compatibility>Les sockets de style Unix (Unix Domain Socket - UDS)
sont supportés à partir de la version 2.4.7 du serveur HTTP Apache</compatibility>


<usage>
    <p>Cette directive permet de référencer des serveurs distants depuis
    l'espace d'URLs du serveur local. Le serveur
    local n'agit pas en tant que mandataire au sens conventionnel, mais
    plutôt comme miroir du serveur distant. Le serveur local est
    souvent nommé <dfn>mandataire inverse</dfn> ou
    <dfn>passerelle</dfn>. L'argument <var>chemin</var> est le nom d'un
    chemin virtuel local ; <var>url</var> est une URL partielle pour le
    serveur distant et ne doit pas contenir de chaîne d'arguments.</p>

    <note>Il est fortement recommandé de revoir le concept de <a
    href="#workers">Worker</a> avant d'aller plus loin.</note>

    <note>Cette directive n'est pas supportée au sein
    des sections <directive type="section" module="core">Directory</directive>
    et <directive type="section" module="core">Files</directive>.</note>

    <note type="warning">En général, la directive <directive
    module="mod_proxy">ProxyRequests</directive> doit être définie à
    <strong>off</strong> lorsqu'on utilise la directive
    <directive>ProxyPass</directive>.</note>

    <p>Les sockets de style Unix sont supportés à partir de la version
    2.4.7 du serveur HTTP Apache ; pour utiliser cette fonctionnalité,
    il suffit d'utiliser une URL cible préfixée par
    <code>unix:/path/lis.sock|</code>. Par exemple, pour mandater HTTP
    et cibler l'UDS /home/www/socket, vous devez utiliser
    <code>unix:/home/www.socket|http://localhost/whatever/</code>.</p>

    <note><strong>Note :</strong>Le chemin associé à l'URL
    <code>unix:</code> tient compte de la directive
    <directive>DefaultRuntimeDir</directive>.</note>

    <p>Lorsque cette directive est utilisée dans une section <directive
    type="section" module="core">Location</directive>, le premier
    argument est omis et le répertoire local est obtenu à partir de
    l'argument de la directive <directive type="section"
    module="core">Location</directive>. Il en est de même à l'intérieur
    d'une section <directive type="section"
    module="core">LocationMatch</directive>, mais le résultat ne sera
    probablement pas celui attendu car ProxyPassReverse va interpréter
    l'expression rationnelle littéralement comme un chemin ; si besoin
    est dans ce cas, définissez la directive ProxyPassReverse en dehors
    de la section, ou dans une section <directive type="section"
    module="core">Location</directive> séparée.</p>

    <p>Supposons que le serveur local a pour adresse
    <code>http://example.com/</code> ; alors la ligne</p>

    <highlight language="config">
&lt;Location "/mirror/foo/"&gt;
    ProxyPass "http://backend.example.com/"
&lt;/Location&gt;
    </highlight>

    <p>va convertir en interne toute requête pour
    <code>http://example.com/miroir/foo/bar</code> en une requête
    mandatée pour <code>http://backend.example.com/bar</code>.</p>

    <p>Si vous avez besoin d'un configuration de mandataire inverse plus
    souple, reportez-vous à la documentaion de la directive <directive
    module="mod_rewrite">RewriteRule</directive> et son drapeau
    <code>[P]</code>.</p>

    <p>La syntaxe alternative suivante est valide, bien qu'elle puisse
    induire une dégradation des performances lorsqu'elle est
    présente en très grand nombre. Elle possède l'avantage de
    permettre un contrôle dynamique via l'interface <a
    href="mod_proxy_balancer.html#balancer_manager">Balancer Manager</a> :</p>

    <highlight language="config">
        ProxyPass "/miroir/foo/" "http://backend.example.com/"
    </highlight>

    <note type="warning">
    <p>Si le premier argument se termine par un slash
    <strong>/</strong>, il doit en être de même pour le second argument
    et vice versa. Dans le cas contraire, il risque de manquer des
    slashes nécessaires dans la requête résultante vers le serveur
    d'arrière-plan et les résulats ne seront pas ceux attendus.
    </p>
    </note>

    <p>Le drapeau <code>!</code> permet de soustraire un sous-répertoire
    du mandat inverse, comme dans l'exemple suivant :</p>

    <highlight language="config">
&lt;Location "/mirror/foo/"&gt;
    ProxyPass "http://backend.example.com/"
&lt;/Location&gt;
&lt;Location "/mirror/foo/i"&gt;
    ProxyPass "!"
&lt;/Location&gt;
    </highlight>

    <highlight language="config">
ProxyPass "/mirror/foo/i" "!"
ProxyPass "/mirror/foo" "http://backend.example.com"
    </highlight>

    <p>va mandater toutes les requêtes pour <code>/miroir/foo</code>
    vers <code>backend.example.com</code>, <em>sauf</em> les requêtes
    pour <code>/miroir/foo/i</code>.</p>

    <note type="warning"><title>Ordre de classement des directives ProxyPass</title>
      <p>Les directives <directive
      module="mod_proxy">ProxyPass</directive> et <directive
      module="mod_proxy">ProxyPassMatch</directive> sont évaluées dans
      l'ordre de leur apparition dans le fichier de configuration. La
      première règle qui correspond s'applique. Vous devez donc en
      général classer les règles <directive
      module="mod_proxy">ProxyPass</directive> qui entrent en conflit de
      l'URL la plus longue à la plus courte. Dans le cas contraire, les
      règles situées après une règle dont l'URL correspond au début de
      leur propre URL seront ignorées. Notez que tout ceci est en
      relation avec le partage de workers. Par contre, on ne peut placer
      qu'une seule directive <directive
      module="mod_proxy">ProxyPass</directive> dans une section
      <directive module="core">Location</directive>, et c'est la section
      la plus spécifique qui l'emportera.</p>

    <p>Pour les mêmes raisons, les exclusions doivent se situer <em>avant</em>
      les directives <directive>ProxyPass</directive> générales. A partir de la
      version 2.4.26 du serveur HTTP Apache, la variable
      d'environnement "no-proxy" est une alternative aux exclusions et constitue
      le seul moyen de configurer une exclusion pour une directive
      <directive>ProxyPass</directive> dans le contexte d'une section <directive
      module="core">Location</directive>. Cette variable doit être définie via
      la directive <directive module="mod_setenvif">SetEnvIf</directive> car la
      directive <directive module="mod_env">SetEnv</directive> n'est pas évaluée
      assez tôt.</p>  

    </note> <!-- /ordering_proxypass -->

    <p><strong>ProxyPass <code>clé=valeur</code> Paramètres</strong></p>

    <p>Depuis la version 2.1 du serveur HTTP Apache, mod_proxy supporte
    les groupements de connexions vers un serveur d'arrière-plan. Les
    connexions créées à la demande peuvent être enregistrées dans un
    groupement pour une utilisation ultérieure. La taille du groupe
    ainsi que d'autres caractéristiques peuvent être définies via la
    directive <directive>ProxyPass</directive> au moyen de paramètres
    <code>clé=valeur</code> dont la description fait l'objet des
    tableaux ci-dessous.</p>

    <note type="warning"><title>Nombre maximum de connexions vers
    l'arrière-plan</title>
     <p>Par défaut, mod_proxy permet et met en réserve le
    nombre maximum de connexions pouvant être utilisées simultanément par le
    processus enfant concerné du serveur web. Le paramètre <code>max</code>
    permet de réduire cette valeur par défaut. Le jeu de connexions est maintenu
    au niveau de chaque processus enfant du serveur web, <code>max</code> et les
    autres réglages n'étant pas coordonnés entre ces différents processus, sauf
    bien entendu lorsqu'un seul processus enfant n'est autorisé par la
    configuration ou le MPM utilisé.</p> </note>
    
    <p>Le paramètre <code>ttl</code>,
    quant à lui, permet de définir une durée de vie optionnelle ; les
    connexions qui n'ont pas été utilisées pendant au moins
    <code>ttl</code> secondes seront fermées. <code>ttl</code> permet
    aussi d'empêcher l'utilisation d'une connexion susceptible d'être
    fermée suite à une fin de vie de connexion persistante sur le
    serveur d'arrière-plan.</p>

    <example><title>Exemple</title>
    <highlight language="config">
        ProxyPass "/example" "http://backend.example.com" max=20 ttl=120 retry=300
	</highlight>
    </example>

    <table border="2"><tr><th>Paramètres de worker (directive BalancerMember)</th></tr></table>
    <table>
    <tr><th>Paramètre</th>
        <th>Défaut</th>
        <th>Description</th></tr>
    <tr><td>min</td>
        <td>0</td>
        <td>Nombre minimum d'entrées dans le pool de connexions,
	distinct du nombre de connexions effectif. La valeur par défaut
	ne doit être modifiée que dans des circonstances particulières
	où la mémoire associée aux connexions avec le serveur
	d'arrière-plan doit être préallouée ou réservée dans le tas.</td></tr>
    <tr><td>max</td>
        <td>1...n</td>
        <td>Nombre maximum de connexions autorisées vers le serveur
	d'arrière-plan. La valeur par défaut correspond au nombre de
	threads par processus pour le MPM (Module Multi Processus)
	actif. La valeur sera toujours 1 pour le MPM Prefork, alors
	qu'elle dépendra de la définition de la directive
	<directive>ThreadsPerChild</directive> pour les autres MPMs.</td></tr>
    <tr><td>smax</td>
        <td>max</td>
        <td>Les entrées du pool de connexions conservées au delà de
	cette limite sont libérées au cours de certaines opérations si
	elles n'ont pas été utilisées au cours de leur durée de vie,
	définie par le paramètre <code>ttl</code>. Si l'entrée du pool
	de connexions est associée à une connexion, cette dernière sera
	fermée. La valeur par défaut ne doit être modifiée que dans des
	circonstances particulières où les entrées du pool de connexions
	et toutes connexions associées qui ont dépassé leur durée de vie
	doivent être libérées ou fermées de manière plus autoritaire.</td></tr>
    <tr><td>acquire</td>
        <td>-</td>
        <td>Cette clé permet de définir le délai maximum d'attente pour
	une connexion libre dans le jeu de connexions, en millisecondes.
	S'il n'y a pas de connexion libre dans le jeu, Apache httpd renverra
	l'état <code>SERVER_BUSY</code> au client.
    </td></tr>
    <tr><td>connectiontimeout</td>
        <td>timeout</td>
        <td>Délai d'attente d'une connexion en secondes.
        La durée en secondes pendant laquelle Apache httpd va attendre pour
	l'établissement d'une connexion vers le serveur d'arrière-plan.
	Le délai peut être spécifié en millisecondes en ajoutant le
	suffixe ms.
    </td></tr>
    <tr><td>disablereuse</td>
        <td>Off</td>
        <td>Vous pouvez utiliser cette clé pour forcer mod_proxy à
	fermer immédiatement une connexion vers le serveur
	d'arrière-plan après utilisation, et ainsi désactiver le jeu de
	connexions permanentes vers ce serveur. Ceci peut s'avérer utile
	dans des situations où un pare-feu situé entre Apache httpd et le
	serveur d'arrière-plan (quelque soit le protocole) interrompt
	des connexions de manière silencieuse, ou lorsque le serveur
	d'arrière-plan lui-même est accessible par rotation de DNS
	(round-robin DNS). Lorsque la réutilisation des connexions est activée,
	chaque domaine d'arrière-plan n'est résolu (via une requête DNS) qu'une
	seule fois par chaque processus enfant et mis en cache pour toutes les
	connexions ultérieures jusqu'au recyclage du processus concerné.	
	Pour désactiver la réutilisation du jeu de
	connexions, définissez cette clé à <code>On</code>.
    </td></tr>
    <tr><td>enablereuse</td>
        <td>On</td>
        <td>Ce paramètre est utilisé par les gestionnaires de protocole pour
	lesquels la réutilisation des connexions est optionnelle (comme
	<module>mod_proxy_fcgi</module>). C'est le contraire du
	paramètre 'disablereuse' ci-dessus, et il est supporté par les
	versions 2.4.11 et supérieures du serveur HTTP Apache.
    </td></tr>
    <tr><td>flushpackets</td>
        <td>off</td>
        <td>Permet de définir si le module mandataire doit vider
	automatiquement le tampon de sortie après chaque tronçon de
	données. 'off' signifie que le tampon sera vidé si
	nécessaire ;
	'on' signifie que le tampon sera vidé après chaque envoi d'un
	tronçon de données, et 'auto' que le tampon sera vidé après un
	délai de 'flushwait' millisecondes si aucune entrée n'est reçue.
	Actuellement, cette clé n'est supportée que par AJP.
    </td></tr>
    <tr><td>flushwait</td>
        <td>10</td>
        <td>Le délai d'attente pour une entrée additionnelle, en
	millisecondes, avant le vidage du tampon en sortie dans le cas
	où 'flushpackets' est à 'auto'.
    </td></tr>
    <tr><td>iobuffersize</td>
        <td>8192</td>
        <td>Permet de définir la taille du tampon d'entrées/sorties du
	bloc-notes interne. Cette clé vous permet d'outrepasser la
	directive <directive>ProxyIOBufferSize</directive> pour un
	serveur cible spécifique. La valeur doit être au minimum 512 ou définie
	à 0 pour la valeur par défaut du système de 8192.
    </td></tr>
    <tr><td>keepalive</td>
        <td>Off</td>
        <td><p>Cette clé doit être utilisée lorsque vous avez un pare-feu
	entre Apache httpd et le serveur d'arrière-plan, et si ce dernier tend
	à interrompre les connexions inactives. Cette clé va faire en
	sorte que le système d'exploitation envoie des messages
	<code>KEEP_ALIVE</code> sur chacune des connexions inactives et
	ainsi éviter la	fermeture de la	connexion par le pare-feu.
	Pour conserver les connexions persistantes, definissez cette
	propriété à <code>On</code>.</p>
    <p>La fréquence de vérification des connexions TCP persistantes
    initiale et subséquentes dépend de la configuration globale de l'OS,
    et peut atteindre 2 heures. Pour être utile, la fréquence configurée
    dans l'OS doit être inférieure au seuil utilisé par le pare-feu.</p>

    </td></tr>
    <tr><td>lbset</td>
        <td>0</td>
        <td>Définit le groupe de répartition de charge dont le serveur cible
	est membre. Le répartiteur de charge va essayer tous les membres
	d'un groupe de répartition de charge de numéro inférieur avant
	d'essayer ceux dont le groupe possède un numéro supérieur.
    </td></tr>
    <tr><td>ping</td>
        <td>0</td>
        <td>Avec la clé Ping, le serveur web va "tester" la connexion
	vers le serveur d'arrière-plan avant de transmettre la requête.
	Avec AJP, <module>mod_proxy_ajp</module> envoie une requête
	<code>CPING</code> sur la connexion ajp13 (implémenté sur Tomcat
	3.3.2+, 4.1.28+ et 5.0.13+). Avec HTTP,
	<module>mod_proxy_http</module> envoie <code>100-Continue</code>
	au serveur d'arrière-plan (seulement avecHTTP/1.1 - pour les
	serveurs d'arrière-plan non HTTP/1.1, cette clé ne produit
	aucun effet). Dans les deux cas, ce paramètre correspond au
	délai en secondes pour l'attente de la réponse. Cette
	fonctionnalité a été ajoutée pour éviter les problèmes avec les
	serveurs d'arrière-plan bloqués ou surchargés.

	Le trafic
	réseau peut s'en trouver augmenté en fonctionnement normal, ce
	qui peut poser problème, mais peut s'en trouver diminué dans les
	cas où les noeuds de cluster sont arrêtés ou
	surchargés. Le délai peut
	aussi être défini en millisecondes en ajoutant le suffixe
	ms.
    </td></tr>
    <tr><td>receivebuffersize</td>
        <td>0</td>
        <td>Définit la taille du tampon réseau explicite (TCP/IP) pour
	les connexions mandatées. Cette clé vous permet d'outrepasser la
	directive <directive>ProxyReceiveBufferSize</directive> pour un
	serveur cible spécifique. Sa valeur doit être au minimum 512 ou définie
	à 0 pour la valeur par défaut du système.
    </td></tr>
    <tr><td>redirect</td>
        <td>-</td>
        <td>Route pour la redirection du serveur cible. Cette valeur est en
	général définie dynamiquement pour permettre une suppression
	sécurisée du noeud du cluster. Si cette clé est définie, toutes
	les requêtes sans identifiant de session seront redirigées vers
	le membre de groupe de répartition de charge dont la route
	correspond à la valeur de la clé.
    </td></tr>
    <tr><td>retry</td>
        <td>60</td>
        <td>Délai entre deux essais du serveur cible du jeu de connexions en
	secondes. Si le serveur cible du jeu de connexions vers le serveur
	d'arrière-plan est dans un état d'erreur, Apache httpd ne redirigera
	pas de requête vers ce serveur avant l'expiration du délai
	spécifié. Ceci permet d'arrêter le serveur d'arrière-plan pour
	maintenance, et de le remettre en ligne plus tard. Une valeur de
	0 implique de toujours essayer les serveurs cibles dans un état d'erreur
	sans délai.
    </td></tr>
    <tr><td>route</td>
        <td>-</td>
        <td>La route du serveur cible lorsqu'il est utilisé au sein d'un
	répartiteur de charge. La route est une valeur ajoutée à
	l'identifiant de session.
    </td></tr>
    <tr><td>status</td>
        <td>-</td>
        <td>Valeur constituée d'une simple lettre et définissant l'état
	initial de ce serveur cible.
	 <table>
         <tr><td>D: le serveur cible est désactivé et n'accepte aucune requête.</td></tr>
         <tr><td>S: le serveur cible est arrêté.</td></tr>
         <tr><td>I: le serveur cible est en mode "erreurs ignorées",
	 et sera toujours considéré comme disponible.</td></tr>
         <tr><td>H: le serveur cible est en mode d'attente et ne sera
	 utilisé que si aucun autre serveur n'est disponible.</td></tr>
         <tr><td>E: le serveur cible est en erreur.</td></tr>
         <tr><td>N: le serveur cible est en mode vidage, n'acceptera que
	 les sessions persistantes qui lui appartiennent, et refusera
	 toutes les autres requêtes.</td></tr>
        </table>
	Une valeur d'état peut être définie (ce qui
	correspond au comportement par défaut) en préfixant la valeur
	par '+', ou annulée en préfixant la valeur par '-'. Ainsi, la
	valeur 'S-E' définit l'état de ce serveur cible à "arrêté" et supprime
	le drapeau "en-erreur".
    </td></tr>
    <tr><td>timeout</td>
        <td><directive module="mod_proxy">ProxyTimeout</directive></td>
        <td>Délai d'attente de la connexion en secondes. Le nombre de
	secondes pendant lesquelles Apache httpd attend l'envoi de
	données vers le serveur d'arrière-plan.
    </td></tr>
    <tr><td>ttl</td>
        <td>-</td>
        <td>Durée de vie des connexions inactives et des entrées du pool
	de connexions associées en secondes. Une fois cette
	limite atteinte, une connexion ne sera pas réutilisée ; elle
	sera fermée après un délai variable.
    </td></tr>
    <tr><td>flusher</td>
        <td>flush</td>
        <td><p>Nom du fournisseur utilisé par <module>mod_proxy_fdpass</module>.
	Voir la documentation de ce module pour plus de détails.</p>
    </td></tr>
    <tr><td>secret</td>
        <td>-</td>
        <td><p>Le mot de passe utilisé par <module>mod_proxy_ajp</module>. Voir
	la documentation de ce module pour plus de détails.</p>
    </td></tr>
    <tr><td>upgrade</td>
        <td>WebSocket</td>
        <td><p>Le protocol accepté par <module>mod_proxy_wstunnel</module> dans
	l'en-tête Upgrade. Voir	la documentation de ce module pour plus de
	détails.</p>
    </td></tr>

    </table>

    <p>Si l'URL de la directive Proxy débute par
    <code>balancer://</code> (par exemple:
    <code>balancer://cluster</code>, toute information relative au
    chemin est ignorée), alors un serveur cible virtuel ne communiquant pas
    réellement avec le serveur d'arrière-plan sera créé. Celui-ci sera
    en fait responsable de la gestion de plusieurs serveurs cibles "réels". Dans
    ce cas, un jeu de paramètres particuliers s'applique à ce serveur cible
    virtuel. Voir <module>mod_proxy_balancer</module> pour plus
    d'informations à propos du fonctionnement du répartiteur de
    charge.
    </p>
    <table border="2"><tr><th>Paramètres du répartiteur</th></tr></table>
    <table>
    <tr><th>Paramètre</th>
        <th>Défaut</th>
        <th>Description</th></tr>
    <tr><td>lbmethod</td>
        <td>byrequests</td>
        <td>Méthode de répartition de charge utilisée. Permet de
	sélectionner la méthode de planification de la répartition de
	charge à utiliser. La valeur est soit <code>byrequests</code>,
	pour effectuer un décompte de requêtes pondérées, soit
	<code>bytraffic</code>, pour effectuer une répartition en
	fonction du décompte des octets transmis, soit
	<code>bybusyness</code>, pour effectuer une répartition en
	fonction des requêtes en attente. La valeur par défaut est
	<code>byrequests</code>.
    </td></tr>
    <tr><td>maxattempts</td>
        <td>1 de moins que le nombre de workers, ou 1 avec un seul
	worker</td>
        <td>Nombre maximum d'échecs avant abandon.
    </td></tr>
    <tr><td>nofailover</td>
        <td>Off</td>
        <td>Si ce paramètre est défini à <code>On</code>, la session va
	s'interrompre si le serveur cible est dans un état d'erreur ou
	désactivé. Définissez ce paramètre à <code>On</code> si le serveur
	d'arrière-plan ne supporte pas la réplication de session.
    </td></tr>
    <tr><td>stickysession</td>
        <td>-</td>
        <td>Nom de session persistant du répartiteur. La valeur est
	généralement du style <code>JSESSIONID</code> ou
	<code>PHPSESSIONID</code>, et dépend du serveur d'application
	d'arrière-plan qui supporte les sessions. Si le serveur
	d'application d'arrière-plan utilise un nom différent pour
	les cookies et les identifiants codés d'URL (comme les
	conteneurs de servlet), séparez-les par le caractère '|'. La
	première partie contient le cookie et la seconde le chemin.<br />
	Disponible depuis la version 2.4.4 du serveur HTTP Apache.
    </td></tr>
    <tr><td>stickysessionsep</td>
        <td>"."</td>
        <td>Définit le caractère de séparation dans le cookie de
	session. Certains serveurs d'application d'arrière-plan
	n'utilisent pas le caractère '.' comme séparateur. Par exemple
	le serveur Oracle Weblogic utilise le caractère '!'. Cette
	option permet d'attribuer au caractère de séparation la valeur
	appropriée. Si elle est définie à 'Off', aucun caractère de
	séparation n'est utilisé.
    </td></tr>
    <tr><td>scolonpathdelim</td>
        <td>Off</td>
        <td>Si ce paramètre est défini à <code>On</code>, le caractère
	';' sera utilisé comme séparateur de chemin de session
	persistante additionnel. Ceci permet principalement de simuler
	le comportement de mod_jk lorsqu'on utilise des chemins du style
	<code>JSESSIONID=6736bcf34;foo=aabfa</code>.
    </td></tr>
    <tr><td>timeout</td>
        <td>0</td>
        <td>Délai du répartiteur en secondes. Si ce paramètre est
	défini, sa valeur correspond à la durée maximale d'attente pour
	un serveur cible libre. Le comportement par défaut est de ne pas
	attendre.
    </td></tr>
    <tr><td>failonstatus</td>
        <td>-</td>
        <td>Une liste de codes d'état HTTP séparés par des virgules. Si
	ce paramètre est présent, le worker se mettra en erreur si le
	serveur d'arrière-plan renvoie un des codes d'état spécifiés
	dans la liste. La récupération du worker s'effectue comme dans
	le cas des autres erreurs de worker.
    </td></tr>
    <tr><td>failontimeout</td>
        <td>Off</td>
        <td>Si ce paramètre est défini à "On", un délai d'attente
	dépassé en entrée/sortie après envoi d'une requête au serveur
	d'arrière-plan va mettre le processus en état d'erreur. La
	sortie de cet état d'erreur se passe de la même façon que pour
	les autres erreurs.<br />
	Disponible à partir de la version 2.4.5 du serveur HTTP Apache.
    </td></tr>
    <tr><td>nonce</td>
        <td>&lt;auto&gt;</td>
        <td>Le nombre à usage unique de protection utilisé dans la page
	de l'application <code>balancer-manager</code>. Par défaut, la
	protection de la page est assurée par un nombre à usage unique
	automatique à base d'UUID. Si une valeur est précisée, elle sera
	utilisée comme nombre à usage unique. La valeur
	<code>None</code> désactive la vérification du nombre à usage
	unique.
    <note><title>Note</title>
      <p>En plus du nombre à usage unique, la page de l'application
      <code>balancer-manager</code> peut être protégée par une ACL.</p>
    </note>
     </td></tr>
    <tr><td>growth</td>
        <td>0</td>
        <td>Nombre de membres supplémentaires que l'on peut ajouter à ce
	répartiteur en plus de ceux définis au niveau de la
	configuration.
    </td></tr>
    <tr><td>forcerecovery</td>
        <td>On</td>
        <td>Force la relance immédiate de tous les membres sans tenir
	compte de leur paramètre retry dans le cas où ils sont tous en
	état d'erreur. Il peut cependant arriver qu'un membre déjà
	surchargé entre dans une situation critique si la relance de
	tous les membres est forcée sans tenir compte du paramètre retry
	de chaque membre. Dans ce cas, définissez ce paramètre à
	<code>Off</code>.<br />
	Disponible depuis la version 2.4.2 du serveur HTTP Apache.
    </td></tr>

    </table>
    <p>Exemple de configuration d'un répartiteur de charge</p>
    <highlight language="config">
ProxyPass "/special-area" "http://special.example.com" smax=5 max=10
ProxyPass "/" "balancer://mycluster/" stickysession=JSESSIONID|jsessionid nofailover=On
&lt;Proxy "balancer://mycluster"&gt;
    BalancerMember "ajp://1.2.3.4:8009"
    BalancerMember "ajp://1.2.3.5:8009" loadfactor=20
    # Less powerful server, don't send as many requests there,
    BalancerMember "ajp://1.2.3.6:8009" loadfactor=5
&lt;/Proxy&gt;
    </highlight>

    <p>Configuration d'un serveur cible de réserve qui ne sera utilisé que si
    aucun autre serveur cible n'est disponible</p>
    <highlight language="config">
ProxyPass "/" "balancer://hotcluster/"
&lt;Proxy "balancer://hotcluster"&gt;
    BalancerMember "ajp://1.2.3.4:8009" loadfactor=1
    BalancerMember "ajp://1.2.3.5:8009" loadfactor=2.25
    # The server below is on hot standby
    BalancerMember "ajp://1.2.3.6:8009" status=+H
    ProxySet lbmethod=bytraffic
&lt;/Proxy&gt;
    </highlight>

    <p><strong>Mots-clés additionnels de ProxyPass</strong></p>

    <p>Normalement, mod_proxy va mettre sous leur forme canonique les
    URLs traitées par ProxyPass. Mais ceci peut être incompatible avec
    certains serveurs d'arrière-plan, et en particulier avec ceux qui
    utilisent <var>PATH_INFO</var>. Le mot-clé optionnel
    <var>nocanon</var> modifie ce comportement et permet de transmettre
    le chemin d'URL sous sa forme brute au serveur d'arrière-plan. Notez
    que ceci peut affecter la sécurité de votre serveur d'arrière-plan,
    car la protection limitée contre les attaques à base d'URL que
    fournit le mandataire est alors supprimée.</p>

    <p>Par défaut, mod_proxy inclut la chaîne de paramètres lors de la
    génération de la variable d'environnement
    <var>SCRIPT_FILENAME</var>. Le mot-clé optionnel <var>noquery</var>
    (disponible à partir de la version 2.4.1) permet d'exclure cette
    chaîne.</p>

    <p>Lorsque la directive ProxyPass est utilisée à l'intérieur d'une
    section <directive type="section" module="core"
    >Location</directive>, le premier argument est omis et le répertoire
    local est obtenu à partir de la section <directive type="section"
    module="core">Location</directive>. Il en sera de même dans une
    section <directive type="section"
    module="core">LocationMatch</directive> ; cependant, ProxyPass
    n'interprète pas les expressions rationnelles, et il sera ici
    nécessaire d'utiliser la directive
    <directive>ProxyPassMatch</directive> à la place.</p>

    <p>Cette directive ne peut pas être placée dans une section
    <directive type="section" module="core">Directory</directive> ou
    <directive type="section" module="core">Files</directive>.</p>

    <p>Si vous avez besoin d'un configuration de mandataire inverse plus
    souple, reportez-vous à la documentaion de la directive <directive
    module="mod_rewrite">RewriteRule</directive> et son drapeau
    <code>[P]</code>.</p>

    <p>Le mot-clé optionnel <var>interpolate</var>, en combinaison avec la directive
    <directive>ProxyPassInterpolateEnv</directive>, permet à ProxyPass
    d'interpoler les variables d'environnement à l'aide de la syntaxe
    <var>${VARNAME}</var>. Notez que de nombreuses variables
    d'environnement standard dérivées de CGI n'existeront pas lorsque
    l'interpolation se produit ; vous devrez alors encore avoir avoir
    recours à <module>mod_rewrite</module> pour des règles
    complexes. Notez aussi que l'interpolation n'est pas supportée dans
    la partie protocole d'une URL. La détermination dynamique du
    protocole peut être effectuée à l'aide de
    <module>mod_rewrite</module> comme dans l'exemple suivant :</p>

    <highlight language="config">
RewriteEngine On

RewriteCond "%{HTTPS}" =off
RewriteRule "". "-" [E=protocol:http]
RewriteCond "%{HTTPS}" =on
RewriteRule "." "-" [E=protocol:https]

RewriteRule "^/mirror/foo/(.*)" "%{ENV:protocol}://backend.example.com/$1" [P]
ProxyPassReverse  "/mirror/foo/" "http://backend.example.com/"
ProxyPassReverse  "/mirror/foo/" "https://backend.example.com/"
    </highlight>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyPassMatch</name>
<description>Fait correspondre des serveurs distants dans l'espace d'URL
du serveur local en utilisant des expressions rationnelles</description>
<syntax>ProxyPassMatch [<var>regex</var>] !|<var>url</var>
[<var>clé=valeur</var>
	<var>[clé=valeur</var> ...]]</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>

<usage>
    <p>Cette directive est identique à la directive <directive
    module="mod_proxy">ProxyPass</directive>, mais fait usage des
    expressions rationnelles, au lieu d'une simple comparaison de
    préfixes. L'expression rationnelle spécifiée est comparée à
    l'<var>url</var>, et si elle correspond, le serveur va substituer
    toute correspondance entre parenthèses dans la chaîne donnée et
    l'utiliser comme nouvelle <var>url</var>.</p>

    <note><strong>Note : </strong>Cette directive ne peut pas être
    utilisée dans un contexte de niveau répertoire.</note>

    <p>Supposons que le serveur local a pour adresse
    <code>http://example.com/</code> ; alors</p>

    <highlight language="config">
      ProxyPassMatch "^(/.*\.gif)$" "http://backend.example.com/$1"
    </highlight>

    <p>va provoquer la conversion interne de la requête locale
    <code>http://example.com/foo/bar.gif</code> en une requête mandatée
    pour <code>http://backend.example.com/foo/bar.gif</code>.</p>

    <note><title>Note</title>
      <p>L'argument URL doit pouvoir être interprété en tant qu'URL
      <em>avant</em> les substitutions d'expressions rationnelles (et
      doit aussi l'être après). Ceci limite les correspondances que vous
      pouvez utiliser. Par exemple, si l'on avait utilisé</p>
      <highlight language="config">
        ProxyPassMatch "^(/.*\.gif)$"
	"http://backend.example.com:8000$1"
      </highlight>
      <p>dans l'exemple précédent, nous aurions provoqué une erreur de
      syntaxe au démarrage du serveur. C'est une bogue (PR 46665 dans
      ASF bugzilla), et il est possible de la contourner en reformulant
      la correspondance :</p>
      <highlight language="config">
        ProxyPassMatch "^/(.*\.gif)$" "http://backend.example.com:8000/$1"
      </highlight>
    </note>

    <p>Le drapeau <code>!</code> vous permet de ne pas mandater un
    sous-répertoire donné.</p>

    <p>Dans une section <directive type="section"
    module="core">LocationMatch</directive>, le premier argument est
    omis et l'expression rationnelle est obtenue à partir de la directive
    <directive type="section" module="core">LocationMatch</directive>.</p>

    <p>Si vous avez besoin d'une configuration du mandataire inverse
    plus flexible, voyez la directive <directive
    module="mod_rewrite">RewriteRule</directive> avec le drapeau
    <code>[P]</code>.</p>

    <note>
 	<title>Substitution par défaut</title>
 	<p>Lorsque le paramètre URL n'utilise pas de références arrières
	dans l'expression rationnelle, l'URL originale sera ajoutée au
	paramètre URL.
 	</p>
 	</note>

    <note type="warning">
      <title>Avertissement à propos de la sécurité</title>
      <p>Lors de la construction de l'URL cible de la règle, il convient
      de prendre en compte l'impact en matière de sécurité qu'aura le
      fait de permettre au client d'influencer le jeu d'URLs pour
      lesquelles votre serveur agira en tant que mandataire.
      Assurez-vous que la partie protocole://nom-serveur de l'URL soit
      fixe, ou ne permette pas au client de l'influencer induement.</p>
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyPassReverse</name>
<description>Ajuste l'URL dans les en-têtes de la réponse HTTP envoyée
par un serveur mandaté en inverse</description>
<syntax>ProxyPassReverse [<var>chemin</var>] <var>url</var>
[<var>interpolate</var>]</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>

<usage>
    <p>Cette directive permet de faire en sorte qu'Apache httpd ajuste l'URL
    dans les en-têtes <code>Location</code>,
    <code>Content-Location</code> et <code>URI</code> des réponses de
    redirection HTTP. Ceci est essentiel lorsqu'Apache httpd est utilisé en
    tant que mandataire inverse (ou passerelle), afin d'éviter de
    court-circuiter le mandataire inverse suite aux redirections HTTP
    sur le serveur d'arrière-plan qui restent derrière le mandataire
    inverse.</p>

    <p>Seuls les en-têtes de réponse HTTP spécialement mentionnés
    ci-dessus seront réécrits. Apache httpd ne réécrira ni les autres en-têtes
    de réponse, ni par défaut les références d'URLs dans les pages HTML. Cela
    signifie que dans le cas où un contenu mandaté contient des
    références à des URLs absolues, elles court-circuiteront le
    mandataire. Pour réécrire un contenu HTML afin qu'il corresponde au
    mandataire, vous devez charger et activer le module
    <module>mod_proxy_html</module>.
    </p>

    <p><var>chemin</var> est le nom d'un chemin virtuel local.
    <var>url</var> est une URL partielle pour le serveur distant. Ces
    paramètres s'utilisent de la même façon qu'avec la
    directive <directive module="mod_proxy">ProxyPass</directive>.</p>

    <p>Supposons par exemple que le serveur local a pour adresse
    <code>http://example.com/</code> ; alors</p>

    <highlight language="config">
ProxyPass         "/mirror/foo/" "http://backend.example.com/"
ProxyPassReverse  "/mirror/foo/" "http://backend.example.com/"
ProxyPassReverseCookieDomain  "backend.example.com" "public.example.com"
ProxyPassReverseCookiePath  "/"  "/mirror/foo/"
    </highlight>

    <p>ne va pas seulement provoquer la conversion interne d'une requête
    locale pour <code>http://example.com/miroir/foo/bar</code> en une
    requête mandatée pour <code>http://backend.example.com/bar</code>
    (la fonctionnalité fournie par <code>ProxyPass</code>). Il va
    aussi s'occuper des redirections que le serveur
    <code>backend.example.com</code> envoie lorsqu'il redirige
    <code>http://backend.example.com/bar</code> vers
    <code>http://backend.example.com/quux</code>. Apache
    httpd corrige ceci en <code>http://example.com/miroir/foo/quux</code>
    avant de faire suivre la redirection HTTP au client. Notez que le
    nom d'hôte utilisé pour construire l'URL est choisi en respectant la
    définition de la directive <directive
    module="core">UseCanonicalName</directive>.</p>

    <p>Notez que la directive <directive>ProxyPassReverse</directive>
    peut aussi être utilisée en conjonction avec la
    fonctionnalité de mandataire
    (<code>RewriteRule ...  [P]</code>) du module
    <module>mod_rewrite</module>, car elle ne dépend pas d'une directive
    <directive module="mod_proxy">ProxyPass</directive>
    correspondante.</p>

    <p>Le mot-clé optionnel <var>interpolate</var>, en
    combinaison avec la directive
    <directive>ProxyPassInterpolateEnv</directive>, permet
    l'interpolation des variables d'environnement spécifiées en
    utilisant le format <var>${VARNAME}</var> Notez que l'interpolation
    n'est pas supportée dans la partie protocole d'une URL.
    </p>

    <p>Lorsque cette directive est utilisée dans une section <directive
    type="section" module="core">Location</directive>, le premier
    argument est omis et le répertoire local est obtenu à partir de
    l'argument de la directive <directive type="section"
    module="core">Location</directive>. Il en est de même à l'intérieur
    d'une section <directive type="section"
    module="core">LocationMatch</directive>, mais le résultat ne sera
    probablement pas celui attendu car ProxyPassReverse va interpréter
    l'expression rationnelle littéralement comme un chemin ; si besoin
    est dans ce cas, définissez la directive ProxyPassReverse en dehors
    de la section, ou dans une section <directive type="section"
    module="core">Location</directive> séparée.</p>

    <p>Cette directive ne peut pas être placée dans une section
    <directive type="section" module="core">Directory</directive> ou
    <directive type="section" module="core">Files</directive>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyPassReverseCookieDomain</name>
<description>Ajuste la chaîne correspondant au domaine dans les en-têtes
Set-Cookie en provenance d'un serveur mandaté</description>
<syntax>ProxyPassReverseCookieDomain <var>domaine-interne</var>
<var>domaine-public</var> [<var>interpolate</var>]</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>
<usage>
<p>L'utilisation de cette directive est similaire à celle de la
directive <directive module="mod_proxy">ProxyPassReverse</directive>,
mais au lieu de réécrire des en-têtes qui contiennent des URLs, elle
réécrit la chaîne correspondant au domaine dans les en-têtes
<code>Set-Cookie</code>.</p>
</usage>
</directivesynopsis>


<directivesynopsis>
<name>ProxyPassReverseCookiePath</name>
<description>Ajuste la chaîne correspondant au chemin dans les en-têtes
Set-Cookie en provenance d'un serveur mandaté</description>
<syntax>ProxyPassReverseCookiePath <var>chemin-interne</var>
<var>chemin-public</var> [<var>interpolate</var>]</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>
<usage>
<p>
Cette directive s'avère utile en conjonction avec la directive
<directive module="mod_proxy">ProxyPassReverse</directive> dans les
situations où les chemins d'URL d'arrière-plan correspondent à des
chemins publics sur le mandataire inverse. Cette directive permet de
réécrire la chaîne <code>path</code> dans les en-têtes
<code>Set-Cookie</code>. Si le début du chemin du cookie correspond à
<var>chemin-interne</var>, le chemin du cookie sera remplacé par
<var>chemin-public</var>.
</p><p>
Dans l'exemple fourni avec la directive <directive
module="mod_proxy">ProxyPassReverse</directive>, la directive :
</p>
    <highlight language="config">
      ProxyPassReverseCookiePath  "/"  "/mirror/foo/"
    </highlight>
<p>
va réécrire un cookie possédant un chemin d'arrière-plan <code>/</code>
(ou <code>/example</code> ou en fait tout chemin)
en <code>/mirror/foo/</code>..
</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyBlock</name>
<description>Termes, serveurs ou domaines bloqués par le
mandataire</description>
<syntax>ProxyBlock *|<var>terme</var>|<var>serveur</var>|<var>domaine</var>
[<var>terme</var>|<var>serveur</var>|<var>domaine</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>ProxyBlock</directive> permet de
    spécifier une liste de termes, serveurs et/ou domaines, séparés par
    des espaces. Les requêtes de documents HTTP, HTTPS, FTP vers des
    sites dont les noms contiennent des termes, noms de serveur ou
    domaine correspondants seront <em>bloqués</em> par le serveur
    mandataire. La module proxy va aussi tenter de déterminer les
    adresses IP des éléments de la liste qui peuvent correspondre à des
    noms d'hôtes au cours du démarrage, et les mettra en cache à des
    fins de comparaisons ultérieures. Ceci peut ralentir le démarrage du
    serveur.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      ProxyBlock "news.example.com" "auctions.example.com" "friends.example.com"
      </highlight>
    </example>

    <p>Notez qu'<code>example</code> suffirait aussi pour atteindre
    ces sites.</p>

    <p>Hosts conviendrait aussi s'il était référencé par adresse IP.</p>

    <p>Notez aussi que</p>

    <highlight language="config">
      ProxyBlock "*"
    </highlight>

    <p>bloque les connexions vers tous les sites.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyReceiveBufferSize</name>
<description>Taille du tampon réseau pour les connexions mandatées HTTP
et FTP</description>
<syntax>ProxyReceiveBufferSize <var>octets</var></syntax>
<default>ProxyReceiveBufferSize 0</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>ProxyReceiveBufferSize</directive> permet
    de spécifier une taille de tampon réseau explicite (TCP/IP) pour les
    connexions mandatées HTTP et FTP, afin d'améliorer le débit de
    données. Elle doit être supérieure à <code>512</code> ou définie à
    <code>0</code> pour indiquer que la taille de tampon par défaut du
    système doit être utilisée.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      ProxyReceiveBufferSize 2048
      </highlight>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyIOBufferSize</name>
<description>Détermine la taille du tampon interne de transfert de
données</description>
<syntax>ProxyIOBufferSize <var>octets</var></syntax>
<default>ProxyIOBufferSize 8192</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>ProxyIOBufferSize</directive> permet
    d'ajuster la taille du tampon interne utilisé comme bloc-note pour
    les transferts de données entre entrée et sortie. La taille minimale
    est de <code>512</code> octets.</p>

    <p>Dans la plupart des cas, il n'y a aucune raison de modifier cette
    valeur.</p>

    <p>Si elle est utilisée avec AJP, cette directive permet de définir
    la taille maximale du paquet AJP en octets. Si la valeur spécifiée
    est supérieure à 65536, elle est corrigée et prend la valeur 65536.
    Si vous ne conservez pas
    la valeur par défaut, vous devez aussi modifier l'attribut
    <code>packetSize</code> de votre connecteur AJP du côté de Tomcat !
    L'attribut <code>packetSize</code> n'est disponible que dans Tomcat
    <code>5.5.20+</code> et <code>6.0.2+</code>.</p>
    <p>Il n'est normalement pas nécessaire de modifier la taille
    maximale du paquet. Des problèmes ont cependant été rapportés avec
    la valeur par défaut lors de l'envoi de certificats ou de chaînes de
    certificats.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyMaxForwards</name>
<description>Nombre maximum de mandataires à travers lesquelles une
requête peut être redirigée</description>
<syntax>ProxyMaxForwards <var>nombre</var></syntax>
<default>ProxyMaxForwards -1</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>
<compatibility>Comportement par défaut
modifié dans 2.2.7</compatibility>

<usage>
    <p>La directive <directive>ProxyMaxForwards</directive> permet de
    spécifier le nombre maximum de mandataires à travers lesquels une
    requête peut passer dans le cas où la la requête ne contient pas
    d'en-tête <code>Max-Forwards</code>. Ceci permet de se prémunir
    contre les boucles infinies de mandataires ou contre les attaques de
    type déni de service.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      ProxyMaxForwards 15
      </highlight>
    </example>

    <p>Notez que la définition de la directive
    <directive>ProxyMaxForwards</directive> constitue une violation du
    protocole HTTP/1.1 (RFC2616), qui interdit à un mandataire de
    définir <code>Max-Forwards</code> si le client ne l'a pas fait
    lui-même. Les versions précédentes d'Apache httpd la définissaient
    systématiquement. Une valeur négative de
    <directive>ProxyMaxForwards</directive>, y compris la valeur par
    défaut -1, implique un comportement compatible avec le protocole,
    mais vous expose aux bouclages infinis.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>NoProxy</name>
<description>Serveurs, domaines ou réseaux auquels on se connectera
directement</description>
<syntax>NoProxy <var>domaine</var> [<var>domaine</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive n'a d'utilité que pour les serveurs mandataires
    Apache httpd au sein d'Intranets. La directive
    <directive>NoProxy</directive> permet de spécifier une liste de
    sous-réseaux, d'adresses IP, de serveurs et/ou de domaines séparés
    par des espaces. Une requête pour un serveur qui correspond à un ou
    plusieurs critères sera toujours servie par ce serveur directement,
    sans être redirigée vers le(s) serveur(s) mandataire(s) défini(s) par
    la directive <directive
    module="mod_proxy">ProxyRemote</directive>.</p>

    <example><title>Exemple</title>
      <highlight language="config">
ProxyRemote  "*"  "http://firewall.example.com:81"
NoProxy         ".example.com" "192.168.112.0/21"
    </highlight>
    </example>

    <p>Le type des arguments <var>serveur</var> de la directive
    <directive>NoProxy</directive> appartiennent à la liste suivante
    :</p>

    <dl>
    <!-- ===================== Domain ======================= -->
    <dt><var><a name="domain" id="domain">Domaine</a></var></dt>
    <dd>
    <p>Un <dfn>domaine</dfn> est ici un nom de domaine DNS partiellement
    qualifié précédé d'un point. Il représente une liste de serveurs qui
    appartiennent logiquement au même domaine ou à la même zonz DNS
    (en d'autres termes, les nom des serveurs se terminent tous par
    <var>domaine</var>).</p>

    <example><title>Exemple</title>
      .com .example.org.
    </example>

    <p>Pour faire la distinction entre <var>domaine</var>s et <var><a
    href="#hostname">nom d'hôte</a></var>s (des points de vue à la fois
    syntaxique et
    sémantique, un domaine DNS pouvant aussi avoir un enregistrement DNS
    de type A !), les <var>domaine</var>s sont toujours spécifiés en les
    préfixant par un point.</p>

    <note><title>Note</title>
      <p>Les comparaisons de noms de domaines s'effectuent sans tenir
      compte de la casse, et les parties droites des <var>Domaine</var>s
      sont toujours censées correspondre à la racine de l'arborescence
      DNS, si bien que les domaines <code>.ExEmple.com</code> et
      <code>.example.com.</code> (notez le point à la fin du nom) sont
      considérés comme identiques. Comme une comparaison de domaines ne
      nécessite pas de recherche DNS, elle est beaucoup plus efficace
      qu'une comparaison de sous-réseaux.</p>
    </note></dd>

    <!-- ===================== SubNet ======================= -->
    <dt><var><a name="subnet" id="subnet">Sous-réseau</a></var></dt>
    <dd>
    <p>Un <dfn>Sous-réseau</dfn> est une adresse internet partiellement
    qualifiée sous forme numérique (quatre nombres séparés par des
    points), optionnellement suivie d'un slash et du masque de
    sous-réseau spécifiant le nombre de bits significatifs dans le
    <var>Sous-réseau</var>. Il représente un sous-réseau de serveurs qui
    peuvent être atteints depuis la même interface réseau. En l'absence
    de masque de sous-réseau explicite, il est sous-entendu que les
    digits manquants (ou caractères 0) de fin spécifient le masque de
    sous-réseau (Dans ce cas, le masque de sous-réseau ne peut être
    qu'un multiple de 8). Voici quelques exemples :</p>

    <dl>
    <dt><code>192.168</code> ou <code>192.168.0.0</code></dt>
    <dd>le sous-réseau 192.168.0.0 avec un masque de sous-réseau
    implicite de 16 bits significatifs (parfois exprimé sous la forme
    <code>255.255.0.0</code>)</dd>
    <dt><code>192.168.112.0/21</code></dt>
    <dd>le sous-réseau <code>192.168.112.0/21</code> avec un masque de
    sous-réseau implicite de 21 bits significatifs (parfois exprimé
    sous la forme<code>255.255.248.0</code>)</dd>
    </dl>

    <p>Comme cas extrêmes, un <em>Sous-réseau</em> avec un masque de
    sous-réseau de 32 bits significatifs est équivalent à une <var><a
    href="#ipaddr">adresse IP</a></var>, alors qu'un <em>Sous-réseau</em> avec un masque de
    sous-réseau de 0 bit significatif (c'est à dire 0.0.0.0/0) est
    identique à la constante <var>_Default_</var>, et peut correspondre
    à toute adresse IP.</p></dd>

    <!-- ===================== IPAddr ======================= -->
    <dt><var><a name="ipaddr" id="ipaddr">Adresse IP</a></var></dt>
    <dd>
    <p>Une <dfn>Adresse IP</dfn> est une adresse internet pleinement
    qualifiée sous forme numérique (quatre nombres séparés par des
    points). En général, cette adresse représente un serveur, mais elle
    ne doit pas nécessairement correspondre à un nom de domaine DNS.</p>
    <example><title>Exemple</title>
      192.168.123.7
    </example>

    <note><title>Note</title>
      <p>Une <dfn>Adresse IP</dfn> ne nécessite pas de résolution DNS,
      et peut ainsi s'avérer plus efficace quant aux performances
      d'Apache.</p>
    </note></dd>

    <!-- ===================== Hostname ======================= -->
    <dt><var><a name="hostname" id="hostname">Nom de serveur</a></var></dt>
    <dd>
    <p>Un <dfn>Nom de serveur</dfn> est un nom de domaine DNS pleinement
    qualifié qui peut être résolu en une ou plusieurs adresses IP par le
    service de noms de domaines DNS. Il représente un hôte logique (par
    opposition aux <var><a href="#domain">Domaine</a></var>s, voir
    ci-dessus), et doit pouvoir être résolu en une ou plusieurs <var><a
    href="#ipaddr">adresses IP</a></var> (ou souvent en une liste
    d'hôtes avec différentes <var><a href="#ipaddr">adresses
    IP</a></var>).</p>

    <example><title>Exemples</title>
      prep.ai.example.edu<br />
      www.example.org
    </example>

    <note><title>Note</title>
      <p>Dans de nombreuses situations, il est plus efficace de
      spécifier une <var><a href="#ipaddr">adresse IP</a></var> qu'un
      <var>Nom de serveur</var> car cela évite d'avoir à effectuer une
      recherche DNS. La résolution de nom dans Apache httpd peut prendre un
      temps très long lorsque la connexion avec le serveur de noms
      utilise une liaison PPP lente.</p>
      <p>Les comparaisons de <var>Nom de serveur</var> s'effectuent sans tenir
      compte de la casse, et les parties droites des <var>Noms de serveur</var>
      sont toujours censées correspondre à la racine de l'arborescence
      DNS, si bien que les domaines <code>WWW.ExEmple.com</code> et
      <code>www.example.com.</code> (notez le point à la fin du nom) sont
      considérés comme identiques.</p>
     </note></dd>
    </dl>
</usage>
<seealso><a href="../dns-caveats.html">Problèmes liés au DNS</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ProxyTimeout</name>
<description>Délai d'attente réseau pour les requêtes
mandatées</description>
<syntax>ProxyTimeout <var>secondes</var></syntax>
<default>Valeur de la directive <directive
module="core">Timeout</directive></default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive permet à l'utilisateur de spécifier un délai pour
    les requêtes mandatées. Ceci s'avère utile dans le cas d'un serveur
    d'applications lent et bogué qui a tendance à se bloquer, et si vous
    préférez simplement renvoyer une erreur timeout et abandonner la
    connexion en douceur plutôt que d'attendre jusqu'à ce que le serveur
    veuille bien répondre.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyDomain</name>
<description>Nom de domaine par défaut pour les requêtes
mandatées</description>
<syntax>ProxyDomain <var>Domaine</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive n'a d'utilité que pour les serveurs mandataires
    Apache httpd au sein d'un Intranet. La directive
    <directive>ProxyDomain</directive> permet de spécifier le domaine
    par défaut auquel le serveur mandataire apache appartient. Si le
    serveur reçoit une requête pour un hôte sans nom de domaine, il va
    générer une réponse de redirection vers le même hôte suffixé par le
    <var>Domaine</var> spécifié.</p>

    <example><title>Exemple</title>
    <highlight language="config">
ProxyRemote  "*"  "http://firewall.example.com:81"
NoProxy         ".example.com" "192.168.112.0/21"
ProxyDomain     ".example.com"      
      </highlight>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyVia</name>
<description>Information fournie dans l'en-tête de réponse HTTP
<code>Via</code> pour les requêtes mandatées</description>
<syntax>ProxyVia On|Off|Full|Block</syntax>
<default>ProxyVia Off</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive permet de contrôler l'utilisation de l'en-tête
    HTTP <code>Via:</code> par le mandataire. Le but recherché est de
    contrôler le flux des requêtes mandatées tout au long d'une chaîne
    de serveurs mandataires. Voir <a
    href="http://www.ietf.org/rfc/rfc2616.txt">RFC 2616</a> (HTTP/1.1),
    section 14.45 pour une description des lignes d'en-tête
    <code>Via:</code>.</p>

    <ul>
    <li>Si elle est définie à <code>Off</code>, valeur par défaut, cette
    directive n'effectue aucun traitement particulier. Si une requête ou
    une réponse contient un en-tête <code>Via:</code>, il est transmis
    sans modification.</li>

    <li>Si elle est définie à <code>On</code>, chaque requête ou réponse
    se verra ajouter une ligne d'en-tête <code>Via:</code> pour le
    serveur courant.</li>

    <li>Si elle est définie à <code>Full</code>, chaque ligne d'en-tête
    <code>Via:</code> se verra ajouter la version du serveur Apache
    httpd sous la forme d'un champ de commentaire <code>Via:</code>.</li>

    <li>Si elle est définie à <code>Block</code>, chaque requête
    mandatée verra ses lignes d'en-tête <code>Via:</code> supprimées.
    Aucun nouvel en-tête <code>Via:</code> ne sera généré.</li>
    </ul>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyErrorOverride</name>
<description>Outrepasser les pages d'erreur pour les contenus
mandatés</description>
<syntax>ProxyErrorOverride On|Off</syntax>
<default>ProxyErrorOverride Off</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>

<usage>
    <p>Cette directive est utile pour les configurations de mandataires
    inverses, lorsque vous souhaitez que les pages d'erreur envoyées
    aux utilisateurs finaux présentent un aspect homogène. Elle permet
    aussi l'inclusion de fichiers (via les SSI de
    <module>mod_include</module>) pour obtenir le code d'erreur et agir
    en conséquence (le comportement par défaut afficherait la page
    d'erreur du serveur mandaté, alors que c'est le message d'erreur SSI
    qui sera affiché si cette directive est à "on").</p>

    <p>Cette directive n'affecte pas le traitement des réponses
    informatives (1xx), de type succès normal (2xx), ou de redirection
    (3xx).</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyPassInterpolateEnv</name>
<description>Active l'interpolation des variables d'environnement dans
les configurations de mandataires inverses</description>
<syntax>ProxyPassInterpolateEnv On|Off</syntax>
<default>ProxyPassInterpolateEnv Off</default>
<contextlist><context>server config</context> <context>virtual host</context>
<context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.2.9 d'Apache</compatibility>

<usage>
    <p>Cette directive, ainsi que l'argument <var>interpolate</var> des
    directives <directive>ProxyPass</directive>,
    <directive>ProxyPassReverse</directive>,
    <directive>ProxyPassReverseCookieDomain</directive> et
    <directive>ProxyPassReverseCookiePath</directive>, permet de
    configurer dynamiquement un mandataire inverse à l'aide de
    variables d'environnement, ces dernières pouvant être définies par un
    autre module comme <module>mod_rewrite</module>. Elle affecte les
    directives <directive>ProxyPass</directive>,
    <directive>ProxyPassReverse</directive>,
    <directive>ProxyPassReverseCookieDomain</directive>, et
    <directive>ProxyPassReverseCookiePath</directive>, en leur indiquant
    de remplacer la chaîne <code>${nom_var}</code> dans les directives
    de configuration par la valeur de la variable d'environnement
    <code>nom_var</code> (si l'option <var>interpolate</var> est
    spécifiée).</p>
    <p>Conservez cette directive à off (pour les performances du
    serveur), sauf si vous en avez réellement besoin.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyStatus</name>
<description>Affiche l'état du répartiteur de charge du mandataire dans
mod_status</description>
<syntax>ProxyStatus Off|On|Full</syntax>
<default>ProxyStatus Off</default>
<contextlist><context>server config</context>
<context>virtual host</context>
</contextlist>
<compatibility>Disponible depuis la version 2.2 d'Apache</compatibility>

<usage>
    <p>Cette directive permet de spécifier si les données d'état du
    répartiteur de charge du mandataire doivent être affichées via la
    page d'état du serveur du module <module>mod_status</module>.</p>
    <note><title>Note</title>
      <p>L'argument <strong>Full</strong> produit le même effet que
      l'argument <strong>On</strong>.</p>
    </note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyAddHeaders</name>
<description>Ajoute des informations à propos du mandataire aux
en-têtes X-Forwarded-*</description>
<syntax>ProxyAddHeaders Off|On</syntax>
<default>ProxyAddHeaders On</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.10</compatibility>

<usage>
    <p>Cette directive permet de passer au serveur d'arrière-plan des
    informations à propos du mandataire via les en-têtes HTTP
    X-Forwarded-For, X-Forwarded-Host et X-Forwarded-Server.</p>
    <note><title>Utilité</title>
     <p>Cette option n'est utile que dans le cas du mandat HTTP traité
     par <module>mod_proxy_http</module>.</p>
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxySourceAddress</name>
<description>Définit l'adresse IP locale pour les connexions mandatées
sortantes</description>
<syntax>ProxySourceAddress <var>adresse</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.9</compatibility>

<usage>
    <p>Cette directive permet de définir une adresse IP locale
    spécifique à laquelle faire référence lors d'une connexion à un
    serveur d'arrière-plan.</p>

</usage>
</directivesynopsis>

</modulesynopsis>
