<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1673563 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_authn_anon.xml.meta">

<name>mod_authn_anon</name>
<description>Permet un acc&egrave;s "anonyme" &agrave; des zones
prot&eacute;g&eacute;es</description>
<status>Extension</status>
<sourcefile>mod_authn_anon.c</sourcefile>
<identifier>authn_anon_module</identifier>
<compatibility>Disponible depuis la version 2.1 d'Apache</compatibility>

<summary>
    <p>Ce module permet aux frontaux d'authentification comme
    <module>mod_auth_basic</module> d'authentifier les utilisateurs
    &agrave; la mani&egrave;re des sites FTP anonymes, c'est &agrave; dire
    en fournissant l'identifiant utilisateur sp&eacute;cial 'anonymous' et
    l'adresse email comme mot de passe. Ces adresses email peuvent &ecirc;tre
    journalis&eacute;es.</p>

    <p>En combinaison avec d'autres m&eacute;thodes de contr&ocirc;le d'acc&egrave;s (base
    de donn&eacute;es), ce module permet d'effectuer un v&eacute;ritable suivi des
    utilisateurs et une personnalisation de leurs acc&egrave;s en fonction de
    leur profil, tout en conservant l'accessibilit&eacute; du site aux
    utilisateurs 'non enregistr&eacute;s'. Un avantage du suivi des
    utilisateurs bas&eacute; sur l'authentification r&eacute;side dans le fait qu'il
    est, &agrave; l'oppos&eacute; des cookies magiques et des dr&ocirc;les d'URLs avec
    pr&eacute;fixes ou suffixes, enti&egrave;rement ind&eacute;pendant du navigateur et qu'il
    permet de partager des URLs entre plusieurs utilisateurs.</p>

    <p>Si l'on utilise le module <module>mod_auth_basic</module>, le
    module <module>mod_authn_anon</module> est invoqu&eacute; en affectant la
    valeur <code>anon</code> &agrave; la directive <directive
    module="mod_auth_basic">AuthBasicProvider</directive>.</p>
</summary>

<section id="example"><title>Exemple</title>
    <p>L'exemple ci-dessous pr&eacute;sente un exemple de combinaison avec
    l'authentification &agrave; base de fichier htpasswd "normale", et permet
    la connexion d'utilisateurs en tant qu'invit&eacute;s avec les propri&eacute;t&eacute;s
    suivantes :</p>

    <ul>
      <li>Il incite l'utilisateur &agrave; fournir un identifiant.
      (<directive module="mod_authn_anon"
      >Anonymous_NoUserID</directive>)</li>

      <li>Il incite l'utilisateur &agrave; fournir un mot de passe.
      (<directive module="mod_authn_anon"
      >Anonymous_MustGiveEmail</directive>)</li>

      <li>Le mot de passe fourni doit &ecirc;tre une adresse email valide,
      c'est &agrave; dire contenant au moins un '@' et un '.'.
      (<directive module="mod_authn_anon"
      >Anonymous_VerifyEmail</directive>)</li>

      <li>Les valeurs possibles pour l'identifiant utilisateur sont
      <code>anonymous, guest, www, test ou welcome</code>, et la
      v&eacute;rification n'est <strong>pas</strong> sensible &agrave; la casse.
      (<directive module="mod_authn_anon"
      >Anonymous</directive>)</li>

      <li>Les adresses email entr&eacute;es dans le champ passwd sont
      enregistr&eacute;es dans le fichier journal des erreurs.
      (<directive module="mod_authn_anon"
      >Anonymous_LogEmail</directive>)</li>
    </ul>

    <example><title>Exemple</title>
      <highlight language="config">
&lt;Directory "/var/www/html/private"&gt;
    AuthName "Use 'anonymous' &amp; Email address for guest entry"
    AuthType Basic
    AuthBasicProvider file anon
    AuthUserFile "/path/to/your/.htpasswd"

    Anonymous_NoUserID off
    Anonymous_MustGiveEmail on
    Anonymous_VerifyEmail on
    Anonymous_LogEmail on
    Anonymous anonymous guest www test welcome

    Require valid-user
&lt;/Directory&gt;
      </highlight>
    </example>
</section>

<directivesynopsis>
<name>Anonymous</name>
<description>D&eacute;finit la liste des identifiants utilisateur autoris&eacute;s &agrave;
acc&eacute;der sans v&eacute;rification du mot de passe</description>
<syntax>Anonymous <var>utilisateur</var> [<var>utilisateur</var>]
...</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Une liste d'un ou plusieurs identifiants utilisateur sp&eacute;ciaux
    autoris&eacute;s &agrave; acc&eacute;der sans v&eacute;rification du mot de passe. Les
    identifiants doivent &ecirc;tre s&eacute;par&eacute;s par un espace. Pour sp&eacute;cifier un
    identifiant contenant un espace, on peut utiliser les guillemets '
    ou ", ou le caract&egrave;re d'&eacute;chappement \.</p>

    <p>Veuillez noter que la v&eacute;rification <strong>n'est pas sensible &agrave;
    la casse</strong>.<br />
    Il est fortement conseill&eacute; d'int&eacute;grer l'utilisateur sp&eacute;cial
    '<code>anonymous</code>' dans la liste des identifiants.</p>

    <example><title>Exemple:</title>
    <highlight language="config">
      Anonymous anonymous "Not Registered" "I don't know"
      </highlight>
    </example>

    <p>Dans cet exemple, l'utilisateur peut acc&eacute;der au site sans
    v&eacute;rification du mot de passe en utilisant l'identifiant "anonymous",
    "Not Registered", "I Don't Know" ou encore "AnonyMous".</p>

    <p>Depuis Apache 2.1, il est possible de remplacer la liste des
    identifiants autoris&eacute;s par le caract&egrave;re "<code>*</code>", ce qui
    permet d'utiliser <em>n'importe quel</em> identifiant pour pouvoir
    acc&eacute;der au site.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Anonymous_LogEmail</name>
<description>D&eacute;termine si le mot de passe fourni sera enregistr&eacute; dans le
journal des erreurs</description>
<syntax>Anonymous_LogEmail On|Off</syntax>
<default>Anonymous_LogEmail On</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Lorsque cette directive est d&eacute;finie &agrave; <code>On</code>, valeur
    par d&eacute;faut, le 'mot de passe' fourni (cens&eacute; contenir une adresse
    email valide) est enregistr&eacute; dans le journal des erreurs.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Anonymous_MustGiveEmail</name>
<description>D&eacute;termine si l'abscence de mot de passe est
autoris&eacute;e</description>
<syntax>Anonymous_MustGiveEmail On|Off</syntax>
<default>Anonymous_MustGiveEmail On</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>D&eacute;termine si l'utilisateur doit sp&eacute;cifier une adresse email comme
    mot de passe. Lorsque cette directive est d&eacute;finie &agrave; <code>On</code>,
    l'abscence de mot de passe est interdite.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Anonymous_NoUserID</name>
<description>D&eacute;termine si le champ identifiant peut &ecirc;tre
vide</description>
<syntax>Anonymous_NoUserID On|Off</syntax>
<default>Anonymous_NoUserID Off</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Lorsque cette directive est d&eacute;finie &agrave; <code>On</code>, les
    utilisateurs peuvent laisser le champ identifiant vide (et peut-&ecirc;tre
    aussi le champ mot de passe selon la d&eacute;finition de la directive
    <directive
    module="mod_authn_anon">Anonymous_MustGiveEmail</directive>). Ceci
    peut s'av&eacute;rer tr&egrave;s utile pour les utilisateurs de MS-Explorer qui
    n'ont pour seule possibilit&eacute; que d'appuyer sur Entr&eacute;e ou de cliquer
    directement sur le bouton OK, ce qui semble &ecirc;tre une r&eacute;action
    naturelle.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Anonymous_VerifyEmail</name>
<description>D&eacute;termine s'il faut v&eacute;rifier que le format de l'adresse
email fournie comme mot de passe est correct</description>
<syntax>Anonymous_VerifyEmail On|Off</syntax>
<default>Anonymous_VerifyEmail Off</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Lorsque cette directive est d&eacute;finie &agrave; <code>On</code>, Apache
    v&eacute;rifie que le 'mot de passe' entr&eacute; contient au moins un '@' et un
    '.' afin d'inciter les utilisateurs &agrave; fournir des adresses email
    valides (voir ci-dessus la directive <directive
    module="mod_authn_anon">Anonymous_LogEmail</directive>).</p>
</usage>
</directivesynopsis>

</modulesynopsis>
