<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1816356 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_authn_socache.xml.meta">

<name>mod_authn_socache</name>
<description>Gère un cache des données d'authentification pour diminuer
la charge des serveurs d'arrière-plan</description>
<status>Base</status>
<sourcefile>mod_authn_socache.c</sourcefile>
<identifier>authn_socache_module</identifier>
<compatibility>Versions 2.3 et ultérieures</compatibility>

<summary>
    <p>Maintient un cache des données d'authentification pour limiter
    les sollicitations du serveur d'arrière-plan.</p>
</summary>

<section id="intro"><title>Mise en cache des données d'authentification</title>
    <p>Certains utilisateurs qui mettent en oeuvre une authentification
    lourde s'appuyant par exemple sur des requêtes SQL
    (<module>mod_authn_dbd</module>) ont signalé une charge induite
    inacceptable sur leur fournisseur d'authentification. Cela se
    produit typiquement dans le cas où une page HTML contient des
    centaines d'objets (images, scripts, pages de styles, media,
    etc...), et où une requête pour cette page génère des centaines de
    sous-requêtes à effet immédiat pour des contenus supplémentaires
    authentifiés.</p>
    <p>Pour résoudre ce problème, mod_authn_socache fournit une solution
    qui permet de maintenir un cache des données d'authentification.</p>
</section>

<section id="usage"><title>Utilisation</title>
    <p>Le cache d'authentification doit être utilisé lorsque les
    requêtes d'authentification induisent une charge significative sur le
    serveur, le serveur d'arrière-plan ou le réseau. Cette mise en cache
    n'apportera probablement aucune amélioration dans le cas d'une
    authentification à base de fichier (<module>mod_authn_file</module>)
    ou de base de données dbm (<module>mod_authn_dbm</module>) car ces
    méthodes sont de par leur conception rapides et légères (la mise en
    cache peut cependant s'avérer utile dans le cas où le fichier est
    situé sur un montage réseau). Les fournisseurs d'authentification
    basés sur SQL ou LDAP ont plus de chances de tirer parti de cette
    mise en cache, en particulier lorsqu'un problème de performances est
    détecté. <module>mod_authnz_ldap</module> gérant son propre cache,
    seul <module>mod_authn_dbd</module> est concerné par notre sujet.</p>
    <p>Les principales règles à appliquer pour la mise en cache sont :</p>
    <ol><li>Inclure le fournisseur pour lequel vous voulez effectuer une
    mise en cache dans une directive
    <directive>AuthnCacheProvideFor</directive>.</li>
        <li>Mettre <var>socache</var> avant le fournisseur pour lequel
	vous voulez effectuer une mise en cache dans votre directive
	<directive module="mod_auth_basic">AuthBasicProvider</directive>
	ou <directive
	module="mod_auth_digest">AuthDigestProvider</directive>.</li>
    </ol>
    <p>Voici un exemple simple permettant d'accélérer
    <module>mod_authn_dbd</module> et utilisant dbm comme moteur de la
    mise en cache :</p>
    <highlight language="config">
    #AuthnCacheSOCache est optionnel. S'il est défini, il l'est pour
    #l'ensemble du serveur
AuthnCacheSOCache dbm
&lt;Directory "/usr/www/myhost/private"&gt;
    AuthType Basic
    AuthName "Cached Authentication Example"
    AuthBasicProvider socache dbd
    AuthDBDUserPWQuery "SELECT password FROM authn WHERE user = %s"
    AuthnCacheProvideFor dbd
    Require valid-user
    #Optionnel
    AuthnCacheContext dbd-authn-example
&lt;/Directory&gt;
    </highlight>
</section>

<section id="dev"><title>La mise en cache avec les modules tiers</title>
    <p>Les développeurs de modules doivent savoir que la mise en cache
    avec mod_authn_socache doit être activée dans leurs modules. La
    fonction de l'API <var>ap_authn_cache_store</var> permet de
    mettre en cache les données d'authentification qu'un fournisseur
    vient de rechercher ou de générer. Vous trouverez des exemples
    d'utilisation à <a
    href="http://svn.eu.apache.org/viewvc?view=revision&amp;revision=957072"
    >r957072</a>, où trois fournisseurs authn sont activés pour la mise
    en cache.</p>
</section>

<directivesynopsis>
<name>AuthnCacheEnable</name>
<description>Active la mise en cache de l'authentification en tout
endroit</description>
<syntax>AuthnCacheEnable</syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Normalement, cette directive n'est pas nécessaire : l'activation
    est implicite si la mise en cache de l'authentification a été
    activée en tout autre endroit du fichier <var>httpd.conf</var>. Par
    contre, si cette mise en cache n'a pas été activée, par défaut, elle
    ne sera pas initialisée, et ne sera donc pas disponible dans un
    contexte de fichier <var>.htaccess</var>. Cette directive permet
    d'être sûr que la mise en cache a bien été activée et pourra
    donc être utilisée dans les fichiers <var>.htaccess</var>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthnCacheSOCache</name>
<description>Sélectionne le fournisseur socache d'arrière-plan à
utiliser</description>
<syntax>AuthnCacheSOCache <var>nom-fournisseur[:arguments-fournisseur]</var></syntax>
<contextlist><context>server config</context></contextlist>
<compatibility>Les arguments optionnels du fournisseur sont disponibles
à partir de la version 2.4.7 du serveur HTTP Apache</compatibility>

<usage>
    <p>Cette définition s'applique à l'ensemble du serveur et permet de
    sélectionner un fournisseur pour le <a href="../socache.html">cache
    d'objets partagés</a>, ainsi que des arguments éventuels pour ce
    fournisseur. Les fournisseurs disponibles sont, entre autres, "dbm",
    "dc", "memcache", ou "shmcb", chacun d'entre eux nécessitant le chargement
    du module approprié. Si elle est
    absente, c'est la valeur par défaut pour votre plate-forme qui sera
    utilisée.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthnCacheProvideFor</name>
<description>Spécifie le fournisseur pour lequel on veut effectuer une
mise en cache</description>
<syntax>AuthnCacheProvideFor <var>fournisseur-authn</var> [...]</syntax>
<default>None</default>
<contextlist><context>directory</context><context>.htaccess</context></contextlist>
<override>AuthConfig</override>

<usage>
    <p>Cette directive permet de spécifier un ou plusieurs fournisseurs
    pour le(s)quel(s) on veut effectuer une mise en cache. Les données
    d'authentification trouvées par un fournisseur non spécifié dans une
    directive AuthnCacheProvideFor ne seront pas mises en cache.</p>

    <p>Par exemple, pour mettre en cache les données d'authentification
    trouvées par <module>mod_authn_dbd</module> ou par un fournisseur
    personnalisé <var>mon-fournisseur</var>, et ne pas mettre en cache
    celles trouvées par les fournisseurs légers comme file ou dbm :</p>
    <highlight language="config">
AuthnCacheProvideFor dbd mon-fournisseur
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthnCacheTimeout</name>
<description>Définit une durée de vie pour les entrées du cache</description>
<syntax>AuthnCacheTimeout <var>durée-de-vie</var> (secondes)</syntax>
<default>300 (5 minutes)</default>
<contextlist><context>directory</context><context>.htaccess</context></contextlist>
<override>AuthConfig</override>

<usage>
    <p>La mise en cache des données d'authentification peut constituer
    un trou de sécurité, bien qu'un mise en cache de courte durée ne
    posera probablement pas de problème. En général, il est conseillé de
    conserver les entrées du cache de façon à ce que la charge du serveur
    d'arrière-plan reste normale, mais pas plus longtemps ;
    une durée de vie plus longue peut être paramétrée si les
    changements d'utilisateurs et de mots de passe sont peu fréquents.
    La durée de vie par défaut de 300 secondes (5 minutes) est à la fois
    raisonnable et suffisamment importante pour réduire la charge d'un
    serveur d'arrière-plan comme dbd (requêtes SQL).</p>
    <p>Cette durée de vie ne doit pas être confondue avec la durée de
    vie de session qui est un tout autre sujet. Cependant, vous devez
    utiliser votre logiciel de gestion de session pour vérifier si les
    données d'authentification mises en cache peuvent allonger
    accidentellement une session, et en tenir compte lorsque vous
    définissez la durée de vie.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthnCacheContext</name>
<description>Spécifie une chaîne de contexte à utiliser dans la clé du
cache</description>
<syntax>AuthnCacheContext <var>directory|server|chaîne-personnalisée</var></syntax>
<default>directory</default>
<contextlist><context>directory</context></contextlist>

<usage>
    <p>Cette directive permet de spécifier une chaîne à utiliser avec le
    nom d'utilisateur fourni (et le domaine d'authentification - realm -
    dans le cas d'une authentification à base de condensés) lors de la
    construction d'une clé de cache. Ceci permet de lever l'ambiguïté
    entre plusieurs noms d'utilisateurs identiques servant différentes
    zones d'authentification sur le serveur.</p>
    <p>Il y a deux valeurs spéciales pour le paramètre : <var>directory</var>,
    qui utilise le contexte de répertoire de la requête comme chaîne, et
    <var>server</var>, qui utilise le nom du serveur virtuel.</p>
    <p>La valeur par défaut est <var>directory</var>, qui est aussi la
    définition la plus courante. Ceci est cependant loin d'être optimal,
    car par exemple, <var>$app-base</var>, <var>$app-base/images</var>,
    <var>$app-base/scripts</var> et <var>$app-base/media</var>
    possèderont chacun leur propre clé de cache. Il est préférable
    d'utiliser le fournisseur de mot de passe : par exemple un fichier
    <var>htpasswd</var> ou une table de base de données.</p>
    <p>Les contextes peuvent être partagés entre différentes zones du
    serveur, où les données d'authentification sont partagées. Ceci est
    cependant susceptible de créer des trous de sécurité de type
    cross-site ou cross-application, et cette directive n'est donc pas
    disponible dans les contextes <var>.htaccess</var>.</p>
</usage>
</directivesynopsis>

</modulesynopsis>

