<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1673563 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_proxy_ajp.xml.meta">

<name>mod_proxy_ajp</name>
<description>Module de support AJP pour
<module>mod_proxy</module></description>
<status>Extension</status>
<sourcefile>mod_proxy_ajp.c</sourcefile>
<identifier>proxy_ajp_module</identifier>
<compatibility>Disponible depuis la version 2.1 d'Apache</compatibility>

<summary>
    <p>Ce module nécessite le chargement de <module
    >mod_proxy</module>. Il fournit le support du <code>Protocole Apache
    JServ version 1.3</code> (nommé dans la suite de ce document
    <em>AJP13</em>).</p>

    <p>Pour être en mesure d'exploiter le protocole <code>AJP13</code>,
    il est donc nécessaire de charger les modules
    <module>mod_proxy</module> et <module>mod_proxy_ajp</module>.</p>

    <note type="warning"><title>Avertissement</title>
      <p>N'activez pas la fonctionnalité de mandataire avant d'avoir <a
      href="mod_proxy.html#access">sécurisé votre serveur</a>. Les
      serveurs mandataires ouverts sont dangereux non seulement pour
      votre réseau, mais aussi pour l'Internet au sens large. </p>
    </note>
</summary>

<seealso><module>mod_proxy</module></seealso>
<seealso><a href="../env.html">Documentation sur les variables
d'environnement</a></seealso>

<section id="usage"><title>Utilisation</title>
    <p>Ce module permet de mandater en inverse un serveur d'application
    d'arrière-plan (comme Apache Tomcat) qui utilise le protocole AJP13.
    Son utilisation est similaire à celle d'un mandataire inverse HTTP,
    mais s'appuie sur le prefixe <code>ajp://</code> :</p>

    <example><title>Mandataire inverse simple</title>
    <highlight language="config">
    ProxyPass "/app" "ajp://backend.example.com:8009/app"
    </highlight>
    </example>

    <p>On peut aussi configurer un répartiteur de charge :</p>
    <example><title>Mandataire inverse avec répartiteur de charge</title>
      <highlight language="config">
&lt;Proxy balancer://cluster&gt;
    BalancerMember "ajp://app1.example.com:8009" loadfactor=1
    BalancerMember "ajp://app2.example.com:8009" loadfactor=2
    ProxySet lbmethod=bytraffic
&lt;/Proxy&gt;
ProxyPass "/app" "balancer://cluster/app"
      </highlight>
    </example>

    <p>Notez qu'en général, la directive <directive
    module="mod_proxy">ProxyPassReverse</directive> n'est pas
    nécessaire. La requête AJP inclut l'en-tête host original fourni
    au mandataire, et le serveur d'application est sensé générer des
    en-têtes auto-référençants relatifs à cet hôte ; aucune réécriture
    n'est donc nécessaire.</p>

    <p>La situation la plus courante dans laquelle la directive <directive
    module="mod_proxy">ProxyPassReverse</directive> est nécessaire se
    rencontre lorsque le chemin de l'URL au niveau du mandataire est
    différente de celle du serveur d'arrière-plan. Dans ce cas, un
    en-tête redirect peut être réécrit relativement à l'URL de l'hôte
    original (et non du serveur d'arrière-plan <code>ajp://</code> URL)
    ; par exemple :</p>
    <example><title>Réécriture d'un chemin mandaté</title>
      <highlight language="config">
ProxyPass "/apps/foo" "ajp://backend.example.com:8009/foo"
ProxyPassReverse "/apps/foo" "http://www.example.com/foo"
    </highlight>
    </example>
    <p>Il est cependant préférable en général de déployer l'application
    sur le serveur d'arrière-plan avec le même chemin que sur le
    mandataire.
    </p>
</section>

<section id="env"><title>Variables d'environnement</title>
    <p>Les variables d'environnement dont le nom possède le préfixe
    <code>AJP_</code> sont transmises au serveur original en tant
    qu'attributs de requête AJP (le préfixe AJP_ étant supprimé du nom
    de la clé).</p>
</section>

<section id="overviewprotocol"><title>Vue d'ensemble du protocole</title>
    <p>Le protocole <code>AJP13</code> est orienté paquet. Le format
    binaire a été préféré, probablement pour des raisons de
    performances, au format texte pourtant plus lisible. Le serveur web
    communique avec le conteneur de servlets sur une connexion TCP. Pour
    diminuer la charge induite par le processus de création de socket,
    le serveur web va tenter d'utiliser des connexions TCP persistantes
    avec le conteneur de servlets, et de réutiliser les connexions
    pendant plusieurs cycles requêtes/réponse.</p>
    <p>Lorsqu'une connexion a été assignée à une requête particulière,
    elle ne sera utilisée pour aucune autre jusqu'à ce que le cycle de
    traitement de la requête se soit terminé. En d'autres termes, il n'y
    a pas de multiplexage des requêtes sur une connexion. Ceci se
    traduit par un code beaucoup plus simple à chaque extrémité de la
    connexion, un nombre plus important de connexions étant cependant
    ouvertes en même temps.</p>
    <p>Lorsque le serveur web a ouvert une connexion vers le conteneur
    de servlets, celle-ci peut se trouver dans l'un des états suivants
    :</p>
    <ul>
    <li> Idle <br/> Aucune requête n'est traitée sur cette
    connexion. </li>
    <li> Assigned <br/> La connexion fait l'objet d'un traitement de
    requête.</li>
    </ul>
    <p>Lorsqu'une connexion est assignée au traitement d'une requête
    particulière, les informations de base de cette dernière (comme les
    en-têtes HTTP, etc...) sont envoyées sur la connexion sous une forme
    très condensée (par exemple les chaînes courantes sont codées sous
    forme d'entiers). Vous trouverez des détails sur ce format plus
    loin dans la structure des paquets de requête. Si la requête possède
    un corps <code>(content-length > 0)</code>, il est envoyé dans un
    paquet séparé immédiatement après.</p>
    <p>A ce moment, le conteneur est probablement prêt à traiter la
    requête. Au cours de ce traitement, il peut renvoyer les messages
    suivants au serveur web :</p>
    <ul>
    <li>SEND_HEADERS <br/>Renvoie un jeu d'en-têtes au navigateur.</li>
    <li>SEND_BODY_CHUNK <br/>Renvoie un tronçon de corps de requête au
    navigateur.
    </li>
    <li>GET_BODY_CHUNK <br/>Reçoit un autre tronçon de données de la
    requête si elle n'a pas encore été transmise intégralement. Ce type
    de transmission est nécessaire car les paquets possèdent une taille
    maximale fixe, et des quantités quelconques de données peuvent être
    contenues dans le corps de la requête (pour un chargement de
    fichier, par exemple). Notez que cela n'a rien à voir avec le
    transfert HTTP fractionné.</li>
    <li>END_RESPONSE <br/> Termine le cycle du traitement de la
    requête.</li>
    </ul>
    <p>Chaque message est associé à un paquet de données formaté
    différemment. Voir plus loin les structures des paquets de réponses
    pour plus de détails.</p>
</section>

<section id="basppacketstruct"><title>Structure de base des paquets</title>
    <p>Ce protocole hérite en partie de XDR, mais il diffère sur de
    nombreux points (pas d'alignement sur 4 bits, par exemple).</p>
    <p>AJP13 utilise les octets selon leur ordre d'arrivée par le réseau
    pour tous les types de données.</p>
    <p>Le protocole comporte quatre types de données : octets, booléens,
    entiers et chaînes de caractères.</p>
    <dl>
    <dt><strong>Octet</strong></dt><dd>Un seul octet.</dd>
    <dt><strong>Booléen</strong></dt>
      <dd>Un seul octet, <code>1 = vrai</code>, <code>0 = faux</code>.
      L'utilisation d'autres valeurs non nulles (dans le style C) peut
      fonctionner dans certains cas, mais pas dans certains autres..</dd>
    <dt><strong>Entier</strong></dt>
      <dd>Un nombre compris entre <code>0 et 2^16 (32768)</code>, stocké
      sur 2 octets en débutant par l'octet de poids forts.</dd>
    <dt><strong>Chaîne</strong></dt>
      <dd>Une chaîne de taille variable (longueur limitée à 2^16). Elle
      est codée comme suit : les deux premiers octets représentent la
      longueur de la chaîne, les octets suivants constituent la chaîne
      proprement dite (y compris le '\0' final). Notez que la longueur
      encodée dans les deux premiers octets ne prend pas en compte le
      '\0' final, de la même manière que <code>strlen</code>. Cela peut
      prêter à confusion du point de vue de Java qui est surchargé de
      déclarations d'autoincrémentation étranges destinées à traiter
      ces terminateurs. Je suppose que le but dans lequel cela a
      été conçu ainsi était de permettre au code C d'être plus efficace
      lors de la lecture de chaînes en provenance du conteneur de
      servlets -- avec le caractère \0 final, le code C peut transmettre
      des références dans un seul tampon, sans avoir à effectuer de
      copie. En l'absence du caractère \0 final, le code C doit
      effectuer une copie afin de pouvoir tenir compte de sa notion de
      chaîne.</dd>
    </dl>

  <section><title>Taille du paquet</title>
    <p>Selon la majorité du code, la taille maximale du paquet est de
    <code>8 * 1024 bytes (8K)</code>. La taille réelle du paquet est
    encodée dans l'en-tête.</p>
  </section>
  <section><title>En-têtes de paquet</title>
    <p>Les paquets envoyés par le serveur vers le conteneur commencent
    par <code>0x1234</code>. Les paquets envoyés par le conteneur vers
    le serveur commencent par <code>AB</code> (c'est à dire le code
    ASCII de A suivi du code ASCII de B). Ensuite, vient un entier (codé
    comme ci-dessus) représentant la longueur des données transmises.
    Bien que ceci puisse faire croire que la taille maximale des données
    est de 2^16, le code définit en fait ce maximum à 8K.</p>
    <table>
       <columnspec><column width=".2"/><column width=".1"/><column width=".1"/><column width=".2"/><column width=".2"/><column width=".2"/></columnspec>    
      <tr>
        <th colspan="6"><em>Format du paquet (Serveur->Conteneur)</em></th>
      </tr>
      <tr>
        <th>Octet</th>
        <td>0</td>
        <td>1</td>
        <td>2</td>
        <td>3</td>
        <td>4...(n+3)</td>
      </tr>
      <tr>
        <th>Contenu</th>
        <td>0x12</td>
        <td>0x34</td>
        <td colspan="2">Taille des données (n)</td>
        <td>Data</td>
      </tr>
    </table>
    <table>
       <columnspec><column width=".2"/><column width=".1"/><column width=".1"/><column width=".2"/><column width=".2"/><column width=".2"/></columnspec>
      <tr>
        <th colspan="6"><em>Format du paquet
	(Conteneur->Serveur)</em></th>
      </tr>
      <tr>
        <th>Octet</th>
        <td>0</td>
        <td>1</td>
        <td>2</td>
        <td>3</td>
        <td>4...(n+3)</td>
      </tr>
      <tr>
        <th>Contenu</th>
        <td>A</td>
        <td>B</td>
        <td colspan="2">Taille des données (n)</td>
        <td>Data</td>
      </tr>
    </table>
    <p>Pour la plupart des paquets, le premier octet de la charge utile
    encode le type de message, à l'exception des paquets contenant un
    corps de requête envoyés du serveur vers le conteneur -- ils
    comportent un en-tête standard (<code>0x1234</code> suivi de la taille
    du paquet), mais celui-ci n'est suivi d'aucun préfixe.</p>
     <p>Le serveur web peut envoyer les messages suivants au conteneur
     de servlets :</p>
    <table>
       <columnspec><column width=".2"/><column width=".3"/><column width=".5"/></columnspec>
      <tr>
        <td>Code</td>
        <td>Type de paquet</td>
        <td>Signification</td>
      </tr>
      <tr>
        <td>2</td>
        <td>Fait suivre la requête</td>
        <td>Débute le cycle de traitement de la requête avec les données
	qui suivent.</td>
      </tr>
      <tr>
        <td>7</td>
        <td>Arrêt</td>
        <td>Le serveur web demande au conteneur de s'arrêter.</td>
      </tr>
      <tr>
        <td>8</td>
        <td>Ping</td>
        <td>Le serveur web demande au conteneur de prendre le contrôle
	(phase de connexion sécurisée).</td>
      </tr>
      <tr>
        <td>10</td>
        <td>CPing</td>
        <td>Le serveur web demande au conteneur de répondre rapidement
	avec un CPong.
        </td>
      </tr>
      <tr>
        <td>none</td>
        <td>Données</td>
        <td>Taille (2 octets) et les données correspondantes.</td>
      </tr>
    </table>
    <p>À des fins de sécurité, le conteneur n'effectuera réellement son
    <code>Arrêt</code> que si la demande provient de la machine par
    laquelle il est hébergé.</p>
    <p>Le premier paquet <code>Données</code> est envoyé immédiatement
    après le paquet <code>Faire suivre la requête</code> par le serveur
    web.</p>
    <p>Le conteneur de servlets peut envoyer les types de messages
    suivants au serveur web :</p>
    <table>
       <columnspec><column width=".2"/><column width=".3"/><column width=".5"/></columnspec>
      <tr>
        <td>Code</td>
        <td>Type de paquet</td>
        <td>Signification</td>
      </tr>
      <tr>
        <td>3</td>
        <td>Envoi d'un tronçon de corps</td>
        <td>Envoi d'un tronçon de corps depuis le conteneur de servlets
	vers le serveur web (et probablement vers le navigateur).</td>
      </tr>
      <tr>
        <td>4</td>
        <td>Envoie les en-têtes</td>
        <td>Envoi des en-têtes de réponse depuis le conteneur de
	servlets vers le serveur web (et probablement vers le
	navigateur).</td>
      </tr>
      <tr>
        <td>5</td>
        <td>Fin de la réponse</td>
        <td>Marque la fin de la réponse (et par conséquent du cycle de
	traitement de la requête).
        </td>
      </tr>
      <tr>
        <td>6</td>
        <td>Réception du tronçon de corps suivant</td>
        <td>Réception de la suite des données de la requête si elles
	n'ont pas encore été entièrement transmises.</td>
      </tr>
      <tr>
        <td>9</td>
        <td>Réponse CPong</td>
        <td>La réponse à une requête CPing</td>
      </tr>
    </table>
    <p>Chacun des messages ci-dessus possède une structure interne
    différente dont vous trouverez les détails ci-dessous.</p>
  </section>
</section>
<section id="rpacetstruct"><title>Structure des paquets de
requête</title>
    <p>Pour les messages de type <em>Faire suivre la requête</em> depuis
    le serveur vers le conteneur :</p>
    <example><pre>
AJP13_FORWARD_REQUEST :=
    prefix_code      (byte) 0x02 = JK_AJP13_FORWARD_REQUEST
    method           (byte)
    protocol         (string)
    req_uri          (string)
    remote_addr      (string)
    remote_host      (string)
    server_name      (string)
    server_port      (integer)
    is_ssl           (boolean)
    num_headers      (integer)
    request_headers *(req_header_name req_header_value)
    attributes      *(attribut_name attribute_value)
    request_terminator (byte) OxFF
    </pre></example>
    <p>Les <code>request_headers</code> possèdent la structure suivante
    :
    </p><example><pre>
req_header_name :=
    sc_req_header_name | (string)  [voir ci-dessous pour la manière dont
    ceci est interprété]

sc_req_header_name := 0xA0xx (integer)

req_header_value := (string)
</pre></example>
    <p>Les <code>attributes</code> sont optionnels et possèdent la
    structure suivante :</p>
    <example><pre>
attribute_name := sc_a_name | (sc_a_req_attribute string)

attribute_value := (string)

    </pre></example>
    <p>Un des en-têtes les plus importants est
    <code>content-length</code>, car il indique si le conteneur doit ou
    non attendre un autre paquet immédiatement.</p>
  <section><title>Description détaillée de la requête que le serveur
  fait suivre vers le conteneur
  </title></section>
  <section><title>Préfixe de la requête</title>
    <p>Pour toutes les requêtes, ce préfixe est 2. Voir ci-dessus pour
    les détails des autres codes de préfixes.</p>
  </section>
  <section><title>Méthode</title>
    <p>La méthode HTTP, encodée sous la forme d'un seul octet :</p>
    <table>
      <tr><td>Nom commande</td><td>Code</td></tr>
      <tr><td>OPTIONS</td><td>1</td></tr>
      <tr><td>GET</td><td>2</td></tr>
      <tr><td>HEAD</td><td>3</td></tr>
      <tr><td>POST</td><td>4</td></tr>
      <tr><td>PUT</td><td>5</td></tr>
      <tr><td>DELETE</td><td>6</td></tr>
      <tr><td>TRACE</td><td>7</td></tr>
      <tr><td>PROPFIND</td><td>8</td></tr>
      <tr><td>PROPPATCH</td><td>9</td></tr>
      <tr><td>MKCOL</td><td>10</td></tr>
      <tr><td>COPY</td><td>11</td></tr>
      <tr><td>MOVE</td><td>12</td></tr>
      <tr><td>LOCK</td><td>13</td></tr>
      <tr><td>UNLOCK</td><td>14</td></tr>
      <tr><td>ACL</td><td>15</td></tr>
      <tr><td>REPORT</td><td>16</td></tr>
      <tr><td>VERSION-CONTROL</td><td>17</td></tr>
      <tr><td>CHECKIN</td><td>18</td></tr>
      <tr><td>CHECKOUT</td><td>19</td></tr>
      <tr><td>UNCHECKOUT</td><td>20</td></tr>
      <tr><td>SEARCH</td><td>21</td></tr>
      <tr><td>MKWORKSPACE</td><td>22</td></tr>
      <tr><td>UPDATE</td><td>23</td></tr>
      <tr><td>LABEL</td><td>24</td></tr>
      <tr><td>MERGE</td><td>25</td></tr>
      <tr><td>BASELINE_CONTROL</td><td>26</td></tr>
      <tr><td>MKACTIVITY</td><td>27</td></tr>
    </table>
    <p>Les versions futures d'ajp13 pourront transmettre des méthodes
    supplémentaires, même si elles ne font pas partie de cette
    liste.</p>
  </section>
  <section><title>protocol, req_uri, remote_addr, remote_host, server_name,
  server_port, is_ssl</title>
    <p>Les significations de ces éléments sont triviales. Ils sont tous
    obligatoires et seront envoyés avec chaque requête.</p>
  </section>
  <section><title>En-têtes</title>
    <p>La structure de <code>request_headers</code> est la suivante
    : tout d'abord, le nombre d'en-têtes <code>num_headers</code> est
    encodé, suivi d'une liste de paires nom d'en-tête
    <code>req_header_name</code> / valeur <code>req_header_value</code>.
    Les noms d'en-têtes courants sont codés sous forme d'entiers afin de
    gagner de la place. Si le nom d'en-tête ne fait partie de la liste
    des en-têtes courants, il est encodé normalement (une chaîne de
    caractères préfixée par la taille). La liste des en-têtes courants
    <code>sc_req_header_name</code> avec leurs codes se présente comme
    suit (il sont tous sensibles à la casse) :</p>
    <table>
      <tr><td>Nom</td><td>Valeur du code</td><td>Nom du code</td></tr>
      <tr><td>accept</td><td>0xA001</td><td>SC_REQ_ACCEPT</td></tr>
      <tr><td>accept-charset</td><td>0xA002</td><td>SC_REQ_ACCEPT_CHARSET
      </td></tr>
      <tr><td>accept-encoding</td><td>0xA003</td><td>SC_REQ_ACCEPT_ENCODING
      </td></tr>
      <tr><td>accept-language</td><td>0xA004</td><td>SC_REQ_ACCEPT_LANGUAGE
      </td></tr>
      <tr><td>authorization</td><td>0xA005</td><td>SC_REQ_AUTHORIZATION</td>
      </tr>
      <tr><td>connection</td><td>0xA006</td><td>SC_REQ_CONNECTION</td></tr>
      <tr><td>content-type</td><td>0xA007</td><td>SC_REQ_CONTENT_TYPE</td>
      </tr>
      <tr><td>content-length</td><td>0xA008</td><td>SC_REQ_CONTENT_LENGTH</td>
      </tr>
      <tr><td>cookie</td><td>0xA009</td><td>SC_REQ_COOKIE</td></tr>
      <tr><td>cookie2</td><td>0xA00A</td><td>SC_REQ_COOKIE2</td></tr>
      <tr><td>host</td><td>0xA00B</td><td>SC_REQ_HOST</td></tr>
      <tr><td>pragma</td><td>0xA00C</td><td>SC_REQ_PRAGMA</td></tr>
      <tr><td>referer</td><td>0xA00D</td><td>SC_REQ_REFERER</td></tr>
      <tr><td>user-agent</td><td>0xA00E</td><td>SC_REQ_USER_AGENT</td></tr>
    </table>
    <p>Le code Java qui lit ceci extrait l'entier représenté par les
    deux premiers octets, et si le premier octet est
    <code>'0xA0'</code>, il utilise l'entier représenté par le deuxième
    octet comme index d'un tableau de noms d'en-têtes. Si le premier
    octet n'est pas <code>0xA0</code>, l'entier représenté par les deux
    octets est considéré comme la longueur d'une chaîne qui est alors
    lue.</p>
    <p>Ceci ne peut fonctionner que si aucun nom d'en-tête ne possède
    une taille supérieure à <code>0x9FFF (==0xA000 - 1)</code>, ce qui
    est vraisemblable, bien qu'un peu arbitraire.</p>
    <note><title>Note:</title>
    L'en-tête <code>content-length</code> est extrêmement important.
    S'il est présent et non nul, le conteneur considère que la requête
    possède un corps (une requête POST, par exemple), et lit
    immédiatement le paquet suivant dans le flux d'entrée pour extraire
    ce corps.
    </note>
  </section>
  <section><title>Attributs</title>
    <p>Les attributs préfixés par <code>?</code> (par exemple
    <code>?context</code>) sont tous optionnels. Chacun d'eux est
    représenté par un octet correspondant au type de l'attribut et par
    sa valeur (chaîne ou entier). Ils peuvent être envoyés dans un ordre
    quelconque (bien que le code C les envoie dans l'ordre ci-dessous).
    Un code de terminaison spécial est envoyé pour signaler la fin de la
    liste des attributs optionnels. La liste des codes est la suivante
    :</p>
    <table>
      <tr><td>Information</td><td>Valeur code</td><td>Type de valeur</td><td>Note</td></tr>
      <tr><td>?context</td><td>0x01</td><td>-</td><td>Non implémenté
      actuellement
      </td></tr>
      <tr><td>?servlet_path</td><td>0x02</td><td>-</td><td>Non implémenté
      actuellement
      </td></tr>
      <tr><td>?remote_user</td><td>0x03</td><td>String</td><td></td></tr>
      <tr><td>?auth_type</td><td>0x04</td><td>String</td><td></td></tr>
      <tr><td>?query_string</td><td>0x05</td><td>String</td><td></td></tr>
      <tr><td>?jvm_route</td><td>0x06</td><td>String</td><td></td></tr>
      <tr><td>?ssl_cert</td><td>0x07</td><td>String</td><td></td></tr>
      <tr><td>?ssl_cipher</td><td>0x08</td><td>String</td><td></td></tr>
      <tr><td>?ssl_session</td><td>0x09</td><td>String</td><td></td></tr>
      <tr><td>?req_attribute</td><td>0x0A</td><td>String</td><td>Nom (le
      nom de l'attribut vient ensuite)</td></tr>
      <tr><td>?ssl_key_size</td><td>0x0B</td><td>Integer</td><td></td></tr>
      <tr><td>are_done</td><td>0xFF</td><td>-</td><td>request_terminator</td></tr>
    </table>
    <p><code>context</code> et <code>servlet_path</code> ne sont pas
    définis actuellement par le code C, et la majorité du code Java
    ignore complètement ce qui est envoyé par l'intermédiaire de ces
    champs (il va même parfois s'interrompre si une chaîne est
    envoyée après un de ces codes). Je ne sais pas si c'est une bogue ou
    une fonctionnalité non implémentée, ou tout simplement du code
    obsolète, mais en tout cas, il n'est pris en charge par aucune des
    deux extrémités de la connexion.</p>
    <p><code>remote_user</code> et <code>auth_type</code> concernent
    probablement l'authentification au niveau HTTP, et contiennent le
    nom de l'utilisateur distant ainsi que le type d'authentification
    utilisée pour établir son identité (à savoir Basic, Digest).</p>
    <p><code>query_string</code>, <code>ssl_cert</code>,
    <code>ssl_cipher</code> et <code>ssl_session</code> contiennent les
    éléments HTTP et HTTPS correspondants.</p>
    <p><code>jvm_route</code> est utilisé dans le cadre des sessions
    persistantes, en associant une session utilisateur à une instance
    Tomcat particulière en présence de plusieurs répartiteurs de
    charge.</p>
    <p>Au delà de cette liste de base, tout autre attribut
    supplémentaire peut être envoyé via le code
    <code>req_attribute</code> <code>0x0A</code>. Une paire de chaînes
    représentant le nom et la valeur de l'attribut est envoyée
    immédiatement après chaque instance de ce code. Les variables
    d'environnement sont transmises par cette méthode.</p>
    <p>Enfin, lorsque tous les attributs ont été transmis, le
    terminateur d'attributs, <code>0xFF</code>, est envoyé. Ce dernier
    indique à la fois la fin de la liste d'attributs et la fin du paquet
    de la requête</p>
  </section>
</section>

<section id="resppacketstruct"><title>Structure du paquet de la
réponse</title>
    <p>Pour les messages que le conteneur peut renvoyer au
    serveur.</p>
    <example><pre>
AJP13_SEND_BODY_CHUNK :=
  prefix_code   3
  chunk_length  (integer)
  chunk        *(byte)
  chunk_terminator (byte) Ox00


AJP13_SEND_HEADERS :=
  prefix_code       4
  http_status_code  (integer)
  http_status_msg   (string)
  num_headers       (integer)
  response_headers *(res_header_name header_value)

res_header_name :=
    sc_res_header_name | (string)   [voir ci-dessous pour la manière
    dont ceci est interprété]

sc_res_header_name := 0xA0 (byte)

header_value := (string)

AJP13_END_RESPONSE :=
  prefix_code       5
  reuse             (boolean)


AJP13_GET_BODY_CHUNK :=
  prefix_code       6
  requested_length  (integer)
    </pre></example>
  <section><title>Détails:</title></section>
  <section><title>Envoi d'un tronçon de corps</title>
    <p>Le tronçon se compose essentiellement de données binaires et est
    renvoyé directement au navigateur.</p>
  </section>
  <section><title>Envoi des en-têtes</title>
    <p>Les code et message d'état correspondent aux code et message HTTP
    habituels (par exemple <code>200</code> et <code>OK</code>). Les
    noms d'en-têtes de réponses sont codés de la même façon que les noms
    d'en-têtes de requêtes. Voir ci-dessus le codage des en-têtes pour
    plus de détails à propos de la manière dont les codes se distinguent
    des chaînes.<br />
    Les codes des en-têtes courants sont ::</p>
    <table>
      <tr><td>Nom</td><td>Valeur code</td></tr>
      <tr><td>Content-Type</td><td>0xA001</td></tr>
      <tr><td>Content-Language</td><td>0xA002</td></tr>
      <tr><td>Content-Length</td><td>0xA003</td></tr>
      <tr><td>Date</td><td>0xA004</td></tr>
      <tr><td>Last-Modified</td><td>0xA005</td></tr>
      <tr><td>Location</td><td>0xA006</td></tr>
      <tr><td>Set-Cookie</td><td>0xA007</td></tr>
      <tr><td>Set-Cookie2</td><td>0xA008</td></tr>
      <tr><td>Servlet-Engine</td><td>0xA009</td></tr>
      <tr><td>Status</td><td>0xA00A</td></tr>
      <tr><td>WWW-Authenticate</td><td>0xA00B</td></tr>
    </table>
    <p>La valeur de l'en-tête est codée immédiatement après le code ou
    la chaîne du nom d'en-tête.</p>
  </section>
  <section><title>Fin de la réponse</title>
    <p>Signale la fin de ce cycle de traitement de requête. Si le
    drapeau <code>reuse</code> est à true <code>(toute valeur autre que
    0 en langage C pur)</code>, cette
    connexion TCP peut être réutilisée pour traiter de nouvelles
    requêtes entrantes. Si <code>reuse</code> est à false
    (==0), la connexion sera fermée.</p>
  </section>
  <section><title>Réception d'un tronçon de corps</title>
    <p>Le conteneur réclame la suite des données de la requête (dans le
    cas où la taille du corps était trop importante pour pouvoir être
    contenue dans le premier paquet envoyé, où lorsque la requête est
    fractionnée). Le serveur va alors envoyer un paquet contenant une
    quantité de données correspondant au minimum de la
    <code>request_length</code>, la taille maximale de corps envoyée
    <code>(8186 (8 Koctets - 6))</code>, et le nombre réel d'octets
    restants à envoyer pour ce corps de requête.<br/>
    S'il ne reste plus de données à transmettre pour ce corps de requête
    (c'est à dire si le conteneur de servlets tente de lire au delà de
    la fin du corps), le serveur va renvoyer un paquet <em>vide</em>
    dont la charge utile est de longueur 0 et se présentant sous la
    forme <code>(0x12,0x34,0x00,0x00)</code>.</p>
  </section>
</section>


</modulesynopsis>
