<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1673563 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="windows.xml.meta">
  <parentdocument href="./">Notes spécifiques à un
  système</parentdocument>

  <title>Utilisation du serveur HTTP Apache sous Microsoft Windows</title>

  <summary>

    <p>Ce document décrit l'installation, la configuration et
    l'exécution d'Apache 2.&httpd.minor; sous Microsoft Windows. Si vous avez des
    questions après avoir lu la documentation, ou si vous avez rencontré
    des évènements particuliers ou des rapports d'erreur, vous pouvez
    consultez la <a href="http://httpd.apache.org/userslist.html">liste
    de diffusion de la communauté des utilisateurs</a>.</p>

    <p>Dans ce document, nous supposons que vous installez une
    distribution binaire d'Apache. Si vous voulez compiler Apache
    vous-même (par exemple pour aider au développement ou pour
    rechercher des bogues), référez-vous au document <a
    href="win_compiling.html">Compilation d'Apache pour Microsoft
    Windows</a>.</p>

  </summary>

  <section id="req">
    <title>Prérequis du système d'exploitation</title>

    <p>La plate-forme Windows de base pour l'exécution d'Apache 2.&httpd.minor; est
    Windows 2000 ou supérieur. Veillez à toujours vous procurer et installer le
    dernier service pack afin d'éviter les bogues du système
    d'exploitation.</p>

    <note>Les versions du serveur HTTP Apache supérieures à 2.2 ne
    fonctionneront sous aucun système d'exploitation d'une version
    antérieure à Windows 2000.</note>

  </section>

  <section id="down">
    <title>Téléchargement d'Apache pour Windows</title>

    <p>Le projet du serveur HTTP Apache proprement dit ne fournit pas de
    distribution binaire mais seulement le code source. Certains membres
    du projet <em>peuvent</em> mettre à disposition des paquets binaires
    à titre individuel, mais ceux-ci n'ont pas vocation à être
    distribués publiquement.</p>
    
    <p>Si vous n'êtes
    pas en mesure de compiler le serveur HTTP Apache vous-même, vous
    pouvez vous procurer un paquet binaire auprès des nombreuses
    distributions disponibles sur Internet.</p>

    <p>Quelques solutions populaires pour déployer Apache httpd, et
    éventuellement PHP et MySQL sous Microsoft Windows :</p>
    <ul>
    <li><a href="http://www.apachehaus.com/cgi-bin/download.plx">ApacheHaus</a></li>
    <li><a href="http://www.apachelounge.com/download/">Apache Lounge</a></li>
    <li><a href="http://bitnami.com/stack/wamp">BitNami WAMP Stack</a></li>
    <li><a href="http://www.wampserver.com/">WampServer</a></li>
    <li><a href="http://www.apachefriends.org/en/xampp.html">XAMPP</a></li>
    </ul>
  </section>

  <section id="cust">
    <title>Personnaliser Apache pour Windows</title>

    <p>La configuration d'Apache est enregistrée dans les fichiers du
    sous-répertoire <code>conf</code>. Ce sont les même fichiers que
    ceux utilisés pour configurer la version Unix, mais il y a quelques
    directives spécifiques à Apache pour Windows. Voir l'<a
    href="../mod/directives.html">index des directives</a> pour la liste
    des directives disponibles.</p>

    <p>Les principales spécificités d'Apache pour Windows sont :</p>
    <ul>
      <li><p>Comme Apache pour Windows est un programme multithread, il
      ne lance pas de processus séparé pour chaque requête, comme Apache
      peut le faire sous Unix. En fait, il n'y a en général que deux
      processus Apache en exécution : un processus parent, et un
      processus enfant qui traite les requêtes. Chaque requête est
      traitée par un thread séparé au sein du processus enfant.</p>

      <p>Les directives de gestion de processus diffèrent également :</p>

      <p><directive module="mpm_common">MaxConnectionsPerChild</directive>
      : comme dans la version Unix, cette directive contrôle le nombre
      de connexions qu'un
      processus enfant particulier va traiter avant de s'arrêter.
      Cependant, à la différence d'Unix, un processus de remplacement
      n'est pas instantanément disponible. Utilisez la définition par
      défaut <code>MaxConnectionsPerChild 0</code>, sauf si vous
      risquez de manquer de mémoire dans des modules tiers ou dans des
      applications in-process.</p>

      <note type="warning"><strong>Attention : le fichier de
      configuration du serveur est rechargé lorsqu'un nouveau processus
      enfant est démarré. En conséquence, si vous avez modifié
      <code>httpd.conf</code>, le nouveau processus enfant peut ne pas
      démarrer, ou vous pouvez obtenir des résultats
      inattendus.</strong></note>

      <p><directive module="mpm_common">ThreadsPerChild</directive> : il
      s'agit d'une nouvelle directive. Elle indique au serveur le nombre
      de threads qu'il doit utiliser. Elle définit le nombre maximum de
      connexions simultanées que le serveur peut gérer ; vous devez
      donc vous assurer que ce nombre soit suffisamment grand pour les
      besoins de votre site. La valeur par défaut <code>ThreadsPerChild
      150</code> est recommandée, mais doit être ajustée à la valeur
      maximale estimée de connexions simultanées à accepter.</p></li>

      <li><p>Les directives qui acceptent des noms de fichiers comme
      arguments doivent utiliser des noms de fichiers Windows et non
      Unix. Cependant, comme Apache peut interpréter les anti-slashes
      comme des séquences d'échappement de caractères, vous devez
      absolument utiliser des slashes dans les noms de chemins à la
      place des anti-slashes.</p></li>

      <li><p>Alors que les noms de fichiers sont en général insensibles
      à la casse sous Windows, les URLs sont encore sensibles à la casse
      en interne avant d'être mises en correspondance avec le système de
      fichiers. Par exemple, les directives <directive module="core"
      type="section">Location</directive>, <directive
      module="mod_alias">Alias</directive>, et <directive
      module="mod_proxy">ProxyPass</directive> utilisent toutes des
      arguments sensibles à la casse. Pour cette raison, il est
      particulièrement recommandé d'utiliser la directive <directive
      module="core" type="section">Directory</directive> lorsqu'on
      désire limiter l'accès à certains contenus du système de fichiers,
      car cette directive s'applique à tout contenu d'un répertoire,
      sans tenir compte de la manière dont on y accède. Pour vous
      assurer que seules des minuscules sont utilisées dans les URLs,
      vous pouvez utiliser ceci :</p>

      <highlight language="config">
RewriteEngine On
RewriteMap lowercase int:tolower
RewriteCond "%{REQUEST_URI}" "[A-Z]"
RewriteRule "(.*)" "${lowercase:$1}" [R,L]
      </highlight></li>

      <li><p>Lors de son exécution, Apache n'a besoin d'un accès en
      écriture qu'au répertoire des journaux et à toute arborescence de
      répertoires de cache configurée. Suite au problème d'insensibilité
      à la casse et au format de noms courts 8.3, Apache doit valider
      tous les noms de chemins fournis. Cela signifie que chaque
      répertoire qu'Apache évalue doit avoir les droits en lecture,
      listage et parcours, et ceci depuis la racine jusqu'aux feuilles.
      Si Apache2.&httpd.minor; est installé dans C:\Program Files, le répertoire
      racine, Program Files et Apache2.&httpd.minor; doivent tous être visibles pour
      Apache</p></li>

      <li><p>Apache peut charger divers modules sans qu'il soit nécessaire
      de recompiler le serveur. Si Apache est compilé
      normalement, il va installer de nombreux modules optionnels dans
      le répertoire <code>\Apache2.&httpd.minor;\modules</code>. Pour activer ces
      modules ou d'autres modules, on doit utiliser la
      directive <directive module="mod_so">LoadModule</directive>. Par
      exemple, pour activer le module status, ajoutez la ligne suivante
      (en plus des directives d'activation de status dans
      <code>access.conf</code>) :</p>

      <highlight language="config">
        LoadModule status_module modules/mod_status.so
      </highlight>

      <p>Des informations sont aussi à votre disposition pour <a
      href="../mod/mod_so.html#creating">créer des modules
      chargeables</a></p></li>

      <li><p>Apache peut aussi charger des extensions ISAPI (Internet
      Server Application Programming Interface), comme celles qu'utilise
      Microsoft IIS et d'autres serveurs Windows. <a
      href="../mod/mod_isapi.html">Voir ici pour plus
      d'informations</a>. Notez qu'Apache ne peut <strong>pas</strong>
      charger de filtres ISAPI, et que les gestionnaires ISAPI contenant
      des extensions de fonctionnalités Microsoft ne fonctionneront
      pas.</p></li>

      <li><p>Pour les scripts CGI, la méthode qu'utilise Apache pour
      déterminer l'interpréteur du script est configurable grâce à la
      directive <directive
      module="core">ScriptInterpreterSource</directive></p></li>

      <li><p>Comme il est souvent difficile de gérer des fichiers avec
      des noms du style <code>.htaccess</code> sous Windows, vous avez
      tout intérêt à changer le nom de ce fichier de configuration par
      répertoire à l'aide de la directive <directive
      module="core">AccessFilename</directive>.</p></li>

      <li><p>Toute erreur survenant au cours du processus de démarrage
      d'Apache est enregistrée dans le journal des évènements de
      Windows si l'on est sous Windows NT. Ce mécanisme fonctionne comme
      une sauvegarde pour les situations où Apache n'est pas encore prêt
      à utiliser le fichier <code>error.log</code>. Vous pouvez
      consulter le journal des évènements applicatifs Windows en
      utilisant l'observateur d'évènements : Démarrage - Paramètres -
      Panneau de configuration - Outils d'administration - Observateur
      d'évènements.</p></li>
    </ul>

  </section>

  <section id="winsvc">
    <title>Exécuter Apache en tant que service</title>

    <p>Apache fournit un utilitaire nommé Apache Service Monitor
    (Moniteur du service Apache). Grâce à lui, vous pouvez voir et gérer
    l'état de tous les services Apache installés sur toutes les machines
    du réseau. Pour pouvoir gérer un service Apache avec le moniteur,
    vous devez d'abord installer le service (soit automatiquement au
    cours de l'installation, soit manuellement).</p>

    <p>Vous pouvez installer Apache en tant que service Windows NT à
    partir de la ligne de commandes et depuis le sous-répertoire Apache
    <code>bin</code> comme suit :</p>

    <example>
      httpd.exe -k install
    </example>

    <p>Si vous avez installé plusieurs services Apache sur votre
    ordinateur, vous devrez spécifier le nom du service que vous voulez
    installer en utilisant la commande suivante (notez que si vous
    spécifiez un nom durant l'installation, vous devrez aussi le
    spécifier pour toute opération comportant l'option -k) :</p>

    <example>
      httpd.exe -k install -n "Nom-service"
    </example>

    <p>Si un service doit utiliser un fichier de configuration
    spécifique, utilisez ceci :</p>

    <example>
      httpd.exe -k install -n "Nom-service" -f "c:\fichiers\Nom-service.conf"
    </example>

    <p>Si vous utilisez la première commande sans paramètre particulier,
    excepté <code>-k install</code>, le service aura pour nom
    <code>Apache2.&httpd.minor;</code> et le fichier de configuration sera censé
    être <code>conf\httpd.conf</code>.</p>

    <p>Supprimer un service Apache est très simple. Utilisez
    simplement :</p>

    <example>
      httpd.exe -k uninstall
    </example>

    <p>On peut spécifier un service Apache particulier en utilisant
    :</p>

    <example>
      httpd.exe -k uninstall -n "Nom service"
    </example>

    <p>Normalement, le démarrage, le redémarrage et l'arrêt d'un
    service Apache s'effectuent via le Moniteur de Service Apache, ou en
    utilisant des commandes telles que <code>NET START Apache2.&httpd.minor;</code> et
    <code>NET STOP Apache2.&httpd.minor;</code>, ou encore via le gestionnaire de
    services standard de Windows. Avant de démarrer Apache en tant que
    service dans quelque but que ce soit, vous devez tester le fichier
    de configuration du service en utilisant :</p>

    <example>
      httpd.exe -n "Nom-service" -t
    </example>

    <p>Vous pouvez aussi contrôler un service Apache à l'aide de ses
    options de ligne de commande. Avec cette méthode, pour démarrer un
    service Apache installé, vous utiliserez :</p>

    <example>
      httpd.exe -k start -n "Nom-Service"
    </example>

    <p>Pour arrêter un service Apache via les options de lignes de
    commande, utilisez ceci :</p>

    <example>
      httpd.exe -k stop -n "Nom-Service"
    </example>

    <p>ou</p>

    <example>
      httpd.exe -k shutdown -n "Nom-Service"
    </example>

    <p>Vous pouvez aussi redémarrer un service en exécution et le forcer
    à relire son fichier de configuration en utilisant :</p>

    <example>
      httpd.exe -k restart -n "Nom-Service"
    </example>

    <p>Par défaut, tous les services Apache sont configurés pour
    s'exécuter sous l'utilisateur system (le compte
    <code>LocalSystem</code>). Le compte <code>LocalSystem</code> n'a
    pas de privilèges sur votre réseau, que ce soit via un mécanisme
    sécurisé de Windows, y compris le système de fichiers, des tubes
    nommés, DCOM ou des RPC sécurisés. Il a cependant des privilèges
    élevés en local.</p>

    <note type="warning"><strong>N'accordez jamais de privilèges réseau
    au compte <code>LocalSystem</code> ! Si Apache doit pouvoir accéder
    à des ressources réseau, créez un compte séparé pour Apache comme
    indiqué ci-dessous.</strong></note>

    <p>Il est fortement fortement conseillé aux utilisateurs de créer un
    compte séparé pour exécuter le(s) service(s) Apache, et même
    obligatoire si vous devez accéder à des ressources réseau via
    Apache.</p>

    <ol>
      <li>Créez un compte d'utilisateur du domaine normal, et
      assurez-vous de retenir son mot de passe.</li>

      <li>Accordez à l'utilisateur nouvellement créé les privilèges
      <code>Log on as a service</code> et <code>Act as part of the
      operating system</code>. Sous Windows NT 4.0, ces privilèges sont
      accordés via le Gestionnaire des utilisateurs du Domaine, mais
      sous Windows 2000 et XP, vous aurez plutôt intérêt à utiliser une
      GPO pour propager ces configurations. Vous pouvez aussi effectuer
      ces réglages via la Politique de Sécurité Locale intégrée à la
      MMC.</li>

      <li>Vérifiez que le compte nouvellement créé est membre du groupe
      Utilisateurs</li>

      <li>Accordez à ce compte les droits Lecture et Exécution (RX) sur
      tous les documents et répertoires de scripts (<code>htdocs</code>
      et <code>cgi-bin</code> par exemple), et aussi sur l'exécutable
      binaire <code>httpd.exe</code>.</li>

      <li>Accordez aussi à ce compte les droits de modification sur le
      répertoire <code>logs</code>.</li>

    </ol>

    <note>Il est en général de bonne pratique d'accorder à l'utilisateur
    sous lequel le service Apache s'exécute les droits en lecture et
    exécution (RX) sur l'ensemble du répertoire Apache2.&httpd.minor;, sauf pour le
    sous-répertoire <code>logs</code>, sur lequel l'utilisateur doit
    avoir au moins les droits de modification (RWXD).</note>

    <p>Si vous permettez à ce compte de se connecter en tant
    qu'utilisateur et service, vous pouvez ouvrir une session sous ce
    compte et vérifier s'il a bien le droit d'exécuter les scripts, de
    lire les pages web, et si vous pouvez démarrer Apache à partir d'une
    console Windows. Si tout fonctionne, et si vous avez suivi les
    étapes ci-dessus, Apache devrait s'exécuter en tant que service sans
    problème.</p>

    <note><strong>Le code d'erreur 2186</strong> indique probablement
    qu'Apache ne peut pas accéder à une ressource réseau nécessaire, et
    que vous devez revoir la configuration "Log On As" (Se connecter en
    tant que ...) du service.</note>

    <p>Lorsqu'Apache démarre en tant que service, il se peut que vous
    obteniez un message d'erreur du Gestionnaire de Services Windows.
    Par exemple, si vous essayez de démarrer Apache en utilisant
    l'applet Services du Panneau de configuration de Windows, vous
    pouvez obtenir le message suivant :</p>

    <example>
      Could not start the Apache2.&httpd.minor; service on \\COMPUTER <br />
      Error 1067; The process terminated unexpectedly.
    </example>

    <p>Vous obtiendrez cette erreur à caractère général pour tout
    problème survenant au cours du démarrage du service Apache. Afin de
    déterminer exactement la cause du problème, vous devez suivre les
    instructions permettant d'exécuter Apache pour Windows depuis la
    ligne de commande.</p>

    <p>Si vous rencontrez des problèmes avec le service, il est
    conseillé de suivre les instructions ci-dessous afin d'essayer de
    démarrer httpd.exe depuis une console, et d'analyser les erreurs
    plutôt que vous démener à essayer de démarrer le service.</p>

  </section>

  <section id="wincons">
    <title>Exécuter Apache depuis la console</title>

    <p>Il est en général recommandé d'exécuter Apache en tant que
    service, mais il est parfois plus simple d'utiliser la ligne de
    commande, en particulier au cours de la configuration initiale et
    les tests.</p>

    <p>Pour exécuter Apache depuis la ligne de commande et en tant
    qu'application de console, utilisez la commande suivante :</p>

    <example>
      httpd.exe
    </example>

    <p>Apache va démarrer, et continuera son exécution jusqu'à ce qu'on
    l'arrête en tapant Ctrl-C.</p>

    <p>Vous pouvez également démarrer Apache via le raccourci "Démarrer
    Apache dans une console" placé dans <code>Démarrer --&gt;
    Programmes --&gt; Apache HTTP Server 2.&httpd.minor;.xx --&gt; Control Apache
    Server</code> au cours de l'installation. Ceci va
    ouvrir une console Windows, et y démarrer Apache.
    Si vous n'avez pas installé Apache en tant que service, la
    fenêtre Windows restera ouverte jusqu'à ce que vous arrêtiez Apache
    en tapant Ctrl-C dans cette fenêtre. Le serveur va alors s'arrêter
    au bout de quelques secondes. Cependant, si vous avez installé
    Apache en tant que service, c'est ce dernier que le raccourci
    ci-dessus va lancer. Si le service Apache est déjà en cours
    d'exécution, le raccourci va rester sans effet.</p>

    <p>Si Apache s'exécute en tant que service, vous pouvez l'arrêter en
    ouvrant une autre console et en entrant :</p>

    <example>
      httpd.exe -k shutdown
    </example>

    <p>Plutôt que de lancer Apache à partir d'une console, il est
    préférable de l'exécuter en tant que service car dans ce cas, il
    termine proprement les opérations en cours avant de s'éteindre.</p>

    <p>Si le serveur a été lancé depuis une console, vous ne pouvez
    l'arrêter qu'en pressant la combinaison de touches Ctrl-C dans la
    même fenêtre.</p>

    <p>Vous pouvez aussi redémarrer Apache. Ceci le force à recharger
    son fichier de configuration. Toute opération en cours peut être
    achevée sans interruption. Pour redémarrer Apache, vous pouvez soit
    taper Control-Break dans la fenêtre de console que vous avez
    utilisée pour le démarrer, soit entrer :</p>

    <example>
      httpd.exe -k restart
    </example>

    <p>si le serveur s'exécute en tant que service.</p>

    <note>Note pour les utilisateurs familiers de la version Unix
    d'Apache : les commandes ci-dessus représentent pour Windows
    l'équivalent des commandes <code>kill -TERM <em>pid</em></code> et
    <code>kill -USR1 <em>pid</em></code>. L'option de ligne de commande
    <code>-k</code> a été choisie à titre de rapprochement avec la
    commande <code>kill</code> utilisée sous Unix.</note>

    <p>Si la fenêtre de la console Apache se ferme immédiatement ou
    inopinément après le démarrage d'Apache, ouvrez une console Windows
    depuis le menu Démarrer --&gt; Programmes. Placez-vous dans le
    répertoire d'installation d'Apache, tapez la commande
    <code>httpd.exe</code>, et observez le message d'erreur. Allez
    ensuite dans le répertoire des journaux, et visualisez le fichier
    <code>error.log</code> pour détecter d'éventuelles erreurs de
    configuration. Si Apache a été installé dans <code>C:\Program
    Files\Apache Software Foundation\Apache2.&httpd.minor;\</code>, vous
    pouvez entrer ce qui suit :</p>

    <example>
      c: <br />
      cd "\Program Files\Apache Software Foundation\Apache2.&httpd.minor;\bin" <br />
      httpd.exe
    </example>

    <p>Attendez ensuite qu'Apache s'arrête ou tapez Ctrl-C. Entrez alors
    la commande suivante :</p>

    <example>
      cd ..\logs <br />
      more &lt; error.log
    </example>

    <p>Lorsqu'on travaille avec Apache, il est important de comprendre
    comment ce dernier trouve son fichier de configuration. Vous pouvez
    spécifier un fichier de configuration à partir de la ligne de
    commande de deux façons :</p>

    <ul>
      <li><p>L'option <code>-f</code> permet de spécifier un chemin
      absolu ou relatif vers un fichier de configuration particulier
      :</p>(sous Windows 9x, il est recommandé d'utiliser la ligne de
    commande à cause du manque de fiabilité du support des services
    fourni par ce système).

      <example>
        httpd.exe -f "c:\fichiers-de-mon-serveur\autre-config.conf"
      </example>

      <p>ou</p>

      <example>
        httpd.exe -f fichiers-de-mon-serveur\autre-config.conf
      </example></li>

      <li><p>L'option <code>-n</code> permet de spécifier le service
      Apache installé dont le fichier de configuration doit être utilisé
      :</p>

      <example>
        httpd.exe -n "Nom-service"
      </example>
      </li>
    </ul>

    <p>Dans les deux cas, la directive <directive
    module="core">ServerRoot</directive> doit être correctement définie
    dans le fichier de configuration.</p>

    <p>Si vous ne spécifiez aucun fichier de configuration à l'aide des
    options <code>-f</code> ou <code>-n</code>, Apache utilisera le nom
    du fichier de configuration compilé dans le serveur, en général
    <code>conf\httpd.conf</code>. Ce chemin codé en dur est relatif au
    répertoire d'installation. Vous pouvez vérifier ce chemin à partir
    de la valeur de l'étiquette <code>SERVER_CONFIG_FILE</code> en
    invoquant Apache avec l'option <code>-V</code>, comme ceci :</p>

    <example>
      httpd.exe -V
    </example>

    <p>Apache va ensuite essayer de déterminer la valeur de son
    <directive module="core">ServerRoot</directive> en effectuant les
    recherches suivantes, dans cet ordre :</p>

    <ol>
      <li>Une directive <directive module="core">ServerRoot</directive>
      via l'option de ligne de commande <code>-C</code>.</li>

      <li>L'option de ligne de commande <code>-d</code>.</li>

      <li>Le répertoire de travail courant.</li>

      <li>Une entrée de la base de registre créée dans le cas d'une
      installation binaire.</li>

      <li>La racine des documents (<code>DocumentRoot</code>) codée en dur
      dans le serveur. Elle
      correspond par défaut à <code>/apache</code>, et vous pouvez le
      vérifier en tapant <code>httpd.exe -V</code> et en recherchant
      l'étiquette <code>HTTPD_ROOT</code>.</li>
    </ol>

    <p>Si vous n'avez pas effectué d'installation binaire, dans certains
    scénarios, Apache va signaler l'absence de cette clé de registre.
    On peut passer outre cet avertissement si le serveur a été en mesure
    de trouver son fichier de configuration d'une autre manière.</p>

    <p>La valeur de cette clé correspond au répertoire <directive
    module="core">ServerRoot</directive> qui contient lui-même le
    sous-répertoire <code>conf</code>. Lors de son démarrage, Apache lit
    le fichier <code>httpd.conf</code> à partir de ce répertoire. Si ce
    fichier contient une directive <directive
    module="core">ServerRoot</directive> qui spécifie un répertoire
    différent de celui que contient la clé de registre ci-dessus, Apache
    oubliera la clé de registre, et utilisera le répertoire spécifié par
    le fichier de configuration. Si vous déplacez le répertoire Apache
    ou ses fichiers de configuration, il est vital de mettre à jour la
    directive <directive module="core">ServerRoot</directive> dans
    <code>httpd.conf</code> afin de refléter la nouvelle
    localisation.</p>

  </section>

  <section id="test">
    <title>Vérification de l'installation</title>

    <p>Une fois Apache démarré (soit à partir d'une console Windows,
    soit en tant que service), ce dernier va se mettre à l'écoute sur
    le port 80 (à moins que vous ayiez modifié la directive <directive
    module="mpm_common">Listen</directive> dans les fichiers de
    configuration ou que vous ayiez installé Apache pour l'utilisateur
    courant seulement). Pour vous connecter au serveur et accéder à la
    page par défaut, lancez un navigateur et entrez cette URL :</p>

    <example>
      http://localhost/
    </example>

    <p>Apache devrait renvoyer une page de bienvenue et vous devriez
    voir s'afficher "It Works!". Si rien ne se passe ou si vous obtenez
    une erreur, consultez le fichier <code>error.log</code> dans le
    sous-répertoire <code>logs</code>. Si votre serveur n'est pas
    connecté au réseau, ou si vous avez de sérieux problèmes avec la
    configuration de votre DNS (Domain Name Service), vous devez
    utiliser cette URL :</p>

    <example>
      http://127.0.0.1/
    </example>

    <p>Si Apache écoute un port non standard, vous devez le préciser
    explicitement dans l'URL :</p>

    <example>
      http://127.0.0.1:8080/
    </example>

    <p>Après que votre installation de base fonctionne, vous devez la
    configurer correctement en éditant les fichiers du sous-répertoire
    <code>conf</code>. Encore une fois, si vous modifiez la
    configuration du service Apache sous Windows NT, essayez d'abord de
    redémarrer le service depuis la ligne de commande afin de vous
    assurer de l'absence d'erreur.</p>

    <p>Comme Apache <strong>ne peut pas</strong> partager le même port
    avec d'autres applications TCP/IP, il se peut que vous soyez amené à
    arrêter, désinstaller ou reconfigurer certains services avant de
    démarrer Apache. Ces services entrant en conflit avec Apache
    comprennent les autres serveurs WWW, certaines implémentations de
    pare-feu, et même certaines applications client (comme Skype) qui
    utilisent le port 80 afin de contourner les pare-feu.</p>

  </section>

  <section id="windrivemap">
    <title>Configuration de l'accès aux ressources réseau</title>

  <p>L'accès à des fichiers par le réseau peut être spécifié via deux
  mécanismes fournis par Windows :</p>

  <dl>
    <dt>Association de lettres de lecteur</dt>
    <dd>Par exemple, <code>Alias "/images/" "Z:/"</code></dd>

    <dt>chemins UNC</dt>
    <dd>Par exemple, <code>Alias "/images/" "//imagehost/www/images/"</code></dd>
  </dl>

  <p>L'association de lettres de lecteur permet à l'administrateur de
  maintenir une correspondance avec une certaine machine et un certain
  chemin en dehors de la configuration d'Apache httpd. Cependant, ces
  associations ne sont possibles que dans le cadre des sessions
  interactives, et ne sont pas directement disponibles pour Apache httpd
  lorsqu'il est démarré en tant que service. <strong>N'utilisez par
  conséquent que des
  chemins UNC pour les ressources réseau dans httpd.conf,</strong> de
  façon à ce que les ressources soient accessibles quelle que soit la
  manière dont Apache httpd a été démarré (des procédures exotiques et
  probablement sujettes aux erreurs peuvent permettre de contourner la
  restriction due aux associations de lettres de lecteur, mais leur
  utilisation est déconseillée).</p>

  <example><title>Exemple de DocumentRoot avec chemin UNC</title>
  <highlight language="config">
  DocumentRoot "//dochost/www/html/"
  </highlight>
  </example>

  <example><title>Exemple de DocumentRoot avec adresse IP dans le chemin UNC</title>
  <highlight language="config">
  DocumentRoot "//192.168.1.50/docs/"
  </highlight>
  </example>

  <example><title>Exemple d'Alias et répertoire correspondant avec
  chemin UNC</title>
  <highlight language="config">
Alias "/images/" "//imagehost/www/images/"

&lt;Directory "//imagehost/www/images/"&gt;
#...
&lt;Directory&gt;
  </highlight>
  </example>

  <p>Lorsqu'Apache s'exécute en tant que service, vous devez créer un
  compte spécifique afin de pouvoir accéder aux ressources réseau, comme
  décrit ci-dessus.</p>
  </section>

  <section id="tuning">
    <title>Personnalisation sous Windows</title>
    <ul>
      <li><p>Si on utilise un grand nombre de redirections de journaux
      via des pipes, il est souvent nécessaire d'augmenter la
      taille de la mémoire du bureau ("desktop heap"). Pour une information plus
      détaillée, veuillez vous reporter à la documentation sur les <a
      href="../logs.html#piped">redirections de journaux</a>.</p></li>
    </ul>
  </section>

</manualpage>
