<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision: 1741864 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="urlmapping.xml.meta">

  <title> Mise en correspondance des URLs avec le système de fichiers</title>

  <summary>
    <p>Ce document explique comment le serveur HTTP Apache utilise l'URL contenue dans une
    requête pour déterminer le noeud du système de fichier à partir duquel le
    fichier devra être servi.</p>
  </summary>

<section id="related"><title>Modules et directives concernés</title>

<related>
<modulelist>
<module>mod_actions</module>
<module>mod_alias</module>
<module>mod_autoindex</module>
<module>mod_dir</module>
<module>mod_imagemap</module>
<module>mod_negotiation</module>
<module>mod_proxy</module>
<module>mod_rewrite</module>
<module>mod_speling</module>
<module>mod_userdir</module>
<module>mod_vhost_alias</module>
</modulelist>
<directivelist>
<directive module="mod_alias">Alias</directive>
<directive module="mod_alias">AliasMatch</directive>
<directive module="mod_speling">CheckSpelling</directive>
<directive module="mod_dir">DirectoryIndex</directive>
<directive module="core">DocumentRoot</directive>
<directive module="core">ErrorDocument</directive>
<directive module="core">Options</directive>
<directive module="mod_proxy">ProxyPass</directive>
<directive module="mod_proxy">ProxyPassReverse</directive>
<directive module="mod_proxy">ProxyPassReverseCookieDomain</directive>
<directive module="mod_proxy">ProxyPassReverseCookiePath</directive>
<directive module="mod_alias">Redirect</directive>
<directive module="mod_alias">RedirectMatch</directive>
<directive module="mod_rewrite">RewriteCond</directive>
<directive module="mod_rewrite">RewriteRule</directive>
<directive module="mod_alias">ScriptAlias</directive>
<directive module="mod_alias">ScriptAliasMatch</directive>
<directive module="mod_userdir">UserDir</directive>
</directivelist>
</related>
</section>

<section id="documentroot"><title>Racine des documents (DocumentRoot)</title>

    <p>La méthode par défaut de httpd pour déterminer quel fichier servir pour
    une requête donnée, consiste à extraire le chemin du fichier de la requête
    (la partie de l'URL qui suit le nom d'hôte et le port), puis de l'ajouter
    à la fin de la valeur de la directive
    <directive module="core">DocumentRoot</directive> définie dans vos fichiers
    de configuration.
    Ainsi, les fichiers et répertoires
    situés en dessous de <directive module="core">DocumentRoot</directive>
    constituent l'arborescence de base des documents qui seront visibles
    depuis le web.</p>

    <p>Par exemple, si la directive
    <directive module="core">DocumentRoot</directive> contient
    <code>/var/www/html</code>, une requête pour
    <code>http://www.example.com/fish/guppies.html</code> retournera le
    fichier <code>/var/www/html/fish/guppies.html</code> au client.</p>

    <p>Si la requête concerne un répertoire (autrement dit un chemin se
    terminant par un slash <code>/</code>), le nom du fichier qui sera
    recherché et servi depuis ce répertoire est défini via la directive
    <directive module="mod_dir">DirectoryIndex</directive>. Par exemple,
    supposons que <code>DocumentRoot</code> ait été définie comme
    précédemment, et que vous ayez défini <code>DirectoryIndex</code>
    comme suit :</p>

    <example>DirectoryIndex index.html index.php</example>

    <p>Si httpd reçoit alors une requête pour
    <code>http://www.example.com/fish/</code>, il tentera de servir le
    fichier <code>/var/www/html/fish/index.html</code>. Si ce fichier
    n'existe pas, il tentera de servir le fichier
    <code>/var/www/html/fish/index.php</code>.</p>

    <p>Si aucun de ces fichiers existe, httpd tentera de générer et
    d'afficher un index du répertoire, à condition que
    <module>mod_autoindex</module> ait été chargé et configuré pour le
    permettre.</p>

    <p>httpd supporte aussi les <a href="vhosts/">Hôtes virtuels</a>,
    ce qui lui permet de traiter des requêtes pour plusieurs hôtes.
    Dans ce cas, un <directive module="core">DocumentRoot</directive>
    différent peut être défini pour chaque hôte virtuel;
    les directives fournies par le module
    <module>mod_vhost_alias</module> peuvent aussi être utilisées afin de
    déterminer dynamiquement le noeud approprié du système de fichiers
    à partir duquel servir un contenu en fonction de l'adresse IP
    ou du nom d'hôte.</p>

    <p>La directive <directive module="core">DocumentRoot</directive>  est
    définie dans le fichier de configuration de votre serveur principal
    (<code>httpd.conf</code>), mais peut aussi être redéfinie pour chaque
    <a href="vhosts/">Hôte virtuel</a> supplémentaire que vous avez créé.</p>
</section>

<section id="outside"><title>Fichiers situés en dehors de
l'arborescence DocumentRoot</title>

    <p>Il existe de nombreuses circonstances pour lesquelles il est nécessaire
    d'autoriser l'accès web à des portions du système de fichiers qui ne se
    trouvent pas dans l'arborescence <directive
    module="core">DocumentRoot</directive>.  httpd propose de nombreuses
    solutions pour réaliser cela. Sur les systèmes Unix, les liens
    symboliques permettent de rattacher d'autres portions du système de
    fichiers au <directive
    module="core">DocumentRoot</directive>. Pour des raisons de sécurité,
    httpd ne suivra les liens symboliques que si les <directive
    module="core">Options</directive> pour le répertoire concerné contiennent
    <code>FollowSymLinks</code> ou <code>SymLinksIfOwnerMatch</code>.</p>

    <p>Une autre méthode consiste à utiliser la directive <directive
    module="mod_alias">Alias</directive> pour rattacher toute portion
    du système de fichiers à l'arborescence du site web. Par exemple, avec</p>

<highlight language="config">Alias "/docs" "/var/web"</highlight>

    <p>l'URL <code>http://www.example.com/docs/dir/file.html</code>
    correspondra au fichier <code>/var/web/dir/file.html</code>. La
    directive
    <directive module="mod_alias">ScriptAlias</directive>
    fonctionne de la même manière, excepté que tout contenu localisé dans le
    chemin cible sera traité comme un script <glossary ref="cgi"
    >CGI</glossary>.</p>

    <p>Pour les situations qui nécessitent plus de flexibilité, vous disposez
    des directives <directive module="mod_alias">AliasMatch</directive>
    et <directive module="mod_alias">ScriptAliasMatch</directive>
    qui permettent des substitutions et comparaisons puissantes basées
    sur les <glossary ref="regex">expressions rationnelles</glossary>.
    Par exemple,</p>

<highlight language="config">
    ScriptAliasMatch "^/~([a-zA-Z0-9]+)/cgi-bin/(.+)" "/home/$1/cgi-bin/$2"
    </highlight>

    <p>fera correspondre une requête du style
    <code>http://example.com/~user/cgi-bin/script.cgi</code> au chemin
    <code>/home/user/cgi-bin/script.cgi</code>, et traitera le fichier résultant
    comme un script CGI.</p>
</section>

<section id="user"><title>Répertoires des utilisateurs</title>

    <p>Sur les systèmes Unix, on peut traditionnellement faire référence
    au répertoire personnel d'un <em>utilisateur</em> particulier à l'aide de
    l'expression <code>~user/</code>.
    Le module <module>mod_userdir</module>
    étend cette idée au web en autorisant l'accès aux fichiers situés dans les
    répertoires home des utilisateurs à l'aide d'URLs
    comme dans ce qui suit :</p>

<example>http://www.example.com/~user/file.html</example>

    <p>Pour des raisons de sécurité, il est déconseillé de permettre un accès
    direct à un répertoire home d'utilisateur depuis le web. A cet effet, la
    directive <directive module="mod_userdir">UserDir</directive>
    spécifie un répertoire où sont situés les fichiers accessibles depuis le web
    dans le répertoire home de l'utilisateur.
    Avec la configuration par défaut
    <code>Userdir public_html</code>, l'URL ci-dessus correspondra à un fichier
    dont le chemin sera du style
    <code>/home/user/public_html/file.html</code> où
    <code>/home/user/</code> est le répertoire home de l'utilisateur tel qu'il
    est défini dans <code>/etc/passwd</code>.</p>

    <p>La directive <code>Userdir</code> met à votre disposition de nombreuses
    formes différentes pour les systèmes où <code>/etc/passwd</code> ne
    spécifie pas la localisation du répertoire home.</p>

    <p>Certains jugent le symbole "~" (dont le code sur le web est souvent
    <code>%7e</code>) inapproprié et préfèrent utiliser une chaîne de
    caractères différente pour représenter les répertoires utilisateurs.
    mod_userdir ne supporte pas cette fonctionnalité. Cependant, si les
    répertoires home des utilisateurs sont structurés de manière rationnelle,
    il est possible d'utiliser la directive
    <directive module="mod_alias">AliasMatch</directive>
    pour obtenir l'effet désiré. Par exemple, pour faire correspondre
    <code>http://www.example.com/upages/user/file.html</code> à
    <code>/home/user/public_html/file.html</code>, utilisez la directive
    <code>AliasMatch</code> suivante :</p>

<highlight language="config">
    AliasMatch "^/upages/([a-zA-Z0-9]+)(/(.*))?$"   "/home/$1/public_html/$3"
    </highlight>
</section>

<section id="redirect"><title>Redirection d'URL</title>

    <p>Les directives de configuration décrites dans les sections précédentes
    demandent à httpd d'extraire un contenu depuis un emplacement spécifique
    du système de fichiers
    et de la retourner au client. Il est cependant parfois
    souhaitable d'informer le
    client que le contenu demandé est localisé à une URL différente, et de
    demander au client d'élaborer une nouvelle requête avec la nouvelle URL.
    Ce processus se nomme <em>redirection</em> et est implémenté par la
    directive <directive module="mod_alias">Redirect</directive>.
    Par exemple, si le contenu du répertoire <code>/foo/</code> sous
    <directive module="core">DocumentRoot</directive> est déplacé vers le
    nouveau répertoire <code>/bar/</code>, vous pouvez demander aux clients
    de le requérir à sa nouvelle localisation comme suit :</p>

<highlight language="config">
    Redirect permanent "/foo/"   "http://www.example.com/bar/"
    </highlight>

    <p>Ceci aura pour effet de rediriger tout chemin d'URL commençant par
    <code>/foo/</code> vers le même chemin d'URL sur le serveur
    <code>www.example.com</code> en remplaçant <code>/foo/</code> par
    <code>/bar/</code>. Vous pouvez rediriger les clients non seulement sur le
    serveur d'origine, mais aussi vers n'importe quel autre serveur.</p>

    <p>httpd propose aussi la directive <directive
    module="mod_alias">RedirectMatch</directive> pour traiter les problèmes
    de réécriture d'une plus grande complexité. Par exemple, afin de rediriger
    les requêtes pour la page d'accueil du site vers un site différent, mais
    laisser toutes les autres requêtes inchangées, utilisez la
    configuration suivante :</p>

<highlight language="config">
   RedirectMatch permanent "^/$"    "http://www.example.com/startpage.html"
    </highlight>

    <p>De même, pour rediriger temporairement toutes les pages d'un site
    vers une page particulière d'un autre site, utilisez ce qui suit :</p>

<highlight language="config">
    RedirectMatch temp ".*"  "http://othersite.example.com/startpage.html"
    </highlight>
</section>

<section id="proxy"><title>Mandataire inverse (Reverse Proxy)</title>

<p>httpd vous permet aussi de rapatrier des documents distants
dans l'espace des URL du serveur local.
Cette technique est appelée <em>mandataire inverse ou reverse
proxying</em> car le serveur web agit comme un serveur mandataire en
rapatriant les documents depuis un serveur distant puis les renvoyant
au client. Ceci diffère d'un service de mandataire usuel (direct) car, pour le client,
les documents semblent appartenir au serveur mandataire inverse.</p>

<p>Dans l'exemple suivant, quand les clients demandent des documents situés
dans le répertoire
<code>/foo/</code>, le serveur rapatrie ces documents depuis le répertoire
<code>/bar/</code> sur <code>internal.example.com</code>
et les renvoie au client comme s'ils appartenaient au serveur local.</p>

<highlight language="config">
ProxyPass "/foo/" "http://internal.example.com/bar/"
ProxyPassReverse "/foo/" "http://internal.example.com/bar/"
ProxyPassReverseCookieDomain internal.example.com public.example.com
ProxyPassReverseCookiePath "/foo/" "/bar/"
</highlight>

<p>La directive <directive module="mod_proxy">ProxyPass</directive> configure
le serveur pour rapatrier les documents appropriés, alors que la directive
<directive module="mod_proxy">ProxyPassReverse</directive>
réécrit les redirections provenant de
<code>internal.example.com</code> de telle manière qu'elles ciblent le
répertoire approprié sur le serveur local. De manière similaire, les directives
<directive module="mod_proxy">ProxyPassReverseCookieDomain</directive>
et <directive module="mod_proxy">ProxyPassReverseCookiePath</directive>
réécrivent les cookies élaborés par le serveur d'arrière-plan.</p>
<p>Il est important de noter cependant, que les liens situés dans les documents
ne seront pas réécrits.  Ainsi, tout lien absolu sur
<code>internal.example.com</code> fera décrocher le client
du serveur mandataire et effectuer sa requête directement sur
<code>internal.example.com</code>. Vous pouvez modifier ces liens (et
d'utres contenus) situés dans la page au moment où elle est envoyée au
client en utilisant le module <module>mod_substitute</module>.</p>

<highlight language="config">
Substitute "s/internal\.example\.com/www.example.com/i"
</highlight>

<p>Le module <module>mod_proxy_html</module> rend possible une réécriture plus
élaborée des liens en HTML et XHTML. Il permet de créer des listes
d'URLs et de leurs réécritures, de façon à pouvoir gérer des scénarios
de réécriture complexes.</p>
</section>

<section id="rewrite"><title>Moteur de réécriture</title>

    <p>Le moteur de réécriture <module>mod_rewrite</module> peut s'avérer
    utile lorsqu'une substitution plus puissante est nécessaire.
    Les directives fournies par ce module peuvent utiliser des caractéristiques de la
    requête comme le type de navigateur ou l'adresse IP source afin de décider
    depuis où servir le contenu. En outre, mod_rewrite peut utiliser des
    fichiers ou programmes de bases de données externes pour déterminer comment
    traiter une requête. Le moteur de réécriture peut effectuer les trois types
    de mise en correspondance discutés plus haut :
    redirections internes (aliases), redirections externes, et services mandataires.
    De nombreux exemples pratiques utilisant mod_rewrite sont discutés dans la
    <a href="rewrite/">documentation détaillée de mod_rewrite</a>.</p>
</section>

<section id="notfound"><title>Fichier non trouvé (File Not Found)</title>

    <p>Inévitablement, apparaîtront des URLs qui ne correspondront à aucun
    fichier du système de fichiers.
    Ceci peut arriver pour de nombreuses raisons.
    Il peut s'agir du déplacement de documents d'une
    localisation vers une autre. Dans ce cas, le mieux est d'utiliser la
    <a href="#redirect">redirection d'URL</a> pour informer les clients de la
    nouvelle localisation de la ressource. De cette façon, vous êtes sur que
    les anciens signets et liens continueront de fonctionner, même si la
    ressource est déplacée.</p>

    <p>Une autre cause fréquente d'erreurs "File Not Found" est l'erreur de
    frappe accidentelle dans les URLs, soit directement dans le navigateur,
    soit dans les liens HTML. httpd propose le module
    <module>mod_speling</module> (sic) pour tenter de résoudre ce problème.
    Lorsque ce module est activé, il intercepte les erreurs
    "File Not Found" et recherche une ressource possédant un nom de fichier
    similaire. Si un tel fichier est trouvé, mod_speling va envoyer une
    redirection HTTP au client pour lui communiquer l'URL correcte.
    Si plusieurs fichiers proches sont trouvés, une liste des alternatives
    possibles sera présentée au client.</p>

    <p>mod_speling possède une fonctionnalité particulièrement utile :
    il compare les noms de fichiers sans tenir compte de la casse.
    Ceci peut aider les systèmes où les utilisateurs ne connaissent pas la
    sensibilité des URLs à la casse et bien sûr les systèmes de fichiers unix.
    Mais l'utilisation de mod_speling pour toute autre chose que la correction
    occasionnelle d'URLs peut augmenter la charge du serveur, car chaque
    requête "incorrecte" entraîne une redirection d'URL et une nouvelle requête
    de la part du client.</p>

    <p><module>mod_dir</module> fournit la directive <directive
    module="mod_dir">FallbackResource</directive> qui permet d'associer
    des URIs virtuels à une ressource réelle qui peut ainsi les servir.
    Cette directive remplace avantageusement
    <module>mod_rewrite</module> lors de l'implémentation d'un
    "contrôleur frontal".</p>

    <p>Si toutes les tentatives pour localiser le contenu
    échouent, httpd
    retourne une page d'erreur avec le code de statut HTTP 404
    (file not found). L'apparence de cette page est contrôlée à l'aide de la
    directive <directive module="core">ErrorDocument</directive>
    et peut être personnalisée de manière très flexible comme discuté dans le
    document
    <a href="custom-error.html">Réponses personnalisées aux erreurs</a>.</p>
</section>

<section id="other"><title>Autres modules de mise en correspondance des
URLs</title>

<!-- TODO Flesh out each of the items in the list below. -->

    <p>Les autres modules disponibles pour la mise en correspondance des
    URLs sont :</p>
    <ul>
    <li><module>mod_actions</module> - Met une URL en correspondance
    avec un script CGI en fonction de la méthode de la requête, ou du
    type MIME de la ressource.</li>
    <li><module>mod_dir</module> - Permet une mise en correspondance
    basique d'un slash terminal dans un fichier index comme
    <code>index.html</code>.</li>
    <li><module>mod_imagemap</module> - Met en correspondance une
    requête avec une URL en fonction de la zone d'une image intégrée à
    un document HTML dans laquelle un utilisateur clique.</li>
    <li><module>mod_negotiation</module> - Sélectionne le document
    approprié en fonction de préférences du client telles que la langue
    ou la compression du contenu.</li>
    </ul>
    
</section>

</manualpage>
