/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.AssignableExpression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class Variable
extends AssignableExpression {
    private String name;

    public Variable(Rule rule, Type type, ParseNode token) {
        super(rule, type, token);
        this.name = token.getText();
    }

    public Variable(Rule rule, Type type, ParseNode token, String name) {
        super(rule, type, token);
        this.name = name;
    }

    @Override
    public void bind() throws TypeException {
        this.bind(false);
    }

    @Override
    public void bindAssign() throws TypeException {
        this.bind(true);
    }

    private boolean bind(boolean isUpdateable) throws TypeException {
        Binding binding = this.getBindings().lookup(this.name);
        if (binding == null) {
            throw new TypeException("Variable.bind : unbound variable " + this.name + this.getPos());
        }
        if (isUpdateable) {
            binding.setUpdated();
        }
        this.type = binding.getType();
        return true;
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.typeCheckAny();
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("Variable.typeCheck() : invalid result type : " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Type typeCheckAssign(Type expected) throws TypeException {
        this.typeCheckAny();
        if (Type.dereference(expected).isDefined() && !this.type.isAssignableFrom(expected)) {
            throw new TypeException("Variable.typeCheck() : invalid value type : " + expected.getName() + " for assignment " + this.getPos());
        }
        return this.type;
    }

    public void typeCheckAny() throws TypeException {
        Binding binding = this.getBindings().lookup(this.name);
        this.type = Type.dereference(binding.getType());
        if (this.type.isUndefined()) {
            throw new TypeException("Variable.typeCheck : unable to derive type for variable " + this.name + this.getPos());
        }
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        return helper.getBinding(this.name);
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(this.name);
        mv.visitMethodInsn(185, Type.internalName(HelperAdapter.class), "getBinding", "(Ljava/lang/String;)Ljava/lang/Object;");
        compileContext.addStackCount(2);
        compileContext.addStackCount(-1);
        if (this.type.isPrimitive()) {
            Type boxType = Type.boxType(this.type);
            this.compileObjectConversion(Type.OBJECT, boxType, mv, compileContext);
            this.compileUnbox(boxType, this.type, mv, compileContext);
        } else {
            this.compileObjectConversion(Type.OBJECT, this.type, mv, compileContext);
        }
    }

    @Override
    public Object interpretAssign(HelperAdapter helperAdapter, Object value) throws ExecuteException {
        helperAdapter.setBinding(this.name, value);
        return value;
    }

    @Override
    public void compileAssign(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        int size;
        compileContext.notifySourceLine(this.line);
        int currentStack = compileContext.getStackCount();
        int n = size = this.type.getNBytes() > 4 ? 2 : 1;
        if (size == 2) {
            mv.visitInsn(92);
        } else {
            mv.visitInsn(89);
        }
        mv.visitVarInsn(25, 0);
        if (size == 2) {
            mv.visitInsn(91);
            mv.visitInsn(87);
        } else {
            mv.visitInsn(95);
        }
        mv.visitLdcInsn(this.name);
        if (size == 2) {
            mv.visitInsn(91);
            compileContext.addStackCount(5);
            mv.visitInsn(87);
            compileContext.addStackCount(-1);
        } else {
            compileContext.addStackCount(3);
            mv.visitInsn(95);
        }
        this.compileObjectConversion(this.type, Type.OBJECT, mv, compileContext);
        mv.visitMethodInsn(185, Type.internalName(HelperAdapter.class), "setBinding", "(Ljava/lang/String;Ljava/lang/Object;)V");
        compileContext.addStackCount(-3);
        if (compileContext.getStackCount() != currentStack) {
            throw new CompileException("variable.compileAssignment : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack);
        }
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write(this.name);
    }
}

