/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.DefaultErrorHandler;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.helpers.Integers;
import org.apache.logging.log4j.status.StatusLogger;

public abstract class AbstractAppender<T extends Serializable>
extends AbstractFilterable
implements Appender<T> {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private final boolean handleException;
    private ErrorHandler handler = new DefaultErrorHandler(this);
    private final Layout<T> layout;
    private final String name;
    private boolean started = false;

    public static int parseInt(String s, int defaultValue) {
        try {
            return Integers.parseInt(s, defaultValue);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Could not parse \"{}\" as an integer,  using default value {}: {}", new Object[]{s, defaultValue, e});
            return defaultValue;
        }
    }

    protected AbstractAppender(String name, Filter filter, Layout<T> layout) {
        this(name, filter, layout, true);
    }

    protected AbstractAppender(String name, Filter filter, Layout<T> layout, boolean handleException) {
        super(filter);
        this.name = name;
        this.layout = layout;
        this.handleException = handleException;
    }

    public void error(String msg) {
        this.handler.error(msg);
    }

    public void error(String msg, LogEvent event, Throwable t) {
        this.handler.error(msg, event, t);
    }

    public void error(String msg, Throwable t) {
        this.handler.error(msg, t);
    }

    @Override
    public ErrorHandler getHandler() {
        return this.handler;
    }

    @Override
    public Layout<T> getLayout() {
        return this.layout;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isExceptionSuppressed() {
        return this.handleException;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setHandler(ErrorHandler handler) {
        if (handler == null) {
            LOGGER.error("The handler cannot be set to null");
        }
        if (this.isStarted()) {
            LOGGER.error("The handler cannot be changed once the appender is started");
            return;
        }
        this.handler = handler;
    }

    @Override
    public void start() {
        this.startFilter();
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
        this.stopFilter();
    }

    public String toString() {
        return this.name;
    }
}

