/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderRuntimeException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.apache.logging.log4j.core.layout.SerializedLayout;
import org.apache.logging.log4j.core.net.JMSQueueManager;

@Plugin(name="JMSQueue", category="Core", elementType="appender", printObject=true)
public final class JMSQueueAppender<T extends Serializable>
extends AbstractAppender<T> {
    private final JMSQueueManager manager;

    private JMSQueueAppender(String name, Filter filter, Layout<T> layout, JMSQueueManager manager, boolean handleExceptions) {
        super(name, filter, layout, handleExceptions);
        this.manager = manager;
    }

    @Override
    public void append(LogEvent event) {
        try {
            this.manager.send((Serializable)this.getLayout().toSerializable(event));
        }
        catch (Exception ex) {
            throw new AppenderRuntimeException(ex);
        }
    }

    @PluginFactory
    public static <S extends Serializable> JMSQueueAppender<S> createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="factoryName") String factoryName, @PluginAttr(value="providerURL") String providerURL, @PluginAttr(value="urlPkgPrefixes") String urlPkgPrefixes, @PluginAttr(value="securityPrincipalName") String securityPrincipalName, @PluginAttr(value="securityCredentials") String securityCredentials, @PluginAttr(value="factoryBindingName") String factoryBindingName, @PluginAttr(value="queueBindingName") String queueBindingName, @PluginAttr(value="userName") String userName, @PluginAttr(value="password") String password, @PluginElement(value="layout") Layout<S> layout, @PluginElement(value="filter") Filter filter, @PluginAttr(value="suppressExceptions") String suppress) {
        if (name == null) {
            LOGGER.error("No name provided for JMSQueueAppender");
            return null;
        }
        boolean handleExceptions = Booleans.parseBoolean(suppress, true);
        JMSQueueManager manager = JMSQueueManager.getJMSQueueManager(factoryName, providerURL, urlPkgPrefixes, securityPrincipalName, securityCredentials, factoryBindingName, queueBindingName, userName, password);
        if (manager == null) {
            return null;
        }
        if (layout == null) {
            SerializedLayout l;
            layout = l = SerializedLayout.createLayout();
        }
        return new JMSQueueAppender<LogEvent>(name, filter, layout, manager, handleExceptions);
    }
}

