/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.apache.logging.log4j.core.layout.HTMLLayout;
import org.apache.logging.log4j.core.net.SMTPManager;

@Plugin(name="SMTP", category="Core", elementType="appender", printObject=true)
public final class SMTPAppender<T extends Serializable>
extends AbstractAppender<T> {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    protected final SMTPManager manager;

    private SMTPAppender(String name, Filter filter, Layout<T> layout, SMTPManager manager, boolean handleExceptions) {
        super(name, filter, layout, handleExceptions);
        this.manager = manager;
    }

    @PluginFactory
    public static <S extends Serializable> SMTPAppender<S> createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="to") String to, @PluginAttr(value="cc") String cc, @PluginAttr(value="bcc") String bcc, @PluginAttr(value="from") String from, @PluginAttr(value="replyTo") String replyTo, @PluginAttr(value="subject") String subject, @PluginAttr(value="smtpProtocol") String smtpProtocol, @PluginAttr(value="smtpHost") String smtpHost, @PluginAttr(value="smtpPort") String smtpPortNum, @PluginAttr(value="smtpUsername") String smtpUsername, @PluginAttr(value="smtpPassword") String smtpPassword, @PluginAttr(value="smtpDebug") String smtpDebug, @PluginAttr(value="bufferSize") String bufferSizeNum, @PluginElement(value="layout") Layout<S> layout, @PluginElement(value="filter") Filter filter, @PluginAttr(value="suppressExceptions") String suppressExceptions) {
        SMTPManager manager;
        int bufferSize;
        if (name == null) {
            LOGGER.error("No name provided for SMTPAppender");
            return null;
        }
        boolean isHandleExceptions = Booleans.parseBoolean(suppressExceptions, true);
        int smtpPort = AbstractAppender.parseInt(smtpPortNum, 0);
        boolean isSmtpDebug = Boolean.parseBoolean(smtpDebug);
        int n = bufferSize = bufferSizeNum == null ? 512 : Integer.valueOf(bufferSizeNum);
        if (layout == null) {
            HTMLLayout l;
            layout = l = HTMLLayout.createLayout(null, null, null, null, null, null);
        }
        if (filter == null) {
            filter = ThresholdFilter.createFilter(null, null, null);
        }
        if ((manager = SMTPManager.getSMTPManager(to, cc, bcc, from, replyTo, subject, smtpProtocol, smtpHost, smtpPort, smtpUsername, smtpPassword, isSmtpDebug, filter.toString(), bufferSize)) == null) {
            return null;
        }
        return new SMTPAppender<String>(name, filter, layout, manager, isHandleExceptions);
    }

    @Override
    public boolean isFiltered(LogEvent event) {
        boolean filtered = super.isFiltered(event);
        if (filtered) {
            this.manager.add(event);
        }
        return filtered;
    }

    @Override
    public void append(LogEvent event) {
        this.manager.sendEvents(this.getLayout(), event);
    }
}

