/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.JDBCDatabaseManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Jdbc", category="Core", elementType="appender", printObject=true)
public final class JDBCAppender
extends AbstractDatabaseAppender<JDBCDatabaseManager> {
    private final String description = this.getName() + "{ manager=" + this.getManager() + " }";

    private JDBCAppender(String name, Filter filter, boolean handleException, JDBCDatabaseManager manager) {
        super(name, filter, handleException, manager);
    }

    @Override
    public String toString() {
        return this.description;
    }

    @PluginFactory
    public static JDBCAppender createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="suppressExceptions") String suppressExceptions, @PluginElement(value="filter") Filter filter, @PluginElement(value="connectionSource") ConnectionSource connectionSource, @PluginAttr(value="bufferSize") String bufferSize, @PluginAttr(value="tableName") String tableName, @PluginElement(value="columnConfigs") ColumnConfig[] columnConfigs) {
        int bufferSizeInt = AbstractAppender.parseInt(bufferSize, 0);
        boolean handleExceptions = !Boolean.parseBoolean(suppressExceptions);
        StringBuilder managerName = new StringBuilder("jdbcManager{ description=").append(name).append(", bufferSize=").append(bufferSizeInt).append(", connectionSource=").append(((Object)connectionSource).toString()).append(", tableName=").append(tableName).append(", columns=[ ");
        int i = 0;
        for (ColumnConfig column : columnConfigs) {
            if (i++ > 0) {
                managerName.append(", ");
            }
            managerName.append(column.toString());
        }
        managerName.append(" ] }");
        JDBCDatabaseManager manager = JDBCDatabaseManager.getJDBCDatabaseManager(managerName.toString(), bufferSizeInt, connectionSource, tableName, columnConfigs);
        if (manager == null) {
            return null;
        }
        return new JDBCAppender(name, filter, handleExceptions, manager);
    }
}

