/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.nosql.couch;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.nosql.NoSQLConnection;
import org.apache.logging.log4j.core.appender.db.nosql.NoSQLObject;
import org.apache.logging.log4j.core.appender.db.nosql.couch.CouchDBObject;
import org.apache.logging.log4j.status.StatusLogger;
import org.lightcouch.CouchDbClient;
import org.lightcouch.Response;

public final class CouchDBConnection
implements NoSQLConnection<Map<String, Object>, CouchDBObject> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final CouchDbClient client;
    private boolean closed = false;

    public CouchDBConnection(CouchDbClient client) {
        this.client = client;
    }

    @Override
    public CouchDBObject createObject() {
        return new CouchDBObject();
    }

    public CouchDBObject[] createList(int length) {
        return new CouchDBObject[length];
    }

    @Override
    public void insertObject(NoSQLObject<Map<String, Object>> object) {
        try {
            Response response = this.client.save(object.unwrap());
            if (response.getError() != null && response.getError().length() > 0) {
                LOGGER.error("Failed to write log event to CouchDB due to error: [{}].", new Object[]{response.getError()});
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to write log event to CouchDB due to error.", (Throwable)e);
        }
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.client.shutdown();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }
}

