/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class WrapTest
implements Test {
    public TestResult perform() {
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding", "BC");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(512, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DES", "BC");
            SecretKey secretKey = keyGenerator.generateKey();
            cipher.init(3, secretKey);
            byte[] byArray = cipher.wrap(privateKey);
            cipher.init(4, secretKey);
            Key key = cipher.unwrap(byArray, "RSA", 2);
            if (!MessageDigest.isEqual(privateKey.getEncoded(), key.getEncoded())) {
                return new SimpleTestResult(false, "Unwrapped key does not match");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
    }

    public String getName() {
        return "WrapTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        WrapTest wrapTest = new WrapTest();
        TestResult testResult = wrapTest.perform();
        System.out.println(((Object)testResult).toString());
    }
}

