/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.jce.provider.test.TestUtils;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.x509.X509CertificatePair;

public class X509CertificatePairTest
extends SimpleTest {
    public void performTest() throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        X509CertificatePair x509CertificatePair = new X509CertificatePair(x509Certificate, x509Certificate2);
        X509CertificatePair x509CertificatePair2 = new X509CertificatePair(x509Certificate, x509Certificate2);
        X509CertificatePair x509CertificatePair3 = new X509CertificatePair(x509Certificate2, x509Certificate3);
        X509CertificatePair x509CertificatePair4 = new X509CertificatePair(x509Certificate, x509Certificate3);
        X509CertificatePair x509CertificatePair5 = new X509CertificatePair(x509Certificate, null);
        X509CertificatePair x509CertificatePair6 = new X509CertificatePair(x509Certificate, null);
        X509CertificatePair x509CertificatePair7 = new X509CertificatePair(null, x509Certificate);
        X509CertificatePair x509CertificatePair8 = new X509CertificatePair(null, x509Certificate);
        if (!x509CertificatePair.equals(x509CertificatePair2)) {
            this.fail("pair1 pair2 equality test");
        }
        if (!x509CertificatePair5.equals(x509CertificatePair6)) {
            this.fail("pair1 pair2 equality test");
        }
        if (!x509CertificatePair7.equals(x509CertificatePair8)) {
            this.fail("pair1 pair2 equality test");
        }
        if (x509CertificatePair.equals(null)) {
            this.fail("pair1 null equality test");
        }
        if (x509CertificatePair.hashCode() != x509CertificatePair2.hashCode()) {
            this.fail("pair1 pair2 hashCode equality test");
        }
        if (x509CertificatePair.equals(x509CertificatePair3)) {
            this.fail("pair1 pair3 inequality test");
        }
        if (x509CertificatePair.equals(x509CertificatePair4)) {
            this.fail("pair1 pair4 inequality test");
        }
        if (x509CertificatePair.equals(x509CertificatePair5)) {
            this.fail("pair1 pair5 inequality test");
        }
        if (x509CertificatePair.equals(x509CertificatePair7)) {
            this.fail("pair1 pair7 inequality test");
        }
        if (x509CertificatePair5.equals(x509CertificatePair)) {
            this.fail("pair5 pair1 inequality test");
        }
        if (x509CertificatePair7.equals(x509CertificatePair)) {
            this.fail("pair7 pair1 inequality test");
        }
        if (x509CertificatePair.getForward() != x509Certificate) {
            this.fail("pair1 forward test");
        }
        if (x509CertificatePair.getReverse() != x509Certificate2) {
            this.fail("pair1 reverse test");
        }
        if (!this.areEqual(x509CertificatePair.getEncoded(), x509CertificatePair2.getEncoded())) {
            this.fail("encoding check");
        }
        x509CertificatePair4 = new X509CertificatePair(x509Certificate, TestUtils.createExceptionCertificate(false));
        try {
            x509CertificatePair4.getEncoded();
            this.fail("no exception on bad getEncoded()");
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        x509CertificatePair4 = new X509CertificatePair(x509Certificate, TestUtils.createExceptionCertificate(true));
        try {
            x509CertificatePair4.getEncoded();
            this.fail("no exception on exception getEncoded()");
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
    }

    public String getName() {
        return "X509CertificatePair";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        X509CertificatePairTest.runTest(new X509CertificatePairTest());
    }
}

