/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.util.HashMap;
import java.util.LinkedList;
import org.jboss.byteman.agent.HelperManager;
import org.jboss.byteman.agent.Location;
import org.jboss.byteman.agent.RuleScript;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.agent.adapter.BMJSRInliner;
import org.jboss.byteman.agent.adapter.BMLocalScopeAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.check.ClassChecker;
import org.jboss.byteman.objectweb.asm.ClassReader;
import org.jboss.byteman.objectweb.asm.ClassWriter;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.exception.ParseException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.exception.TypeWarningException;
import org.jboss.byteman.rule.type.TypeHelper;

public class TransformContext {
    private static final String JAVA_METHOD_SPEC_PATTERN = "[A-Za-z0-9$.]+ +[A-Za-z0-9$]+\\(.*\\)";
    public static final String TOFU = "java/lang/Object";
    private Transformer transformer;
    private RuleScript ruleScript;
    private String triggerClassName;
    private String targetMethodName;
    private String targetDescriptor;
    private ClassLoader loader;
    private HelperManager helperManager;
    private HashMap<String, Rule> ruleMap;
    private Rule firstRule;

    public TransformContext(Transformer transformer, RuleScript ruleScript, String triggerClassName, ClassLoader loader, HelperManager helperManager) {
        String targetMethodSpec = ruleScript.getTargetMethod();
        String mungedMethodSpec = this.mungeMethodSpecReturnType(targetMethodSpec);
        this.transformer = transformer;
        this.ruleScript = ruleScript;
        this.triggerClassName = triggerClassName;
        this.targetMethodName = TypeHelper.parseMethodName(mungedMethodSpec);
        this.targetDescriptor = TypeHelper.parseMethodDescriptor(mungedMethodSpec);
        this.loader = loader;
        this.helperManager = helperManager;
        this.ruleMap = new HashMap();
        this.firstRule = null;
    }

    public byte[] transform(byte[] targetClassBytes) {
        Location handlerLocation = this.ruleScript.getTargetLocation();
        String ruleName = this.ruleScript.getName();
        try {
            this.parseRule();
        }
        catch (ParseException pe) {
            if (Transformer.isVerbose()) {
                System.out.println("org.jboss.byteman.agent.Transformer : error parsing rule " + ruleName + "\n" + pe);
            }
            this.recordFailedTransform(pe);
            return targetClassBytes;
        }
        catch (Throwable th) {
            if (Transformer.isVerbose()) {
                System.out.println("org.jboss.byteman.agent.Transformer : unexpected error parsing rule " + ruleName + "\n" + th);
            }
            this.recordFailedTransform(th);
            return targetClassBytes;
        }
        ClassReader cr = new ClassReader(targetClassBytes);
        ClassWriter dummy = this.getNonLoadingClassWriter(0);
        RuleCheckAdapter checkAdapter = handlerLocation.getRuleCheckAdapter(dummy, this);
        try {
            BMLocalScopeAdapter localScopeAdapter = new BMLocalScopeAdapter(checkAdapter);
            cr.accept(localScopeAdapter, 8);
        }
        catch (TransformFailure te) {
            return targetClassBytes;
        }
        catch (Throwable th) {
            if (Transformer.isVerbose()) {
                System.out.println("org.jboss.byteman.agent.Transformer : unexpected error applying rule " + this.ruleScript.getName() + " to class " + this.triggerClassName + "\n" + th);
                th.printStackTrace(System.out);
            }
            this.recordFailedTransform(th);
            return targetClassBytes;
        }
        if (!checkAdapter.isVisited()) {
            return targetClassBytes;
        }
        if (Transformer.isVerbose()) {
            System.out.println("org.jboss.byteman.agent.Transformer : possible trigger for rule " + this.ruleScript.getName() + " in class " + this.triggerClassName);
        }
        cr = new ClassReader(targetClassBytes);
        ClassWriter cw = this.getNonLoadingClassWriter(3);
        RuleTriggerAdapter adapter = handlerLocation.getRuleAdapter(cw, this);
        BMJSRInliner jsrInliner = new BMJSRInliner(adapter);
        try {
            cr.accept(jsrInliner, 8);
        }
        catch (TransformFailure te) {
            return targetClassBytes;
        }
        catch (Throwable th) {
            if (Transformer.isVerbose()) {
                System.out.println("org.jboss.byteman.agent.Transformer : unexpected error injecting trigger for rule " + this.ruleScript.getName() + " into class " + this.triggerClassName + "\n" + th);
                th.printStackTrace(System.out);
            }
            this.recordFailedTransform(th);
            return targetClassBytes;
        }
        if (Transformer.isVerbose()) {
            System.out.println("org.jboss.byteman.agent.Transformer : inserted trigger for " + this.ruleScript.getName() + " in class " + this.triggerClassName);
        }
        if (!this.notifyRules()) {
            return targetClassBytes;
        }
        return cw.toByteArray();
    }

    public void parseRule() throws Exception {
        Rule rule = Rule.create(this.ruleScript, this.loader, this.helperManager);
        this.ruleMap.put(this.triggerClassName, rule);
        this.firstRule = rule;
    }

    public Rule lookupRule(String triggerMethodName, String triggerMethodDescriptor) {
        String key = this.getRuleKey(triggerMethodName, triggerMethodDescriptor);
        return this.ruleMap.get(key);
    }

    public Rule createRule(String triggerMethodName, String triggerMethodDescriptor) {
        String key = this.getRuleKey(triggerMethodName, triggerMethodDescriptor);
        Rule rule = this.ruleMap.remove(this.triggerClassName);
        if (rule == null) {
            try {
                rule = Rule.create(this.ruleScript, this.loader, this.helperManager);
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
        this.ruleMap.put(key, rule);
        return rule;
    }

    public void warn(String triggerMethodName, String triggerMethodDescriptor, String warningMessage) {
        String key = this.getRuleKey(triggerMethodName, triggerMethodDescriptor);
        Rule rule = this.ruleMap.remove(key);
        String message = warningMessage + " for method " + triggerMethodName + TypeHelper.internalizeDescriptor(triggerMethodDescriptor);
        TypeWarningException tw = new TypeWarningException(message);
        this.ruleScript.recordTransform(this.loader, this.triggerClassName, triggerMethodName, triggerMethodDescriptor, rule, tw);
    }

    public void fail(String failMessage, String triggerMethodName, String triggerMethodDescriptor) {
        String key = this.getRuleKey(triggerMethodName, triggerMethodDescriptor);
        Rule rule = this.ruleMap.get(key);
        String message = failMessage + " for method " + triggerMethodName + TypeHelper.internalizeDescriptor(triggerMethodDescriptor);
        TypeException te = new TypeException(message);
        this.ruleScript.recordTransform(this.loader, this.triggerClassName, triggerMethodName, triggerMethodDescriptor, rule, te);
        this.purgeRules();
        throw new TransformFailure();
    }

    public void recordFailedTransform(Throwable th) {
        this.ruleScript.recordTransform(this.loader, this.triggerClassName, null, null, null, th);
        this.purgeRules();
    }

    public boolean matchTargetMethod(int access, String name, String desc) {
        return (access & 0x1500) == 0 && this.targetMethodName.equals(name) && (this.targetDescriptor.equals("") || TypeHelper.equalDescriptors(this.targetDescriptor, desc));
    }

    public boolean injectIntoMethod(String name, String desc) {
        return this.lookupRule(name, desc) != null;
    }

    public String getTriggerClassName() {
        return this.triggerClassName;
    }

    private boolean notifyRules() {
        if (this.ruleMap.isEmpty() && this.firstRule != null) {
            TypeWarningException twe = new TypeWarningException("failed to find any matching trigger method in class " + TypeHelper.internalizeClass(this.triggerClassName));
            this.ruleScript.recordTransform(this.loader, this.triggerClassName, null, null, this.firstRule, twe);
        }
        for (String key : this.ruleMap.keySet()) {
            Rule rule;
            String triggerMethodDescriptor;
            String triggerMethodName = this.getKeyTriggerMethodName(key);
            if (this.ruleScript.recordTransform(this.loader, this.triggerClassName, triggerMethodName, triggerMethodDescriptor = this.getKeyTriggerMethodDescriptor(key), rule = this.ruleMap.get(key), null)) continue;
            this.purgeRules();
            return false;
        }
        return true;
    }

    private void purgeRules() {
        for (Rule rule : this.ruleMap.values()) {
            rule.purge();
        }
    }

    private String getRuleKey(String triggerMethodName, String triggerMethodDescriptor) {
        return this.triggerClassName + "#" + triggerMethodName + "#" + triggerMethodDescriptor;
    }

    private String getKeyTriggerMethodName(String key) {
        int firstHash = key.indexOf(35);
        int secondHash = key.lastIndexOf(35);
        return key.substring(firstHash + 1, secondHash);
    }

    private String getKeyTriggerMethodDescriptor(String key) {
        int secondHash = key.lastIndexOf(35);
        return key.substring(secondHash + 1);
    }

    private String mungeMethodSpecReturnType(String targetMethodSpec) {
        if ((targetMethodSpec = targetMethodSpec.trim()).matches(JAVA_METHOD_SPEC_PATTERN)) {
            int spaceIdx = targetMethodSpec.indexOf(32);
            String returnType = targetMethodSpec.substring(0, spaceIdx);
            targetMethodSpec = targetMethodSpec.substring(spaceIdx).trim() + returnType;
        }
        return targetMethodSpec;
    }

    private ClassWriter getNonLoadingClassWriter(int flags) {
        final TransformContext finalContext = this;
        return new ClassWriter(flags){
            TransformContext context;
            {
                super(x0);
                this.context = finalContext;
            }

            @Override
            protected String getCommonSuperClass(String type1, String type2) {
                return this.context.findLeastCommonSuper(type1, type2);
            }
        };
    }

    public String findLeastCommonSuper(String t1, String t2) {
        if (TOFU.equals(t1) || TOFU.equals(t2)) {
            return TOFU;
        }
        if (t1.equals(t2)) {
            return t2;
        }
        String type1 = t1.replaceAll("/", ".");
        String type2 = t2.replaceAll("/", ".");
        ClassChecker checker1 = this.transformer.getClassChecker(type1, this.loader);
        ClassChecker checker2 = this.transformer.getClassChecker(type2, this.loader);
        if (checker1.isInterface()) {
            if (checker2.isInterface()) {
                LinkedList<String> interfaces2 = this.listInterfaces(checker2);
                if (interfaces2.contains(type1)) {
                    return t1;
                }
                LinkedList<String> interfaces1 = this.listInterfaces(checker1);
                while (!interfaces1.isEmpty()) {
                    String next = interfaces1.pop();
                    if (next.equals(type2)) {
                        return t2;
                    }
                    if (!interfaces2.contains(next)) continue;
                    return next.replaceAll("\\.", "/");
                }
                return TOFU;
            }
            LinkedList<String> interfaces2 = this.listInterfaces(checker2);
            if (interfaces2.contains(type1)) {
                return t1;
            }
            LinkedList<String> interfaces1 = this.listInterfaces(checker1);
            while (!interfaces1.isEmpty()) {
                String next = interfaces1.pop();
                if (!interfaces2.contains(next)) continue;
                return next.replaceAll("\\.", "/");
            }
            return TOFU;
        }
        if (checker2.isInterface()) {
            LinkedList<String> interfaces1 = this.listInterfaces(checker1);
            if (interfaces1.contains(type2)) {
                return t1;
            }
            LinkedList<String> interfaces2 = this.listInterfaces(checker2);
            while (!interfaces2.isEmpty()) {
                String next = interfaces2.pop();
                if (!interfaces1.contains(next)) continue;
                return next.replaceAll("\\.", "/");
            }
            return TOFU;
        }
        LinkedList<String> supers2 = this.listSupers(checker2);
        if (supers2.contains(type1)) {
            return t1;
        }
        LinkedList<String> supers1 = this.listSupers(checker1);
        while (!supers1.isEmpty()) {
            String next = supers1.pop();
            if (next.equals(type2)) {
                return t2;
            }
            if (!supers2.contains(next)) continue;
            return next.replaceAll("\\.", "/");
        }
        return TOFU;
    }

    private LinkedList<String> listInterfaces(ClassChecker checker) {
        LinkedList<String> interfaces = new LinkedList<String>();
        ClassChecker current = checker;
        while (current != null) {
            LinkedList<String> toCheck = new LinkedList<String>();
            int count = current.getInterfaceCount();
            for (int i = 0; i < count; ++i) {
                toCheck.add(current.getInterface(i));
            }
            while (!toCheck.isEmpty()) {
                String next = (String)toCheck.pop();
                if (interfaces.contains(next)) continue;
                interfaces.add(next);
                ClassChecker newChecker = this.transformer.getClassChecker(next, this.loader);
                count = newChecker.getInterfaceCount();
                for (int i = 0; i < count; ++i) {
                    toCheck.add(newChecker.getInterface(i));
                }
            }
            String superType = current.getSuper();
            if (superType == null || TOFU.equals(superType)) {
                current = null;
                continue;
            }
            current = this.transformer.getClassChecker(superType, this.loader);
        }
        return interfaces;
    }

    private LinkedList<String> listSupers(ClassChecker checker) {
        LinkedList<String> supers = new LinkedList<String>();
        ClassChecker current = checker;
        while (current != null) {
            String superType = current.getSuper();
            if (superType != null) {
                supers.add(superType);
                current = this.transformer.getClassChecker(superType, this.loader);
                continue;
            }
            current = null;
        }
        return supers;
    }

    private class TransformFailure
    extends RuntimeException {
    }
}

