/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.type.TypeHelper;

public class FieldAccessTriggerAdapter
extends RuleTriggerAdapter {
    private String ownerClass;
    private String fieldName;
    private int flags;
    private int count;
    private boolean whenComplete;

    public FieldAccessTriggerAdapter(ClassVisitor cv, TransformContext transformContext, String ownerClass, String fieldName, int flags, int count, boolean whenComplete) {
        super(cv, transformContext);
        this.ownerClass = ownerClass;
        this.fieldName = fieldName;
        this.flags = flags;
        this.count = count;
        this.whenComplete = whenComplete;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.injectIntoMethod(name, desc)) {
            if (name.equals("<init>")) {
                return new FieldAccessTriggerConstructorAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
            }
            return new FieldAccessTriggerMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class FieldAccessTriggerConstructorAdapter
    extends FieldAccessTriggerMethodAdapter {
        FieldAccessTriggerConstructorAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.latched = true;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if (this.latched && FieldAccessTriggerAdapter.this.isSuperOrSiblingConstructorCall(opcode, owner, name)) {
                this.latched = false;
            }
        }
    }

    private class FieldAccessTriggerMethodAdapter
    extends RuleTriggerMethodAdapter {
        protected boolean latched;
        private int visitedCount;

        FieldAccessTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.visitedCount = 0;
            this.latched = false;
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (FieldAccessTriggerAdapter.this.whenComplete) {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
            if ((FieldAccessTriggerAdapter.this.count == 0 || this.visitedCount < FieldAccessTriggerAdapter.this.count) && this.matchCall(opcode, owner, name, desc)) {
                ++this.visitedCount;
                if (!(this.latched || FieldAccessTriggerAdapter.this.count != 0 && this.visitedCount != FieldAccessTriggerAdapter.this.count)) {
                    this.injectTriggerPoint();
                }
            }
            if (!FieldAccessTriggerAdapter.this.whenComplete) {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        private boolean matchCall(int opcode, String owner, String name, String desc) {
            if (!FieldAccessTriggerAdapter.this.fieldName.equals(name)) {
                return false;
            }
            switch (opcode) {
                case 178: 
                case 180: {
                    if ((FieldAccessTriggerAdapter.this.flags & 1) != 0) break;
                    return false;
                }
                case 179: 
                case 181: {
                    if ((FieldAccessTriggerAdapter.this.flags & 2) != 0) break;
                    return false;
                }
            }
            if (FieldAccessTriggerAdapter.this.ownerClass != null && !FieldAccessTriggerAdapter.this.ownerClass.equals(TypeHelper.internalizeClass(owner))) {
                if (FieldAccessTriggerAdapter.this.ownerClass.indexOf(46) >= 0) {
                    return false;
                }
                int ownerPackageIdx = owner.lastIndexOf(47);
                if (ownerPackageIdx < 0) {
                    return false;
                }
                if (!owner.substring(ownerPackageIdx + 1).equals(FieldAccessTriggerAdapter.this.ownerClass)) {
                    return false;
                }
            }
            return true;
        }
    }
}

