#!/bin/bash

JDG_REMOTE=jdg
REDHAT_REMOTE=redhat
JDG_BRANCH=jdg-6.3.x
TEMP_BRANCH=__tmp

function prepare() {
	echo "Preparing release for milestone $1"
    git fetch -p $JDG_REMOTE
	git branch -D $TEMP_BRANCH 2> /dev/null
	git checkout -b $TEMP_BRANCH $JDG_REMOTE/$JDG_BRANCH
	sed -i "s/\"SNAPSHOT\"/\"$1\"/" CMakeLists.txt
	rm -fr build
	mkdir build
	pushd build 2> /dev/null
	cmake ..
	cpack --config CPackSourceConfig.cmake
	popd
	exit
}

function perform() {
	RELEASE=`grep ::VERSION build/Version.cpp | cut -d\" -f2`
	echo "Performing release $RELEASE"
    git add CMakeLists.txt
    git commit -a -m "$RELEASE"
    git tag -a $RELEASE -m $RELEASE
    git checkout $JDG_BRANCH
    git branch -D $TEMP_BRANCH
    echo "Don't forget to push the $RELEASE tag to the $REDHAT_REMOTE remote"
	exit
}

function usage() {
	echo "Usage: $0 [--prepare MILESTONE|--perform]"
	exit 1
}

case "$1" in
    "--prepare" )
    	if [ "$#" -ne 2 ]; then
			usage
		fi
        prepare "$2"
        ;;
    "--perform" )
        perform
        ;;
    *)
        usage
        ;;
esac

