__author__ = 'slaskawi@redhat.com'

import os
import logging
import subprocess


class DependencyAnalyzer:
    def __init__(self, configuration):
        self._configuration = configuration

    def prepare_dependency_information(self):
        logging.info("Preparing dependency list")
        return_to_this_dir = os.getcwd()
        try:
            os.chdir(self._configuration.get_packaging_repo_location())
            command = ["./bin/dependency-report.sh"]
            projects = self._configuration.get_productization_repo_location() + "," + self._configuration.get_camel_productization_repo_location()
            command.extend(["--projects", projects])
            logging.debug("Invoking dependency report with arguments: " + str(command))
            subprocess.check_call(command)
        finally:
            os.chdir(return_to_this_dir)
