__author__ = 'slaskawi@redhat.com'

import os
import logging
import subprocess
import zipfile


class LocalBuilder:
    def __init__(self, configuration):
        self._configuration = configuration

    def build_locally_jdg(self):
        logging.info("Building distribution")
        os.system(
            "./" + self._configuration.get_productization_repo_location() + "/build.sh clean install -DskipTests -Pdistribution")

    def build_locally_camel(self):
        logging.info("Building Camel")
        os.system(
            "./" + self._configuration.get_camel_productization_repo_location() + "/build.sh clean install -DskipTests")

    def build_locally_packaging(self):
        logging.info("Building from packaging")
        os.system(
            "./" + self._configuration.get_packaging_repo_location() + "/build.sh")
        
    def build_locally_quickstarts(self):
        logging.info("Building Quickstarts")
        return_to_this_dir = os.getcwd()
        mvn_cmd = "mvn -s settings.xml clean install -Pdistribution,ci " + \
            "-Dmaven.repo.local=../jboss-datagrid-" + self._configuration.get_product_release_version() + \
            "-maven-repository"
        os.chdir(self._configuration.get_quickstarts_repo_location())
        logging.info("Building Quickstarts with command: " + mvn_cmd)
        os.system(mvn_cmd)
        os.chdir(return_to_this_dir)

    def prepare_dependency_information(self):
        logging.info("Preparing dependency list")
        return_to_this_dir = os.getcwd()
        try:
            os.chdir(self._configuration.get_packaging_repo_location())
            command = ["./bin/dependency-report.sh"]
            projects = self._configuration.get_productization_repo_location() + "," + self._configuration.get_camel_productization_repo_location()
            command.extend(["--projects", projects])
            logging.debug("Invoking dependency report with arguments: " + str(command))
            subprocess.check_call(command)
        finally:
            os.chdir(return_to_this_dir)
            
    def prepare_maven_repo(self):
        logging.info("Setting up Maven Repository")
        repo_zip = "jboss-datagrid-" + self._configuration.get_product_release_version() + \
                   "." + self._configuration.get_version_modifier() + "-maven-repository.zip"
        os.system("wget " + self._configuration.get_release_url() + 
                  "/" + repo_zip)
        zfile = zipfile.ZipFile(repo_zip)
        zfile.extractall()
        
        