__author__ = 'slaskawi@redhat.com'

import logging


class BuildSteps:

    VALIDATE = "VALIDATE"
    PREPARE_REPOSITORIES = "PREPARE_REPOSITORIES"
    BUILD_LOCALLY = "BUILD_LOCALLY"
    PUSH_PRODUCTIZED_REPOSITORIES = "PUSH_PRODUCTIZED_REPOSITORIES"
    UPLOAD_DEPENDENCY_INFORMATION = "UPLOAD_DEPENDENCY_INFORMATION"
    BUILD_IN_BREW = "BUILD_IN_BREW"
    REVERSION_TO_SNAPSHOT = "REVERSION_TO_SNAPSHOT"
    PERFORM_REMOTE_RELEASE = "PERFORM_REMOTE_RELEASE"
    BUILD_QUICKSTARTS = "BUILD_QUICKSTARTS"

    ALL_STEPS = [VALIDATE, PREPARE_REPOSITORIES, BUILD_LOCALLY, PUSH_PRODUCTIZED_REPOSITORIES, 
                 UPLOAD_DEPENDENCY_INFORMATION, BUILD_IN_BREW, PERFORM_REMOTE_RELEASE, 
                 BUILD_QUICKSTARTS, REVERSION_TO_SNAPSHOT]

    def __init__(self, resume_from=VALIDATE):
        if resume_from in BuildSteps.ALL_STEPS:
            self._steps_to_perform = BuildSteps.ALL_STEPS[BuildSteps.ALL_STEPS.index(resume_from):len(BuildSteps.ALL_STEPS)]
        elif resume_from is None:
            self._steps_to_perform = BuildSteps.ALL_STEPS
        else:
            raise AttributeError("Not acceptable type for Build Steps")

    def log_checkpoint_and_check_if_should_perform_step(self, step):
        logging.info("Got checkpoint, to resume from here use --resume-from \"" + str(step) + "\"")
        return step in self._steps_to_perform