#!/usr/bin/python

import argparse

from com.redhat.release.jdg.build.BrewBuilder import *
from com.redhat.release.jdg.configuration.JDGReleaseConfiguration import *
from com.redhat.release.jdg.git.GitRepositoryUpdater import *
from com.redhat.release.jdg.kerberos.KerberosAuthenticator import *
from com.redhat.release.jdg.version.VersionUpdater import *
from com.redhat.release.jdg.build.LocalBuilder import *
from com.redhat.release.jdg.build.DependencyAnalyzer import *
from com.redhat.release.jdg.build.RemoteHostReleaseHandler import *
from com.redhat.release.jdg.supervisor.BuildSteps import *

def create_release_directory(release_path):
    logging.info("Creating release directory %s", release_path)
    os.system("mkdir -p " + release_path)
    os.chdir(release_path)


# ./release.py --product-version '6.4.0' --infinispan-version '6.2.0' --relese-modifier 'ER2-redhat-1' --upstream-branch-name 'jdg-9.9.x' --working-dir 'test' --releasing-username 'slaskawi' --keytab-file '../krb5.keytab'
def main(argv):
    logging.basicConfig(level=logging.DEBUG)

    parser = argparse.ArgumentParser(description='This script performs JDG release. v. pre pre pre Alpha')
    parser.add_argument('--product-version', dest="product_version", required=True,
                        help='Version of the product e.g. 6.4')
    parser.add_argument('--infinispan-version', dest="infinispan_version", required=True,
                        help='Infinispan version on which JDG is build e.g. 6.2')
    parser.add_argument('--relese-modifier', dest="release_modifier", required=True,
                        help='Identifier of the release e.g. ER1-redhat-1')
    parser.add_argument('--upstream-branch-name', dest="upstream_branch_name", required=True,
                        help='Name of the upstream productized branch e.g. jdg-6.4.x')
    parser.add_argument('--working-dir', dest="working_dir", required=True,
                        help='Relative release working directory e.g. release')
    parser.add_argument('--releasing-username', dest="releasing_user", required=True,
                        help='User who does this release e.g. slaskawi')
    parser.add_argument('--keytab-file', dest="keytab_file",
                        help='Kerberos authentication file, use ktutil to create it')
    parser.add_argument('--dry-run', dest="dry_run", help='Dry run? Default True', default=True)
    parser.add_argument('--skip-clients', dest="skip_clients",
                        help='Skip C++/C# client builds? Default False', default=False)
    parser.add_argument('--resume-from', dest="resume_from",
                        help='Where the build should resume')
    
    args = parser.parse_args()

    release_configuration = JDGReleaseConfiguration(args.product_version, args.infinispan_version, args.release_modifier,  args.upstream_branch_name, args.working_dir, args.releasing_user, args.keytab_file, args.dry_run, args.skip_clients)
    version_updater = VersionUpdater(release_configuration)
    git_repository_updater = GitRepositoryUpdater(release_configuration)
    distribution_builder = LocalBuilder(release_configuration)
    brew_builder = BrewBuilder(release_configuration)
    kerberos_authenticator = KerberosAuthenticator(release_configuration)
    dependency_analyzer = DependencyAnalyzer(release_configuration)
    remote_host_release_handler = RemoteHostReleaseHandler(release_configuration)
    build_steps = BuildSteps(args.resume_from)

    kerberos_authenticator.authenticate()
    create_release_directory(release_configuration.get_release_directory())
    git_repository_updater.initialize_repositories()

    if build_steps.log_checkpoint_and_check_if_should_perform_step(BuildSteps.VALIDATE):
        git_repository_updater.check_if_tags_exists_in_productized_repos()

    if build_steps.log_checkpoint_and_check_if_should_perform_step(BuildSteps.PREPARE_REPOSITORIES):
        git_repository_updater.checkout_productization_branches()
        git_repository_updater.create_base_tag()
        git_repository_updater.prepare_productized_repo_for_release()
        version_updater.update_version()
        git_repository_updater.commit_versions()
        git_repository_updater.tag_versions()
        version_updater.prepare_clients()

    if build_steps.log_checkpoint_and_check_if_should_perform_step(BuildSteps.BUILD_LOCALLY):
        distribution_builder.build_locally_jdg()
        distribution_builder.build_locally_camel()
        distribution_builder.build_locally_packaging()

    if build_steps.log_checkpoint_and_check_if_should_perform_step(BuildSteps.PUSH_PRODUCTIZED_REPOSITORIES):
        git_repository_updater.push_to_productized_repos()

    if build_steps.log_checkpoint_and_check_if_should_perform_step(BuildSteps.UPLOAD_DEPENDENCY_INFORMATION):
        dependency_analyzer.prepare_dependency_information()
        remote_host_release_handler.upload_dependency_information()

    if build_steps.log_checkpoint_and_check_if_should_perform_step(BuildSteps.BUILD_IN_BREW):
        brew_builder.build_in_brew()
        brew_builder.rebuild_maven_repo()
        brew_builder.build_clients()

    if build_steps.log_checkpoint_and_check_if_should_perform_step(BuildSteps.PERFORM_REMOTE_RELEASE):
        remote_host_release_handler.prepare_release_directory()
        remote_host_release_handler.run_release_script()

    if build_steps.log_checkpoint_and_check_if_should_perform_step(BuildSteps.BUILD_QUICKSTARTS):
        distribution_builder.prepare_maven_repo()
        distribution_builder.build_locally_quickstarts()
        remote_host_release_handler.upload_quickstarts()
        remote_host_release_handler.clean_release_area()

    if build_steps.log_checkpoint_and_check_if_should_perform_step(BuildSteps.REVERSION_TO_SNAPSHOT):
        version_updater.change_versions_back_to_snapshot()
        git_repository_updater.commit_snapshot_versions()
        git_repository_updater.push_to_productized_repos()
        remote_host_release_handler.update_release_permissions("devel", "775")

    success = '''
        __ ____  _____    _____
     __|  |    \|   __|  |_   _|___ ___ _____
    |  |  |  |  |  |  |    | | | -_| .'|     |
    |_____|____/|_____|    |_| |___|__,|_|_|_|

    '''
    logging.info(success)


if __name__ == "__main__":
    main(sys.argv[1:])
