"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const common_flags_1 = require("../../common-flags");
class Stop extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Stop);
            const Listr = require('listr');
            const notifier = require('node-notifier');
            const tasks = new Listr([
                { title: 'Verify if we can access Kubernetes API', skip: () => 'Not implemented yet', task: () => { } },
                { title: 'Verify if CodeReady Workspaces is responding', skip: () => 'Not implemented yet', task: () => { } },
                { title: 'Verify if the workspaces is running', skip: () => 'Not implemented yet', task: () => { } },
                { title: 'Stop the workspace', skip: () => 'Not implemented yet', task: () => { } },
                { title: 'Waiting for the workspace resources to be deleted', skip: () => 'Not implemented yet', task: () => { } },
            ], { renderer: flags['listr-renderer'] });
            yield tasks.run();
            notifier.notify({
                title: 'crwctl',
                message: 'Command workspace:stop has completed.'
            });
        });
    }
}
exports.default = Stop;
Stop.description = 'stop a running workspace';
Stop.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
    'access-token': common_flags_1.accessToken,
    'listr-renderer': common_flags_1.listrRenderer
};
//# sourceMappingURL=stop.js.map