/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
import { Command, flags } from '@oclif/command';
export default class Deploy extends Command {
    static description: string;
    static flags: flags.Input<any>;
    setPlaformDefaults(flags: any, ctx: any): Promise<void>;
    /**
     * Checks if TLS is disabled via operator custom resource.
     * Returns true if TLS is enabled (or omitted) and false if it is explicitly disabled.
     */
    checkTlsMode(ctx: any): Promise<boolean>;
    private isDevWorkspaceEnabled;
    private checkCompatibility;
    run(): Promise<void>;
    /**
     * Sets default installer which is `olm` for OpenShift 4 with stable version of crwctl
     * and `operator` for other cases.
     */
    setDefaultInstaller(flags: any, _ctx: any): Promise<void>;
}
