"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const che_api_client_1 = require("../../api/che-api-client");
const che_login_manager_1 = require("../../api/che-login-manager");
const context_1 = require("../../api/context");
const common_flags_1 = require("../../common-flags");
const constants_1 = require("../../constants");
class List extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(List);
            yield context_1.ChectlContext.init(flags, this);
            yield this.config.runHook(constants_1.DEFAULT_ANALYTIC_HOOK_NAME, { command: List.id, flags });
            const { cheApiEndpoint, accessToken } = yield che_login_manager_1.getLoginData(flags[common_flags_1.CHE_API_ENDPOINT_KEY], flags[common_flags_1.ACCESS_TOKEN_KEY], flags);
            const cheApiClient = che_api_client_1.CheApiClient.getInstance(cheApiEndpoint);
            const workspaces = yield cheApiClient.getAllWorkspaces(accessToken);
            this.printWorkspaces(workspaces);
        });
    }
    printWorkspaces(workspaces) {
        const data = [];
        workspaces.forEach((workspace) => {
            data.push({
                id: workspace.id,
                name: workspace.devfile.metadata.name,
                namespace: workspace.attributes.infrastructureNamespace,
                status: workspace.status,
                created: new Date(parseInt(workspace.attributes.created, 10)).toISOString(),
                updated: workspace.attributes.updated ? new Date(parseInt(workspace.attributes.updated, 10)).toISOString() : '',
            });
        });
        cli_ux_1.cli.table(data, { id: {}, name: {}, namespace: {}, status: {}, created: {}, updated: {} });
    }
}
exports.default = List;
List.description = 'List workspaces';
List.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
    [common_flags_1.CHE_API_ENDPOINT_KEY]: common_flags_1.cheApiEndpoint,
    [common_flags_1.ACCESS_TOKEN_KEY]: common_flags_1.accessToken,
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck,
    telemetry: common_flags_1.CHE_TELEMETRY,
};
//# sourceMappingURL=list.js.map