/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { Command } from '@oclif/command';
declare const languages: ("java" | "typescript" | "go" | "python" | "c#")[];
export declare type Language = (typeof languages)[number];
declare const editors: ("theia-next" | "theia-1.0.0")[];
export declare type Editor = (typeof editors)[number];
export default class Generate extends Command {
    static description: string;
    static flags: {
        help: import("@oclif/parser/lib/flags").IBooleanFlag<void>;
        name: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        dockerimage: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        namespace: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        editor: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        selector: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        language: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        plugin: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        'git-repo': import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        command: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
    };
    run(): Promise<void>;
    private getPluginsByLanguage;
    private getDeploymentsBySelector;
    private getServicesBySelector;
    private getIngressesBySelector;
    private getPersistentVolumeClaimsBySelector;
}
export {};
