# Croatian (hr) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                    | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987.                                              | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                                 | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987.                                              | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                                 | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1.                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1. kv.                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kv.                                             | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1. kvartal                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kvartal                                         | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1.                                                 | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                 | Invalid Date             |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1.                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1. kv.                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kv.                                             | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1. kvartal                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kvartal                                         | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2.                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                 | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | velj                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | srp                                                | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | veljače                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | srpnja                                             | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | 2.                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                 | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2.                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                 | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | velj                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | srp                                                | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | veljača                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | srpanj                                             | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | 2.                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                 | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1.                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1.                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28.                                                | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365.                                               | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | pon                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pet                                                | Invalid Date             |
|                                 | EE           | 2019-02-11T12:13:14.015Z | pon                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pet                                                | Invalid Date             |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | pon                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pet                                                | Invalid Date             |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | ponedjeljak                                        | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | petak                                              | Invalid Date             |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | P                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                  | Invalid Date             |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | pon                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pet                                                | Invalid Date             |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | pon                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pet                                                | Invalid Date             |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | ponedjeljak                                        | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | petak                                              | Invalid Date             |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | P                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                  | Invalid Date             |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | pon                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pet                                                | Invalid Date             |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | pon                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pet                                                | Invalid Date             |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | ponedjeljak                                        | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | petak                                              | Invalid Date             |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | P                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                  | Invalid Date             |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | pon                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pet                                                | Invalid Date             |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                 | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | pon                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pet                                                | Invalid Date             |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | ponedjeljak                                        | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | petak                                              | Invalid Date             |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | P                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                  | Invalid Date             |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | pon                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pet                                                | Invalid Date             |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | ujutro                                             | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popodne                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | navečer                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | noću                                               | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | ujutro                                             | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popodne                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | navečer                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | noću                                               | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | ujutro                                             | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popodne                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | navečer                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | noću                                               | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | ujutro                                             | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | poslije podne                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | navečer                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | noću                                               | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | ujutro                                             | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popodne                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | navečer                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | noću                                               | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11.                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11.                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11.                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11.                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1.                                                 | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55.                                                | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1.                                                 | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55.                                                | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11. 02. 1987.                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. 05. 1453.                                      | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11. velj 1987.                                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. svi 1453.                                      | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11. veljače 1987.                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. svibnja 1453.                                  | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | srijeda, 11. veljače 1987.                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | nedjelja, 29. svibnja 1453.                        | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                              | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                              | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                           | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                           | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                     | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 (GMT+00:00)                               | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 (GMT+00:00)                               | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11. 02. 1987. 12:13                                | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. 05. 1453. 23:59                                | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11. velj 1987. 12:13:14                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. svi 1453. 23:59:59                             | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11. veljače 1987. u 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. svibnja 1453. u 23:59:59 GMT+0                 | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | srijeda, 11. veljače 1987. u 12:13:14 (GMT+00:00)  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | nedjelja, 29. svibnja 1453. u 23:59:59 (GMT+00:00) | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result            | `includeSeconds: true` | `addSuffix: true`       |
| ------------------------ | ----------------- | ---------------------- | ----------------------- |
| 2006-01-01T00:00:00.000Z | oko 6 godina      | oko 6 godina           | za oko 6 godina         |
| 2005-01-01T00:00:00.000Z | oko 5 godina      | oko 5 godina           | za oko 5 godina         |
| 2004-01-01T00:00:00.000Z | oko 4 godine      | oko 4 godine           | za oko 4 godine         |
| 2003-01-01T00:00:00.000Z | oko 3 godine      | oko 3 godine           | za oko 3 godine         |
| 2002-01-01T00:00:00.000Z | oko 2 godine      | oko 2 godine           | za oko 2 godine         |
| 2001-06-01T00:00:00.000Z | preko 1 godinu    | preko 1 godinu         | za preko 1 godinu       |
| 2001-02-01T00:00:00.000Z | oko 1 godinu      | oko 1 godinu           | za oko 1 godinu         |
| 2001-01-01T00:00:00.000Z | oko 1 godinu      | oko 1 godinu           | za oko 1 godinu         |
| 2000-06-01T00:00:00.000Z | 5 mjeseci         | 5 mjeseci              | za 5 mjeseci            |
| 2000-03-01T00:00:00.000Z | 2 mjeseca         | 2 mjeseca              | za 2 mjeseca            |
| 2000-02-01T00:00:00.000Z | oko 1 mjesec      | oko 1 mjesec           | za oko 1 mjesec         |
| 2000-01-15T00:00:00.000Z | 14 dana           | 14 dana                | za 14 dana              |
| 2000-01-02T00:00:00.000Z | 1 dan             | 1 dan                  | za 1 dan                |
| 2000-01-01T06:00:00.000Z | oko 6 sati        | oko 6 sati             | za oko 6 sati           |
| 2000-01-01T01:00:00.000Z | oko 1 sat         | oko 1 sat              | za oko 1 sat            |
| 2000-01-01T00:45:00.000Z | oko 1 sat         | oko 1 sat              | za oko 1 sat            |
| 2000-01-01T00:30:00.000Z | 30 minuta         | 30 minuta              | za 30 minuta            |
| 2000-01-01T00:15:00.000Z | 15 minuta         | 15 minuta              | za 15 minuta            |
| 2000-01-01T00:01:00.000Z | 1 minuta          | 1 minuta               | za 1 minutu             |
| 2000-01-01T00:00:25.000Z | manje od 1 minute | pola minute            | za manje od 1 minutu    |
| 2000-01-01T00:00:15.000Z | manje od 1 minute | manje od 20 sekundi    | za manje od 1 minutu    |
| 2000-01-01T00:00:05.000Z | manje od 1 minute | manje od 10 sekundi    | za manje od 1 minutu    |
| 2000-01-01T00:00:00.000Z | manje od 1 minute | manje od 5 sekundi     | prije manje od 1 minute |
| 1999-12-31T23:59:55.000Z | manje od 1 minute | manje od 10 sekundi    | prije manje od 1 minute |
| 1999-12-31T23:59:45.000Z | manje od 1 minute | manje od 20 sekundi    | prije manje od 1 minute |
| 1999-12-31T23:59:35.000Z | manje od 1 minute | pola minute            | prije manje od 1 minute |
| 1999-12-31T23:59:00.000Z | 1 minuta          | 1 minuta               | prije 1 minute          |
| 1999-12-31T23:45:00.000Z | 15 minuta         | 15 minuta              | prije 15 minuta         |
| 1999-12-31T23:30:00.000Z | 30 minuta         | 30 minuta              | prije 30 minuta         |
| 1999-12-31T23:15:00.000Z | oko 1 sat         | oko 1 sat              | prije oko 1 sat         |
| 1999-12-31T23:00:00.000Z | oko 1 sat         | oko 1 sat              | prije oko 1 sat         |
| 1999-12-31T18:00:00.000Z | oko 6 sati        | oko 6 sati             | prije oko 6 sati        |
| 1999-12-30T00:00:00.000Z | 2 dana            | 2 dana                 | prije 2 dana            |
| 1999-12-15T00:00:00.000Z | 17 dana           | 17 dana                | prije 17 dana           |
| 1999-12-01T00:00:00.000Z | oko 1 mjesec      | oko 1 mjesec           | prije oko 1 mjesec      |
| 1999-11-01T00:00:00.000Z | 2 mjeseca         | 2 mjeseca              | prije 2 mjeseca         |
| 1999-06-01T00:00:00.000Z | 7 mjeseci         | 7 mjeseci              | prije 7 mjeseci         |
| 1999-01-01T00:00:00.000Z | oko 1 godinu      | oko 1 godinu           | prije oko 1 godinu      |
| 1998-12-01T00:00:00.000Z | oko 1 godinu      | oko 1 godinu           | prije oko 1 godinu      |
| 1998-06-01T00:00:00.000Z | preko 1 godinu    | preko 1 godinu         | prije preko 1 godinu    |
| 1998-01-01T00:00:00.000Z | oko 2 godine      | oko 2 godine           | prije oko 2 godine      |
| 1997-01-01T00:00:00.000Z | oko 3 godine      | oko 3 godine           | prije oko 3 godine      |
| 1996-01-01T00:00:00.000Z | oko 4 godine      | oko 4 godine           | prije oko 4 godine      |
| 1995-01-01T00:00:00.000Z | oko 5 godina      | oko 5 godina           | prije oko 5 godina      |
| 1994-01-01T00:00:00.000Z | oko 6 godina      | oko 6 godina           | prije oko 6 godina      |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result     | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ---------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 godina   | za 6 godina       | 52608 sati                     |
| 2005-01-01T00:00:00.000Z | 5 godina   | za 5 godina       | 43848 sati                     |
| 2004-01-01T00:00:00.000Z | 4 godine   | za 4 godine       | 35064 sata                     |
| 2003-01-01T00:00:00.000Z | 3 godine   | za 3 godine       | 26304 sata                     |
| 2002-01-01T00:00:00.000Z | 2 godine   | za 2 godine       | 17544 sata                     |
| 2001-06-01T00:00:00.000Z | 1 godina   | za 1 godinu       | 12408 sati                     |
| 2001-02-01T00:00:00.000Z | 1 godina   | za 1 godinu       | 9528 sati                      |
| 2001-01-01T00:00:00.000Z | 1 godina   | za 1 godinu       | 8784 sata                      |
| 2000-06-01T00:00:00.000Z | 5 mjeseci  | za 5 mjeseci      | 3648 sati                      |
| 2000-03-01T00:00:00.000Z | 2 mjeseca  | za 2 mjeseca      | 1440 sati                      |
| 2000-02-01T00:00:00.000Z | 1 mjesec   | za 1 mjesec       | 744 sata                       |
| 2000-01-15T00:00:00.000Z | 14 dana    | za 14 dana        | 336 sati                       |
| 2000-01-02T00:00:00.000Z | 1 dan      | za 1 dan          | 24 sata                        |
| 2000-01-01T06:00:00.000Z | 6 sati     | za 6 sati         | 6 sati                         |
| 2000-01-01T01:00:00.000Z | 1 sat      | za 1 sat          | 1 sat                          |
| 2000-01-01T00:45:00.000Z | 45 minuta  | za 45 minuta      | 1 sat                          |
| 2000-01-01T00:30:00.000Z | 30 minuta  | za 30 minuta      | 1 sat                          |
| 2000-01-01T00:15:00.000Z | 15 minuta  | za 15 minuta      | 0 sati                         |
| 2000-01-01T00:01:00.000Z | 1 minuta   | za 1 minutu       | 0 sati                         |
| 2000-01-01T00:00:25.000Z | 25 sekundi | za 25 sekundi     | 0 sati                         |
| 2000-01-01T00:00:15.000Z | 15 sekundi | za 15 sekundi     | 0 sati                         |
| 2000-01-01T00:00:05.000Z | 5 sekundi  | za 5 sekundi      | 0 sati                         |
| 2000-01-01T00:00:00.000Z | 0 sekundi  | prije 0 sekundi   | 0 sati                         |
| 1999-12-31T23:59:55.000Z | 5 sekundi  | prije 5 sekundi   | 0 sati                         |
| 1999-12-31T23:59:45.000Z | 15 sekundi | prije 15 sekundi  | 0 sati                         |
| 1999-12-31T23:59:35.000Z | 25 sekundi | prije 25 sekundi  | 0 sati                         |
| 1999-12-31T23:59:00.000Z | 1 minuta   | prije 1 minute    | 0 sati                         |
| 1999-12-31T23:45:00.000Z | 15 minuta  | prije 15 minuta   | 0 sati                         |
| 1999-12-31T23:30:00.000Z | 30 minuta  | prije 30 minuta   | 1 sat                          |
| 1999-12-31T23:15:00.000Z | 45 minuta  | prije 45 minuta   | 1 sat                          |
| 1999-12-31T23:00:00.000Z | 1 sat      | prije 1 sat       | 1 sat                          |
| 1999-12-31T18:00:00.000Z | 6 sati     | prije 6 sati      | 6 sati                         |
| 1999-12-30T00:00:00.000Z | 2 dana     | prije 2 dana      | 48 sati                        |
| 1999-12-15T00:00:00.000Z | 17 dana    | prije 17 dana     | 408 sati                       |
| 1999-12-01T00:00:00.000Z | 1 mjesec   | prije 1 mjesec    | 744 sata                       |
| 1999-11-01T00:00:00.000Z | 2 mjeseca  | prije 2 mjeseca   | 1464 sata                      |
| 1999-06-01T00:00:00.000Z | 7 mjeseci  | prije 7 mjeseci   | 5136 sati                      |
| 1999-01-01T00:00:00.000Z | 1 godina   | prije 1 godine    | 8760 sati                      |
| 1998-12-01T00:00:00.000Z | 1 godina   | prije 1 godine    | 9504 sata                      |
| 1998-06-01T00:00:00.000Z | 2 godine   | prije 2 godine    | 13896 sati                     |
| 1998-01-01T00:00:00.000Z | 2 godine   | prije 2 godine    | 17520 sati                     |
| 1997-01-01T00:00:00.000Z | 3 godine   | prije 3 godine    | 26280 sati                     |
| 1996-01-01T00:00:00.000Z | 4 godine   | prije 4 godine    | 35064 sata                     |
| 1995-01-01T00:00:00.000Z | 5 godina   | prije 5 godina    | 43824 sata                     |
| 1994-01-01T00:00:00.000Z | 6 godina   | prije 6 godina    | 52584 sata                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                     |
| ------------------------ | -------------------------- |
| 2000-01-10T00:00:00.000Z | 10. 01. 2000.              |
| 2000-01-05T00:00:00.000Z | iduću srijedu u 00:00      |
| 2000-01-02T00:00:00.000Z | sutra u 00:00              |
| 2000-01-01T00:00:00.000Z | danas u 00:00              |
| 1999-12-31T00:00:00.000Z | jučer u 00:00              |
| 1999-12-27T00:00:00.000Z | prošli ponedjeljak u 00:00 |
| 1999-12-21T00:00:00.000Z | 21. 12. 1999.              |
