# Dutch (nl) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                 | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ----------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987e                                           | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5e                                              | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987e                                           | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4e                                              | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1e                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2e                                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | K1                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1e kwartaal                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2e kwartaal                                     | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                               | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1e                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2e                                              | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | K1                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                              | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1e kwartaal                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2e kwartaal                                     | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2e                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7e                                              | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | feb.                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul.                                            | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | februari                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                            | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | F                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                               | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2e                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7e                                              | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | feb.                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul.                                            | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | februari                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                            | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | F                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                               | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1e                                              | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48e                                             | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1e                                              | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48e                                             | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11e                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28e                                             | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42e                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365e                                            | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | maa                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vri                                             | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | maa                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vri                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | maa                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vri                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | maandag                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vrijdag                                         | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | M                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | ma                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vr                                              | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1e                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5e                                              | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | maa                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vri                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | maandag                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vrijdag                                         | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | M                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | ma                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vr                                              | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1e                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5e                                              | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | maa                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vri                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | maandag                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vrijdag                                         | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | M                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | ma                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vr                                              | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1e                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5e                                              | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | maa                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vri                                             | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | maandag                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vrijdag                                         | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | M                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                               | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | ma                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vr                                              | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | 's ochtends                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 's middags                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 's avonds                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 's nachts                                       | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | 's ochtends                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 's middags                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 's avonds                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 's nachts                                       | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | 's ochtends                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 's middags                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 's avonds                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 's nachts                                       | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | 's ochtends                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 's middags                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 's avonds                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 's nachts                                       | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | 's ochtends                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 's middags                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 's avonds                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 's nachts                                       | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11e                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11e                                             | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11e                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23e                                             | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11e                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11e                                             | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11e                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23e                                             | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1e                                              | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55e                                             | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1e                                              | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55e                                             | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11-02-1987                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-05-1453                                      | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 feb. 1987                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mei. 1453                                    | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 februari 1987                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mei 1453                                     | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | woensdag 11 februari 1987                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | zondag 29 mei 1453                              | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                           | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                           | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                        | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                        | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                  | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                              | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11-02-1987, 12:13                               | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-05-1453, 23:59                               | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 feb. 1987, 12:13:14                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mei. 1453, 23:59:59                          | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 februari 1987 om 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mei 1453 om 23:59:59 GMT+0                   | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | woensdag 11 februari 1987 om 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | zondag 29 mei 1453 om 23:59:59 GMT+00:00        | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result                | `includeSeconds: true` | `addSuffix: true`             |
| ------------------------ | --------------------- | ---------------------- | ----------------------------- |
| 2006-01-01T00:00:00.000Z | ongeveer 6 jaar       | ongeveer 6 jaar        | over ongeveer 6 jaar          |
| 2005-01-01T00:00:00.000Z | ongeveer 5 jaar       | ongeveer 5 jaar        | over ongeveer 5 jaar          |
| 2004-01-01T00:00:00.000Z | ongeveer 4 jaar       | ongeveer 4 jaar        | over ongeveer 4 jaar          |
| 2003-01-01T00:00:00.000Z | ongeveer 3 jaar       | ongeveer 3 jaar        | over ongeveer 3 jaar          |
| 2002-01-01T00:00:00.000Z | ongeveer 2 jaar       | ongeveer 2 jaar        | over ongeveer 2 jaar          |
| 2001-06-01T00:00:00.000Z | meer dan 1 jaar       | meer dan 1 jaar        | over meer dan 1 jaar          |
| 2001-02-01T00:00:00.000Z | ongeveer 1 jaar       | ongeveer 1 jaar        | over ongeveer 1 jaar          |
| 2001-01-01T00:00:00.000Z | ongeveer 1 jaar       | ongeveer 1 jaar        | over ongeveer 1 jaar          |
| 2000-06-01T00:00:00.000Z | 5 maanden             | 5 maanden              | over 5 maanden                |
| 2000-03-01T00:00:00.000Z | 2 maanden             | 2 maanden              | over 2 maanden                |
| 2000-02-01T00:00:00.000Z | ongeveer 1 maand      | ongeveer 1 maand       | over ongeveer 1 maand         |
| 2000-01-15T00:00:00.000Z | 14 dagen              | 14 dagen               | over 14 dagen                 |
| 2000-01-02T00:00:00.000Z | 1 dag                 | 1 dag                  | over 1 dag                    |
| 2000-01-01T06:00:00.000Z | ongeveer 6 uur        | ongeveer 6 uur         | over ongeveer 6 uur           |
| 2000-01-01T01:00:00.000Z | ongeveer 1 uur        | ongeveer 1 uur         | over ongeveer 1 uur           |
| 2000-01-01T00:45:00.000Z | ongeveer 1 uur        | ongeveer 1 uur         | over ongeveer 1 uur           |
| 2000-01-01T00:30:00.000Z | 30 minuten            | 30 minuten             | over 30 minuten               |
| 2000-01-01T00:15:00.000Z | 15 minuten            | 15 minuten             | over 15 minuten               |
| 2000-01-01T00:01:00.000Z | een minuut            | een minuut             | over een minuut               |
| 2000-01-01T00:00:25.000Z | minder dan een minuut | een halve minuut       | over minder dan een minuut    |
| 2000-01-01T00:00:15.000Z | minder dan een minuut | minder dan 20 seconden | over minder dan een minuut    |
| 2000-01-01T00:00:05.000Z | minder dan een minuut | minder dan 10 seconden | over minder dan een minuut    |
| 2000-01-01T00:00:00.000Z | minder dan een minuut | minder dan 5 seconden  | minder dan een minuut geleden |
| 1999-12-31T23:59:55.000Z | minder dan een minuut | minder dan 10 seconden | minder dan een minuut geleden |
| 1999-12-31T23:59:45.000Z | minder dan een minuut | minder dan 20 seconden | minder dan een minuut geleden |
| 1999-12-31T23:59:35.000Z | minder dan een minuut | een halve minuut       | minder dan een minuut geleden |
| 1999-12-31T23:59:00.000Z | een minuut            | een minuut             | een minuut geleden            |
| 1999-12-31T23:45:00.000Z | 15 minuten            | 15 minuten             | 15 minuten geleden            |
| 1999-12-31T23:30:00.000Z | 30 minuten            | 30 minuten             | 30 minuten geleden            |
| 1999-12-31T23:15:00.000Z | ongeveer 1 uur        | ongeveer 1 uur         | ongeveer 1 uur geleden        |
| 1999-12-31T23:00:00.000Z | ongeveer 1 uur        | ongeveer 1 uur         | ongeveer 1 uur geleden        |
| 1999-12-31T18:00:00.000Z | ongeveer 6 uur        | ongeveer 6 uur         | ongeveer 6 uur geleden        |
| 1999-12-30T00:00:00.000Z | 2 dagen               | 2 dagen                | 2 dagen geleden               |
| 1999-12-15T00:00:00.000Z | 17 dagen              | 17 dagen               | 17 dagen geleden              |
| 1999-12-01T00:00:00.000Z | ongeveer 1 maand      | ongeveer 1 maand       | ongeveer 1 maand geleden      |
| 1999-11-01T00:00:00.000Z | 2 maanden             | 2 maanden              | 2 maanden geleden             |
| 1999-06-01T00:00:00.000Z | 7 maanden             | 7 maanden              | 7 maanden geleden             |
| 1999-01-01T00:00:00.000Z | ongeveer 1 jaar       | ongeveer 1 jaar        | ongeveer 1 jaar geleden       |
| 1998-12-01T00:00:00.000Z | ongeveer 1 jaar       | ongeveer 1 jaar        | ongeveer 1 jaar geleden       |
| 1998-06-01T00:00:00.000Z | meer dan 1 jaar       | meer dan 1 jaar        | meer dan 1 jaar geleden       |
| 1998-01-01T00:00:00.000Z | ongeveer 2 jaar       | ongeveer 2 jaar        | ongeveer 2 jaar geleden       |
| 1997-01-01T00:00:00.000Z | ongeveer 3 jaar       | ongeveer 3 jaar        | ongeveer 3 jaar geleden       |
| 1996-01-01T00:00:00.000Z | ongeveer 4 jaar       | ongeveer 4 jaar        | ongeveer 4 jaar geleden       |
| 1995-01-01T00:00:00.000Z | ongeveer 5 jaar       | ongeveer 5 jaar        | ongeveer 5 jaar geleden       |
| 1994-01-01T00:00:00.000Z | ongeveer 6 jaar       | ongeveer 6 jaar        | ongeveer 6 jaar geleden       |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true`   | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 jaar      | over 6 jaar         | 52608 uur                      |
| 2005-01-01T00:00:00.000Z | 5 jaar      | over 5 jaar         | 43848 uur                      |
| 2004-01-01T00:00:00.000Z | 4 jaar      | over 4 jaar         | 35064 uur                      |
| 2003-01-01T00:00:00.000Z | 3 jaar      | over 3 jaar         | 26304 uur                      |
| 2002-01-01T00:00:00.000Z | 2 jaar      | over 2 jaar         | 17544 uur                      |
| 2001-06-01T00:00:00.000Z | 1 jaar      | over 1 jaar         | 12408 uur                      |
| 2001-02-01T00:00:00.000Z | 1 jaar      | over 1 jaar         | 9528 uur                       |
| 2001-01-01T00:00:00.000Z | 1 jaar      | over 1 jaar         | 8784 uur                       |
| 2000-06-01T00:00:00.000Z | 5 maanden   | over 5 maanden      | 3648 uur                       |
| 2000-03-01T00:00:00.000Z | 2 maanden   | over 2 maanden      | 1440 uur                       |
| 2000-02-01T00:00:00.000Z | 1 maand     | over 1 maand        | 744 uur                        |
| 2000-01-15T00:00:00.000Z | 14 dagen    | over 14 dagen       | 336 uur                        |
| 2000-01-02T00:00:00.000Z | 1 dag       | over 1 dag          | 24 uur                         |
| 2000-01-01T06:00:00.000Z | 6 uur       | over 6 uur          | 6 uur                          |
| 2000-01-01T01:00:00.000Z | 1 uur       | over 1 uur          | 1 uur                          |
| 2000-01-01T00:45:00.000Z | 45 minuten  | over 45 minuten     | 1 uur                          |
| 2000-01-01T00:30:00.000Z | 30 minuten  | over 30 minuten     | 1 uur                          |
| 2000-01-01T00:15:00.000Z | 15 minuten  | over 15 minuten     | 0 uur                          |
| 2000-01-01T00:01:00.000Z | een minuut  | over een minuut     | 0 uur                          |
| 2000-01-01T00:00:25.000Z | 25 seconden | over 25 seconden    | 0 uur                          |
| 2000-01-01T00:00:15.000Z | 15 seconden | over 15 seconden    | 0 uur                          |
| 2000-01-01T00:00:05.000Z | 5 seconden  | over 5 seconden     | 0 uur                          |
| 2000-01-01T00:00:00.000Z | 0 seconden  | 0 seconden geleden  | 0 uur                          |
| 1999-12-31T23:59:55.000Z | 5 seconden  | 5 seconden geleden  | 0 uur                          |
| 1999-12-31T23:59:45.000Z | 15 seconden | 15 seconden geleden | 0 uur                          |
| 1999-12-31T23:59:35.000Z | 25 seconden | 25 seconden geleden | 0 uur                          |
| 1999-12-31T23:59:00.000Z | een minuut  | een minuut geleden  | 0 uur                          |
| 1999-12-31T23:45:00.000Z | 15 minuten  | 15 minuten geleden  | 0 uur                          |
| 1999-12-31T23:30:00.000Z | 30 minuten  | 30 minuten geleden  | 1 uur                          |
| 1999-12-31T23:15:00.000Z | 45 minuten  | 45 minuten geleden  | 1 uur                          |
| 1999-12-31T23:00:00.000Z | 1 uur       | 1 uur geleden       | 1 uur                          |
| 1999-12-31T18:00:00.000Z | 6 uur       | 6 uur geleden       | 6 uur                          |
| 1999-12-30T00:00:00.000Z | 2 dagen     | 2 dagen geleden     | 48 uur                         |
| 1999-12-15T00:00:00.000Z | 17 dagen    | 17 dagen geleden    | 408 uur                        |
| 1999-12-01T00:00:00.000Z | 1 maand     | 1 maand geleden     | 744 uur                        |
| 1999-11-01T00:00:00.000Z | 2 maanden   | 2 maanden geleden   | 1464 uur                       |
| 1999-06-01T00:00:00.000Z | 7 maanden   | 7 maanden geleden   | 5136 uur                       |
| 1999-01-01T00:00:00.000Z | 1 jaar      | 1 jaar geleden      | 8760 uur                       |
| 1998-12-01T00:00:00.000Z | 1 jaar      | 1 jaar geleden      | 9504 uur                       |
| 1998-06-01T00:00:00.000Z | 2 jaar      | 2 jaar geleden      | 13896 uur                      |
| 1998-01-01T00:00:00.000Z | 2 jaar      | 2 jaar geleden      | 17520 uur                      |
| 1997-01-01T00:00:00.000Z | 3 jaar      | 3 jaar geleden      | 26280 uur                      |
| 1996-01-01T00:00:00.000Z | 4 jaar      | 4 jaar geleden      | 35064 uur                      |
| 1995-01-01T00:00:00.000Z | 5 jaar      | 5 jaar geleden      | 43824 uur                      |
| 1994-01-01T00:00:00.000Z | 6 jaar      | 6 jaar geleden      | 52584 uur                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                     |
| ------------------------ | -------------------------- |
| 2000-01-10T00:00:00.000Z | 10-01-2000                 |
| 2000-01-05T00:00:00.000Z | woensdag om 00:00          |
| 2000-01-02T00:00:00.000Z | morgen om 00:00            |
| 2000-01-01T00:00:00.000Z | vandaag om 00:00           |
| 1999-12-31T00:00:00.000Z | gisteren om 00:00          |
| 1999-12-27T00:00:00.000Z | afgelopen maandag om 00:00 |
| 1999-12-21T00:00:00.000Z | 21-12-1999                 |
