export interface SegmentConfig {
    segmentWriteKey: string;
    flushAt?: number;
    flushInterval?: number;
}
export interface Flags {
    platform?: string;
    installer?: string;
}
export declare namespace SegmentProperties {
    const Telemetry = "segment.telemetry";
    const ID = "segment.id";
}
/**
 * Class with help methods which help to connect segment and send telemetry data.
 */
export declare class SegmentAdapter {
    private readonly segment;
    private readonly id;
    constructor(segmentConfig: SegmentConfig, segmentId: string);
    /**
     * Create a segment track object which includes command properties and some crwctl filtred properties
     * @param options crwctl information like command or flags.
     * @param segmentID crwctl ID generated only if telemetry it is 'on'
     */
    trackSegmentEvent(options: {
        command: string;
        flags: any;
    }): Promise<void>;
}
