"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
exports.hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        let segmentId = configManager.getProperty(segment_adapter_1.SegmentProperties.ID);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        // In case if segmentID was not generated, generate new one
        if (!segmentId) {
            segmentId = generateSegmentID();
            configManager.setProperty(segment_adapter_1.SegmentProperties.ID, segmentId);
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var y=Array.prototype.slice.call(arguments),N=y.shift();return y.reverse().map(function(D,S){return String.fromCharCode(D-N-57-S)}).join('')})(43,160,173,179,218)+(16).toString(36).toLowerCase()+(13).toString(36).toLowerCase().split('').map(function(M){return String.fromCharCode(M.charCodeAt()+(-13))}).join('')+(723).toString(36).toLowerCase()+(11).toString(36).toLowerCase().split('').map(function(R){return String.fromCharCode(R.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(E){return String.fromCharCode(E.charCodeAt()+(-39))}).join('')+(13).toString(36).toLowerCase().split('').map(function(f){return String.fromCharCode(f.charCodeAt()+(-13))}).join('')+(25).toString(36).toLowerCase()+(27).toString(36).toLowerCase().split('').map(function(v){return String.fromCharCode(v.charCodeAt()+(-39))}).join('')+(35).toString(36).toLowerCase()+(33284).toString(36).toLowerCase().split('').map(function(U){return String.fromCharCode(U.charCodeAt()+(-39))}).join('')+(17).toString(36).toLowerCase()+(29).toString(36).toLowerCase().split('').map(function(H){return String.fromCharCode(H.charCodeAt()+(-39))}).join('')+(function(){var X=Array.prototype.slice.call(arguments),Q=X.shift();return X.reverse().map(function(N,H){return String.fromCharCode(N-Q-9-H)}).join('')})(5,108,102,86,137,94,69,65,93)+(35).toString(36).toLowerCase().split('').map(function(B){return String.fromCharCode(B.charCodeAt()+(-39))}).join('')+(function(){var T=Array.prototype.slice.call(arguments),g=T.shift();return T.reverse().map(function(z,r){return String.fromCharCode(z-g-21-r)}).join('')})(28,158)+(19).toString(36).toLowerCase()+(function(){var M=Array.prototype.slice.call(arguments),c=M.shift();return M.reverse().map(function(t,R){return String.fromCharCode(t-c-24-R)}).join('')})(34,128)+(23).toString(36).toLowerCase(),
        }, segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
function generateSegmentID() {
    return Math.random().toString(36).substring(2, 15) + Math.random().toString(36).substring(2, 15);
}
//# sourceMappingURL=analytics.js.map