"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SegmentAdapter = exports.SegmentProperties = void 0;
const tslib_1 = require("tslib");
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
const lodash_1 = require("lodash");
let Analytics = require('analytics-node');
var SegmentProperties;
(function (SegmentProperties) {
    SegmentProperties.Telemetry = 'segment.telemetry';
    SegmentProperties.ID = 'segment.id';
})(SegmentProperties = exports.SegmentProperties || (exports.SegmentProperties = {}));
/**
 * Class with help methods which help to connect segment and send telemetry data.
 */
class SegmentAdapter {
    constructor(segmentConfig, segmentId) {
        const { segmentWriteKey } = segmentConfig, options = tslib_1.__rest(segmentConfig, ["segmentWriteKey"]);
        this.segment = new Analytics(segmentWriteKey, options);
        this.id = segmentId;
    }
    /**
     * Create a segment track object which includes command properties and some crwctl filtred properties
     * @param options crwctl information like command or flags.
     * @param segmentID crwctl ID generated only if telemetry it is 'on'
     */
    trackSegmentEvent(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            this.segment.track({
                anonymousId: this.id,
                event: options.command.replace(':', ' '),
                properties: Object.assign(Object.assign({}, lodash_1.pick(options.flags, ['platform', 'installer'])), { command: options.command }),
                // Property which indicate segment will integrate with all configured destinations.
                integrations: {
                    All: true
                }
            });
        });
    }
}
exports.SegmentAdapter = SegmentAdapter;
//# sourceMappingURL=segment-adapter.js.map