"use strict";
/*********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const version_1 = require("../../api/version");
const constants_1 = require("../../constants");
const util_1 = require("../../util");
const isChectl = util_1.getProjectName() === constants_1.CHECTL_PROJECT_NAME;
const hook = function (options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (!isChectl) {
            return;
        }
        const commandName = options.Command.id;
        if (commandName === 'server:deploy' || commandName === 'server:update') {
            return;
        }
        try {
            if (yield version_1.VersionHelper.isChectlUpdateAvailable(options.config.cacheDir)) {
                cli_ux_1.cli.warn('A newer version of crwctl is available. Run "crwctl update" to update to the newer version.');
            }
        }
        catch (_a) {
            // An error occured while checking for newer version. Ignore it.
        }
    });
};
exports.default = hook;
//# sourceMappingURL=new-version-warning.js.map