/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { Command } from '@oclif/command';
import * as Listr from 'listr';
import { CheHelper } from '../api/che';
import { KubeHelper } from '../api/kube';
import { OpenShiftHelper } from '../api/openshift';
import { KubeTasks } from './kube';
/**
 * Holds tasks to work with CodeReady Workspaces component.
 */
export declare class CheTasks {
    kube: KubeHelper;
    kubeTasks: KubeTasks;
    oc: OpenShiftHelper;
    che: CheHelper;
    cheNamespace: string;
    cheAccessToken: string | undefined;
    cheSelector: string;
    cheDeploymentName: string;
    dashboardDeploymentName: string;
    dashboardSelector: string;
    keycloakDeploymentName: string;
    keycloakSelector: string;
    postgresDeploymentName: string;
    postgresSelector: string;
    devfileRegistryDeploymentName: string;
    devfileRegistrySelector: string;
    pluginRegistryDeploymentName: string;
    pluginRegistrySelector: string;
    cheConsoleLinkName: string;
    constructor(flags: any);
    /**
     * Returns tasks list that waits until every CodeReady Workspaces component will be started.
     *
     * Note that CodeReady Workspaces components statuses should be already set in context.
     *
     * @see che.checkIfCheIsInstalledTasks
     */
    waitDeployedChe(): ReadonlyArray<Listr.ListrTask>;
    /**
     * Returns list of tasks that checks if CodeReady Workspaces is already installed.
     *
     * After executing the following properties are set in context:
     * is[Component]Deployed, is[Component]Stopped, is[Component]Ready
     * where component is one the: Che, Keycloak, Postgres, PluginRegistry, DevfileRegistry
     */
    checkIfCheIsInstalledTasks(_flags: any, command: Command): ReadonlyArray<Listr.ListrTask>;
    /**
     * Returns tasks list which scale up all CodeReady Workspaces components which are deployed.
     * It requires {@link this#checkIfCheIsInstalledTasks} to be executed before.
     *
     * @see [CheTasks](#checkIfCheIsInstalledTasks)
     */
    scaleCheUpTasks(): ReadonlyArray<Listr.ListrTask>;
    /**
     * Returns tasks list which scale down all CodeReady Workspaces components which are deployed.
     * It requires {@link this#checkIfCheIsInstalledTasks} to be executed before.
     *
     * @see [CheTasks](#checkIfCheIsInstalledTasks)
     */
    scaleCheDownTasks(command: Command): ReadonlyArray<Listr.ListrTask>;
    /**
     * Returns tasks which remove all CodeReady Workspaces related resources.
     */
    deleteTasks(flags: any): ReadonlyArray<Listr.ListrTask>;
    /**
     * Returns tasks which wait until pods are deleted.
     */
    waitPodsDeletedTasks(): ReadonlyArray<Listr.ListrTask>;
    deleteNamespace(flags: any): ReadonlyArray<Listr.ListrTask>;
    verifyCheNamespaceExistsTask(flags: any, command: Command): ReadonlyArray<Listr.ListrTask>;
    /**
     * Verifies if workspace running and puts #V1Pod into a context.
     */
    verifyWorkspaceRunTask(flags: any, command: Command): ReadonlyArray<Listr.ListrTask>;
    /**
     * Return tasks to collect CodeReady Workspaces logs.
     */
    serverLogsTasks(flags: any, follow: boolean): ReadonlyArray<Listr.ListrTask>;
    debugTask(flags: any): ReadonlyArray<Listr.ListrTask>;
    preparePostInstallationOutput(flags: any): ReadonlyArray<Listr.ListrTask>;
    checkEclipseCheStatus(): ReadonlyArray<Listr.ListrTask>;
}
