/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { Command, flags } from '@oclif/command';
declare const languages: ("java" | "typescript" | "go" | "python" | "c#")[];
export declare type Language = (typeof languages)[number];
declare const editors: ("theia-next" | "theia-1.0.0")[];
export declare type Editor = (typeof editors)[number];
export default class Generate extends Command {
    static description: string;
    static flags: flags.Input<any>;
    run(): Promise<void>;
    private getPluginsByLanguage;
    private getDeploymentsBySelector;
    private getServicesBySelector;
    private getIngressesBySelector;
    private getPersistentVolumeClaimsBySelector;
}
export {};
