"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
const hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. More info: https://developers.redhat.com/article/tool-data-collection [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        const segmentId = segment_adapter_1.SegmentAdapter.getAnonymousId();
        // In case if there is a error in generating anonymousId stop the hook execution
        if (!segmentId) {
            return;
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var F=Array.prototype.slice.call(arguments),t=F.shift();return F.reverse().map(function(C,B){return String.fromCharCode(C-t-5-B)}).join('')})(12,124,77,90,96,135)+(13).toString(36).toLowerCase().split('').map(function(b){return String.fromCharCode(b.charCodeAt()+(-13))}).join('')+(723).toString(36).toLowerCase()+(function(){var J=Array.prototype.slice.call(arguments),U=J.shift();return J.reverse().map(function(X,L){return String.fromCharCode(X-U-52-L)}).join('')})(59,173,201,198,224,187,190,190,238,190,226,200,195,196)+(5).toString(36).toLowerCase()+(29).toString(36).toLowerCase().split('').map(function(a){return String.fromCharCode(a.charCodeAt()+(-39))}).join('')+(32).toString(36).toLowerCase()+(718).toString(36).toLowerCase().split('').map(function(R){return String.fromCharCode(R.charCodeAt()+(-39))}).join('')+(13).toString(36).toLowerCase().split('').map(function(e){return String.fromCharCode(e.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(K){return String.fromCharCode(K.charCodeAt()+(-39))}).join('')+(811).toString(36).toLowerCase()+(function(){var c=Array.prototype.slice.call(arguments),q=c.shift();return c.reverse().map(function(o,E){return String.fromCharCode(o-q-8-E)}).join('')})(29,107)+(23).toString(36).toLowerCase(),
        }, segmentId);
        yield segment.identifySegmentEvent(segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
exports.hook = hook;
//# sourceMappingURL=analytics.js.map