/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import * as Listr from 'listr';
import { CheHelper } from '../../api/che';
import { KubeHelper } from '../../api/kube';
import { OpenShiftHelper } from '../../api/openshift';
import { CertManagerTasks } from '../component-installers/cert-manager';
/**
 * Handle setup of the dev workspace operator controller.
 */
export declare class DevWorkspaceTasks {
    private readonly flags;
    protected kubeHelper: KubeHelper;
    protected cheHelper: CheHelper;
    protected openShiftHelper: OpenShiftHelper;
    protected certManagerTask: CertManagerTasks;
    protected devWorkspaceServiceAccount: string;
    protected devWorkspaceLeaderElectionRole: string;
    protected devWorkspaceLeaderElectionRoleBinding: string;
    protected devWorkspaceEditWorkspaceClusterRole: string;
    protected devworkspaceProxyClusterRole: string;
    protected devworkspaceClusterRole: string;
    protected devWorkspaceViewWorkspaceClusterRole: string;
    protected devWorkspaceClusterRoleWebhook: string;
    protected devworkspaceProxyClusterRoleBinding: string;
    protected devWorkspaceRoleBinding: string;
    protected devWorkspaceCheLeaderElectionRole: string;
    protected devWorkspaceCheLeaderElectionRoleBinding: string;
    protected devWorkspaceCheMetricsReader: string;
    protected devWorkspaceCheProxyRole: string;
    protected devWorkspaceCheRole: string;
    protected devWorkspaceCheProxyClusterRolebinding: string;
    protected devWorkspaceCheClusterRolebinding: string;
    protected devWorkspaceWebhookServerClusterRolebinding: string;
    protected deploymentName: string;
    protected devWorkspaceConfigMap: string;
    protected devworkspaceCheConfigmap: string;
    protected devWorkspaceCertificate: string;
    protected devWorkspaceCertIssuer: string;
    protected devWorkspacesCrdName: string;
    protected devWorkspaceTemplatesCrdName: string;
    protected workspaceRoutingsCrdName: string;
    protected webhooksName: string;
    protected WTOSubscriptionName: string;
    protected WTONamespace: string;
    constructor(flags: any);
    getTemplatePath(ctx: any): string;
    /**
     * Returns list of tasks which setup dev-workspace.
     */
    getInstallTasks(flags: any): ReadonlyArray<Listr.ListrTask>;
    /**
     * Returns list of tasks which uninstall dev-workspace.
     */
    getUninstallTasks(): ReadonlyArray<Listr.ListrTask>;
}
