"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiTasks = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const kube_1 = require("../../api/kube");
class ApiTasks {
    /**
     * Returns tasks which tests if K8s or OpenShift API is configured in the current context.
     *
     * `isOpenShift` property is provisioned into context.
     */
    testApiTasks(flags, command) {
        let kube = new kube_1.KubeHelper(flags);
        return {
            title: 'Verify Kubernetes API',
            task: (ctx, task) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                try {
                    cli_ux_1.cli.info(`› Current Kubernetes context: '${yield kube.currentContext()}'`);
                    if (!flags['skip-kubernetes-health-check']) {
                        yield kube.checkKubeApi();
                    }
                    task.title = `${task.title}...OK`;
                    ctx.isOpenShift = yield kube.isOpenShift();
                    ctx.isOpenShift4 = yield kube.isOpenShift4();
                    if (ctx.isOpenShift) {
                        task.title = `${task.title} (it's OpenShift)`;
                    }
                }
                catch (error) {
                    command.error(`Failed to connect to Kubernetes API, error: ${error.message}. If you're sure that your Kubernetes cluster is healthy - you can skip this check with '--skip-kubernetes-health-check' flag.`);
                }
            })
        };
    }
}
exports.ApiTasks = ApiTasks;
//# sourceMappingURL=api.js.map