package org.jbpm.gd.jpdl.ui.outline.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.ActionElementContainer;
import org.jbpm.gd.jpdl.model.ProcessDefinition;

public class ActionElementListOutlineEditPart extends JpdlElementOutlineEditPart {
	
	public ActionElementListOutlineEditPart(ProcessDefinition model) {
		super(model);
	}

	protected String getIconName() {
		return "action_elements_multiple.gif";
	}
	
	protected String getText() {
		return "Action Elements";
	}
	
	protected List getModelChildren() {
		List result = new ArrayList();
		ActionElement[] actionElements = ((ActionElementContainer)getModel()).getActionElements();
		for (int i = 0; i < actionElements.length; i++) {
			result.add(actionElements[i]);
		}
		return result;
	}

	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("actionElementAdd")) {
			handleChildAdd(evt.getNewValue());
		} else if (eventName.equals("actionElementRemove")) {
			refreshChildren();
			getViewer().select(this);
		} else {
			super.propertyChange(evt);
		}
	}
}
