/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hibernate.AssertionFailure;
import org.hibernate.Cache;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.TypeHelper;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.context.internal.JTASessionContext;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.context.internal.ThreadLocalSessionContext;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.query.spi.QueryPlanCache;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.internal.TransactionCoordinatorImpl;
import org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryObserverChain;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.internal.TransactionEnvironmentImpl;
import org.hibernate.internal.TypeLocatorImpl;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.config.spi.ConfigurationService;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.jndi.spi.JndiService;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistryFactory;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.jboss.logging.Logger;

public final class SessionFactoryImpl
implements SessionFactoryImplementor {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)SessionFactoryImpl.class.getName());
    private static final IdentifierGenerator UUID_GENERATOR = UUIDGenerator.buildSessionFactoryUniqueIdentifierGenerator();
    private final String name;
    private final String uuid;
    private final transient Map entityPersisters;
    private final transient Map<String, ClassMetadata> classMetadata;
    private final transient Map collectionPersisters;
    private final transient Map collectionMetadata;
    private final transient Map<String, Set<String>> collectionRolesByEntityParticipant;
    private final transient Map<String, IdentifierGenerator> identifierGenerators;
    private final transient Map<String, NamedQueryDefinition> namedQueries;
    private final transient Map<String, NamedSQLQueryDefinition> namedSqlQueries;
    private final transient Map<String, ResultSetMappingDefinition> sqlResultSetMappings;
    private final transient Map<String, FilterDefinition> filters;
    private final transient Map<String, FetchProfile> fetchProfiles;
    private final transient Map<String, String> imports;
    private final transient SessionFactoryServiceRegistry serviceRegistry;
    private final transient JdbcServices jdbcServices;
    private final transient Dialect dialect;
    private final transient Settings settings;
    private final transient Properties properties;
    private transient SchemaExport schemaExport;
    private final transient QueryCache queryCache;
    private final transient UpdateTimestampsCache updateTimestampsCache;
    private final transient Map<String, QueryCache> queryCaches;
    private final transient ConcurrentMap<String, Region> allCacheRegions = new ConcurrentHashMap<String, Region>();
    private final transient CurrentSessionContext currentSessionContext;
    private final transient SQLFunctionRegistry sqlFunctionRegistry;
    private final transient SessionFactoryObserverChain observer = new SessionFactoryObserverChain();
    private final transient ConcurrentHashMap<EntityNameResolver, Object> entityNameResolvers = new ConcurrentHashMap();
    private final transient QueryPlanCache queryPlanCache;
    private final transient Cache cacheAccess = new CacheImpl();
    private transient boolean isClosed = false;
    private final transient TypeResolver typeResolver;
    private final transient TypeHelper typeHelper;
    private final transient TransactionEnvironment transactionEnvironment;
    private final transient SessionFactory.SessionFactoryOptions sessionFactoryOptions;
    private static final Object ENTITY_NAME_RESOLVER_MAP_VALUE = new Object();

    public SessionFactoryImpl(final Configuration cfg, Mapping mapping, ServiceRegistry serviceRegistry, Settings settings, SessionFactoryObserver observer) throws HibernateException {
        Map errors;
        String entityName;
        LOG.debug("Building session factory");
        this.sessionFactoryOptions = new SessionFactory.SessionFactoryOptions(){
            private EntityNotFoundDelegate entityNotFoundDelegate;

            @Override
            public Interceptor getInterceptor() {
                return cfg.getInterceptor();
            }

            @Override
            public EntityNotFoundDelegate getEntityNotFoundDelegate() {
                if (this.entityNotFoundDelegate == null) {
                    this.entityNotFoundDelegate = cfg.getEntityNotFoundDelegate() != null ? cfg.getEntityNotFoundDelegate() : new EntityNotFoundDelegate(){

                        @Override
                        public void handleEntityNotFound(String entityName, Serializable id) {
                            throw new ObjectNotFoundException(id, entityName);
                        }
                    };
                }
                return this.entityNotFoundDelegate;
            }
        };
        this.settings = settings;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)cfg.getProperties());
        this.serviceRegistry = serviceRegistry.getService(SessionFactoryServiceRegistryFactory.class).buildServiceRegistry((SessionFactoryImplementor)this, cfg);
        this.jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
        this.dialect = this.jdbcServices.getDialect();
        this.sqlFunctionRegistry = new SQLFunctionRegistry(this.getDialect(), cfg.getSqlFunctions());
        if (observer != null) {
            this.observer.addObserver(observer);
        }
        this.typeResolver = cfg.getTypeResolver().scope(this);
        this.typeHelper = new TypeLocatorImpl(this.typeResolver);
        this.filters = new HashMap<String, FilterDefinition>();
        this.filters.putAll(cfg.getFilterDefinitions());
        LOG.debugf("Session factory constructed with filter configurations : %s", this.filters);
        LOG.debugf("Instantiating session factory with properties: %s", this.properties);
        settings.getRegionFactory().start(settings, this.properties);
        this.queryPlanCache = new QueryPlanCache(this);
        class IntegratorObserver
        implements SessionFactoryObserver {
            private ArrayList<Integrator> integrators = new ArrayList();

            IntegratorObserver() {
            }

            @Override
            public void sessionFactoryCreated(SessionFactory factory) {
            }

            @Override
            public void sessionFactoryClosed(SessionFactory factory) {
                for (Integrator integrator : this.integrators) {
                    integrator.disintegrate(SessionFactoryImpl.this, SessionFactoryImpl.this.serviceRegistry);
                }
            }
        }
        IntegratorObserver integratorObserver = new IntegratorObserver();
        this.observer.addObserver(integratorObserver);
        for (Integrator integrator : serviceRegistry.getService(IntegratorService.class).getIntegrators()) {
            integrator.integrate(cfg, (SessionFactoryImplementor)this, this.serviceRegistry);
            integratorObserver.integrators.add(integrator);
        }
        this.identifierGenerators = new HashMap<String, IdentifierGenerator>();
        Iterator<PersistentClass> classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass model = classes.next();
            if (model.isInherited()) continue;
            IdentifierGenerator generator = model.getIdentifier().createIdentifierGenerator(cfg.getIdentifierGeneratorFactory(), this.getDialect(), settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), (RootClass)model);
            this.identifierGenerators.put(model.getEntityName(), generator);
        }
        String cacheRegionPrefix = settings.getCacheRegionPrefix() == null ? "" : settings.getCacheRegionPrefix() + ".";
        this.entityPersisters = new HashMap();
        HashMap<String, RegionAccessStrategy> entityAccessStrategies = new HashMap<String, RegionAccessStrategy>();
        HashMap<String, ClassMetadata> classMeta = new HashMap<String, ClassMetadata>();
        classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            AccessType accessType;
            PersistentClass model = classes.next();
            model.prepareTemporaryTables(mapping, this.getDialect());
            String cacheRegionName = cacheRegionPrefix + model.getRootClass().getCacheRegionName();
            EntityRegionAccessStrategy accessStrategy = (EntityRegionAccessStrategy)entityAccessStrategies.get(cacheRegionName);
            if (accessStrategy == null && settings.isSecondLevelCacheEnabled() && (accessType = AccessType.fromExternalName(model.getCacheConcurrencyStrategy())) != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.tracev("Building cache for entity data [{0}]", model.getEntityName());
                }
                EntityRegion entityRegion = settings.getRegionFactory().buildEntityRegion(cacheRegionName, this.properties, CacheDataDescriptionImpl.decode(model));
                accessStrategy = entityRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(cacheRegionName, accessStrategy);
                this.allCacheRegions.put(cacheRegionName, entityRegion);
            }
            EntityPersister entityPersister = serviceRegistry.getService(PersisterFactory.class).createEntityPersister(model, accessStrategy, (SessionFactoryImplementor)this, mapping);
            this.entityPersisters.put(model.getEntityName(), entityPersister);
            classMeta.put(model.getEntityName(), entityPersister.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(classMeta);
        HashMap<String, HashSet<String>> tmpEntityToCollectionRoleMap = new HashMap<String, HashSet<String>>();
        this.collectionPersisters = new HashMap();
        Iterator collections = cfg.getCollectionMappings();
        while (collections.hasNext()) {
            Type elementType;
            Collection model = (Collection)collections.next();
            String string = cacheRegionPrefix + model.getCacheRegionName();
            AccessType accessType = AccessType.fromExternalName(model.getCacheConcurrencyStrategy());
            CollectionRegionAccessStrategy accessStrategy = null;
            if (accessType != null && settings.isSecondLevelCacheEnabled()) {
                if (LOG.isTraceEnabled()) {
                    LOG.tracev("Building cache for collection data [{0}]", model.getRole());
                }
                CollectionRegion collectionRegion = settings.getRegionFactory().buildCollectionRegion(string, this.properties, CacheDataDescriptionImpl.decode(model));
                accessStrategy = collectionRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(string, accessStrategy);
                this.allCacheRegions.put(string, collectionRegion);
            }
            CollectionPersister persister = serviceRegistry.getService(PersisterFactory.class).createCollectionPersister(cfg, model, accessStrategy, (SessionFactoryImplementor)this);
            this.collectionPersisters.put(model.getRole(), persister.getCollectionMetadata());
            Type indexType = persister.getIndexType();
            if (indexType != null && indexType.isAssociationType() && !indexType.isAnyType()) {
                entityName = ((AssociationType)indexType).getAssociatedEntityName(this);
                HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName);
                if (roles == null) {
                    roles = new HashSet<String>();
                    tmpEntityToCollectionRoleMap.put(entityName, roles);
                }
                roles.add(persister.getRole());
            }
            if (!(elementType = persister.getElementType()).isAssociationType() || elementType.isAnyType()) continue;
            String entityName2 = ((AssociationType)elementType).getAssociatedEntityName(this);
            HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName2);
            if (roles == null) {
                roles = new HashSet<String>();
                tmpEntityToCollectionRoleMap.put(entityName2, roles);
            }
            roles.add(persister.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(this.collectionPersisters);
        for (Map.Entry entry : tmpEntityToCollectionRoleMap.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(tmpEntityToCollectionRoleMap);
        this.namedQueries = new HashMap<String, NamedQueryDefinition>(cfg.getNamedQueries());
        this.namedSqlQueries = new HashMap<String, NamedSQLQueryDefinition>(cfg.getNamedSQLQueries());
        this.sqlResultSetMappings = new HashMap<String, ResultSetMappingDefinition>(cfg.getSqlResultSetMappings());
        this.imports = new HashMap<String, String>(cfg.getImports());
        for (Object persister : this.entityPersisters.values()) {
            persister.postInstantiate();
            this.registerEntityNameResolvers((EntityPersister)persister);
        }
        for (Object persister : this.collectionPersisters.values()) {
            persister.postInstantiate();
        }
        this.name = settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryRegistry.INSTANCE.addSessionFactory(this.uuid, this.name, this, serviceRegistry.getService(JndiService.class));
        LOG.debugf("Instantiated session factory", new Object[0]);
        if (settings.isAutoCreateSchema()) {
            new SchemaExport(serviceRegistry, cfg).setImportSqlCommandExtractor(serviceRegistry.getService(ImportSqlCommandExtractor.class)).create(false, true);
        }
        if (settings.isAutoUpdateSchema()) {
            new SchemaUpdate(serviceRegistry, cfg).execute(false, true);
        }
        if (settings.isAutoValidateSchema()) {
            new SchemaValidator(serviceRegistry, cfg).validate();
        }
        if (settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(serviceRegistry, cfg).setImportSqlCommandExtractor(serviceRegistry.getService(ImportSqlCommandExtractor.class));
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (settings.isQueryCacheEnabled()) {
            this.updateTimestampsCache = new UpdateTimestampsCache(settings, this.properties, this);
            this.queryCache = settings.getQueryCacheFactory().getQueryCache(null, this.updateTimestampsCache, settings, this.properties);
            this.queryCaches = new HashMap<String, QueryCache>();
            this.allCacheRegions.put(this.updateTimestampsCache.getRegion().getName(), this.updateTimestampsCache.getRegion());
            this.allCacheRegions.put(this.queryCache.getRegion().getName(), this.queryCache.getRegion());
        } else {
            this.updateTimestampsCache = null;
            this.queryCache = null;
            this.queryCaches = null;
        }
        if (settings.isNamedQueryStartupCheckingEnabled() && !(errors = this.checkNamedQueries()).isEmpty()) {
            Set keys = errors.keySet();
            StringBuffer failingQueries = new StringBuffer("Errors in named queries: ");
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String queryName = (String)iterator.next();
                HibernateException e = (HibernateException)errors.get(queryName);
                failingQueries.append(queryName);
                if (iterator.hasNext()) {
                    failingQueries.append(", ");
                }
                LOG.namedQueryError(queryName, e);
            }
            throw new HibernateException(failingQueries.toString());
        }
        this.fetchProfiles = new HashMap<String, FetchProfile>();
        Iterator itr = cfg.iterateFetchProfiles();
        while (itr.hasNext()) {
            org.hibernate.mapping.FetchProfile mappingProfile = (org.hibernate.mapping.FetchProfile)itr.next();
            FetchProfile fetchProfile = new FetchProfile(mappingProfile.getName());
            for (FetchProfile.Fetch mappingFetch : mappingProfile.getFetches()) {
                entityName = this.getImportedClassName(mappingFetch.getEntity());
                EntityPersister owner = entityName == null ? null : this.entityPersisters.get(entityName);
                if (owner == null) {
                    throw new HibernateException("Unable to resolve entity reference [" + mappingFetch.getEntity() + "] in fetch profile [" + fetchProfile.getName() + "]");
                }
                Type associationType = owner.getPropertyType(mappingFetch.getAssociation());
                if (associationType == null || !associationType.isAssociationType()) {
                    throw new HibernateException("Fetch profile [" + fetchProfile.getName() + "] specified an invalid association");
                }
                Fetch.Style fetchStyle = Fetch.Style.parse(mappingFetch.getStyle());
                fetchProfile.addFetch(new Association(owner, mappingFetch.getAssociation()), fetchStyle);
                ((Loadable)owner).registerAffectingFetchProfile(fetchProfile.getName());
            }
            this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
        }
        this.transactionEnvironment = new TransactionEnvironmentImpl(this);
        this.observer.sessionFactoryCreated(this);
    }

    /*
     * WARNING - void declaration
     */
    public SessionFactoryImpl(MetadataImplementor metadata, SessionFactory.SessionFactoryOptions sessionFactoryOptions, SessionFactoryObserver observer) throws HibernateException {
        Map map;
        String entityName;
        LOG.debug("Building session factory");
        this.sessionFactoryOptions = sessionFactoryOptions;
        this.properties = SessionFactoryImpl.createPropertiesFromMap(metadata.getServiceRegistry().getService(ConfigurationService.class).getSettings());
        this.settings = new SettingsFactory().buildSettings(this.properties, metadata.getServiceRegistry());
        this.serviceRegistry = metadata.getServiceRegistry().getService(SessionFactoryServiceRegistryFactory.class).buildServiceRegistry((SessionFactoryImplementor)this, metadata);
        this.jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
        this.dialect = this.jdbcServices.getDialect();
        this.sqlFunctionRegistry = new SQLFunctionRegistry(this.dialect, new HashMap<String, SQLFunction>());
        if (observer != null) {
            this.observer.addObserver(observer);
        }
        this.typeResolver = metadata.getTypeResolver().scope(this);
        this.typeHelper = new TypeLocatorImpl(this.typeResolver);
        this.filters = new HashMap<String, FilterDefinition>();
        for (FilterDefinition filterDefinition : metadata.getFilterDefinitions()) {
            this.filters.put(filterDefinition.getFilterName(), filterDefinition);
        }
        LOG.debugf("Session factory constructed with filter configurations : %s", this.filters);
        LOG.debugf("Instantiating session factory with properties: %s", this.properties);
        this.settings.getRegionFactory().start(this.settings, this.properties);
        this.queryPlanCache = new QueryPlanCache(this);
        class IntegratorObserver
        implements SessionFactoryObserver {
            private ArrayList<Integrator> integrators = new ArrayList();

            IntegratorObserver() {
            }

            @Override
            public void sessionFactoryCreated(SessionFactory factory) {
            }

            @Override
            public void sessionFactoryClosed(SessionFactory factory) {
                for (Integrator integrator : this.integrators) {
                    integrator.disintegrate(SessionFactoryImpl.this, SessionFactoryImpl.this.serviceRegistry);
                }
            }
        }
        IntegratorObserver integratorObserver = new IntegratorObserver();
        this.observer.addObserver(integratorObserver);
        for (Integrator integrator : this.serviceRegistry.getService(IntegratorService.class).getIntegrators()) {
            integrator.integrate(metadata, (SessionFactoryImplementor)this, this.serviceRegistry);
            integratorObserver.integrators.add(integrator);
        }
        this.identifierGenerators = new HashMap<String, IdentifierGenerator>();
        for (EntityBinding entityBinding : metadata.getEntityBindings()) {
            if (!entityBinding.isRoot()) continue;
            this.identifierGenerators.put(entityBinding.getEntity().getName(), entityBinding.getHierarchyDetails().getEntityIdentifier().getIdentifierGenerator());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.settings.getCacheRegionPrefix() != null) {
            stringBuilder.append(this.settings.getCacheRegionPrefix()).append('.');
        }
        String cacheRegionPrefix = stringBuilder.toString();
        this.entityPersisters = new HashMap();
        HashMap<String, RegionAccessStrategy> entityAccessStrategies = new HashMap<String, RegionAccessStrategy>();
        HashMap<String, ClassMetadata> classMeta = new HashMap<String, ClassMetadata>();
        for (EntityBinding model : metadata.getEntityBindings()) {
            void var12_22;
            String cacheRegionName;
            EntityRegionAccessStrategy entityRegionAccessStrategy;
            EntityBinding entityBinding = metadata.getRootEntityBinding(model.getEntity().getName());
            Object var12_23 = null;
            if (this.settings.isSecondLevelCacheEnabled() && entityBinding.getHierarchyDetails().getCaching() != null && model.getHierarchyDetails().getCaching() != null && model.getHierarchyDetails().getCaching().getAccessType() != null && (entityRegionAccessStrategy = (EntityRegionAccessStrategy)EntityRegionAccessStrategy.class.cast(entityAccessStrategies.get(cacheRegionName = cacheRegionPrefix + entityBinding.getHierarchyDetails().getCaching().getRegion()))) == null) {
                AccessType accessType = model.getHierarchyDetails().getCaching().getAccessType();
                if (LOG.isTraceEnabled()) {
                    LOG.tracev("Building cache for entity data [{0}]", model.getEntity().getName());
                }
                EntityRegion entityRegion = this.settings.getRegionFactory().buildEntityRegion(cacheRegionName, this.properties, CacheDataDescriptionImpl.decode(model));
                EntityRegionAccessStrategy entityRegionAccessStrategy2 = entityRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(cacheRegionName, entityRegionAccessStrategy2);
                this.allCacheRegions.put(cacheRegionName, entityRegion);
            }
            EntityPersister cp = this.serviceRegistry.getService(PersisterFactory.class).createEntityPersister(model, (EntityRegionAccessStrategy)var12_22, (SessionFactoryImplementor)this, (Mapping)metadata);
            this.entityPersisters.put(model.getEntity().getName(), cp);
            classMeta.put(model.getEntity().getName(), cp.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(classMeta);
        HashMap<String, HashSet<String>> tmpEntityToCollectionRoleMap = new HashMap<String, HashSet<String>>();
        this.collectionPersisters = new HashMap();
        for (PluralAttributeBinding pluralAttributeBinding : metadata.getCollectionBindings()) {
            Type elementType;
            if (pluralAttributeBinding.getAttribute() == null) {
                throw new IllegalStateException("No attribute defined for a AbstractPluralAttributeBinding: " + pluralAttributeBinding);
            }
            if (pluralAttributeBinding.getAttribute().isSingular()) {
                throw new IllegalStateException("AbstractPluralAttributeBinding has a Singular attribute defined: " + pluralAttributeBinding.getAttribute().getName());
            }
            String string = cacheRegionPrefix + pluralAttributeBinding.getCaching().getRegion();
            AccessType accessType = pluralAttributeBinding.getCaching().getAccessType();
            CollectionRegionAccessStrategy accessStrategy = null;
            if (accessType != null && this.settings.isSecondLevelCacheEnabled()) {
                if (LOG.isTraceEnabled()) {
                    LOG.tracev("Building cache for collection data [{0}]", pluralAttributeBinding.getAttribute().getRole());
                }
                CollectionRegion collectionRegion = this.settings.getRegionFactory().buildCollectionRegion(string, this.properties, CacheDataDescriptionImpl.decode(pluralAttributeBinding));
                accessStrategy = collectionRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(string, accessStrategy);
                this.allCacheRegions.put(string, collectionRegion);
            }
            CollectionPersister persister = this.serviceRegistry.getService(PersisterFactory.class).createCollectionPersister(metadata, pluralAttributeBinding, accessStrategy, (SessionFactoryImplementor)this);
            this.collectionPersisters.put(pluralAttributeBinding.getAttribute().getRole(), persister.getCollectionMetadata());
            Type indexType = persister.getIndexType();
            if (indexType != null && indexType.isAssociationType() && !indexType.isAnyType()) {
                entityName = ((AssociationType)indexType).getAssociatedEntityName(this);
                HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName);
                if (roles == null) {
                    roles = new HashSet<String>();
                    tmpEntityToCollectionRoleMap.put(entityName, roles);
                }
                roles.add(persister.getRole());
            }
            if (!(elementType = persister.getElementType()).isAssociationType() || elementType.isAnyType()) continue;
            String entityName2 = ((AssociationType)elementType).getAssociatedEntityName(this);
            HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName2);
            if (roles == null) {
                roles = new HashSet<String>();
                tmpEntityToCollectionRoleMap.put(entityName2, roles);
            }
            roles.add(persister.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(this.collectionPersisters);
        for (Map.Entry entry : tmpEntityToCollectionRoleMap.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(tmpEntityToCollectionRoleMap);
        this.namedQueries = new HashMap<String, NamedQueryDefinition>();
        for (NamedQueryDefinition namedQueryDefinition : metadata.getNamedQueryDefinitions()) {
            this.namedQueries.put(namedQueryDefinition.getName(), namedQueryDefinition);
        }
        this.namedSqlQueries = new HashMap<String, NamedSQLQueryDefinition>();
        for (NamedSQLQueryDefinition namedSQLQueryDefinition : metadata.getNamedNativeQueryDefinitions()) {
            this.namedSqlQueries.put(namedSQLQueryDefinition.getName(), namedSQLQueryDefinition);
        }
        this.sqlResultSetMappings = new HashMap<String, ResultSetMappingDefinition>();
        for (ResultSetMappingDefinition resultSetMappingDefinition : metadata.getResultSetMappingDefinitions()) {
            this.sqlResultSetMappings.put(resultSetMappingDefinition.getName(), resultSetMappingDefinition);
        }
        this.imports = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : metadata.getImports()) {
            this.imports.put(entry.getKey(), entry.getValue());
        }
        for (EntityPersister entityPersister : this.entityPersisters.values()) {
            entityPersister.postInstantiate();
            this.registerEntityNameResolvers(entityPersister);
        }
        for (CollectionPersister collectionPersister : this.collectionPersisters.values()) {
            collectionPersister.postInstantiate();
        }
        this.name = this.settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryRegistry.INSTANCE.addSessionFactory(this.uuid, this.name, this, this.serviceRegistry.getService(JndiService.class));
        LOG.debugf("Instantiated session factory", new Object[0]);
        if (this.settings.isAutoCreateSchema()) {
            new SchemaExport(metadata).setImportSqlCommandExtractor(this.serviceRegistry.getService(ImportSqlCommandExtractor.class)).create(false, true);
        }
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(metadata).setImportSqlCommandExtractor(this.serviceRegistry.getService(ImportSqlCommandExtractor.class));
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (this.settings.isQueryCacheEnabled()) {
            this.updateTimestampsCache = new UpdateTimestampsCache(this.settings, this.properties, this);
            this.queryCache = this.settings.getQueryCacheFactory().getQueryCache(null, this.updateTimestampsCache, this.settings, this.properties);
            this.queryCaches = new HashMap<String, QueryCache>();
            this.allCacheRegions.put(this.updateTimestampsCache.getRegion().getName(), this.updateTimestampsCache.getRegion());
            this.allCacheRegions.put(this.queryCache.getRegion().getName(), this.queryCache.getRegion());
        } else {
            this.updateTimestampsCache = null;
            this.queryCache = null;
            this.queryCaches = null;
        }
        if (this.settings.isNamedQueryStartupCheckingEnabled() && !(map = this.checkNamedQueries()).isEmpty()) {
            Set keys = map.keySet();
            StringBuffer failingQueries = new StringBuffer("Errors in named queries: ");
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String queryName = (String)iterator.next();
                HibernateException e = (HibernateException)map.get(queryName);
                failingQueries.append(queryName);
                if (iterator.hasNext()) {
                    failingQueries.append(", ");
                }
                LOG.namedQueryError(queryName, e);
            }
            throw new HibernateException(failingQueries.toString());
        }
        this.fetchProfiles = new HashMap<String, FetchProfile>();
        for (org.hibernate.metamodel.binding.FetchProfile mappingProfile : metadata.getFetchProfiles()) {
            FetchProfile fetchProfile = new FetchProfile(mappingProfile.getName());
            for (FetchProfile.Fetch mappingFetch : mappingProfile.getFetches()) {
                entityName = this.getImportedClassName(mappingFetch.getEntity());
                EntityPersister owner = entityName == null ? null : this.entityPersisters.get(entityName);
                if (owner == null) {
                    throw new HibernateException("Unable to resolve entity reference [" + mappingFetch.getEntity() + "] in fetch profile [" + fetchProfile.getName() + "]");
                }
                Type associationType = owner.getPropertyType(mappingFetch.getAssociation());
                if (associationType == null || !associationType.isAssociationType()) {
                    throw new HibernateException("Fetch profile [" + fetchProfile.getName() + "] specified an invalid association");
                }
                Fetch.Style fetchStyle = Fetch.Style.parse(mappingFetch.getStyle());
                fetchProfile.addFetch(new Association(owner, mappingFetch.getAssociation()), fetchStyle);
                ((Loadable)owner).registerAffectingFetchProfile(fetchProfile.getName());
            }
            this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
        }
        this.transactionEnvironment = new TransactionEnvironmentImpl(this);
        this.observer.sessionFactoryCreated(this);
    }

    private static Properties createPropertiesFromMap(Map map) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)map);
        return properties;
    }

    @Override
    public Session openSession() throws HibernateException {
        return this.withOptions().openSession();
    }

    @Override
    public Session openTemporarySession() throws HibernateException {
        return this.withOptions().autoClose(false).flushBeforeCompletion(false).connectionReleaseMode(ConnectionReleaseMode.AFTER_STATEMENT).openSession();
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    @Override
    public SessionBuilder withOptions() {
        return new SessionBuilderImpl(this);
    }

    @Override
    public StatelessSessionBuilder withStatelessOptions() {
        return new StatelessSessionBuilderImpl(this);
    }

    @Override
    public StatelessSession openStatelessSession() {
        return this.withStatelessOptions().openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return this.withStatelessOptions().connection(connection).openStatelessSession();
    }

    @Override
    public void addObserver(SessionFactoryObserver observer) {
        this.observer.addObserver(observer);
    }

    public TransactionEnvironment getTransactionEnvironment() {
        return this.transactionEnvironment;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return null;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    private void registerEntityNameResolvers(EntityPersister persister) {
        if (persister.getEntityMetamodel() == null || persister.getEntityMetamodel().getTuplizer() == null) {
            return;
        }
        this.registerEntityNameResolvers(persister.getEntityMetamodel().getTuplizer());
    }

    private void registerEntityNameResolvers(EntityTuplizer tuplizer) {
        EntityNameResolver[] resolvers = tuplizer.getEntityNameResolvers();
        if (resolvers == null) {
            return;
        }
        for (EntityNameResolver resolver : resolvers) {
            this.registerEntityNameResolver(resolver);
        }
    }

    public void registerEntityNameResolver(EntityNameResolver resolver) {
        this.entityNameResolvers.put(resolver, ENTITY_NAME_RESOLVER_MAP_VALUE);
    }

    public Iterable<EntityNameResolver> iterateEntityNameResolvers() {
        return this.entityNameResolvers.keySet();
    }

    @Override
    public QueryPlanCache getQueryPlanCache() {
        return this.queryPlanCache;
    }

    private Map checkNamedQueries() throws HibernateException {
        NamedQueryDefinition qd;
        String queryName;
        HashMap<String, HibernateException> errors = new HashMap<String, HibernateException>();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Checking %s named HQL queries", this.namedQueries.size());
        }
        for (Map.Entry<String, NamedQueryDefinition> entry : this.namedQueries.entrySet()) {
            queryName = entry.getKey();
            qd = entry.getValue();
            try {
                LOG.debugf("Checking named query: %s", queryName);
                this.queryPlanCache.getHQLQueryPlan(qd.getQueryString(), false, CollectionHelper.EMPTY_MAP);
            }
            catch (QueryException e) {
                errors.put(queryName, e);
            }
            catch (MappingException e) {
                errors.put(queryName, e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Checking %s named SQL queries", this.namedSqlQueries.size());
        }
        for (Map.Entry<String, NamedQueryDefinition> entry : this.namedSqlQueries.entrySet()) {
            queryName = entry.getKey();
            qd = (NamedSQLQueryDefinition)entry.getValue();
            try {
                NativeSQLQuerySpecification spec;
                LOG.debugf("Checking named SQL query: %s", queryName);
                if (((NamedSQLQueryDefinition)qd).getResultSetRef() != null) {
                    ResultSetMappingDefinition definition = this.sqlResultSetMappings.get(((NamedSQLQueryDefinition)qd).getResultSetRef());
                    if (definition == null) {
                        throw new MappingException("Unable to find resultset-ref definition: " + ((NamedSQLQueryDefinition)qd).getResultSetRef());
                    }
                    spec = new NativeSQLQuerySpecification(qd.getQueryString(), definition.getQueryReturns(), ((NamedSQLQueryDefinition)qd).getQuerySpaces());
                } else {
                    spec = new NativeSQLQuerySpecification(qd.getQueryString(), ((NamedSQLQueryDefinition)qd).getQueryReturns(), ((NamedSQLQueryDefinition)qd).getQuerySpaces());
                }
                this.queryPlanCache.getNativeSQLQueryPlan(spec);
            }
            catch (QueryException e) {
                errors.put(queryName, e);
            }
            catch (MappingException e) {
                errors.put(queryName, e);
            }
        }
        return errors;
    }

    @Override
    public EntityPersister getEntityPersister(String entityName) throws MappingException {
        EntityPersister result = (EntityPersister)this.entityPersisters.get(entityName);
        if (result == null) {
            throw new MappingException("Unknown entity: " + entityName);
        }
        return result;
    }

    @Override
    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        CollectionPersister result = (CollectionPersister)this.collectionPersisters.get(role);
        if (result == null) {
            throw new MappingException("Unknown collection role: " + role);
        }
        return result;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public SessionFactory.SessionFactoryOptions getSessionFactoryOptions() {
        return this.sessionFactoryOptions;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.jdbcServices;
    }

    @Override
    public Dialect getDialect() {
        if (this.serviceRegistry == null) {
            throw new IllegalStateException("Cannot determine dialect because serviceRegistry is null.");
        }
        return this.dialect;
    }

    @Override
    public Interceptor getInterceptor() {
        return this.sessionFactoryOptions.getInterceptor();
    }

    @Override
    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.getSQLExceptionHelper().getSqlExceptionConverter();
    }

    @Override
    public SqlExceptionHelper getSQLExceptionHelper() {
        return this.getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public Set<String> getCollectionRolesByEntityParticipant(String entityName) {
        return this.collectionRolesByEntityParticipant.get(entityName);
    }

    @Override
    public Reference getReference() {
        LOG.debug("Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryRegistry.ObjectFactoryImpl.class.getName(), null);
    }

    private Object readResolve() throws ObjectStreamException {
        LOG.trace("Resolving serialized SessionFactory");
        SessionFactory result = SessionFactoryRegistry.INSTANCE.getSessionFactory(this.uuid);
        if (result == null) {
            result = SessionFactoryRegistry.INSTANCE.getNamedSessionFactory(this.name);
            if (result == null) {
                throw new InvalidObjectException("Could not find a SessionFactory [uuid=" + this.uuid + ",name=" + this.name + "]");
            }
            LOG.debugf("Resolved SessionFactory by name", new Object[0]);
        } else {
            LOG.debugf("Resolved SessionFactory by UUID", new Object[0]);
        }
        return result;
    }

    @Override
    public NamedQueryDefinition getNamedQuery(String queryName) {
        return this.namedQueries.get(queryName);
    }

    @Override
    public NamedSQLQueryDefinition getNamedSQLQuery(String queryName) {
        return this.namedSqlQueries.get(queryName);
    }

    @Override
    public ResultSetMappingDefinition getResultSetMapping(String resultSetName) {
        return this.sqlResultSetMappings.get(resultSetName);
    }

    @Override
    public Type getIdentifierType(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierType();
    }

    @Override
    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierPropertyName();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing");
        in.defaultReadObject();
        LOG.debugf("Deserialized: %s", this.uuid);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        LOG.debugf("Serializing: %s", this.uuid);
        out.defaultWriteObject();
        LOG.trace("Serialized");
    }

    @Override
    public Type[] getReturnTypes(String queryString) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(queryString, false, CollectionHelper.EMPTY_MAP).getReturnMetadata().getReturnTypes();
    }

    @Override
    public String[] getReturnAliases(String queryString) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(queryString, false, CollectionHelper.EMPTY_MAP).getReturnMetadata().getReturnAliases();
    }

    @Override
    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getClassMetadata(persistentClass.getName());
    }

    @Override
    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return (CollectionMetadata)this.collectionMetadata.get(roleName);
    }

    @Override
    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return this.classMetadata.get(entityName);
    }

    @Override
    public String[] getImplementors(String className) throws MappingException {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(className);
        }
        catch (ClassNotFoundException cnfe) {
            return new String[]{className};
        }
        ArrayList<String> results = new ArrayList<String>();
        for (EntityPersister testPersister : this.entityPersisters.values()) {
            boolean assignableSuperclass;
            if (!(testPersister instanceof Queryable)) continue;
            Queryable testQueryable = (Queryable)testPersister;
            String testClassName = testQueryable.getEntityName();
            boolean isMappedClass = className.equals(testClassName);
            if (testQueryable.isExplicitPolymorphism()) {
                if (!isMappedClass) continue;
                return new String[]{className};
            }
            if (isMappedClass) {
                results.add(testClassName);
                continue;
            }
            Class mappedClass = testQueryable.getMappedClass();
            if (mappedClass == null || !clazz.isAssignableFrom(mappedClass)) continue;
            if (testQueryable.isInherited()) {
                Class mappedSuperclass = this.getEntityPersister(testQueryable.getMappedSuperclass()).getMappedClass();
                assignableSuperclass = clazz.isAssignableFrom(mappedSuperclass);
            } else {
                assignableSuperclass = false;
            }
            if (assignableSuperclass) continue;
            results.add(testClassName);
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public String getImportedClassName(String className) {
        String result = this.imports.get(className);
        if (result == null) {
            try {
                ReflectHelper.classForName(className);
                return className;
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
        return result;
    }

    @Override
    public Map<String, ClassMetadata> getAllClassMetadata() throws HibernateException {
        return this.classMetadata;
    }

    @Override
    public Map getAllCollectionMetadata() throws HibernateException {
        return this.collectionMetadata;
    }

    @Override
    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.getEntityPersister(className).getPropertyType(propertyName);
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.jdbcServices.getConnectionProvider();
    }

    @Override
    public void close() throws HibernateException {
        if (this.isClosed) {
            LOG.trace("Already closed");
            return;
        }
        LOG.closing();
        this.isClosed = true;
        for (Object p : this.entityPersisters.values()) {
            if (!p.hasCache()) continue;
            p.getCacheAccessStrategy().getRegion().destroy();
        }
        for (Object p : this.collectionPersisters.values()) {
            if (!p.hasCache()) continue;
            p.getCacheAccessStrategy().getRegion().destroy();
        }
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.destroy();
            for (QueryCache cache : this.queryCaches.values()) {
                cache.destroy();
            }
            this.updateTimestampsCache.destroy();
        }
        this.settings.getRegionFactory().stop();
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport.drop(false, true);
        }
        SessionFactoryRegistry.INSTANCE.removeSessionFactory(this.uuid, this.name, this.serviceRegistry.getService(JndiService.class));
        this.observer.sessionFactoryClosed(this);
        this.serviceRegistry.destroy();
    }

    @Override
    public Cache getCache() {
        return this.cacheAccess;
    }

    @Override
    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.getCache().evictEntity(entityName, id);
    }

    @Override
    public void evictEntity(String entityName) throws HibernateException {
        this.getCache().evictEntityRegion(entityName);
    }

    @Override
    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getCache().evictEntity(persistentClass, id);
    }

    @Override
    public void evict(Class persistentClass) throws HibernateException {
        this.getCache().evictEntityRegion(persistentClass);
    }

    @Override
    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getCache().evictCollection(roleName, id);
    }

    @Override
    public void evictCollection(String roleName) throws HibernateException {
        this.getCache().evictCollectionRegion(roleName);
    }

    @Override
    public void evictQueries() throws HibernateException {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.clear();
        }
    }

    @Override
    public void evictQueries(String regionName) throws HibernateException {
        this.getCache().evictQueryRegion(regionName);
    }

    @Override
    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.updateTimestampsCache;
    }

    @Override
    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    @Override
    public QueryCache getQueryCache(String regionName) throws HibernateException {
        if (regionName == null) {
            return this.getQueryCache();
        }
        if (!this.settings.isQueryCacheEnabled()) {
            return null;
        }
        QueryCache currentQueryCache = this.queryCaches.get(regionName);
        if (currentQueryCache == null) {
            currentQueryCache = this.settings.getQueryCacheFactory().getQueryCache(regionName, this.updateTimestampsCache, this.settings, this.properties);
            this.queryCaches.put(regionName, currentQueryCache);
            this.allCacheRegions.put(currentQueryCache.getRegion().getName(), currentQueryCache.getRegion());
        }
        return currentQueryCache;
    }

    @Override
    public Region getSecondLevelCacheRegion(String regionName) {
        return (Region)this.allCacheRegions.get(regionName);
    }

    @Override
    public Map getAllSecondLevelCacheRegions() {
        return new HashMap<String, Region>(this.allCacheRegions);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Statistics getStatistics() {
        return this.getStatisticsImplementor();
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.serviceRegistry.getService(StatisticsImplementor.class);
    }

    @Override
    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        FilterDefinition def = this.filters.get(filterName);
        if (def == null) {
            throw new HibernateException("No such filter configured [" + filterName + "]");
        }
        return def;
    }

    @Override
    public boolean containsFetchProfileDefinition(String name) {
        return this.fetchProfiles.containsKey(name);
    }

    @Override
    public Set getDefinedFilterNames() {
        return this.filters.keySet();
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return this.identifierGenerators.get(rootEntityName);
    }

    private TransactionFactory transactionFactory() {
        return this.serviceRegistry.getService(TransactionFactory.class);
    }

    private boolean canAccessTransactionManager() {
        try {
            return this.serviceRegistry.getService(JtaPlatform.class).retrieveTransactionManager() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String impl = this.properties.getProperty("hibernate.current_session_context_class");
        if (impl == null) {
            if (this.canAccessTransactionManager()) {
                impl = "jta";
            } else {
                return null;
            }
        }
        if ("jta".equals(impl)) {
            if (!this.transactionFactory().compatibleWithJtaSynchronization()) {
                LOG.autoFlushWillNotWork();
            }
            return new JTASessionContext(this);
        }
        if ("thread".equals(impl)) {
            return new ThreadLocalSessionContext(this);
        }
        if ("managed".equals(impl)) {
            return new ManagedSessionContext(this);
        }
        try {
            Class implClass = ReflectHelper.classForName(impl);
            return (CurrentSessionContext)implClass.getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable t) {
            LOG.unableToConstructCurrentSessionContext(impl, t);
            return null;
        }
    }

    @Override
    public ServiceRegistryImplementor getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.sessionFactoryOptions.getEntityNotFoundDelegate();
    }

    @Override
    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.sqlFunctionRegistry;
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfiles.get(name);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.uuid);
        oos.writeBoolean(this.name != null);
        if (this.name != null) {
            oos.writeUTF(this.name);
        }
    }

    static SessionFactoryImpl deserialize(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        String uuid = ois.readUTF();
        boolean isNamed = ois.readBoolean();
        String name = isNamed ? ois.readUTF() : null;
        SessionFactory result = SessionFactoryRegistry.INSTANCE.getSessionFactory(uuid);
        if (result == null) {
            LOG.tracev("Could not locate session factory by uuid [{0}] during session deserialization; trying name", uuid);
            if (isNamed) {
                result = SessionFactoryRegistry.INSTANCE.getNamedSessionFactory(name);
            }
            if (result == null) {
                throw new InvalidObjectException("could not resolve session factory during session deserialization [uuid=" + uuid + ", name=" + name + "]");
            }
        }
        return (SessionFactoryImpl)result;
    }

    public static class StatelessSessionBuilderImpl
    implements StatelessSessionBuilder {
        private final SessionFactoryImpl sessionFactory;
        private Connection connection;
        private String tenantIdentifier;

        public StatelessSessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        @Override
        public StatelessSession openStatelessSession() {
            return new StatelessSessionImpl(this.connection, this.tenantIdentifier, this.sessionFactory);
        }

        @Override
        public StatelessSessionBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StatelessSessionBuilder tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }
    }

    static class SessionBuilderImpl
    implements SessionBuilder {
        private final SessionFactoryImpl sessionFactory;
        private Interceptor interceptor;
        private Connection connection;
        private ConnectionReleaseMode connectionReleaseMode;
        private boolean autoClose;
        private boolean autoJoinTransactions = true;
        private boolean flushBeforeCompletion;
        private String tenantIdentifier;

        SessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
            Settings settings = sessionFactory.settings;
            this.interceptor = sessionFactory.getInterceptor();
            this.connectionReleaseMode = settings.getConnectionReleaseMode();
            this.autoClose = settings.isAutoCloseSessionEnabled();
            this.flushBeforeCompletion = settings.isFlushBeforeCompletionEnabled();
        }

        protected TransactionCoordinatorImpl getTransactionCoordinator() {
            return null;
        }

        @Override
        public Session openSession() {
            return new SessionImpl(this.connection, this.sessionFactory, this.getTransactionCoordinator(), this.autoJoinTransactions, this.sessionFactory.settings.getRegionFactory().nextTimestamp(), this.interceptor, this.flushBeforeCompletion, this.autoClose, this.connectionReleaseMode, this.tenantIdentifier);
        }

        @Override
        public SessionBuilder interceptor(Interceptor interceptor) {
            this.interceptor = interceptor;
            return this;
        }

        @Override
        public SessionBuilder noInterceptor() {
            this.interceptor = EmptyInterceptor.INSTANCE;
            return this;
        }

        @Override
        public SessionBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public SessionBuilder connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
            this.connectionReleaseMode = connectionReleaseMode;
            return this;
        }

        @Override
        public SessionBuilder autoJoinTransactions(boolean autoJoinTransactions) {
            this.autoJoinTransactions = autoJoinTransactions;
            return this;
        }

        @Override
        public SessionBuilder autoClose(boolean autoClose) {
            this.autoClose = autoClose;
            return this;
        }

        @Override
        public SessionBuilder flushBeforeCompletion(boolean flushBeforeCompletion) {
            this.flushBeforeCompletion = flushBeforeCompletion;
            return this;
        }

        @Override
        public SessionBuilder tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }
    }

    private class CacheImpl
    implements Cache {
        private CacheImpl() {
        }

        @Override
        public boolean containsEntity(Class entityClass, Serializable identifier) {
            return this.containsEntity(entityClass.getName(), identifier);
        }

        @Override
        public boolean containsEntity(String entityName, Serializable identifier) {
            EntityPersister p = SessionFactoryImpl.this.getEntityPersister(entityName);
            return p.hasCache() && p.getCacheAccessStrategy().getRegion().contains(this.buildCacheKey(identifier, p));
        }

        @Override
        public void evictEntity(Class entityClass, Serializable identifier) {
            this.evictEntity(entityClass.getName(), identifier);
        }

        @Override
        public void evictEntity(String entityName, Serializable identifier) {
            EntityPersister p = SessionFactoryImpl.this.getEntityPersister(entityName);
            if (p.hasCache()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Evicting second-level cache: %s", MessageHelper.infoString(p, identifier, (SessionFactoryImplementor)SessionFactoryImpl.this));
                }
                p.getCacheAccessStrategy().evict(this.buildCacheKey(identifier, p));
            }
        }

        private CacheKey buildCacheKey(Serializable identifier, EntityPersister p) {
            return new CacheKey(identifier, p.getIdentifierType(), p.getRootEntityName(), null, SessionFactoryImpl.this);
        }

        @Override
        public void evictEntityRegion(Class entityClass) {
            this.evictEntityRegion(entityClass.getName());
        }

        @Override
        public void evictEntityRegion(String entityName) {
            EntityPersister p = SessionFactoryImpl.this.getEntityPersister(entityName);
            if (p.hasCache()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Evicting second-level cache: %s", p.getEntityName());
                }
                p.getCacheAccessStrategy().evictAll();
            }
        }

        @Override
        public void evictEntityRegions() {
            Iterator entityNames = SessionFactoryImpl.this.entityPersisters.keySet().iterator();
            while (entityNames.hasNext()) {
                this.evictEntityRegion((String)entityNames.next());
            }
        }

        @Override
        public boolean containsCollection(String role, Serializable ownerIdentifier) {
            CollectionPersister p = SessionFactoryImpl.this.getCollectionPersister(role);
            return p.hasCache() && p.getCacheAccessStrategy().getRegion().contains(this.buildCacheKey(ownerIdentifier, p));
        }

        @Override
        public void evictCollection(String role, Serializable ownerIdentifier) {
            CollectionPersister p = SessionFactoryImpl.this.getCollectionPersister(role);
            if (p.hasCache()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Evicting second-level cache: %s", MessageHelper.collectionInfoString(p, ownerIdentifier, (SessionFactoryImplementor)SessionFactoryImpl.this));
                }
                CacheKey cacheKey = this.buildCacheKey(ownerIdentifier, p);
                p.getCacheAccessStrategy().evict(cacheKey);
            }
        }

        private CacheKey buildCacheKey(Serializable ownerIdentifier, CollectionPersister p) {
            return new CacheKey(ownerIdentifier, p.getKeyType(), p.getRole(), null, SessionFactoryImpl.this);
        }

        @Override
        public void evictCollectionRegion(String role) {
            CollectionPersister p = SessionFactoryImpl.this.getCollectionPersister(role);
            if (p.hasCache()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Evicting second-level cache: %s", p.getRole());
                }
                p.getCacheAccessStrategy().evictAll();
            }
        }

        @Override
        public void evictCollectionRegions() {
            Iterator collectionRoles = SessionFactoryImpl.this.collectionPersisters.keySet().iterator();
            while (collectionRoles.hasNext()) {
                this.evictCollectionRegion((String)collectionRoles.next());
            }
        }

        @Override
        public boolean containsQuery(String regionName) {
            return SessionFactoryImpl.this.queryCaches.get(regionName) != null;
        }

        @Override
        public void evictDefaultQueryRegion() {
            if (SessionFactoryImpl.this.settings.isQueryCacheEnabled()) {
                SessionFactoryImpl.this.queryCache.clear();
            }
        }

        @Override
        public void evictQueryRegion(String regionName) {
            QueryCache namedQueryCache;
            if (regionName == null) {
                throw new NullPointerException("Region-name cannot be null (use Cache#evictDefaultQueryRegion to evict the default query cache)");
            }
            if (SessionFactoryImpl.this.settings.isQueryCacheEnabled() && (namedQueryCache = (QueryCache)SessionFactoryImpl.this.queryCaches.get(regionName)) != null) {
                namedQueryCache.clear();
            }
        }

        @Override
        public void evictQueryRegions() {
            if (SessionFactoryImpl.this.queryCaches != null) {
                for (QueryCache queryCache : SessionFactoryImpl.this.queryCaches.values()) {
                    queryCache.clear();
                }
            }
        }
    }
}

