/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.options.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.undo.XUndoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenPaletteTabsHandler
extends AbstractHandler {
    SpecialWizard wizard = SpecialWizardFactory.createSpecialWizard("org.jboss.tools.common.model.ui.views.palette.editor.HiddenPaletteTabsWizard");

    @Override
    public boolean isEnabled(XModelObject object) {
        return this.wizard != null && object != null && object.isObjectEditable();
    }

    @Override
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        this.wizard = SpecialWizardFactory.createSpecialWizard("org.jboss.tools.common.model.ui.views.palette.editor.HiddenPaletteTabsWizard");
        HashMap<String, XModelObject> objects = new HashMap<String, XModelObject>();
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        this.collect(object, "", objects, dataList);
        String[][] vs = (String[][])dataList.toArray((T[])new String[0][]);
        if (p == null) {
            p = new Properties();
        }
        p.put("data", vs);
        p.setProperty("help", "SharablePalette_HiddenTabs");
        p.setProperty("expandingLevel", "1");
        this.wizard.setObject(p);
        if (this.wizard.execute() != 0) {
            return;
        }
        this.execute(object.getModel(), vs, objects);
    }

    private void collect(XModelObject object, String prefix, Map<String, XModelObject> objects, List<String[]> dataList) {
        XModelObject[] cs = object.getChildren();
        int i = 0;
        while (i < cs.length) {
            String path = String.valueOf(prefix) + "/" + cs[i].getAttributeValue("name");
            String hidden = cs[i].getAttributeValue("hidden");
            if (hidden == null) {
                hidden = "no";
            }
            dataList.add(new String[]{path, hidden});
            objects.put(path, cs[i]);
            String kind = cs[i].getAttributeValue("element type");
            if ("group".equals(kind)) {
                this.collect(cs[i], path, objects, dataList);
            }
            ++i;
        }
    }

    public void execute(XModel model, String[][] vs, Map objects) throws XModelException {
        this.fireTransactionEvent("transaction_begin");
        try {
            XUndoManager undo = model.getUndoManager();
            undo.beginTransaction();
            int i = 0;
            while (i < vs.length) {
                XModelObject o = (XModelObject)objects.get(vs[i][0]);
                if (o != null) {
                    o.getModel().changeObjectAttribute(o, "hidden", vs[i][1]);
                }
                ++i;
            }
            undo.commitTransaction();
            model.saveOptions();
        }
        finally {
            this.fireTransactionEvent("transaction_end");
        }
    }

    private void fireTransactionEvent(String kind) {
        XModelImpl m = (XModelImpl)PreferenceModelUtilities.getPreferenceModel();
        m.fireStructureChanged(m.getByPath("%Palette%"), 2, kind);
    }
}

