/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.util.StringTokenizer;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelObject;

public class PositionSearcher {
    String text;
    XModelObject object;
    String attribute;
    int startPosition;
    int endPosition;
    boolean selectAttributeName = false;

    public void init(String text, XModelObject object, String attribute) {
        if (attribute != null && attribute.startsWith("&")) {
            this.selectAttributeName = true;
            attribute = attribute.substring(1);
        }
        this.text = text;
        this.object = object;
        this.attribute = attribute;
    }

    public void execute() {
        this.startPosition = -1;
        this.endPosition = -1;
        if (this.text == null || this.object == null) {
            return;
        }
        TagIterator it = new TagIterator();
        it.selectObject(this.object);
        if (it.startPos < 0 || it.endPos < it.startPos) {
            return;
        }
        this.startPosition = it.startPos;
        this.endPosition = it.endPos;
        this.selectAttribute();
    }

    private void selectAttribute() {
        String xml;
        if (this.attribute == null || this.attribute.length() == 0) {
            return;
        }
        XAttribute a = this.object.getModelEntity().getAttribute(this.attribute);
        if (this.isESB(a)) {
            this.findESBAttrPosition(a);
        }
        String string = xml = a == null ? null : a.getXMLName();
        if (xml == null || xml.length() == 0) {
            return;
        }
        if (xml.indexOf(".") < 0) {
            int i3;
            String s = this.text.substring(this.startPosition, this.endPosition);
            int i1 = this.findAttrPosition(s, xml);
            if (this.selectAttributeName) {
                if (i1 < 0) {
                    return;
                }
                this.startPosition += i1;
                this.endPosition = this.startPosition + xml.length();
                return;
            }
            int i2 = i1 < 0 ? -1 : s.indexOf(34, i1 + 1);
            int n = i3 = i2 < 0 ? -1 : s.indexOf(34, i2 + 1);
            if (i3 > 0) {
                this.endPosition = this.startPosition + i3;
                this.startPosition = this.startPosition + i2 + 1;
            }
        } else {
            String s;
            xml = xml.substring(0, xml.indexOf(46));
            int e1 = this.text.indexOf("</" + this.object.getModelEntity().getXMLSubPath() + ">", this.startPosition);
            String string2 = s = e1 < 0 ? "" : this.text.substring(this.startPosition, e1);
            if (xml.length() == 0) {
                int i1 = s.indexOf(">");
                this.endPosition = this.startPosition + i1 + 1;
                this.startPosition += e1;
            } else if (s.length() > 0) {
                int i2;
                int i1a = s.indexOf("<" + xml + ">");
                int i1b = s.indexOf("<" + xml + "/>");
                int n = i2 = i1a < 0 ? -1 : s.indexOf("</", i1a);
                if (i1a >= 0 && i2 >= 0) {
                    this.endPosition = this.startPosition + i2;
                    this.startPosition = this.startPosition + i1a + 2 + xml.length();
                } else if (i1b >= 0) {
                    this.endPosition = this.startPosition + i1b + 3 + xml.length();
                    this.startPosition += i1b;
                }
            }
        }
    }

    private int findAttrPosition(String s, String name) {
        int i = s.indexOf(name);
        if (i < 0) {
            return -1;
        }
        StringTokenizer st = new StringTokenizer(s, "\"", true);
        int pos = 0;
        boolean inValue = false;
        while (st.hasMoreTokens()) {
            int k;
            String t = st.nextToken();
            if (t.equals("\"")) {
                inValue = !inValue;
            } else if (!inValue && (k = t.indexOf(name)) >= 0) {
                char c;
                boolean ok = true;
                if (k > 0 && (Character.isJavaIdentifierPart(c = t.charAt(k - 1)) || c == '-')) {
                    ok = false;
                }
                if (ok) {
                    return pos + k;
                }
            }
            pos += t.length();
        }
        return -1;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    void findTagEnd() {
        if (this.startPosition < 0) {
            return;
        }
        if (this.attribute != null && this.attribute.length() > 0) {
            return;
        }
        String tagname = this.object.getModelEntity().getXMLSubPath();
        if (tagname == null || tagname.length() == 0) {
            return;
        }
        String start = "<" + tagname;
        if (this.text.indexOf(start, this.startPosition) != this.startPosition) {
            return;
        }
        String finish = "</" + tagname + ">";
        int i = this.text.indexOf(finish, this.startPosition);
        if (i >= 0) {
            this.endPosition = i + finish.length();
        }
    }

    boolean isESB(XAttribute a) {
        return a != null && "true".equals(a.getProperty("pre"));
    }

    void findESBAttrPosition(XAttribute a) {
        String name;
        int ep = this.text.indexOf("</action>", this.startPosition);
        if (ep < 0) {
            return;
        }
        String dt = this.text.substring(this.startPosition, ep);
        int name_i = dt.indexOf(name = "name=\"" + a.getXMLName() + "\"");
        if (name_i < 0) {
            return;
        }
        int ps = dt.lastIndexOf("<property", name_i);
        if (ps < 0) {
            return;
        }
        int pe = dt.indexOf("/>", ps);
        if (pe < 0) {
            return;
        }
        String dt2 = dt.substring(ps, pe + 2);
        int value_i = dt2.indexOf("value=");
        if (value_i >= 0) {
            int i3;
            int i2 = dt2.indexOf(34, value_i);
            int n = i3 = i2 < 0 ? -1 : dt2.indexOf(34, i2 + 1);
            if (i3 > i2 + 1) {
                this.startPosition = this.startPosition + ps + i2 + 1;
                this.endPosition = this.startPosition + i3 - i2 - 1;
                return;
            }
            if (i3 == i2 + 1) {
                this.startPosition = this.startPosition + ps + i2;
                this.endPosition = this.startPosition + 2;
                return;
            }
        }
        this.startPosition += ps;
        this.endPosition = this.startPosition + pe + 2 - ps;
    }

    class TagIterator {
        int startPos = -1;
        int endPos = 0;

        TagIterator() {
        }

        public void selectObject(XModelObject object) {
            if (object == null) {
                return;
            }
            String xml = object.getModelEntity().getXMLSubPath();
            String token = "<" + xml;
            if (object.getFileType() == 1) {
                this.startPos = this.nextStartPos(token, this.startPos + 1);
                if (this.startPos >= 0) {
                    this.endPos = PositionSearcher.this.text.indexOf(">", this.startPos + 1);
                    if (this.endPos < 0) {
                        this.endPos = PositionSearcher.this.text.indexOf("<", this.startPos + 1);
                    }
                    this.endPos = this.endPos < 0 ? PositionSearcher.this.text.length() : ++this.endPos;
                }
            } else if (token.equals("<")) {
                this.selectObject(object.getParent());
            } else {
                XModelObject parent = object.getParent();
                this.selectObject(parent);
                if (this.startPos < 0) {
                    return;
                }
                XModelObject[] os = parent.getChildren();
                int i = 0;
                while (i < os.length) {
                    String xml_i = os[i].getModelEntity().getXMLSubPath();
                    if (xml.equals(xml_i)) {
                        boolean ok = false;
                        while (!ok) {
                            this.startPos = this.nextStartPos(token, this.startPos + 1);
                            if (this.startPos < 0) {
                                return;
                            }
                            if (this.startPos + token.length() == PositionSearcher.this.text.length()) {
                                ok = true;
                                continue;
                            }
                            char ch = PositionSearcher.this.text.charAt(this.startPos + token.length());
                            boolean bl = ok = Character.isWhitespace(ch) || ch == '/' || ch == '>';
                        }
                        if (os[i] == object) {
                            this.endPos = PositionSearcher.this.text.indexOf(">", this.startPos + 1);
                            if (this.endPos < 0) {
                                this.endPos = PositionSearcher.this.text.indexOf("<", this.startPos + 1);
                            }
                            this.endPos = this.endPos < 0 ? PositionSearcher.this.text.length() : ++this.endPos;
                            return;
                        }
                    }
                    ++i;
                }
            }
        }

        int nextStartPos(String token, int b) {
            int s = PositionSearcher.this.text.indexOf(token, b);
            if (s < 0) {
                return s;
            }
            int cb = PositionSearcher.this.text.indexOf("<!--", b);
            if (cb < 0 || cb > s) {
                return s;
            }
            int ce = PositionSearcher.this.text.indexOf("-->", cb);
            if (ce < 0) {
                return -1;
            }
            return this.nextStartPos(token, ce + 3);
        }
    }
}

