/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format.css;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.tools.vpe.editor.toolbar.format.css.SinglePropertyValue;
import org.jboss.tools.vpe.editor.toolbar.format.css.StyleProperty;
import org.jboss.tools.vpe.editor.toolbar.format.css.Token;
import org.w3c.dom.Attr;

public class StyleAttribute {
    private String name;
    private ArrayList tokens = new ArrayList();

    public StyleAttribute(Attr styleAttribute) {
        this.name = styleAttribute.getName();
        this.parse(styleAttribute.getValue());
    }

    private void parse(String value) {
        this.tokens.clear();
        StringTokenizer tokenizer = new StringTokenizer(value, ";", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(";")) {
                this.tokens.add(new Token(token));
                continue;
            }
            this.tokens.add(new StyleProperty(token));
        }
    }

    public boolean addStyleProperty(String name, String value) {
        StyleProperty property = this.getProperty(name);
        if (property == null) {
            Token token;
            String space = "";
            if (this.tokens.size() > 0 && !(token = (Token)this.tokens.get(0)).toString().startsWith(" ")) {
                space = " ";
            }
            StyleProperty newProperty = new StyleProperty(String.valueOf(name) + ": " + value + ";" + space);
            this.tokens.add(0, newProperty);
        } else {
            SinglePropertyValue propertyValue = property.getSinglePropertyValue(value);
            if (propertyValue == null) {
                property.addSingleValue(value);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean isStylePropertySet(String name, String value) {
        StyleProperty property = this.getProperty(name);
        if (property == null) {
            return false;
        }
        SinglePropertyValue propertyValue = property.getSinglePropertyValue(value);
        return propertyValue != null;
    }

    public boolean removeStyleProperty(String name, String value) {
        StyleProperty property = this.getProperty(name);
        if (property == null) {
            return false;
        }
        boolean result = property.removeSingleValue(value);
        if (!property.hasPropertyValue()) {
            this.removeStyleProperty(name);
        }
        return result;
    }

    public boolean removeStyleProperty(String name) {
        StyleProperty property = this.getProperty(name);
        if (property != null) {
            Token nextToken;
            int index = this.tokens.indexOf(property) + 1;
            if (index < this.tokens.size() && (nextToken = (Token)this.tokens.get(index)).getDirtyValue().equals(";")) {
                this.tokens.remove(index);
            }
            return this.tokens.remove(property);
        }
        return false;
    }

    public void format() {
        this.parse(this.toString().trim());
    }

    public void invertStyleProperty(String name, String value) {
        StyleProperty property = this.getProperty(name);
        if (property == null) {
            this.addStyleProperty(name, value);
        } else {
            SinglePropertyValue propertyValue = property.getSinglePropertyValue(value);
            if (propertyValue == null) {
                property.addSingleValue(value);
            } else {
                property.removeSingleValue(value);
                if (!property.hasPropertyValue()) {
                    this.removeStyleProperty(name);
                }
            }
        }
    }

    public void ivertSingleStyleProperty(String stylePropertyName, String stylePropertyValue) {
        StyleProperty property = this.getProperty(stylePropertyName);
        if (property == null) {
            this.addStyleProperty(stylePropertyName, stylePropertyValue);
        } else {
            SinglePropertyValue value = property.getSinglePropertyValue(stylePropertyValue);
            if (value != null) {
                this.removeStyleProperty(stylePropertyName);
            } else {
                this.removeStyleProperty(stylePropertyName);
                this.addStyleProperty(stylePropertyName, stylePropertyValue);
            }
        }
    }

    public void setSingleStyleProperty(String stylePropertyName, String stylePropertyValue) {
        StyleProperty property = this.getProperty(stylePropertyName);
        if (property != null) {
            this.removeStyleProperty(stylePropertyName);
        }
        this.addStyleProperty(stylePropertyName, stylePropertyValue);
    }

    public StyleProperty getProperty(String name) {
        int i = 0;
        while (i < this.tokens.size()) {
            StyleProperty property;
            if (this.tokens.get(i) instanceof StyleProperty && (property = (StyleProperty)this.tokens.get(i)).getName() != null && name.equalsIgnoreCase(property.getName().getCleanValue())) {
                return property;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.tokens.size()) {
            buffer.append(this.tokens.get(i).toString());
            ++i;
        }
        return buffer.toString();
    }

    public String getName() {
        return this.name;
    }
}

