/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.eclipse.ui.views.ViewMemento;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutlinePage;
import net.sourceforge.pmd.eclipse.ui.views.actions.PriorityFilterAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.QuickFixAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.RemoveViolationAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.ReviewAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.ShowRuleAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class ViolationOutline
extends PageBookView
implements ISelectionProvider {
    private FileRecord resourceRecord;
    private PriorityFilter priorityFilter;
    private ViewMemento memento;
    protected static final String PRIORITY_LIST = "priorityFilterList";
    protected static final String COLUMN_WIDTHS = "tableColumnWidths";
    protected static final String COLUMN_SORTER = "tableColumnSorter";

    public void createPartControl(Composite composite) {
        this.createDropDownMenu();
        super.createPartControl(composite);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        List list;
        super.init(iViewSite);
        this.memento = new ViewMemento("/violationOutline_memento.xml");
        this.priorityFilter = new PriorityFilter();
        if (this.memento != null && !(list = this.memento.getIntegerList(PRIORITY_LIST)).isEmpty()) {
            this.priorityFilter.setPriorityFilterList(list);
        }
    }

    public void dispose() {
        this.memento.putList(PRIORITY_LIST, this.priorityFilter.getPriorityFilterList());
        this.memento.save("/violationOutline_memento.xml");
        super.dispose();
    }

    protected IPage createDefaultPage(PageBook pageBook) {
        MessagePage messagePage = new MessagePage();
        this.initPage((IPageBookViewPage)messagePage);
        messagePage.createControl((Composite)pageBook);
        messagePage.setMessage(PMDPlugin.getDefault().getStringTable().getString("view.outline.default_text"));
        return messagePage;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart iWorkbenchPart) {
        if (this.resourceRecord != null) {
            ViolationOutlinePage violationOutlinePage = new ViolationOutlinePage(this.resourceRecord, this);
            if (violationOutlinePage instanceof IPageBookViewPage) {
                this.initPage((IPageBookViewPage)violationOutlinePage);
            }
            violationOutlinePage.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(iWorkbenchPart, (IPage)violationOutlinePage);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart iWorkbenchPart, PageBookView.PageRec pageRec) {
        ViolationOutlinePage violationOutlinePage = (ViolationOutlinePage)pageRec.page;
        if (violationOutlinePage != null) {
            Integer[] integerArray = violationOutlinePage.getColumnWidths();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(Arrays.asList(integerArray));
            this.memento.putList(COLUMN_WIDTHS, arrayList);
            Integer[] integerArray2 = violationOutlinePage.getSorterProperties();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(Arrays.asList(integerArray2));
            this.memento.putList(COLUMN_SORTER, arrayList2);
            this.memento.save("net.sourceforge.pmd.eclipse.ui.views.violationOutline");
            violationOutlinePage.dispose();
        }
        pageRec.dispose();
    }

    private void createDropDownMenu() {
        IMenuManager iMenuManager = this.getViewSite().getActionBars().getMenuManager();
        List list = this.priorityFilter.getPriorityFilterList();
        Integer[] integerArray = PMDPlugin.getDefault().getPriorityValues();
        int n = 0;
        while (n < integerArray.length) {
            PriorityFilterAction priorityFilterAction = new PriorityFilterAction(integerArray[n], this);
            if (list.contains(integerArray[n])) {
                priorityFilterAction.setChecked(true);
            }
            iMenuManager.add((IAction)priorityFilterAction);
            ++n;
        }
    }

    public void createContextMenu(final TableViewer tableViewer) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ShowRuleAction showRuleAction = new ShowRuleAction(tableViewer, ViolationOutline.this.getSite().getShell());
                iMenuManager.add((IAction)showRuleAction);
                ReviewAction reviewAction = new ReviewAction(tableViewer);
                iMenuManager.add((IAction)reviewAction);
                RemoveViolationAction removeViolationAction = new RemoveViolationAction(tableViewer);
                iMenuManager.add((IAction)removeViolationAction);
                QuickFixAction quickFixAction = new QuickFixAction(tableViewer);
                quickFixAction.setEnabled(quickFixAction.hasQuickFix());
                iMenuManager.add((IAction)quickFixAction);
                iMenuManager.add((IContributionItem)new Separator("additions"));
                iMenuManager.add((IContributionItem)new Separator("additions-end"));
            }
        });
        Table table = tableViewer.getTable();
        table.setMenu(menuManager.createContextMenu((Control)table));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)tableViewer);
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
        if (iWorkbenchPage != null) {
            return iWorkbenchPage.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart iWorkbenchPart) {
        return iWorkbenchPart instanceof IEditorPart;
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        IEditorInput iEditorInput;
        if (iWorkbenchPart instanceof IEditorPart) {
            iEditorInput = ((IEditorPart)iWorkbenchPart).getEditorInput();
            if (iEditorInput != null && iEditorInput instanceof IFileEditorInput) {
                IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                this.resourceRecord = iFile.getFileExtension().equalsIgnoreCase("java") ? new FileRecord((IResource)iFile) : null;
            }
        } else {
            iEditorInput = this.getSite().getPage().getActiveEditor();
            if (iEditorInput != null) {
                this.partActivated((IWorkbenchPart)iEditorInput);
            }
        }
        if ((iEditorInput = this.getSite().getPage().getActivePart()) == null) {
            this.getSite().getPage().activate((IWorkbenchPart)this);
        }
        super.partActivated(iWorkbenchPart);
        this.refresh();
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        this.partActivated(iWorkbenchPart);
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        ViolationOutlinePage violationOutlinePage = this.getCurrentOutlinePage();
        ViolationOutlinePage violationOutlinePage2 = null;
        if (pageRec.page instanceof ViolationOutlinePage) {
            violationOutlinePage2 = (ViolationOutlinePage)pageRec.page;
        }
        if (violationOutlinePage != violationOutlinePage2) {
            Integer[] integerArray;
            Object object;
            Object object2;
            if (violationOutlinePage != null) {
                object2 = violationOutlinePage.getColumnWidths();
                object = new ArrayList(Arrays.asList(object2));
                this.memento.putList(COLUMN_WIDTHS, (List)object);
                integerArray = violationOutlinePage.getSorterProperties();
                ArrayList<Integer> arrayList = new ArrayList<Integer>(Arrays.asList(integerArray));
                this.memento.putList(COLUMN_SORTER, arrayList);
            }
            if (violationOutlinePage2 != null) {
                object2 = this.memento.getIntegerList(COLUMN_WIDTHS);
                if (!object2.isEmpty()) {
                    object = new Integer[3];
                    object2.toArray((T[])object);
                    violationOutlinePage2.setColumnWidths((Integer[])object);
                }
                if (!(object = this.memento.getIntegerList(COLUMN_SORTER)).isEmpty()) {
                    integerArray = new Integer[object.size()];
                    object.toArray(integerArray);
                    violationOutlinePage2.setSorterProperties(integerArray);
                }
            }
        }
        super.showPageRec(pageRec);
    }

    private ViolationOutlinePage getCurrentOutlinePage() {
        IPage iPage = super.getCurrentPage();
        if (!(iPage instanceof ViolationOutlinePage)) {
            return null;
        }
        return (ViolationOutlinePage)iPage;
    }

    public ViewerFilter[] getFilters() {
        return new ViewerFilter[]{this.priorityFilter};
    }

    public void refresh() {
        ViolationOutlinePage violationOutlinePage = this.getCurrentOutlinePage();
        if (violationOutlinePage != null) {
            violationOutlinePage.refresh();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        ViolationOutlinePage violationOutlinePage = this.getCurrentOutlinePage();
        if (violationOutlinePage != null) {
            violationOutlinePage.getTableViewer().addSelectionChangedListener(iSelectionChangedListener);
        }
    }

    public ISelection getSelection() {
        ViolationOutlinePage violationOutlinePage = this.getCurrentOutlinePage();
        if (violationOutlinePage != null) {
            return violationOutlinePage.getTableViewer().getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        ViolationOutlinePage violationOutlinePage = this.getCurrentOutlinePage();
        if (violationOutlinePage != null) {
            violationOutlinePage.getTableViewer().removeSelectionChangedListener(iSelectionChangedListener);
        }
    }

    public void setSelection(ISelection iSelection) {
        ViolationOutlinePage violationOutlinePage = this.getCurrentOutlinePage();
        if (violationOutlinePage != null) {
            violationOutlinePage.getTableViewer().setSelection(iSelection);
        }
    }
}

