/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.AbstractExtendedXMLFileImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.filesystems.impl.JarFolderImpl;

public class ThreadSafeCopyFactory {
    XModelObject object;
    Thread loadingThread = Thread.currentThread();
    Map<Thread, XModelObject> concurrentlyLoaded = null;

    public ThreadSafeCopyFactory(XModelObject object) {
        this.object = object;
    }

    XModelObject getThreadSafeCopy() {
        if (this.loadingThread == null) {
            this.concurrentlyLoaded = null;
            return null;
        }
        if (Thread.currentThread() == this.loadingThread) {
            return null;
        }
        Map<Thread, XModelObject> map = this.concurrentlyLoaded;
        XModelObject copy = null;
        if (map != null && (copy = map.get(Thread.currentThread())) != null) {
            return copy;
        }
        if (this.object.getParent() instanceof JarFolderImpl) {
            copy = ((JarFolderImpl)this.object.getParent()).createValidChildCopy(this.object);
        } else if (this.object.getParent() instanceof FolderImpl) {
            copy = ((FolderImpl)this.object.getParent()).createValidChildCopy(this.object);
        }
        if (copy != null) {
            int i = 0;
            while (i < 50) {
                Thread t = this.loadingThread;
                if (t != null) {
                    try {
                        t.join(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.loadingThread == null) {
                    return null;
                }
                ++i;
            }
            if (map == null) {
                this.concurrentlyLoaded = map = new HashMap<Thread, XModelObject>();
            }
            map.put(Thread.currentThread(), (AbstractExtendedXMLFileImpl)copy);
        }
        return copy;
    }

    public void destroy() {
        this.loadingThread = null;
        this.concurrentlyLoaded = null;
    }
}

