/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultEditHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;

public class RenameFileSystemHandler
extends DefaultEditHandler {
    static String RFS = "root file system";
    static String SFS = "src file system";

    public boolean isEnabled(XModelObject object) {
        if (!super.isEnabled(object)) {
            return false;
        }
        String nm = object.getAttributeValue("name");
        return !"WEB-INF".equals(nm);
    }

    public void executeHandler(XModelObject object, Properties prop) throws XModelException {
        if (!this.isEnabled(object) || this.data == null) {
            return;
        }
        Properties p = RenameFileSystemHandler.extractProperties(this.data[0]);
        this.setOtherProperties(object, p);
        String oldName = object.getAttributeValue("name");
        RenameFileSystemHandler.edit(object, p);
        String newName = p.getProperty("name");
        XModelObject web = object.getModel().getByPath("Web");
        if (web == null) {
            return;
        }
        XModelObject[] ms = web.getChildren();
        int i = 0;
        while (i < ms.length) {
            String f = ms[i].getAttributeValue(RFS);
            if (oldName.equals(f)) {
                object.getModel().changeObjectAttribute(ms[i], RFS, newName);
            }
            if (oldName.equals(f = ms[i].getAttributeValue(SFS))) {
                object.getModel().changeObjectAttribute(ms[i], SFS, newName);
            }
            ++i;
        }
    }
}

